/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.CollectionUtil;
import workbench.util.ElementInfo;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class InsertColumnMatcher {
    private List<InsertColumnInfo> columns;
    private boolean isInsert;
    private String noValue = "<" + ResourceMgr.getString("TxtNoValue") + ">";

    public InsertColumnMatcher(WbConnection wbConnection, String string) {
        this.analyzeStatement(wbConnection, string);
    }

    InsertColumnMatcher(String string) {
        this.analyzeStatement(null, string);
    }

    public boolean isInsertStatement() {
        return this.isInsert;
    }

    private void analyzeStatement(WbConnection wbConnection, String string) {
        try {
            Set<String> set = CollectionUtil.caseInsensitiveSet("INSERT", "MERGE");
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(wbConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null || !set.contains(sQLToken.getContents())) {
                this.isInsert = false;
                this.columns = Collections.emptyList();
                return;
            }
            boolean bl = false;
            if (sQLToken.getContents().equals("MERGE")) {
                while (sQLToken != null && !sQLToken.getContents().equals("INSERT")) {
                    sQLToken = sQLLexer.getNextToken(false, false);
                }
            }
            List<ElementInfo> list = null;
            ArrayList<List<ElementInfo>> arrayList = new ArrayList<List<ElementInfo>>(1);
            int n = 0;
            boolean bl2 = false;
            while (sQLToken != null) {
                String string2 = sQLToken.getContents();
                if (sQLToken.getContents().equals(")")) {
                    --n;
                } else if (sQLToken.getContents().equals("(") && !bl) {
                    if (++n == 1) {
                        list = this.getListValues(sQLLexer, sQLToken.getCharEnd(), string);
                        --n;
                    }
                } else if (sQLToken.getContents().equals("(") && bl) {
                    if (++n == 1) {
                        arrayList.add(this.getListValues(sQLLexer, sQLToken.getCharEnd(), string));
                        --n;
                    }
                } else if (sQLToken.getContents().equals("VALUES")) {
                    bl = true;
                } else if (string2.equals("SELECT") || string2.equals("WITH")) {
                    String string3 = string.substring(sQLToken.getCharBegin());
                    List<ElementInfo> list2 = SqlUtil.getColumnEntries(string3, true, wbConnection);
                    for (ElementInfo object : list2) {
                        object.setOffset(sQLToken.getCharBegin());
                    }
                    arrayList.add(list2);
                    bl2 = true;
                    break;
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            int n2 = -1;
            for (List<ElementInfo> list2 : arrayList) {
                if (list2.size() <= n2) continue;
                n2 = list2.size();
            }
            int n3 = list.size() > n2 ? list.size() : n2;
            this.columns = new ArrayList<InsertColumnInfo>(n3);
            for (int i = 0; i < n3; ++i) {
                InsertColumnInfo insertColumnInfo = new InsertColumnInfo();
                if (i < list.size()) {
                    insertColumnInfo.columnStart = list.get(i).getStartPosition();
                    insertColumnInfo.columnEnd = list.get(i).getEndPosition();
                    insertColumnInfo.columnName = list.get(i).getElementValue();
                } else {
                    insertColumnInfo.columnStart = -1;
                    insertColumnInfo.columnEnd = -1;
                    insertColumnInfo.columnName = null;
                }
                for (List list2 : arrayList) {
                    if (i < list2.size()) {
                        insertColumnInfo.addValue(((ElementInfo)list2.get(i)).getElementValue(), ((ElementInfo)list2.get(i)).getStartPosition(), ((ElementInfo)list2.get(i)).getEndPosition());
                        continue;
                    }
                    insertColumnInfo.addValue(null, -1, -1);
                }
                this.columns.add(insertColumnInfo);
            }
            if (bl2) {
                this.adjustValueStarts();
            }
        }
        catch (Exception exception) {
            if (this.columns == null) {
                this.columns = Collections.emptyList();
            }
            LogMgr.logError(new CallerInfo(){}, "Could not analyze statement: " + string, exception);
        }
    }

    private void adjustValueStarts() {
        for (int i = 0; i < this.columns.size() - 1; ++i) {
            InsertColumnInfo insertColumnInfo = this.columns.get(i);
            InsertColumnInfo insertColumnInfo2 = this.columns.get(i + 1);
            for (int j = 0; j < insertColumnInfo2.values.size(); ++j) {
                if (insertColumnInfo2.values.get((int)j).valueStart <= 0 || insertColumnInfo2.values.get((int)j).valueEnd <= 0) continue;
                insertColumnInfo2.values.get((int)j).valueStart = insertColumnInfo.values.get((int)j).valueEnd - 1;
            }
        }
    }

    private List<ElementInfo> getListValues(SQLLexer sQLLexer, int n, String string) {
        ArrayList<ElementInfo> arrayList = new ArrayList<ElementInfo>();
        int n2 = 1;
        int n3 = n;
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        while (sQLToken != null) {
            ElementInfo elementInfo;
            String string2 = sQLToken.getText();
            if (string2.equals("(")) {
                ++n2;
            } else if (string2.equals(")")) {
                if (--n2 == 0) {
                    elementInfo = new ElementInfo(string.substring(n3, sQLToken.getCharBegin()).trim(), n3, sQLToken.getCharBegin());
                    arrayList.add(elementInfo);
                    break;
                }
            } else if (string2.equals(",") && n2 == 1) {
                elementInfo = new ElementInfo(string.substring(n3, sQLToken.getCharBegin()).trim(), n3, sQLToken.getCharBegin());
                arrayList.add(elementInfo);
                n3 = sQLToken.getCharEnd();
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        return arrayList;
    }

    public boolean inValueList(int n) {
        for (InsertColumnInfo insertColumnInfo : this.columns) {
            for (ColumnValueInfo columnValueInfo : insertColumnInfo.values) {
                if (columnValueInfo.valueStart > n || columnValueInfo.valueEnd < n) continue;
                return true;
            }
        }
        return false;
    }

    public boolean inColumnList(int n) {
        for (InsertColumnInfo insertColumnInfo : this.columns) {
            if (insertColumnInfo.columnStart > n || insertColumnInfo.columnEnd < n) continue;
            return true;
        }
        return false;
    }

    public List<String> getColumns() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.columns.size());
        for (InsertColumnInfo insertColumnInfo : this.columns) {
            arrayList.add(insertColumnInfo.columnName);
        }
        return arrayList;
    }

    public String getValueForColumn(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        for (InsertColumnInfo insertColumnInfo : this.columns) {
            if (!StringUtil.equalStringIgnoreCase(string, insertColumnInfo.columnName)) continue;
            return insertColumnInfo.getValue();
        }
        return null;
    }

    public String getInsertColumnName(int n) {
        for (InsertColumnInfo insertColumnInfo : this.columns) {
            for (ColumnValueInfo columnValueInfo : insertColumnInfo.values) {
                if (columnValueInfo.valueStart > n || columnValueInfo.valueEnd < n) continue;
                return insertColumnInfo.columnName;
            }
        }
        return null;
    }

    public String getTooltipForPosition(int n) {
        for (InsertColumnInfo insertColumnInfo : this.columns) {
            if (insertColumnInfo.columnStart <= n && insertColumnInfo.columnEnd >= n) {
                return insertColumnInfo.getValue();
            }
            for (ColumnValueInfo columnValueInfo : insertColumnInfo.values) {
                if (columnValueInfo.valueStart > n || columnValueInfo.valueEnd < n) continue;
                return insertColumnInfo.columnName;
            }
        }
        return null;
    }

    private class ColumnValueInfo {
        int valueStart;
        int valueEnd;
        String value;

        ColumnValueInfo(String string, int n, int n2) {
            this.valueStart = n;
            this.valueEnd = n2;
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }

    private class InsertColumnInfo {
        int columnStart;
        int columnEnd;
        String columnName;
        List<ColumnValueInfo> values = new ArrayList<ColumnValueInfo>(1);

        private InsertColumnInfo() {
        }

        void addValue(String string, int n, int n2) {
            this.values.add(new ColumnValueInfo(string, n, n2));
        }

        String getValue() {
            if (this.values.isEmpty()) {
                return null;
            }
            if (this.values.size() == 1) {
                return this.values.get((int)0).value;
            }
            StringBuilder stringBuilder = new StringBuilder(this.values.size() * 5);
            stringBuilder.append('[');
            for (int i = 0; i < this.values.size(); ++i) {
                String string;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (StringUtil.isBlank(string = this.values.get((int)i).value)) {
                    stringBuilder.append(InsertColumnMatcher.this.noValue);
                    continue;
                }
                stringBuilder.append(this.values.get((int)i).value);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

