/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import workbench.db.ColumnIdentifier;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbTable;
import workbench.gui.renderer.SortHeaderRenderer;
import workbench.gui.renderer.WbRenderer;
import workbench.resource.GuiSettings;
import workbench.util.StringUtil;

public class ColumnWidthOptimizer {
    private WbTable table;

    public ColumnWidthOptimizer(WbTable wbTable) {
        this.table = wbTable;
    }

    public void optimizeAllColWidth() {
        this.optimizeAllColWidth(GuiSettings.getMinColumnWidth(), GuiSettings.getMaxColumnWidth(), GuiSettings.getIncludeHeaderInOptimalWidth());
    }

    public void optimizeAllColWidth(boolean bl) {
        this.optimizeAllColWidth(GuiSettings.getMinColumnWidth(), GuiSettings.getMaxColumnWidth(), bl);
    }

    public void optimizeAllColWidth(int n, int n2, boolean bl) {
        int n3 = this.table.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            this.optimizeColWidth(i, n, n2, bl);
        }
        WbSwingUtilities.repaintLater(this.table);
        WbSwingUtilities.repaintLater(this.table.getTableHeader());
    }

    public void optimizeColWidth(int n, boolean bl) {
        this.optimizeColWidth(n, GuiSettings.getMinColumnWidth(), GuiSettings.getMaxColumnWidth(), bl);
        WbSwingUtilities.repaintLater(this.table);
        WbSwingUtilities.repaintLater(this.table.getTableHeader());
    }

    private void optimizeColWidth(int n, int n2, int n3, boolean bl) {
        int n4 = this.calculateOptimalColumnWidth(n, n2, n3, bl, null);
        WbSwingUtilities.invoke(() -> {
            if (n4 > 0) {
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(n);
                tableColumn.setPreferredWidth(n4);
            }
        });
    }

    public int calculateOptimalColumnWidth(int n, int n2, int n3, boolean bl, FontMetrics fontMetrics) {
        if (this.table == null || n < 0 || n > this.table.getColumnCount() - 1) {
            return -1;
        }
        int n4 = n2;
        if (bl) {
            n4 = this.optimizeHeaderColumn(n, fontMetrics);
        }
        int n5 = this.table.getRowCount();
        int n6 = GuiSettings.getAutRowHeightMaxLines();
        int n7 = this.getAdditionalColumnSpace();
        for (int i = 0; i < n5; ++i) {
            Object object;
            String string = null;
            int n8 = -1;
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(i, n);
            Object object2 = this.table.getValueAt(i, n);
            Component component = tableCellRenderer.getTableCellRendererComponent(this.table, object2, false, false, i, n);
            FontMetrics fontMetrics2 = fontMetrics;
            if (fontMetrics2 == null) {
                object = component.getFont();
                fontMetrics2 = component.getFontMetrics((Font)object);
            }
            if (component instanceof WbRenderer) {
                object = (WbRenderer)((Object)component);
                int n9 = object.calculateDisplaySize(object2);
                if (n9 > -1) {
                    n8 = n9;
                } else {
                    string = object.getDisplayValue();
                }
            } else if (component instanceof JTextArea) {
                object = (JTextArea)component;
                String string2 = ((JTextComponent)object).getText();
                string = StringUtil.getLongestLine(string2, n6);
            } else {
                string = component instanceof JLabel ? ((JLabel)component).getText() : this.table.getValueAsString(i, n);
            }
            if (n8 == -1 && string != null) {
                object = StringUtil.rtrim(string);
                n8 = fontMetrics2.stringWidth((String)object);
                if (((String)object).length() < string.length()) {
                    n8 += fontMetrics2.stringWidth("www");
                }
            }
            n4 = Math.max(n4, n8 + n7);
        }
        if (n3 > 0) {
            n4 = Math.min(n4, n3);
        }
        return n4;
    }

    public void optimizeHeader() {
        if (this.table == null) {
            return;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (tableColumnModel == null) {
            return;
        }
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n = tableColumn.getWidth();
            int n2 = this.optimizeHeaderColumn(i, null);
            if (n2 <= n) continue;
            tableColumn.setPreferredWidth(n2);
        }
    }

    public int optimizeHeaderColumn(int n, FontMetrics fontMetrics) {
        String string;
        int n2;
        int n3;
        String string2;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        if (this.table == null || n < 0 || n > this.table.getColumnCount() - 1) {
            return -1;
        }
        TableCellRenderer tableCellRenderer = this.table.getHeaderRenderer();
        if (tableCellRenderer == null) {
            object = this.table.getTableHeader();
            tableCellRenderer = ((JTableHeader)object).getDefaultRenderer();
        }
        object = this.table.getColumnName(n);
        JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, -1, n);
        int n4 = 0;
        if (this.table.isViewColumnSorted(n)) {
            n4 = (int)((double)SortHeaderRenderer.getArrowSize(fontMetrics, this.table.isPrimarySortColumn(n)) * 1.15);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        SortHeaderRenderer sortHeaderRenderer = this.table.getHeaderRenderer();
        DataStoreTableModel dataStoreTableModel = this.table.getDataStoreTableModel();
        if (sortHeaderRenderer != null) {
            bl = sortHeaderRenderer.getShowDataType();
            bl2 = sortHeaderRenderer.getShowRemarks();
            bl3 = sortHeaderRenderer.getShowColumnTable();
            if (sortHeaderRenderer.getShowTableAsColumnPrefix()) {
                bl3 = false;
                serializable2 = dataStoreTableModel.getColumn(n);
                if (serializable2 != null) {
                    object = StringUtil.concatWithSeparator(".", new String[]{((ColumnIdentifier)serializable2).getSourceTableName(), object});
                }
            }
        }
        if ((serializable2 = fontMetrics) == null) {
            serializable = jComponent.getFont();
            serializable2 = jComponent.getFontMetrics((Font)serializable);
        }
        serializable = jComponent.getInsets();
        if (!bl2) {
            return jComponent.getPreferredSize().width + n4;
        }
        int n5 = this.getAdditionalHeaderSpace() + ((Insets)serializable).left + ((Insets)serializable).right;
        int n6 = ((FontMetrics)serializable2).stringWidth((String)object) + n5;
        if (sortHeaderRenderer == null || dataStoreTableModel == null) {
            return n6 + n4;
        }
        if (bl && (string2 = dataStoreTableModel.getDbmsType(n)) != null && (n3 = ((FontMetrics)serializable2).stringWidth(string2) + n5) > n6) {
            n6 = n3;
        }
        if (bl2 && StringUtil.isNonBlank(string2 = dataStoreTableModel.getColumnRemarks(n)) && (n2 = ((FontMetrics)serializable2).stringWidth(string = StringUtil.getFirstWord(string2)) + n5) > n6) {
            n6 = n2;
        }
        if (bl3 && StringUtil.isNonEmpty(string2 = dataStoreTableModel.getColumnTable(n)) && (n3 = ((FontMetrics)serializable2).stringWidth(string2) + n5) > n6) {
            n6 = n3;
        }
        return n6 + n4;
    }

    private int getAdditionalHeaderSpace() {
        int n = this.table.getIntercellSpacing().width;
        if (this.table.getShowVerticalLines()) {
            n += 4;
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        int n2 = tableColumnModel.getColumnMargin();
        return n += n2;
    }

    private int getAdditionalColumnSpace() {
        int n = this.table.getIntercellSpacing().width;
        if (this.table.getShowVerticalLines()) {
            n += 4;
        }
        return n += this.table.getColumnModel().getColumnMargin();
    }

    public void adjustColumns(boolean bl) {
        if (this.table.getModel() == null) {
            return;
        }
        DataStoreTableModel dataStoreTableModel = this.table.getDataStoreTableModel();
        if (dataStoreTableModel == null) {
            return;
        }
        Font font = this.table.getFont();
        FontMetrics fontMetrics = this.table.getFontMetrics(font);
        int n = Math.max(fontMetrics.getMaxAdvance(), fontMetrics.charWidth('M'));
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (tableColumnModel == null) {
            return;
        }
        int n2 = GuiSettings.getMinColumnWidth();
        int n3 = GuiSettings.getMaxColumnWidth();
        int n4 = this.getAdditionalColumnSpace();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n5 = 0;
            if (bl) {
                String string = dataStoreTableModel.getColumnName(i);
                n5 = fontMetrics.stringWidth(string) + n4;
            }
            int n6 = dataStoreTableModel.getColumnWidth(i) * n + n4;
            int n7 = Math.max(n6, n5);
            if (n3 > 0) {
                n7 = Math.min(n7, n3);
            }
            if (n2 > 0) {
                n7 = Math.max(n7, n2);
            }
            tableColumn.setPreferredWidth(n7);
        }
    }
}

