/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ToggleIndicator;
import workbench.gui.renderer.ColorUtils;
import workbench.resource.ResourceMgr;

public class FoldingPanel
extends JPanel
implements MouseListener {
    private final JPanel content;
    private ToggleIndicator toggle;
    private boolean showing;
    private String tooltipFolded;
    private String tooltipExpanded;

    public FoldingPanel(JPanel jPanel) {
        super(new BorderLayout(0, 2));
        this.content = jPanel;
        this.toggle = new ToggleIndicator();
        Color color = this.toggle.getBackground().darker();
        color = ColorUtils.blend(this.toggle.getBackground(), color, 150);
        this.toggle.setBackground(color);
        this.toggle.setBorder(new EmptyBorder(0, 2, 0, 2));
        Cursor cursor = Cursor.getPredefinedCursor(12);
        this.toggle.setCursor(cursor);
        this.toggle.addMouseListener(this);
        this.tooltipExpanded = ResourceMgr.getString("TxtExtOptHide");
        this.tooltipFolded = ResourceMgr.getString("TxtExtOptShow");
        this.toggle.setToolTipText(this.tooltipFolded);
        this.add((Component)this.toggle, "First");
    }

    public void setTooltips(String string, String string2) {
        this.tooltipFolded = string;
        this.tooltipExpanded = string2;
    }

    public void showContent() {
        this.add((Component)this.content, "Center");
        this.showing = true;
        this.toggle.setDirectionUp();
        this.toggle.setToolTipText(this.tooltipExpanded);
        this.updateDisplay(this.content.getPreferredSize().height);
    }

    public void hideContent() {
        this.remove(this.content);
        this.showing = false;
        this.toggle.setDirectionDown();
        this.toggle.setToolTipText(this.tooltipFolded);
        this.updateDisplay(-1 * this.content.getPreferredSize().height);
    }

    private void updateDisplay(int n) {
        this.invalidate();
        WbSwingUtilities.invokeLater(() -> {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.validate();
                Dimension dimension = window.getSize();
                dimension.height += n;
                window.setSize(dimension);
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.showing) {
            this.hideContent();
        } else {
            this.showContent();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

