/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import workbench.gui.WbSwingUtilities;
import workbench.gui.sql.LogArea;
import workbench.log.CallerInfo;
import workbench.log.LogListener;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.FixedSizeList;
import workbench.util.MemoryWatcher;
import workbench.util.WbFile;
import workbench.util.WbThread;

public class LogFileViewer
extends JFrame
implements LogListener {
    protected LogArea display;
    protected JScrollPane scroll;
    private WbFile sourceFile;

    public LogFileViewer(Frame frame) {
        ResourceMgr.setWindowIcons((Window)this, "logfile");
        this.display = new LogArea(this);
        this.display.setMaxLineCount(LogFileViewer.getMaxLines() + 5);
        this.display.setFont(Settings.getInstance().getEditorFont());
        this.display.setEditable(false);
        this.display.setBackground(Color.WHITE);
        this.display.setWrapStyleWord(false);
        this.display.setLineWrap(false);
        this.scroll = new JScrollPane(this.display);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scroll, "Center");
        if (!Settings.getInstance().restoreWindowSize(this)) {
            this.setSize(800, 600);
        }
        if (!Settings.getInstance().restoreWindowPosition(this)) {
            WbSwingUtilities.center(this, frame);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LogMgr.removeLogListener(LogFileViewer.this);
                LogFileViewer.this.saveSettings();
                LogFileViewer.this.setVisible(false);
                LogFileViewer.this.dispose();
            }
        });
    }

    public void setText(String string) {
        this.display.setText(string);
    }

    @Override
    public void messageLogged(final CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogFileViewer.this.display.addLine(charSequence.toString());
                LogFileViewer.this.scrollToEnd();
            }
        });
    }

    public void load() {
        if (this.sourceFile == null) {
            return;
        }
        final FixedSizeList<String> fixedSizeList = this.readLines();
        if (fixedSizeList == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogFileViewer.this.display.setText("");
                while (fixedSizeList.size() > 0) {
                    LogFileViewer.this.display.addLine((String)fixedSizeList.removeFirst());
                }
                LogFileViewer.this.scrollToEnd();
                LogMgr.addLogListener(LogFileViewer.this);
            }
        });
    }

    private void scrollToEnd() {
        try {
            int n = this.display.getLineStartOffset(this.display.getLineCount() - 1);
            this.display.setCaretPosition(n);
        }
        catch (BadLocationException badLocationException) {
            JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
            this.scroll.getHorizontalScrollBar().setValue(0);
        }
    }

    public void showFile(WbFile wbFile) {
        this.sourceFile = new WbFile(wbFile);
        this.setTitle(this.sourceFile.getFullPath());
        WbThread wbThread = new WbThread("LogFileLoader"){

            @Override
            public void run() {
                LogFileViewer.this.load();
            }
        };
        wbThread.start();
    }

    private void saveSettings() {
        Settings.getInstance().storeWindowPosition(this);
        Settings.getInstance().storeWindowSize(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FixedSizeList<String> readLines() {
        Object object;
        if (this.sourceFile == null) {
            return null;
        }
        int n = (int)((double)MemoryWatcher.getFreeMemory() * 0.1);
        int n2 = Settings.getInstance().getMaxLogfileSize();
        int n3 = Settings.getInstance().getIntProperty("workbench.logviewer.readbuff", (int)((double)n2 * 0.15));
        if (n3 > n) {
            n3 = n;
        }
        FixedSizeList<String> fixedSizeList = new FixedSizeList<String>(LogFileViewer.getMaxLines());
        fixedSizeList.doAppend(true);
        fixedSizeList.setAllowDuplicates(true);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = EncodingUtil.createBufferedReader(this.sourceFile, "UTF-8", n3);
            object = bufferedReader.readLine();
            while (object != null) {
                fixedSizeList.add((String)object);
                object = bufferedReader.readLine();
            }
            object = fixedSizeList;
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not load logfile", exception);
                this.display.setText(ExceptionUtil.getDisplay(exception));
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(bufferedReader);
                throw throwable;
            }
            FileUtil.closeQuietely(bufferedReader);
            return null;
        }
        FileUtil.closeQuietely(bufferedReader);
        return object;
    }

    public static int getMaxLines() {
        return Settings.getInstance().getIntProperty("workbench.logviewer.numlines", 1000);
    }
}

