/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.AWTException;
import java.awt.EventQueue;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

public class RunningJobIndicator
implements ActionListener {
    private JFrame clientWindow;
    private int runningJobs = 0;
    public static final String TITLE_PREFIX = "\u00bb ";
    private long startTime;
    private TrayIcon trayIcon;
    private final Object iconMonitor = new Object();
    private final Object counterMonitor = new Object();

    public RunningJobIndicator(JFrame jFrame) {
        this.clientWindow = jFrame;
    }

    public void baseTitleChanged() {
        this.updateTitle();
    }

    private void updateTitle() {
        String string = this.clientWindow.getTitle();
        if (this.runningJobs > 0) {
            if (!string.startsWith(TITLE_PREFIX)) {
                this.clientWindow.setTitle(TITLE_PREFIX + string);
            }
        } else if (string.startsWith(TITLE_PREFIX)) {
            this.clientWindow.setTitle(string.substring(TITLE_PREFIX.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobStarted() {
        Object object = this.counterMonitor;
        synchronized (object) {
            if (this.runningJobs == 0) {
                this.startTime = System.currentTimeMillis();
                this.removeTrayIcon();
            }
            ++this.runningJobs;
            this.updateTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allJobsEnded() {
        Object object = this.counterMonitor;
        synchronized (object) {
            this.runningJobs = 0;
            this.updateTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobEnded() {
        long l = 0L;
        boolean bl = false;
        Object object = this.counterMonitor;
        synchronized (object) {
            boolean bl2;
            boolean bl3 = bl2 = this.runningJobs > 0;
            if (this.runningJobs > 0) {
                --this.runningJobs;
            }
            this.updateTitle();
            l = System.currentTimeMillis() - this.startTime;
            if (this.runningJobs > 0) {
                bl = false;
            } else if (this.runningJobs == 0 && bl2) {
                bl = GuiSettings.showScriptFinishedAlert();
            }
        }
        if (!bl) {
            return;
        }
        long l2 = GuiSettings.getScriptFinishedAlertDuration();
        if (l2 == 0L || l > l2) {
            boolean bl4;
            String string = ResourceMgr.getString("TxtScriptFinished");
            boolean bl5 = bl4 = GuiSettings.useSystemTrayForAlert() && SystemTray.isSupported();
            if (bl4) {
                this.showTrayIcon(string);
            } else if (this.clientWindow != null) {
                WbSwingUtilities.invoke(this::showClient);
                WbSwingUtilities.showMessage(this.clientWindow, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTrayIcon(String string) {
        Object object = this.iconMonitor;
        synchronized (object) {
            SystemTray systemTray = SystemTray.getSystemTray();
            try {
                if (this.trayIcon == null) {
                    this.trayIcon = new TrayIcon(IconMgr.getInstance().getLabelIcon("workbench").getImage());
                    this.trayIcon.addActionListener(this);
                    this.trayIcon.setToolTip(string + " (" + StringUtil.getCurrentTimestamp() + ")");
                    systemTray.add(this.trayIcon);
                }
                this.trayIcon.displayMessage("SQL Workbench/J", string, TrayIcon.MessageType.INFO);
            }
            catch (AWTException aWTException) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not install tray icon", aWTException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTrayIcon() {
        Object object = this.iconMonitor;
        synchronized (object) {
            if (SystemTray.isSupported()) {
                SystemTray systemTray = SystemTray.getSystemTray();
                systemTray.remove(this.trayIcon);
                this.trayIcon = null;
            }
        }
    }

    private void showClient() {
        if (this.clientWindow == null) {
            return;
        }
        if (this.clientWindow.getState() == 1) {
            this.clientWindow.setState(0);
        }
        this.clientWindow.setVisible(true);
        this.clientWindow.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.removeTrayIcon();
        if (WbAction.isCtrlPressed(actionEvent) && this.clientWindow != null) {
            EventQueue.invokeLater(this::showClient);
        }
    }
}

