/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SingleLineBorder
extends AbstractBorder {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT_RIGHT = 3;
    protected int borderType;
    private Color lineColor;

    public SingleLineBorder(int n, Color color) {
        this.borderType = n;
        this.lineColor = color;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        if ((this.borderType & 4) == 4) {
            graphics.drawLine(n, n2, n + n3, n2);
        }
        if ((this.borderType & 8) == 8) {
            graphics.drawLine(n, n2 + n4 - 2, n + n3, n2 + n4 - 2);
        }
        if ((this.borderType & 1) == 1) {
            graphics.drawLine(n, n2, n, n2 + n4);
        }
        if ((this.borderType & 2) == 2) {
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.bottom = 1;
        insets.right = 1;
        insets.top = 1;
        insets.left = 1;
        return insets;
    }
}

