/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.RowHeaderRenderer;
import workbench.gui.components.TableRowHeaderModel;

public class TableRowHeader
extends JTable
implements ChangeListener,
PropertyChangeListener {
    private TableRowHeaderModel rowModel;
    private RowHeaderRenderer renderer;
    private JTable clientTable;

    public TableRowHeader(JTable jTable) {
        this.rowModel = new TableRowHeaderModel(jTable);
        this.setModel(this.rowModel);
        this.clientTable = jTable;
        this.renderer = new RowHeaderRenderer(this, jTable);
        this.getColumnModel().getColumn(0).setCellRenderer(this.renderer);
        this.setSelectionModel(jTable.getSelectionModel());
        this.setBackground(jTable.getBackground());
        this.setOpaque(false);
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setRowSelectionAllowed(false);
        this.setAutoscrolls(false);
        this.setFocusable(false);
        this.clientTable.addPropertyChangeListener("font", this);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.renderer != null) {
            this.renderer.setFont(font);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            jViewport.addChangeListener(this);
        }
        this.setRowHeight(this.clientTable.getRowHeight());
    }

    public void rowHeightChanged(int n) {
        this.setRowHeight(n, this.clientTable.getRowHeight(n));
    }

    public void rowHeightChanged() {
        if (this.clientTable == null) {
            return;
        }
        int n = this.clientTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setRowHeight(i, this.clientTable.getRowHeight(i));
        }
    }

    public static void showRowHeader(JTable jTable) {
        Container container;
        Container container2 = jTable.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            jScrollPane.setRowHeaderView(new TableRowHeader(jTable));
        }
    }

    public static boolean isRowHeaderVisible(JTable jTable) {
        return TableRowHeader.getRowHeader(jTable) != null;
    }

    public static TableRowHeader getRowHeader(JTable jTable) {
        Component component;
        JScrollPane jScrollPane;
        JViewport jViewport;
        Container container;
        Container container2 = jTable.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && (jViewport = (jScrollPane = (JScrollPane)container).getRowHeader()) != null && (component = jViewport.getView()) instanceof TableRowHeader) {
            return (TableRowHeader)component;
        }
        return null;
    }

    public static void removeRowHeader(JTable jTable) {
        Container container;
        Container container2 = jTable.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            TableRowHeader tableRowHeader = TableRowHeader.getRowHeader(jTable);
            if (tableRowHeader != null && tableRowHeader.clientTable != null) {
                tableRowHeader.clientTable.getModel().removeTableModelListener(tableRowHeader);
            }
            jScrollPane.setRowHeader(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JViewport jViewport = (JViewport)changeEvent.getSource();
        if (jViewport == null) {
            return;
        }
        JScrollPane jScrollPane = (JScrollPane)jViewport.getParent();
        if (jScrollPane == null) {
            return;
        }
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        if (jScrollBar == null) {
            return;
        }
        jScrollBar.setValue(jViewport.getViewPosition().y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.clientTable && "font".equals(propertyChangeEvent.getPropertyName())) {
            Font font = this.clientTable.getFont();
            this.setFont(font);
        }
    }
}

