/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FlatButton;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;

public class WbColorPicker
extends JPanel
implements Serializable {
    private ActionListener actionListener;
    private JLabel defaultLabel;
    private JPanel infoPanel;
    private JButton resetButton;
    private JLabel sampleColor;
    private JButton selectColor;

    public WbColorPicker() {
        this(false);
    }

    public WbColorPicker(boolean bl) {
        this.initComponents();
        this.resetButton.setEnabled(bl);
        this.resetButton.setVisible(bl);
        int n = IconMgr.getInstance().getSizeForLabel();
        int n2 = (int)((double)n * 1.5);
        if (bl) {
            this.resetButton.setIcon(IconMgr.getInstance().getLabelIcon("delete"));
            WbSwingUtilities.adjustButtonWidth(this.resetButton, n2, n2);
        }
        this.defaultLabel.setVisible(false);
        WbSwingUtilities.adjustButtonWidth(this.selectColor, n2, n2);
        Dimension dimension = new Dimension((int)((double)n2 * 0.9), (int)((double)n2 * 0.9));
        this.setButtonSize(this.sampleColor, dimension);
        this.sampleColor.setOpaque(true);
        this.sampleColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
    }

    private void setButtonSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setMinimumSize(dimension);
    }

    public void setDefaultLabelKey(String string) {
        this.defaultLabel.setText(ResourceMgr.getString(string));
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.sampleColor = new JLabel();
        this.resetButton = new FlatButton();
        this.selectColor = new FlatButton();
        this.defaultLabel = new JLabel();
        this.setLayout(new FlowLayout(0, 0, 0));
        this.infoPanel.setLayout(new FlowLayout(1, 5, 0));
        this.sampleColor.setMinimumSize(new Dimension(16, 16));
        this.sampleColor.setPreferredSize(new Dimension(16, 16));
        this.infoPanel.add(this.sampleColor);
        this.resetButton.setToolTipText(ResourceMgr.getDescription("LblResetColor"));
        this.resetButton.setMaximumSize(null);
        this.resetButton.setMinimumSize(null);
        this.resetButton.setPreferredSize(null);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WbColorPicker.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.infoPanel.add(this.resetButton);
        this.selectColor.setText("...");
        this.selectColor.setMargin(new Insets(0, 0, 0, 0));
        this.selectColor.setMaximumSize(null);
        this.selectColor.setMinimumSize(null);
        this.selectColor.setPreferredSize(null);
        this.selectColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WbColorPicker.this.selectColorMouseClicked(mouseEvent);
            }
        });
        this.infoPanel.add(this.selectColor);
        this.defaultLabel.setText(ResourceMgr.getString("LblNone"));
        this.infoPanel.add(this.defaultLabel);
        this.add(this.infoPanel);
    }

    private void selectColorMouseClicked(MouseEvent mouseEvent) {
        Color color = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(this), ResourceMgr.getString("TxtSelectColor"), this.getSelectedColor());
        if (color != null) {
            this.setSelectedColor(color);
            this.fireColorChanged();
        }
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.resetColor();
        this.fireColorChanged();
    }

    private void fireColorChanged() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1, "color-changed"));
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    private void resetColor() {
        this.resetButton.setEnabled(false);
        this.sampleColor.setBackground(this.getBackground());
        this.defaultLabel.setVisible(true);
    }

    public void setSelectedColor(Color color) {
        if (color == null) {
            this.resetColor();
        } else {
            this.resetButton.setEnabled(true);
            this.defaultLabel.setVisible(false);
            this.sampleColor.setBackground(color);
        }
    }

    public Color getSelectedColor() {
        if (this.defaultLabel.isVisible()) {
            return null;
        }
        return this.sampleColor.getBackground();
    }
}

