/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CancellationException;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DropDownButton;
import workbench.gui.components.FocusIndicator;
import workbench.gui.components.PlainEditor;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbToolbar;
import workbench.gui.dbobjects.EditorTabSelectMenu;
import workbench.gui.dbobjects.ScriptExecutionFeedback;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.Highlighter;
import workbench.gui.sql.PanelContentSender;
import workbench.gui.sql.PasteType;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Replaceable;
import workbench.interfaces.Resettable;
import workbench.interfaces.ResultLogger;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.DelimiterDefinition;
import workbench.sql.ErrorDescriptor;
import workbench.sql.ExecutionStatus;
import workbench.sql.parser.ScriptParser;
import workbench.util.StringUtil;

public class DbObjectSourcePanel
extends JPanel
implements ActionListener,
Resettable,
ResultLogger {
    protected EditorPanel sourceEditor;
    protected PlainEditor errorLog;
    private JSplitPane splitPane;
    protected ReloadAction reloadSource;
    protected DropDownButton editButton;
    private EditorTabSelectMenu selectTabMenu;
    private MainWindow parentWindow;
    private boolean initialized;
    private boolean allowReformat;
    private boolean allowEditAndExec;
    private String objectName;
    private WbToolbar toolbar;
    private WbConnection connection;
    private WbAction runScript;
    private final String runScriptCommand = "run-script";
    private String objectType;

    public DbObjectSourcePanel(MainWindow mainWindow, Reloadable reloadable) {
        super(new BorderLayout());
        this.parentWindow = mainWindow;
        if (reloadable != null) {
            this.reloadSource = new ReloadAction(reloadable);
            this.reloadSource.setEnabled(false);
        }
    }

    public Replaceable getEditor() {
        return this.sourceEditor.getReplacer();
    }

    private void checkReadonly() {
        boolean bl;
        boolean bl2 = bl = this.connection == null || this.connection.getProfile().isReadOnly() || this.runScript == null;
        if (this.runScript != null) {
            this.runScript.setEnabled(!bl);
        }
        this.sourceEditor.setEditable(!bl);
    }

    public void allowEditing(boolean bl) {
        boolean bl2 = this.allowEditAndExec;
        this.allowEditAndExec = bl;
        if (this.initialized && this.allowEditAndExec != bl2) {
            this.toolbar.invalidate();
            if (this.allowEditAndExec) {
                this.enableSourceEditing();
            } else {
                this.disableSourceEditing();
            }
            this.checkReadonly();
            WbSwingUtilities.invokeLater(this.toolbar::validate);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.sourceEditor.setEnabled(bl);
        if (this.editButton != null) {
            this.editButton.setEnabled(bl);
        }
        if (bl) {
            this.checkReadonly();
        } else if (this.runScript != null) {
            this.runScript.setEnabled(false);
        }
        if (this.reloadSource != null) {
            this.reloadSource.setEnabled(bl);
        }
    }

    public void allowReformat() {
        this.allowReformat = true;
    }

    private void initGui() {
        if (this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(this::_initGui);
    }

    private void _initGui() {
        if (this.initialized) {
            return;
        }
        this.sourceEditor = EditorPanel.createSqlEditor();
        this.sourceEditor.showFindOnPopupMenu();
        this.sourceEditor.setEditable(false);
        this.sourceEditor.setAllowFileLoading(false);
        this.sourceEditor.setAllowReformatOnReadonly(true);
        if (this.allowReformat) {
            this.sourceEditor.showFormatSql();
        }
        this.toolbar = new WbToolbar();
        if (this.reloadSource != null) {
            this.toolbar.add(this.reloadSource);
            this.reloadSource.addToInputMap(this.sourceEditor);
        }
        this.add((Component)this.sourceEditor, "Center");
        if (this.parentWindow != null) {
            this.editButton = new DropDownButton(ResourceMgr.getString("LblEditScriptSource"));
            this.selectTabMenu = new EditorTabSelectMenu(ResourceMgr.getString("LblEditScriptSource"), "LblEditInNewTab", "LblEditInTab", this.parentWindow);
            this.selectTabMenu.setActionListener(this);
            this.editButton.setDropDownMenu(this.selectTabMenu.getPopupMenu());
            this.toolbar.add(this.editButton);
        }
        if (this.allowEditAndExec) {
            this.enableSourceEditing();
        }
        this.add((Component)this.toolbar, "First");
        if (DbExplorerSettings.showFocusInDbExplorer()) {
            new FocusIndicator(this.sourceEditor, this.sourceEditor);
        }
        this.initialized = true;
    }

    private void disableSourceEditing() {
        this.sourceEditor.setEditable(false);
        if (this.runScript != null) {
            this.runScript.setEnabled(false);
        }
    }

    private void enableSourceEditing() {
        if (this.runScript == null) {
            this.runScript = new WbAction(this, "run-script");
            this.runScript.setIcon("execute_sel");
            this.toolbar.add(Box.createHorizontalStrut(IconMgr.getInstance().getSizeForLabel()));
            this.toolbar.addSeparator();
            this.toolbar.add(this.runScript);
        }
        this.runScript.setEnabled(this.sourceEditor.getDocumentLength() > 0);
        this.sourceEditor.setEditable(true);
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.sourceEditor.setCursor(cursor);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("run-script".equals(string)) {
            this.runScript();
        }
        if (string.startsWith("panel_") && this.parentWindow != null) {
            try {
                int n = Integer.parseInt(string.substring("panel_".length()));
                EventQueue.invokeLater(() -> this.editText(n));
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when accessing editor tab", exception);
            }
        }
    }

    private void editText(int n) {
        if (this.parentWindow != null) {
            PanelContentSender panelContentSender = new PanelContentSender(this.parentWindow, this.objectName);
            panelContentSender.sendContent(this.getText(), n, PasteType.overwrite);
        }
    }

    public void setPlainText(String string) {
        this.initGui();
        this.setEditorText(string, false);
    }

    public void setText(String string, String string2, String string3) {
        this.initGui();
        boolean bl = StringUtil.isNonEmpty(string);
        this.objectName = string2;
        this.objectType = string3;
        if (this.reloadSource != null) {
            this.reloadSource.setEnabled(bl);
        }
        if (this.runScript != null) {
            this.runScript.setEnabled(this.allowEditAndExec && bl);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(bl);
        }
        if (bl && (string.startsWith("Support for displaying view source is currently not configured for:") || string.startsWith("Support for displaying procedure source is currently not configured for:") || string.startsWith(ResourceMgr.getString("MsgSynonymSourceNotImplemented")))) {
            this.setEditorText(string, false);
        } else {
            this.setEditorText(string, true);
        }
    }

    private void setEditorText(String string, boolean bl) {
        if (bl) {
            this.sourceEditor.enableSqlHighlight();
        } else {
            this.sourceEditor.disableSqlHighlight();
        }
        WbSwingUtilities.invoke(() -> {
            this.hideErrorLog();
            this.sourceEditor.setText(string == null ? "" : string);
            this.sourceEditor.clearUndoBuffer();
            this.sourceEditor.invalidate();
            this.sourceEditor.doLayout();
        });
    }

    public void appendText(String string) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            this.sourceEditor.appendLine(string);
            this.sourceEditor.invalidate();
            this.sourceEditor.doLayout();
        });
    }

    public void appendDelimiter(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        if (wbConnection.generateCommitForDDL()) {
            DelimiterDefinition delimiterDefinition = wbConnection.getAlternateDelimiter();
            this.appendText("\nCOMMIT");
            if (delimiterDefinition == null) {
                this.appendText(";\n");
            } else {
                this.appendText("\n" + delimiterDefinition.getDelimiter() + "\n");
            }
        }
    }

    public String getText() {
        if (this.sourceEditor == null) {
            return null;
        }
        return this.sourceEditor.getText();
    }

    @Override
    public void requestFocus() {
        if (this.sourceEditor != null) {
            this.sourceEditor.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.requestFocusInWindow();
        }
        return false;
    }

    public void setCaretPosition(int n, boolean bl) {
        this.initGui();
        this.sourceEditor.setCaretPosition(n);
        if (bl) {
            int n2 = this.sourceEditor.getCaretLine();
            int n3 = this.sourceEditor.getLineLength(n2);
            int n4 = this.sourceEditor.getLineStartOffset(n2);
            if (n4 > 0 && n3 > 0) {
                this.sourceEditor.select(n4, n4 + n3);
            }
        }
    }

    public void scrollToCaret() {
        if (this.sourceEditor != null) {
            this.sourceEditor.scrollToCaret();
        }
    }

    public void setDatabaseConnection(WbConnection wbConnection) {
        this.initGui();
        this.sourceEditor.setDatabaseConnection(wbConnection);
        this.connection = wbConnection;
        this.checkReadonly();
    }

    public void setEditable(boolean bl) {
        if (this.sourceEditor != null) {
            this.sourceEditor.setEditable(bl);
        }
    }

    @Override
    public void reset() {
        if (this.sourceEditor != null) {
            this.setText("", null, null);
            WbSwingUtilities.invoke(this::hideErrorLog);
        }
    }

    public void dispose() {
        this.reset();
        WbSwingUtilities.removeAllListeners(this);
        if (this.selectTabMenu != null) {
            this.selectTabMenu.dispose();
            this.selectTabMenu = null;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.dispose();
            this.sourceEditor = null;
        }
        if (this.editButton != null) {
            this.editButton.dispose();
            this.editButton = null;
        }
        if (this.reloadSource != null) {
            this.reloadSource.dispose();
            this.reloadSource = null;
        }
        if (this.runScript != null) {
            this.runScript.dispose();
            this.runScript = null;
        }
        if (this.errorLog != null) {
            this.errorLog.setText("");
            this.errorLog = null;
        }
    }

    private void showErrorLog() {
        if (this.errorLog != null) {
            return;
        }
        this.remove(this.sourceEditor);
        this.errorLog = new PlainEditor("workbench.sql.error.wordwrap", false, false);
        this.splitPane = new WbSplitPane(0, true, this.sourceEditor, this.errorLog);
        this.add((Component)this.splitPane, "Center");
        this.invalidate();
        this.doLayout();
        this.splitPane.setDividerLocation(0.8);
    }

    private void hideErrorLog() {
        if (this.errorLog == null) {
            return;
        }
        this.splitPane.remove(this.sourceEditor);
        this.splitPane.remove(this.errorLog);
        this.remove(this.splitPane);
        this.add((Component)this.sourceEditor, "Center");
        this.splitPane = null;
        this.errorLog.setText("");
        this.errorLog = null;
        this.invalidate();
        this.doLayout();
    }

    @Override
    public void clearLog() {
        if (this.errorLog != null) {
            WbSwingUtilities.invoke(this.errorLog::clear);
        }
    }

    @Override
    public void appendToLog(CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        if (this.errorLog != null) {
            if (StringUtil.isBlank(this.errorLog.getText()) && StringUtil.isBlank(charSequence)) {
                return;
            }
            WbSwingUtilities.invoke(() -> this.errorLog.append(charSequence.toString()));
        }
    }

    @Override
    public void showLogMessage(CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        if (this.errorLog != null) {
            WbSwingUtilities.invoke(() -> this.errorLog.setText(charSequence.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript() {
        if (this.connection == null) {
            return;
        }
        if (this.connection.getProfile().isReadOnly()) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.connection)) {
            return;
        }
        String string = this.getText();
        if (string.isEmpty()) {
            return;
        }
        String string2 = this.objectType == null ? "object" : this.objectType.toLowerCase();
        boolean bl = false == DbExplorerSettings.objectTypesToRunWithoutConfirmation().contains(string2);
        String string3 = ResourceMgr.getFormattedString("MsgConfirmRecreate", string2, this.objectName);
        if (bl && !WbSwingUtilities.getYesNo(this, string3)) {
            return;
        }
        this.showErrorLog();
        try {
            ErrorDescriptor errorDescriptor;
            this.runScript.setEnabled(false);
            ScriptExecutionFeedback scriptExecutionFeedback = new ScriptExecutionFeedback(this.connection, string, this);
            scriptExecutionFeedback.runScript(this.objectName, this.parentWindow);
            ExecutionStatus executionStatus = (ExecutionStatus)((Object)scriptExecutionFeedback.get());
            if (executionStatus == ExecutionStatus.Error && (errorDescriptor = scriptExecutionFeedback.getLastError()) != null) {
                Highlighter highlighter = new Highlighter(this.sourceEditor);
                ScriptParser scriptParser = ScriptParser.createScriptParser(this.connection);
                scriptParser.setScript(string);
                highlighter.markError(false, scriptParser, scriptExecutionFeedback.getLastErrorIndex(), 0, errorDescriptor);
            }
        }
        catch (CancellationException cancellationException) {
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when running script", exception);
        }
        finally {
            this.runScript.setEnabled(true);
            WbSwingUtilities.requestFocus(this.sourceEditor);
        }
    }
}

