/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;

public class ExplorerUtils {
    public static void endTransaction(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        if (wbConnection.getAutoCommit()) {
            return;
        }
        if (!wbConnection.isShared() && wbConnection.selectStartsTransaction()) {
            wbConnection.rollbackSilently();
        }
    }

    public static boolean isOwnTransaction(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.getAutoCommit()) {
            return false;
        }
        return !wbConnection.isShared();
    }

    public static void initDbExplorerConnection(WbConnection wbConnection) {
        int n;
        wbConnection.getMetadata().disableOutput();
        if (wbConnection.getMetadata().isSqlServer() && (n = wbConnection.getDbSettings().getLockTimoutForSqlServer()) > 0) {
            SqlServerUtil.setLockTimeout(wbConnection, n);
        }
    }
}

