/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import workbench.db.DbObject;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleObjectCompiler;
import workbench.gui.WbSwingUtilities;
import workbench.gui.sql.EditorPanel;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.WbThread;

public class ObjectCompilerUI
extends JPanel
implements Runnable,
WindowListener {
    private Thread worker;
    protected EditorPanel log;
    private JFrame window;
    private List<DbObject> objects;
    private OracleObjectCompiler compiler;
    private WbConnection dbConnection;

    public ObjectCompilerUI(List<DbObject> list, WbConnection wbConnection) throws SQLException {
        this.objects = list;
        this.dbConnection = wbConnection;
        this.compiler = new OracleObjectCompiler(wbConnection);
        this.setLayout(new BorderLayout());
        this.log = EditorPanel.createTextEditor();
        this.add((Component)this.log, "Center");
    }

    private void startCompile() {
        this.worker = new WbThread(this, "ObjectCompiler Thread");
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = ResourceMgr.getString("TxtCompilingObject");
        this.log.setText("");
        int n = this.objects.size();
        try {
            this.dbConnection.setBusy(true);
            for (int i = 0; i < n; ++i) {
                DbObject dbObject = this.objects.get(i);
                if (i > 0) {
                    this.appendLog("\n");
                }
                if (dbObject instanceof ProcedureDefinition && ((ProcedureDefinition)dbObject).isPackageProcedure()) {
                    this.appendLog(string + " " + dbObject.getCatalog() + "... ");
                } else {
                    this.appendLog(string + " " + dbObject.getObjectName() + "... ");
                }
                String string2 = this.compiler.compileObject(dbObject);
                if (string2 == null) {
                    this.appendLog(ResourceMgr.getString("TxtOK"));
                    continue;
                }
                this.appendLog(ResourceMgr.getString("TxtError") + "\n  " + string2.replaceAll("((\r\n)|(\n\r)|\r|\n)", "\n  "));
            }
        }
        finally {
            this.dbConnection.setBusy(false);
        }
        EventQueue.invokeLater(() -> this.log.setCaretPosition(0));
    }

    private void appendLog(String string) {
        EventQueue.invokeLater(() -> {
            this.log.appendLine(string);
            this.log.validate();
            this.log.updateScrollBars();
        });
    }

    public void show(Window window) {
        if (this.window == null) {
            this.window = new JFrame(ResourceMgr.getString("TxtWindowTitleCompileStatus"));
            this.window.getContentPane().setLayout(new BorderLayout());
            this.window.getContentPane().add((Component)this, "Center");
            ResourceMgr.setWindowIcons((Window)this.window, "compile");
            if (!Settings.getInstance().restoreWindowSize(this.window, ObjectCompilerUI.class.getName())) {
                this.window.setSize(500, 400);
            }
            if (!Settings.getInstance().restoreWindowPosition(this.window, ObjectCompilerUI.class.getName())) {
                WbSwingUtilities.center(this.window, window);
            }
            this.window.addWindowListener(this);
        }
        this.window.setVisible(true);
        this.startCompile();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.worker != null) {
            this.worker.interrupt();
            this.compiler = null;
            this.worker = null;
        }
        Settings.getInstance().storeWindowPosition(this.window, ObjectCompilerUI.class.getName());
        Settings.getInstance().storeWindowSize(this.window, ObjectCompilerUI.class.getName());
        this.window.setVisible(false);
        this.window.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

