/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import workbench.WbManager;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DropType;
import workbench.db.GenericObjectDropper;
import workbench.db.JdbcProcedureReader;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.ProcedureReader;
import workbench.db.ReaderFactory;
import workbench.db.SourceStatementsHelp;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.dependency.DependencyReaderFactory;
import workbench.db.objectcache.SourceCache;
import workbench.db.oracle.OraclePackageParser;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.AlterProcedureAction;
import workbench.gui.actions.CompileDbObjectAction;
import workbench.gui.actions.CreateSnippetAction;
import workbench.gui.actions.DropDbObjectAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.ScriptDbObjectAction;
import workbench.gui.actions.WbAction;
import workbench.gui.actions.WbPluginProcedurePanelAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.FlatButton;
import workbench.gui.components.QuickFilterPanel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.DbObjectSourcePanel;
import workbench.gui.dbobjects.DbObjectTable;
import workbench.gui.dbobjects.EditorTabSelectMenu;
import workbench.gui.dbobjects.IsolationLevelChanger;
import workbench.gui.dbobjects.ObjectDependencyPanel;
import workbench.gui.dbobjects.ProcedureChangeValidator;
import workbench.gui.dbobjects.SummaryLabel;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.gui.renderer.ProcStatusRenderer;
import workbench.gui.renderer.SqlTypeRenderer;
import workbench.gui.settings.PlacementChooser;
import workbench.gui.sql.PanelContentSender;
import workbench.gui.sql.PasteType;
import workbench.interfaces.PropertyStorage;
import workbench.interfaces.Reloadable;
import workbench.interfaces.WbProcedurePanelAction;
import workbench.interfaces.WbSelectionModel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.storage.DataStore;
import workbench.util.FilteredProperties;
import workbench.util.LowMemoryException;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbPluginUtil;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class ProcedureListPanel
extends JPanel
implements ListSelectionListener,
Reloadable,
DbObjectList,
PropertyChangeListener,
TableModelListener {
    private WbConnection dbConnection;
    private JPanel listPanel;
    private QuickFilterPanel findPanel;
    private DbObjectTable procList;
    private WbTable procColumns;
    private DbObjectSourcePanel source;
    private ObjectDependencyPanel dependencyPanel;
    private JTabbedPane displayTab;
    private JPanel statusPanel;
    private FlatButton alterButton;
    private WbSplitPane splitPane;
    private String currentSchema;
    private String currentCatalog;
    private boolean shouldRetrieve;
    private CompileDbObjectAction compileAction;
    private SummaryLabel infoLabel;
    private boolean isRetrieving;
    protected ProcStatusRenderer statusRenderer;
    private MainWindow parentWindow;
    private boolean initialized;
    private FilteredProperties workspaceSettings;
    private EditorTabSelectMenu generateWbCall;
    private SourceCache cache;
    private FilterDefinitionManager filterMgr;
    private IsolationLevelChanger levelChanger = new IsolationLevelChanger();
    private ProcedureChangeValidator validator = new ProcedureChangeValidator();
    private AlterProcedureAction renameAction;

    public ProcedureListPanel(MainWindow mainWindow) {
        this.parentWindow = mainWindow;
    }

    private void initGui() {
        if (this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(this::_initGui);
    }

    private void _initGui() {
        if (this.initialized) {
            return;
        }
        this.displayTab = new WbTabbedPane();
        int n = PlacementChooser.getPlacementLocation();
        this.displayTab.setTabPlacement(n);
        this.procColumns = new DbObjectTable();
        Reloadable reloadable = () -> {
            if (this.dbConnection.isBusy()) {
                return;
            }
            try {
                this.dbConnection.setBusy(true);
                this.retrieveCurrentProcedure(false);
            }
            finally {
                this.dbConnection.setBusy(false);
            }
        };
        this.source = new DbObjectSourcePanel(this.parentWindow, reloadable);
        if (DbExplorerSettings.allowSourceEditing()) {
            this.source.allowEditing(true);
        }
        this.displayTab.add(ResourceMgr.getString("TxtDbExplorerSource"), this.source);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new WbScrollPane(this.procColumns), "Center");
        this.displayTab.add(ResourceMgr.getString("TxtDbExpProcParams"), jPanel);
        this.listPanel = new JPanel(new BorderLayout());
        this.statusRenderer = new ProcStatusRenderer();
        this.procList = new DbObjectTable(){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n2 == this.convertColumnIndexToView(1)) {
                    return ProcedureListPanel.this.statusRenderer;
                }
                return super.getCellRenderer(n, n2);
            }
        };
        this.procList.setReadOnly(!DbExplorerSettings.allowAlterInDbExplorer());
        this.procList.getSelectionModel().addListSelectionListener(this);
        this.procList.getSelectionModel().setSelectionMode(2);
        this.procList.setRememberColumnOrder(DbExplorerSettings.getRememberMetaColumnOrder("procedurelist"));
        this.procList.addTableModelListener(this);
        if (DbExplorerSettings.enableExtendedObjectFilter()) {
            this.filterMgr = new FilterDefinitionManager();
        }
        this.findPanel = new QuickFilterPanel(this.procList, false, this.filterMgr, "procedurelist");
        this.configureFindPanel();
        ReloadAction reloadAction = new ReloadAction(this);
        reloadAction.setUseLabelIconSize(true);
        this.findPanel.addToToolbar(reloadAction, true, false);
        reloadAction.getToolbarButton().setToolTipText(ResourceMgr.getString("TxtRefreshProcedureList"));
        this.listPanel.add((Component)this.findPanel, "North");
        this.splitPane = new WbSplitPane(1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(6);
        this.listPanel.add((Component)new WbScrollPane(this.procList), "Center");
        this.renameAction = new AlterProcedureAction(this.procList);
        this.renameAction.setReloader(this);
        this.renameAction.setEnabled(false);
        this.renameAction.addPropertyChangeListener(this);
        this.statusPanel = new JPanel(new BorderLayout());
        this.alterButton = new FlatButton(this.renameAction);
        this.alterButton.setResourceKey("MnuTxtRunAlter");
        this.infoLabel = new SummaryLabel("");
        this.statusPanel.add((Component)this.infoLabel, "Center");
        this.listPanel.add((Component)this.statusPanel, "South");
        this.splitPane.setLeftComponent(this.listPanel);
        this.splitPane.setRightComponent(this.displayTab);
        this.splitPane.setDividerBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.setDefaultComponent(this.findPanel);
        wbTraversalPolicy.addComponent(this.findPanel);
        wbTraversalPolicy.addComponent(this.procList);
        wbTraversalPolicy.addComponent(this.procColumns);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.reset();
        this.extendPopupMenu();
        this.source.setDatabaseConnection(this.dbConnection);
        this.compileAction.setConnection(this.dbConnection);
        this.validator.setConnection(this.dbConnection);
        this.renameAction.setConnection(this.dbConnection);
        this.initialized = true;
        this.restoreSettings();
        if (this.workspaceSettings != null) {
            this.readSettings(this.workspaceSettings, this.workspaceSettings.getFilterPrefix());
            this.workspaceSettings = null;
        }
        this.addDependencyPanelIfSupported();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.dbexplorer.allow.source.edit", new String[0]);
    }

    public void dispose() {
        this.reset();
        if (this.generateWbCall != null) {
            this.generateWbCall.removeAll();
        }
        if (this.procList != null) {
            this.procList.dispose();
        }
        if (this.source != null) {
            this.source.dispose();
        }
        WbAction.dispose(this.compileAction, this.renameAction);
        if (this.findPanel != null) {
            this.findPanel.dispose();
        }
        if (this.dependencyPanel != null) {
            this.dependencyPanel.dispose();
        }
        Settings.getInstance().removePropertyChangeListener(this);
    }

    private void configureFindPanel() {
        if (this.findPanel == null) {
            return;
        }
        this.findPanel.setFilterOnType(DbExplorerSettings.getFilterDuringTyping());
        this.findPanel.setAlwaysUseContainsFilter(DbExplorerSettings.getUsePartialMatch());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.renameAction) {
            this.checkAlterButton();
        } else if (propertyChangeEvent.getPropertyName().equals("workbench.dbexplorer.instantfilter") || propertyChangeEvent.getPropertyName().equals("workbench.dbexplorer.assumewildcards")) {
            this.configureFindPanel();
        } else if ("workbench.dbexplorer.allow.source.edit".equals(propertyChangeEvent.getPropertyName()) && this.source != null) {
            this.source.allowEditing(DbExplorerSettings.allowSourceEditing());
        }
    }

    protected void checkAlterButton() {
        WbSwingUtilities.invoke(() -> {
            if (this.renameAction.isEnabled() && !WbSwingUtilities.containsComponent(this.statusPanel, this.alterButton)) {
                this.statusPanel.add((Component)this.alterButton, "East");
                this.statusPanel.validate();
            } else {
                this.statusPanel.remove(this.alterButton);
            }
        });
    }

    private void extendPopupMenu() {
        if (this.parentWindow != null) {
            this.generateWbCall = this.createGenerateWbCallMenu();
            this.procList.addPopupMenu(this.generateWbCall, true);
            this.loadPlugInActions();
        }
        WbSelectionModel wbSelectionModel = WbSelectionModel.Factory.createFacade(this.procList.getSelectionModel());
        ScriptDbObjectAction scriptDbObjectAction = new ScriptDbObjectAction(this, wbSelectionModel);
        this.procList.addPopupAction(scriptDbObjectAction, true);
        this.compileAction = new CompileDbObjectAction(this, wbSelectionModel);
        this.procList.addPopupAction(this.compileAction, false);
        DropDbObjectAction dropDbObjectAction = new DropDbObjectAction(this, wbSelectionModel, this);
        this.procList.addPopupAction(dropDbObjectAction, false);
    }

    private void loadPlugInActions() {
        DBID dBID = DBID.fromID(this.dbConnection.getMetadata().getDbId());
        WbConnection wbConnection = this.getConnection();
        WbPluginUtil.getPluginProcedurePanelActions(dBID).forEach(wbProcedurePanelAction -> {
            WbPluginProcedurePanelAction wbPluginProcedurePanelAction = new WbPluginProcedurePanelAction((WbProcedurePanelAction)wbProcedurePanelAction, wbConnection, this::getCurrentProcedureDefinition);
            this.procList.getSelectionModel().addListSelectionListener(wbPluginProcedurePanelAction);
            this.procList.addPopupAction(wbPluginProcedurePanelAction, false);
        });
    }

    private EditorTabSelectMenu createGenerateWbCallMenu() {
        EditorTabSelectMenu editorTabSelectMenu = new EditorTabSelectMenu(ResourceMgr.getString("MnuTxtShowProcData"), "LblWbCallInNewTab", "LblWbCallInTab", this.parentWindow, true);
        editorTabSelectMenu.setActionListener(actionEvent -> {
            Object object;
            int n;
            String string = actionEvent.getActionCommand();
            if ("clipboard".equals(string)) {
                n = WbAction.isCtrlPressed(actionEvent);
                object = this.buildProcedureCallForTable();
                if (object != null) {
                    if (n != 0) {
                        object = CreateSnippetAction.makeJavaString(object, true);
                    }
                    StringSelection stringSelection = new StringSelection((String)object);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                }
            }
            if (string.startsWith("panel_") && this.parentWindow != null) {
                try {
                    n = Integer.parseInt(string.substring("panel_".length()));
                    object = WbAction.isCtrlPressed(actionEvent) ? PasteType.append : PasteType.overwrite;
                    EventQueue.invokeLater(() -> this.lambda$null$3(n, (PasteType)((Object)((Object)object))));
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error when accessing editor tab", exception);
                }
            }
        });
        editorTabSelectMenu.setEnabled(false);
        return editorTabSelectMenu;
    }

    public void disconnect() {
        this.dbConnection = null;
        this.reset();
    }

    public void reset() {
        if (!this.initialized) {
            return;
        }
        this.procList.saveColumnOrder();
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.dbConnection != null) {
            this.dbConnection.getMetadata().getProcedureReader().clearCache();
        }
        WbSwingUtilities.invoke(() -> {
            this.procList.reset();
            this.procColumns.reset();
            this.source.reset();
            if (this.dependencyPanel != null) {
                this.dependencyPanel.reset();
            }
        });
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        if (this.source != null) {
            this.source.setDatabaseConnection(wbConnection);
        }
        this.reset();
        if (this.compileAction != null) {
            this.compileAction.setConnection(wbConnection);
        }
        if (this.dbConnection != null) {
            this.cache = new SourceCache(this.dbConnection.getDbId());
        }
        if (this.validator != null) {
            this.validator.setConnection(this.dbConnection);
        }
        if (this.renameAction != null) {
            this.renameAction.setConnection(this.dbConnection);
        }
        this.addDependencyPanelIfSupported();
    }

    private void addDependencyPanelIfSupported() {
        if (this.dbConnection == null) {
            return;
        }
        if (!this.initialized) {
            return;
        }
        DependencyReader dependencyReader = DependencyReaderFactory.getReader(this.dbConnection);
        if (dependencyReader != null) {
            WbSwingUtilities.invoke(() -> {
                if (this.dependencyPanel == null) {
                    this.dependencyPanel = new ObjectDependencyPanel();
                }
                this.dependencyPanel.setConnection(this.dbConnection);
                this.displayTab.add(ResourceMgr.getString("TxtDeps"), this.dependencyPanel);
            });
        }
    }

    public void setCatalogAndSchema(String string, String string2, boolean bl) throws Exception {
        this.currentSchema = string2;
        this.currentCatalog = string;
        if (this.initialized && this.isVisible() && bl) {
            this.startRetrieve();
        } else {
            this.reset();
            this.shouldRetrieve = true;
        }
    }

    public void panelSelected() {
        if (this.shouldRetrieve) {
            this.startRetrieve();
        }
    }

    public void startRetrieve() {
        this.initGui();
        if (this.isRetrieving) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        this.reset();
        WbThread wbThread = new WbThread("RetrieveProcedures"){

            @Override
            public void run() {
                ProcedureListPanel.this._retrieve();
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retrieve() {
        Container container = this.getParent();
        try {
            this.dbConnection.setBusy(true);
            WbSwingUtilities.showWaitCursor(container);
            WbSwingUtilities.invoke(() -> this.infoLabel.setText(ResourceMgr.getString("MsgRetrieving")));
            if (this.dbConnection.getProfile().getUseSeparateConnectionPerTab()) {
                this.levelChanger.changeIsolationLevel(this.dbConnection);
            }
            DbMetadata dbMetadata = this.dbConnection.getMetadata();
            DataStore dataStore = dbMetadata.getProcedureReader().getProcedures(this.currentCatalog, this.currentSchema, null);
            this.procList.setOriginalOrder(dataStore);
            this.dbConnection.getObjectCache().addProcedureList(dataStore, this.currentSchema);
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
            dataStoreTableModel.setSortDefinition(JdbcProcedureReader.getProcedureListSort());
            dataStoreTableModel.setValidator(this.validator);
            WbSwingUtilities.invoke(() -> {
                this.infoLabel.showObjectListInfo(dataStoreTableModel);
                this.procList.setModel(dataStoreTableModel, true);
            });
            if (this.displayTab.getSelectedComponent() == this.dependencyPanel) {
                this.dependencyPanel.doLoad();
            }
            this.shouldRetrieve = false;
        }
        catch (LowMemoryException lowMemoryException) {
            WbManager.getInstance().showLowMemoryError();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            WbManager.getInstance().showOutOfMemoryError();
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve procedure list", throwable);
        }
        finally {
            this.isRetrieving = false;
            this.dbConnection.setBusy(false);
            this.levelChanger.restoreIsolationLevel(this.dbConnection);
            WbSwingUtilities.showDefaultCursor(container);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.infoLabel.showObjectListInfo(this.procList.getDataStoreTableModel());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.shouldRetrieve) {
            this.initGui();
            WbSwingUtilities.invokeLater(this::startRetrieve);
        }
    }

    private String getWorkspacePrefix(int n) {
        return "dbexplorer" + n + ".procedurelist.";
    }

    public void saveSettings() {
        if (this.initialized) {
            this.storeSettings(Settings.getInstance(), this.getClass().getName() + ".");
            this.findPanel.saveSettings();
        }
    }

    public void saveToWorkspace(WbWorkspace wbWorkspace, int n) {
        String string = this.getWorkspacePrefix(n);
        if (this.initialized) {
            this.storeSettings(wbWorkspace.getSettings(), string);
            this.findPanel.saveSettings(wbWorkspace.getSettings(), string);
        } else if (this.workspaceSettings != null) {
            this.workspaceSettings.copyTo(wbWorkspace.getSettings(), string);
        }
    }

    private void storeSettings(PropertyStorage propertyStorage, String string) {
        if (this.filterMgr != null) {
            this.filterMgr.saveSettings(propertyStorage, string);
        }
        propertyStorage.setProperty(string + "divider", this.splitPane.getDividerLocation());
        List<String> list = this.procList.saveColumnOrder();
        if (list != null) {
            propertyStorage.setProperty(string + "columnorder", StringUtil.listToString(list, ','));
        }
    }

    public void restoreSettings() {
        if (this.initialized) {
            this.readSettings(Settings.getInstance(), this.getClass().getName() + ".");
            this.findPanel.restoreSettings();
        }
    }

    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) {
        String string = this.getWorkspacePrefix(n);
        if (!this.initialized) {
            this.workspaceSettings = new FilteredProperties(wbWorkspace.getSettings(), string);
        } else {
            this.readSettings(wbWorkspace.getSettings(), string);
        }
    }

    private void readSettings(PropertyStorage propertyStorage, String string) {
        int n = propertyStorage.getIntProperty(string + "divider", 200);
        if (this.filterMgr != null) {
            this.filterMgr.loadSettings(propertyStorage, string);
        }
        this.splitPane.setDividerLocation(n);
        this.findPanel.restoreSettings(propertyStorage, string);
        String string2 = propertyStorage.getProperty(string + "columnorder", null);
        if (StringUtil.isNonEmpty(string2)) {
            this.procList.setNewColumnOrder(StringUtil.stringToList(string2, ","));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.initialized) {
            return;
        }
        if (listSelectionEvent.getSource() != this.procList.getSelectionModel()) {
            return;
        }
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.retrieveCurrentProcedure(true);
        if (listSelectionEvent.getSource() == this.procList.getSelectionModel() && this.generateWbCall != null) {
            this.generateWbCall.setEnabled(this.procList.getSelectedRowCount() == 1);
        }
    }

    protected void retrieveCurrentProcedure(boolean bl) {
        ProcedureDefinition procedureDefinition = this.getCurrentProcedureDefinition();
        if (procedureDefinition == null) {
            return;
        }
        EventQueue.invokeLater(() -> this.retrieveProcDefinition(procedureDefinition, bl));
    }

    private ProcedureDefinition getCurrentProcedureDefinition() {
        int n = this.procList.getSelectedRow();
        ProcedureDefinition procedureDefinition = null;
        if (n > -1) {
            procedureDefinition = this.getDefinition(n);
        }
        return procedureDefinition;
    }

    private String getCurrentProcedureName() {
        ProcedureDefinition procedureDefinition = this.getCurrentProcedureDefinition();
        if (procedureDefinition == null) {
            return null;
        }
        return procedureDefinition.getProcedureName();
    }

    private String getCurrentProcedureType() {
        ProcedureDefinition procedureDefinition = this.getCurrentProcedureDefinition();
        if (procedureDefinition == null) {
            return null;
        }
        return procedureDefinition.getObjectType();
    }

    private ProcedureDefinition getDefinition(int n) {
        ProcedureDefinition procedureDefinition = null;
        Object object = this.procList.getDataStore().getRow(n).getUserObject();
        procedureDefinition = object instanceof ProcedureDefinition ? (ProcedureDefinition)object : ProcedureListPanel.buildDefinitionFromDataStore(this.dbConnection, this.procList.getDataStore(), n, true);
        return procedureDefinition;
    }

    public static ProcedureDefinition buildDefinitionFromDataStore(WbConnection wbConnection, DataStore dataStore, int n, boolean bl) {
        Serializable serializable;
        boolean bl2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 1;
        boolean bl3 = bl2 = dataStore.getColumnIndex("SPECIFIC_NAME") > 1;
        if (bl) {
            string = dataStore.getValueAsString(n, 0);
            string2 = dataStore.getValueAsString(n, 3);
            string3 = dataStore.getValueAsString(n, 2);
            string4 = dataStore.getValueAsString(n, 4);
            string5 = bl2 ? dataStore.getValueAsString(n, 5) : null;
            n2 = dataStore.getValueAsInt(n, 1, 1);
        } else {
            string = (String)dataStore.getOriginalValue(n, 0);
            string2 = (String)dataStore.getOriginalValue(n, 3);
            string3 = (String)dataStore.getOriginalValue(n, 2);
            string4 = (String)dataStore.getOriginalValue(n, 4);
            string5 = bl2 ? (String)dataStore.getOriginalValue(n, 5) : null;
            serializable = (Integer)dataStore.getOriginalValue(n, 1);
            if (serializable != null) {
                n2 = (Integer)serializable;
            }
        }
        serializable = null;
        if (wbConnection.getMetadata().isOracle() && string3 != null) {
            serializable = ProcedureDefinition.createOracleDefinition(string2, string, string3, n2, string4);
        } else {
            serializable = new ProcedureDefinition(string3, string2, string, n2);
            ((ProcedureDefinition)serializable).setComment(string4);
        }
        ((ProcedureDefinition)serializable).setSpecificName(string5);
        return serializable;
    }

    private String getCacheKey(ProcedureDefinition procedureDefinition) {
        if (procedureDefinition.isPackageProcedure()) {
            return procedureDefinition.getSchema() + "." + procedureDefinition.getPackageName();
        }
        return procedureDefinition.getObjectNameForDrop(this.dbConnection);
    }

    private CharSequence getSourceFromCache(ProcedureDefinition procedureDefinition) {
        if (procedureDefinition == null) {
            return null;
        }
        return this.cache.getSource(procedureDefinition.getObjectType(), this.getCacheKey(procedureDefinition));
    }

    private void putSourceToCache(ProcedureDefinition procedureDefinition, CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        if (this.cache.addSource(procedureDefinition.getObjectType(), this.getCacheKey(procedureDefinition), charSequence)) {
            procedureDefinition.setSource(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveProcDefinition(ProcedureDefinition procedureDefinition, boolean bl) {
        if (this.dbConnection == null) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        Container container = this.getParent();
        WbSwingUtilities.showWaitCursor(container);
        CharSequence charSequence = null;
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.dbConnection.getProfile().getUseSeparateConnectionPerTab()) {
                this.levelChanger.changeIsolationLevel(this.dbConnection);
            }
            this.dbConnection.setBusy(true);
            try {
                object3 = new DataStoreTableModel(dbMetadata.getProcedureReader().getProcedureColumns(procedureDefinition));
                this.procColumns.setModel((TableModel)object3, true);
                object2 = this.procColumns.getColumnModel();
                object = object2.getColumn(3);
                if (object != null) {
                    ((TableColumn)object).setCellRenderer(new SqlTypeRenderer());
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not read procedure definition", exception);
                this.procColumns.reset();
            }
            if (bl) {
                charSequence = this.getSourceFromCache(procedureDefinition);
            } else {
                procedureDefinition.setSource(null);
            }
            try {
                if (charSequence == null) {
                    object3 = ReaderFactory.getProcedureReader(this.dbConnection.getMetadata());
                    object3.readProcedureSource(procedureDefinition);
                    charSequence = procedureDefinition.getSource();
                    this.putSourceToCache(procedureDefinition, charSequence);
                }
                this.source.setText(this.addDropStatement(charSequence, procedureDefinition), this.getCurrentProcedureName(), this.getCurrentProcedureType());
            }
            catch (NoConfigException noConfigException) {
                object2 = new SourceStatementsHelp(this.dbConnection.getMetadata().getMetaDataSQLMgr());
                object = ((SourceStatementsHelp)object2).explainMissingProcSourceSql();
                this.source.setPlainText((String)object);
            }
            catch (Throwable throwable) {
                charSequence = null;
                LogMgr.logError(new CallerInfo(){}, "Could not read procedure source", throwable);
                this.source.setPlainText(throwable.getMessage());
            }
        }
        finally {
            WbSwingUtilities.showDefaultCursor(container);
            this.levelChanger.restoreIsolationLevel(this.dbConnection);
            this.dbConnection.setBusy(false);
        }
        this.source.appendDelimiter(this.dbConnection);
        if (this.dependencyPanel != null) {
            this.dependencyPanel.setCurrentObject(procedureDefinition);
        }
        int n = this.findOracleProcedureInPackage(charSequence, procedureDefinition);
        if (this.procList.getSelectedRowCount() == 1) {
            EventQueue.invokeLater(() -> {
                this.source.setCaretPosition(n, n > 0);
                if (DbExplorerSettings.getSelectSourcePanelAfterRetrieve()) {
                    this.source.requestFocusInWindow();
                }
            });
        }
    }

    private String addDropStatement(CharSequence charSequence, ProcedureDefinition procedureDefinition) {
        Object object;
        if (charSequence == null || procedureDefinition == null) {
            return "";
        }
        if (DbExplorerSettings.getDropTypeToGenerate() == DropType.none) {
            return charSequence.toString();
        }
        ProcedureReader procedureReader = ReaderFactory.getProcedureReader(this.dbConnection.getMetadata());
        if (procedureReader.isRecreateStatement(charSequence)) {
            return charSequence.toString();
        }
        String string = procedureDefinition.getDropStatement(this.dbConnection, true);
        if (string == null) {
            object = new GenericObjectDropper();
            ((GenericObjectDropper)object).setConnection(this.dbConnection);
            CharSequence charSequence2 = ((GenericObjectDropper)object).getDropForObject(procedureDefinition);
            if (charSequence2 != null) {
                string = charSequence2.toString();
            }
        }
        if (StringUtil.isEmptyString(string = StringUtil.trim(SqlUtil.trimSemicolon(string)))) {
            return charSequence.toString();
        }
        object = Settings.getInstance().getAlternateDelimiter(this.dbConnection, DelimiterDefinition.STANDARD_DELIMITER);
        if (((DelimiterDefinition)object).isSingleLine()) {
            string = string + "\n";
        }
        string = string + ((DelimiterDefinition)object).getDelimiter() + "\n";
        return string + "\n" + charSequence;
    }

    private List<String> getParameterNames() {
        int n = this.procColumns.getRowCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.procColumns.getValueAsString(i, 0);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private int findOracleProcedureInPackage(CharSequence charSequence, ProcedureDefinition procedureDefinition) {
        if (charSequence == null) {
            return 0;
        }
        if (this.dbConnection == null) {
            return 0;
        }
        if (!this.dbConnection.getMetadata().isOracle()) {
            return 0;
        }
        if (StringUtil.isEmptyString(procedureDefinition.getPackageName())) {
            return 0;
        }
        int n = OraclePackageParser.findProcedurePosition(charSequence, procedureDefinition, this.getParameterNames());
        return n < 0 ? 0 : n;
    }

    @Override
    public int getSelectionCount() {
        return this.procList.getSelectedRowCount();
    }

    @Override
    public TableDefinition getCurrentTableDefinition() {
        return null;
    }

    @Override
    public TableIdentifier getObjectTable() {
        return null;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    @Override
    public List<TableIdentifier> getSelectedTables() {
        return Collections.emptyList();
    }

    @Override
    public List<DbObject> getSelectedObjects() {
        if (!this.initialized) {
            return null;
        }
        if (this.procList.getSelectedRowCount() == 0) {
            return null;
        }
        int[] nArray = this.procList.getSelectedRows();
        int n = nArray.length;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>(n);
        if (n == 0) {
            return arrayList;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.procList.getValueAsString(nArray[i], 0);
            if (string.indexOf(59) > 0) {
                string = string.substring(0, string.indexOf(59));
            }
            ProcedureDefinition procedureDefinition = this.getDefinition(nArray[i]);
            arrayList.add(procedureDefinition);
        }
        return arrayList;
    }

    @Override
    public void reload() {
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        this.startRetrieve();
    }

    private void showProcedureCallData(int n, PasteType pasteType) {
        PanelContentSender panelContentSender = new PanelContentSender(this.parentWindow, null);
        String string = this.buildProcedureCallForTable();
        if (string != null) {
            panelContentSender.sendContent(string, n, pasteType);
        }
    }

    private String buildProcedureCallForTable() {
        ProcedureDefinition procedureDefinition = this.getCurrentProcedureDefinition();
        if (procedureDefinition == null) {
            return null;
        }
        return procedureDefinition.createSql(this.getConnection());
    }

    private /* synthetic */ void lambda$null$3(int n, PasteType pasteType) {
        this.showProcedureCallData(n, pasteType);
    }
}

