/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import workbench.resource.GuiSettings;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.RegExComparator;
import workbench.util.StringUtil;

public class QuickFilterExpressionBuilder {
    private final ColumnComparator comparator = new RegExComparator();

    public ColumnExpression buildExpression(String string, boolean bl) {
        return this.buildExpression(string, "*", bl);
    }

    public ColumnExpression buildExpression(String string, String string2, boolean bl) {
        String string3 = this.getPattern(string, bl);
        ColumnExpression columnExpression = new ColumnExpression(string2, this.comparator, string3);
        columnExpression.setIgnoreCase(true);
        return columnExpression;
    }

    private String getPattern(String string, boolean bl) throws PatternSyntaxException {
        if (GuiSettings.getUseRegexInQuickFilter()) {
            Pattern.compile(string);
            return string;
        }
        List<String> list = StringUtil.stringToList(string, ",", true, true, false, false);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (bl && !this.containsWildcards(string2)) {
                string2 = "*" + string2 + "*";
            }
            String string3 = StringUtil.wildcardToRegex(string2, true);
            list.set(i, string3);
        }
        String string4 = StringUtil.listToString(list, "|", false, '\"');
        Pattern.compile(string4);
        return string4;
    }

    private boolean containsWildcards(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(37) > -1 || string.indexOf(42) > -1;
    }
}

