/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportType;
import workbench.gui.WbSwingUtilities;
import workbench.gui.dbobjects.ProgressDialog;
import workbench.gui.dialogs.export.ExportFileDialog;
import workbench.interfaces.DbExecutionListener;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.ResultInfo;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbThread;

public class TableExporter
implements DbExecutionListener {
    private DataExporter exporter;
    private ProgressDialog progress;
    private List<TableIdentifier> toExport;
    private List<ColumnIdentifier> columnsToExport;
    private boolean openExportFile;
    private String selectedOutput;
    private String extension;

    public TableExporter(WbConnection wbConnection) {
        this.exporter = new DataExporter(wbConnection);
        this.exporter.setReportInterval(10);
    }

    public DataExporter getExporter() {
        return this.exporter;
    }

    public boolean selectTables(List<? extends DbObject> list, Frame frame) {
        ExportFileDialog exportFileDialog;
        Object object;
        boolean bl;
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        boolean bl2 = bl = list.size() == 1;
        if (bl && list.get(0) instanceof TableIdentifier) {
            object = null;
            try {
                object = new ResultInfo((TableIdentifier)list.get(0), this.exporter.getConnection());
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve table columns", exception);
            }
            exportFileDialog = new ExportFileDialog((Component)frame, (ResultInfo)object);
            exportFileDialog.setIncludeSqlUpdate(true);
            exportFileDialog.setSelectDirectoryOnly(false);
        } else {
            exportFileDialog = new ExportFileDialog(frame);
            exportFileDialog.setIncludeSqlUpdate(false);
            exportFileDialog.setSelectDirectoryOnly(true);
        }
        exportFileDialog.restoreSettings();
        exportFileDialog.setAllowOpenFile(bl);
        object = list.stream().map(dbObject -> dbObject.getObjectName()).collect(Collectors.joining(", "));
        String string = ResourceMgr.getString("LblSelectDirTitle");
        WbConnection wbConnection = this.exporter.getConnection();
        DbMetadata dbMetadata = wbConnection.getMetadata();
        exportFileDialog.setExportInfo((String)object);
        boolean bl3 = exportFileDialog.selectOutput(string);
        if (!bl3) {
            return false;
        }
        if (bl) {
            this.columnsToExport = exportFileDialog.getColumnsToExport();
        }
        this.openExportFile = exportFileDialog.doOpenFile();
        this.selectedOutput = exportFileDialog.getSelectedFilename();
        exportFileDialog.setExporterOptions(this.exporter);
        this.toExport = new ArrayList<TableIdentifier>(list.size());
        ExportType exportType = exportFileDialog.getExportType();
        this.extension = exportType.getDefaultFileExtension();
        for (DbObject dbObject2 : list) {
            String string2 = dbObject2.getObjectType();
            if (string2 == null || !dbMetadata.objectTypeCanContainData(string2) || !(dbObject2 instanceof TableIdentifier)) continue;
            this.toExport.add((TableIdentifier)dbObject2);
        }
        return bl3;
    }

    public void startExport(final Frame frame) {
        if (this.toExport == null) {
            return;
        }
        this.progress = new ProgressDialog(ResourceMgr.getString("MsgSpoolWindowTitle"), frame, this.exporter);
        this.exporter.setRowMonitor(this.progress.getMonitor());
        this.progress.showProgressWindow();
        this.progress.getInfoPanel().setMonitorType(7);
        this.progress.getInfoPanel().setCurrentObject(ResourceMgr.getString("MsgDiffRetrieveDbInfo"), -1L, -1L);
        WbThread wbThread = new WbThread("Init export"){

            @Override
            public void run() {
                if (TableExporter.this.toExport.size() == 1) {
                    TableExporter.this.exportSingleTable(frame);
                } else {
                    TableExporter.this.exportTableList(frame);
                }
                TableExporter.this.progress.getInfoPanel().setMonitorType(3);
                TableExporter.this.exporter.addExecutionListener(TableExporter.this);
                TableExporter.this.exporter.startBackgroundExport();
            }
        };
        wbThread.start();
    }

    private void exportSingleTable(Frame frame) {
        try {
            TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.exporter.getConnection());
            String string = tableSelectBuilder.getSelectForColumns(this.toExport.get(0), this.columnsToExport, 0);
            this.exporter.addQueryJob(string, new WbFile(this.selectedOutput), null);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not create export query", exception);
            WbSwingUtilities.showMessage(frame, exception.getMessage());
        }
    }

    private void exportTableList(Frame frame) {
        for (TableIdentifier tableIdentifier : this.toExport) {
            String string = StringUtil.makeFilename(tableIdentifier.getObjectName());
            WbFile wbFile = new WbFile(this.selectedOutput, string + this.extension);
            try {
                this.exporter.addTableExportJob(wbFile, tableIdentifier);
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Error adding ExportJob", sQLException);
                WbSwingUtilities.showMessage(frame, sQLException.getMessage());
            }
        }
    }

    @Override
    public void executionStart(WbConnection wbConnection, Object object) {
    }

    @Override
    public void executionEnd(WbConnection wbConnection, Object object) {
        if (this.progress != null) {
            this.progress.finished();
            this.progress.dispose();
        }
        if (this.exporter != null && !this.exporter.isSuccess()) {
            CharSequence charSequence = this.exporter.getErrors();
            WbSwingUtilities.showErrorMessage(charSequence.toString());
        }
        if (this.openExportFile) {
            ExportFileDialog.openFile(this.exporter.getOutputFile());
        }
    }
}

