/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.WbManager;
import workbench.db.DbObject;
import workbench.db.DropType;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CompileDbObjectAction;
import workbench.gui.actions.DropDbObjectAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.ScriptDbObjectAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.QuickFilterPanel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.DbObjectSourcePanel;
import workbench.gui.dbobjects.IsolationLevelChanger;
import workbench.gui.dbobjects.SummaryLabel;
import workbench.gui.renderer.RendererSetup;
import workbench.interfaces.PropertyStorage;
import workbench.interfaces.Reloadable;
import workbench.interfaces.WbSelectionModel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.parser.ScriptParser;
import workbench.storage.DataStore;
import workbench.util.ExceptionUtil;
import workbench.util.FilteredProperties;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class TriggerListPanel
extends JPanel
implements ListSelectionListener,
Reloadable,
DbObjectList,
TableModelListener,
PropertyChangeListener {
    private static final String TRG_TYPE_NAME = "TRIGGER";
    private WbConnection dbConnection;
    private TriggerReader reader;
    private QuickFilterPanel findPanel;
    private WbTable triggerList;
    protected DbObjectSourcePanel source;
    private WbSplitPane splitPane;
    private String currentSchema;
    private String currentCatalog;
    private boolean shouldRetrieve;
    private SummaryLabel infoLabel;
    private boolean isRetrieving;
    private CompileDbObjectAction compileAction;
    private DropDbObjectAction dropAction;
    private MainWindow parentWindow;
    private boolean initialized;
    private FilteredProperties workspaceProperties;
    private IsolationLevelChanger levelChanger = new IsolationLevelChanger();

    public TriggerListPanel(MainWindow mainWindow) {
        this.parentWindow = mainWindow;
    }

    private void initGui() {
        if (this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(this::_initGui);
    }

    private void _initGui() {
        if (this.initialized) {
            return;
        }
        Reloadable reloadable = () -> {
            if (this.dbConnection == null) {
                return;
            }
            if (this.dbConnection.isBusy()) {
                return;
            }
            this.retrieveCurrentTrigger();
        };
        this.source = new DbObjectSourcePanel(this.parentWindow, reloadable);
        if (DbExplorerSettings.allowSourceEditing()) {
            this.source.allowEditing(true);
        }
        JPanel jPanel = new JPanel();
        this.triggerList = new WbTable(true, false, false);
        this.triggerList.setRendererSetup(RendererSetup.getBaseSetup());
        this.triggerList.setAutoResizeMode(0);
        this.triggerList.setCellSelectionEnabled(false);
        this.triggerList.setColumnSelectionAllowed(false);
        this.triggerList.setRowSelectionAllowed(true);
        this.triggerList.getSelectionModel().addListSelectionListener(this);
        this.triggerList.getSelectionModel().setSelectionMode(2);
        this.triggerList.addTableModelListener(this);
        this.triggerList.setReadOnly(true);
        this.findPanel = new QuickFilterPanel(this.triggerList, false, "triggerlist");
        this.findPanel.setFilterOnType(DbExplorerSettings.getFilterDuringTyping());
        this.findPanel.setAlwaysUseContainsFilter(DbExplorerSettings.getUsePartialMatch());
        ReloadAction reloadAction = new ReloadAction(this);
        reloadAction.setUseLabelIconSize(true);
        this.findPanel.addToToolbar(reloadAction, true, false);
        reloadAction.getToolbarButton().setToolTipText(ResourceMgr.getString("TxtRefreshTriggerList"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.findPanel, "North");
        this.splitPane = new WbSplitPane(1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(6);
        WbScrollPane wbScrollPane = new WbScrollPane(this.triggerList);
        jPanel.add((Component)wbScrollPane, "Center");
        this.infoLabel = new SummaryLabel("");
        jPanel.add((Component)this.infoLabel, "South");
        this.splitPane.setLeftComponent(jPanel);
        this.splitPane.setRightComponent(this.source);
        this.splitPane.setDividerBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.setDefaultComponent(this.findPanel);
        wbTraversalPolicy.addComponent(this.findPanel);
        wbTraversalPolicy.addComponent(this.triggerList);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.reset();
        WbSelectionModel wbSelectionModel = WbSelectionModel.Factory.createFacade(this.triggerList.getSelectionModel());
        ScriptDbObjectAction scriptDbObjectAction = new ScriptDbObjectAction(this, wbSelectionModel);
        this.triggerList.addPopupAction(scriptDbObjectAction, true);
        this.compileAction = new CompileDbObjectAction(this, wbSelectionModel);
        this.triggerList.addPopupAction(this.compileAction, false);
        this.dropAction = new DropDbObjectAction(this, wbSelectionModel, this);
        this.triggerList.addPopupAction(this.dropAction, false);
        if (this.dbConnection != null) {
            this.setConnection(this.dbConnection);
        }
        this.splitPane.setDividerLocation(0.5);
        this.initialized = true;
        this.restoreSettings();
        if (this.workspaceProperties != null) {
            this.readSettings(this.workspaceProperties, this.workspaceProperties.getFilterPrefix());
            this.workspaceProperties = null;
        }
        Settings.getInstance().addPropertyChangeListener(this, "workbench.dbexplorer.allow.source.edit", new String[0]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.source != null) {
            this.source.allowEditing(DbExplorerSettings.allowSourceEditing());
        }
    }

    public void dispose() {
        this.reset();
        WbAction.dispose(this.dropAction, this.compileAction);
        if (this.source != null) {
            this.source.dispose();
        }
        if (this.findPanel != null) {
            this.findPanel.dispose();
        }
        if (this.triggerList != null) {
            this.triggerList.dispose();
        }
        Settings.getInstance().removePropertyChangeListener(this);
    }

    public void disconnect() {
        this.reader = null;
        this.dbConnection = null;
        this.reset();
    }

    public void reset() {
        if (!this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            this.triggerList.reset();
            this.source.reset();
        });
    }

    public void setConnection(WbConnection wbConnection) {
        this.shouldRetrieve = true;
        this.reset();
        this.dbConnection = wbConnection;
        this.reader = TriggerReaderFactory.createReader(this.dbConnection);
        if (this.source != null) {
            this.source.setDatabaseConnection(wbConnection);
        }
        if (this.compileAction != null) {
            this.compileAction.setConnection(wbConnection);
        }
    }

    public void setCatalogAndSchema(String string, String string2, boolean bl) throws Exception {
        this.currentSchema = string2;
        this.currentCatalog = string;
        if (this.initialized && this.isVisible() && bl) {
            this.retrieve();
        } else {
            this.reset();
            this.shouldRetrieve = true;
        }
    }

    public void panelSelected() {
        if (this.shouldRetrieve) {
            this.retrieve();
        }
    }

    public void retrieve() {
        this.initGui();
        if (this.dbConnection == null) {
            return;
        }
        if (this.reader == null) {
            return;
        }
        if (this.isRetrieving) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        try {
            this.reset();
            this.dbConnection.setBusy(true);
            this.isRetrieving = true;
            this.infoLabel.setText(ResourceMgr.getString("MsgRetrieving"));
            WbSwingUtilities.showWaitCursorOnWindow(this);
            DataStore dataStore = this.reader.getTriggers(this.currentCatalog, this.currentSchema);
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
            WbSwingUtilities.invoke(() -> {
                this.infoLabel.showObjectListInfo(dataStoreTableModel);
                this.triggerList.setModel(dataStoreTableModel, true);
            });
            this.shouldRetrieve = false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            WbManager.getInstance().showOutOfMemoryError();
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve trigger list", throwable);
        }
        finally {
            this.isRetrieving = false;
            this.dbConnection.setBusy(false);
            WbSwingUtilities.showDefaultCursorOnWindow(this);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.infoLabel.showObjectListInfo(this.triggerList.getDataStoreTableModel());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.shouldRetrieve) {
            this.retrieve();
        }
    }

    private String getWorkspacePrefix(int n) {
        return "dbexplorer" + n + ".triggerlist.";
    }

    public void saveSettings() {
        if (this.initialized) {
            this.storeSettings(Settings.getInstance(), this.getClass().getName() + ".");
            this.findPanel.saveSettings();
        }
    }

    public void saveToWorkspace(WbWorkspace wbWorkspace, int n) {
        String string = this.getWorkspacePrefix(n);
        if (this.initialized) {
            this.storeSettings(wbWorkspace.getSettings(), string);
            this.findPanel.saveSettings(wbWorkspace.getSettings(), string);
        } else if (this.workspaceProperties != null) {
            this.workspaceProperties.copyTo(wbWorkspace.getSettings(), string);
        }
    }

    private void storeSettings(PropertyStorage propertyStorage, String string) {
        propertyStorage.setProperty(string + "divider", this.splitPane.getDividerLocation());
    }

    public void restoreSettings() {
        if (this.initialized) {
            this.readSettings(Settings.getInstance(), this.getClass().getName() + ".");
            this.findPanel.restoreSettings();
        }
    }

    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) {
        String string = this.getWorkspacePrefix(n);
        if (this.initialized) {
            this.readSettings(wbWorkspace.getSettings(), string);
        } else {
            this.workspaceProperties = new FilteredProperties(wbWorkspace.getSettings(), string);
        }
    }

    private void readSettings(PropertyStorage propertyStorage, String string) {
        if (this.initialized) {
            int n = propertyStorage.getIntProperty(string + "divider", 200);
            this.splitPane.setDividerLocation(n);
            this.findPanel.restoreSettings(propertyStorage, string);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.initialized) {
            return;
        }
        if (listSelectionEvent.getSource() != this.triggerList.getSelectionModel()) {
            return;
        }
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        WbThread wbThread = new WbThread("TriggerSourceRetrieve"){

            @Override
            public void run() {
                TriggerListPanel.this.retrieveCurrentTrigger();
            }
        };
        wbThread.start();
    }

    private String getDelimiterForDrop() {
        if (this.dbConnection == null) {
            return ";";
        }
        DelimiterDefinition delimiterDefinition = this.dbConnection.getAlternateDelimiter();
        if (delimiterDefinition == null) {
            return ";";
        }
        ScriptParser scriptParser = ScriptParser.createScriptParser(this.dbConnection);
        if (scriptParser.supportsMixedDelimiter()) {
            return ";";
        }
        return "\n" + delimiterDefinition.getDelimiter() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveCurrentTrigger() {
        if (this.dbConnection == null || this.reader == null) {
            return;
        }
        int n = this.triggerList.getSelectedRow();
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        if (n < 0) {
            return;
        }
        String string = this.triggerList.getValueAsString(n, 0);
        String string2 = this.triggerList.getValueAsString(n, 3);
        String string3 = this.triggerList.getValueAsString(n, 4);
        Container container = this.getParent();
        WbSwingUtilities.showWaitCursor(container);
        try {
            if (this.dbConnection.getProfile().getUseSeparateConnectionPerTab()) {
                this.levelChanger.changeIsolationLevel(this.dbConnection);
            }
            this.dbConnection.setBusy(true);
            try {
                Object object;
                String string4;
                TableIdentifier tableIdentifier = null;
                if (string2 != null) {
                    tableIdentifier = new TableIdentifier(string2, this.dbConnection);
                    if (tableIdentifier.getCatalog() == null) {
                        tableIdentifier.setCatalog(this.currentCatalog);
                    }
                    if (tableIdentifier.getSchema() == null) {
                        tableIdentifier.setSchema(this.currentSchema);
                    }
                }
                DropType dropType = DbExplorerSettings.getDropTypeToGenerate(TRG_TYPE_NAME);
                String string5 = this.reader.getTriggerSource(this.currentCatalog, this.currentSchema, string, tableIdentifier, string3, true);
                Object object2 = this.triggerList.getUserObject(n);
                boolean bl = SqlUtil.isReplaceDDL(string5, this.dbConnection, dropType);
                if (dropType != DropType.none && object2 instanceof TriggerDefinition && string5 != null && !bl && StringUtil.isNonBlank(string4 = ((TriggerDefinition)(object = (TriggerDefinition)object2)).getDropStatement(this.dbConnection, dropType == DropType.cascaded))) {
                    string5 = string4 + this.getDelimiterForDrop() + "\n\n" + string5;
                }
                object = string5 == null ? "" : string5;
                WbSwingUtilities.invoke(() -> this.lambda$retrieveCurrentTrigger$3((String)object, string));
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not read trigger source", throwable);
                this.source.setPlainText(ExceptionUtil.getDisplay(throwable));
            }
        }
        finally {
            WbSwingUtilities.showDefaultCursor(container);
            this.levelChanger.restoreIsolationLevel(this.dbConnection);
            this.dbConnection.setBusy(false);
        }
        if (this.triggerList.getSelectedRowCount() == 1) {
            EventQueue.invokeLater(() -> {
                this.source.setCaretPosition(0, false);
                if (DbExplorerSettings.getSelectSourcePanelAfterRetrieve()) {
                    this.source.requestFocusInWindow();
                }
            });
        }
    }

    @Override
    public int getSelectionCount() {
        return this.triggerList.getSelectedRowCount();
    }

    @Override
    public TableDefinition getCurrentTableDefinition() {
        return null;
    }

    @Override
    public TableIdentifier getObjectTable() {
        return null;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    @Override
    public List<TableIdentifier> getSelectedTables() {
        return Collections.emptyList();
    }

    @Override
    public List<DbObject> getSelectedObjects() {
        if (!this.initialized) {
            return null;
        }
        if (this.triggerList.getSelectedRowCount() == 0) {
            return null;
        }
        int[] nArray = this.triggerList.getSelectedRows();
        int n = nArray.length;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>(n);
        if (n == 0) {
            return arrayList;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.triggerList.getValueAsString(nArray[i], 0);
            int n2 = string.indexOf(59);
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            TriggerDefinition triggerDefinition = new TriggerDefinition(this.currentCatalog, this.currentSchema, string);
            String string2 = this.triggerList.getValueAsString(nArray[i], 3);
            if (string2 != null) {
                triggerDefinition.setRelatedTable(new TableIdentifier(string2, this.dbConnection));
            }
            arrayList.add(triggerDefinition);
        }
        return arrayList;
    }

    @Override
    public void reload() {
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        this.reset();
        this.retrieve();
    }

    private /* synthetic */ void lambda$retrieveCurrentTrigger$3(String string, String string2) {
        this.source.setText(string, string2, TRG_TYPE_NAME);
    }
}

