/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.util.Set;
import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.objecttree.GlobalTypeNode;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;

public class GlobalTreeNode
extends ObjectTreeNode {
    private final Set<String> typesToShow = CollectionUtil.caseInsensitiveSet();

    public GlobalTreeNode(Set<String> set) {
        super(ResourceMgr.getString("LblGlobalObjects"), "global");
        this.setAllowsChildren(true);
        this.setTypesToShow(set);
    }

    public void setTypesToShow(Set<String> set) {
        this.typesToShow.clear();
        this.typesToShow.addAll(set);
    }

    @Override
    public boolean loadChildren(WbConnection wbConnection, TreeLoader treeLoader) {
        if (wbConnection == null) {
            return false;
        }
        DbSettings dbSettings = wbConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return false;
        }
        Set<String> set = dbSettings.getGlobalObjectTypes();
        if (CollectionUtil.isEmpty(set)) {
            return false;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Loading global object types: " + set);
        for (String string : set) {
            if (!this.typesToShow.isEmpty() && !this.typesToShow.contains(string)) continue;
            GlobalTypeNode globalTypeNode = new GlobalTypeNode(string);
            this.add(globalTypeNode);
        }
        this.setChildrenLoaded(true);
        return true;
    }
}

