/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree.vertica;

import workbench.db.WbConnection;
import workbench.db.vertica.VerticaProjectionReader;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.gui.dbobjects.objecttree.vertica.BuddyNode;
import workbench.gui.dbobjects.objecttree.vertica.ProjectionNode;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;

public class BuddyListNode
extends ObjectTreeNode {
    public BuddyListNode() {
        super("Buddies", "projection-buddies");
        this.setAllowsChildren(true);
    }

    private ProjectionNode getProjection() {
        if (this.getParent() == null) {
            return null;
        }
        return (ProjectionNode)this.getParent();
    }

    @Override
    public boolean loadChildren(WbConnection wbConnection, TreeLoader treeLoader) {
        ProjectionNode projectionNode = this.getProjection();
        if (projectionNode != null) {
            this.readBuddies(wbConnection, projectionNode);
        }
        return true;
    }

    private void readBuddies(WbConnection wbConnection, ProjectionNode projectionNode) {
        VerticaProjectionReader verticaProjectionReader = new VerticaProjectionReader();
        verticaProjectionReader.setConnection(wbConnection);
        try {
            DataStore dataStore = verticaProjectionReader.getProjectionCopies(projectionNode.getName(), projectionNode.getBaseTable().getSchema());
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                String string = dataStore.getValueAsString(i, "name");
                String string2 = dataStore.getValueAsString(i, "node");
                this.add(new BuddyNode(string, string2));
            }
            this.setChildrenLoaded(true);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read buddies", exception);
        }
    }
}

