/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.dataimport;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import workbench.db.importer.ImportOptions;
import workbench.db.importer.ProducerFactory;
import workbench.db.importer.TextImportOptions;
import workbench.gui.components.DividerBorder;
import workbench.gui.dialogs.dataimport.GeneralImportOptionsPanel;
import workbench.gui.dialogs.dataimport.TextOptionsPanel;
import workbench.interfaces.EncodingSelector;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class ImportOptionsPanel
extends JPanel
implements EncodingSelector,
ActionListener,
ValidatingComponent {
    private JPanel typePanel;
    private CardLayout card;
    private JComboBox typeSelector;
    private GeneralImportOptionsPanel generalOptions;
    private TextOptionsPanel textOptions;
    private ProducerFactory.ImportType currentType = null;

    public ImportOptionsPanel() {
        this.setLayout(new BorderLayout(0, 2));
        this.generalOptions = new GeneralImportOptionsPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.generalOptions, "Center");
        EmptyBorder emptyBorder = new EmptyBorder(0, 3, 0, 0);
        jPanel.setBorder(emptyBorder);
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        CompoundBorder compoundBorder = new CompoundBorder(DividerBorder.BOTTOM_DIVIDER, new EmptyBorder(0, 0, 5, 0));
        jPanel2.setBorder(compoundBorder);
        this.typeSelector = new JComboBox();
        this.typeSelector.addItem("Text");
        this.typeSelector.addItem("XML");
        JLabel jLabel = new JLabel("Type");
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)this.typeSelector, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "North");
        this.textOptions = new TextOptionsPanel();
        this.typePanel = new JPanel();
        this.typePanel.setBorder(emptyBorder);
        this.card = new CardLayout();
        this.typePanel.setLayout(this.card);
        this.typePanel.add((Component)this.textOptions, "text");
        this.typePanel.add((Component)new JPanel(), "xml");
        this.add((Component)this.typePanel, "Center");
        this.typeSelector.addActionListener(this);
    }

    public void allowImportTypeSelection(boolean bl) {
    }

    public void allowImportModeSelection(boolean bl) {
        this.generalOptions.setModeSelectorEnabled(bl);
    }

    public void saveSettings(String string) {
        this.generalOptions.saveSettings(string);
        this.textOptions.saveSettings(string + ".text");
        if (StringUtil.isBlank(string)) {
            string = "import";
        }
        Settings.getInstance().setProperty("workbench." + string + ".type", this.currentType == null ? -1 : this.currentType.toInteger());
    }

    public void restoreSettings(String string) {
        if (StringUtil.isBlank(string)) {
            string = "import";
        }
        this.generalOptions.restoreSettings(string);
        this.textOptions.restoreSettings(string + ".text");
        int n = Settings.getInstance().getIntProperty("workbench." + string + ".type", -1);
        this.setImportType(ProducerFactory.ImportType.valueOf(n));
    }

    public void setImportType(ProducerFactory.ImportType importType) {
        if (importType == ProducerFactory.ImportType.Text) {
            this.setTypeText();
        } else if (importType == ProducerFactory.ImportType.XML) {
            this.setTypeXml();
        }
    }

    public ProducerFactory.ImportType getImportType() {
        return this.currentType;
    }

    public void setTypeText() {
        this.card.show(this.typePanel, "text");
        this.currentType = ProducerFactory.ImportType.Text;
        this.typeSelector.setSelectedIndex(0);
    }

    public void setTypeXml() {
        this.card.show(this.typePanel, "xml");
        this.currentType = ProducerFactory.ImportType.XML;
        this.typeSelector.setSelectedIndex(1);
    }

    public ImportOptions getGeneralOptions() {
        return this.generalOptions;
    }

    public TextImportOptions getTextOptions() {
        return this.textOptions;
    }

    @Override
    public String getEncoding() {
        return this.generalOptions.getEncoding();
    }

    @Override
    public void setEncoding(String string) {
        this.generalOptions.setEncoding(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.typeSelector) {
            String string = this.typeSelector.getSelectedItem().toString().toLowerCase();
            ProducerFactory.ImportType importType = this.currentType;
            this.card.show(this.typePanel, string);
            if ("text".equals(string)) {
                this.currentType = ProducerFactory.ImportType.Text;
            } else if ("xml".equals(string)) {
                this.currentType = ProducerFactory.ImportType.XML;
            }
            if (importType != this.currentType) {
                this.firePropertyChange("exportType", (Object)importType, (Object)this.currentType);
            }
        }
    }

    @Override
    public boolean validateInput() {
        if (this.textOptions != null) {
            return this.generalOptions.validateInput();
        }
        return true;
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public void componentWillBeClosed() {
    }
}

