/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import workbench.gui.editor.SyntaxStyle;
import workbench.gui.editor.Token;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;

public class SyntaxUtilities {
    public static int findMatch(Segment segment, String string, int n, boolean bl) {
        char[] cArray = segment.array;
        int n2 = string.length();
        int n3 = 0;
        int n4 = segment.offset + segment.count;
        if (n4 > cArray.length) {
            n4 = cArray.length;
        }
        for (int i = segment.offset + n; i < n4; ++i) {
            char c = cArray[i];
            char c2 = string.charAt(n3);
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c == c2) {
                if (++n3 != n2) continue;
                return i + 1 - n2 - segment.offset;
            }
            i -= n3;
            n3 = 0;
        }
        return -1;
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n, char[] cArray) {
        int n2 = n + cArray.length;
        char[] cArray2 = segment.array;
        if (n2 > segment.offset + segment.count) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray2[n3];
            char c2 = cArray[n4];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[11];
        syntaxStyleArray[1] = SyntaxUtilities.getStyle("comment1", Color.GRAY, 2);
        syntaxStyleArray[2] = SyntaxUtilities.getStyle("comment2", Color.GRAY, 2);
        syntaxStyleArray[6] = SyntaxUtilities.getStyle("keyword1", Color.BLUE, 0);
        syntaxStyleArray[7] = SyntaxUtilities.getStyle("keyword2", Color.MAGENTA, 0);
        syntaxStyleArray[8] = SyntaxUtilities.getStyle("keyword3", new Color(38400), 0);
        syntaxStyleArray[3] = SyntaxUtilities.getStyle("literal1", new Color(6619289), 0);
        syntaxStyleArray[4] = SyntaxUtilities.getStyle("literal2", new Color(6619289), 0);
        syntaxStyleArray[5] = SyntaxUtilities.getStyle("datatype", new Color(0x990033), 0);
        syntaxStyleArray[9] = SyntaxUtilities.getStyle("operator", Color.BLACK, 0);
        syntaxStyleArray[10] = SyntaxUtilities.getStyle("invalid", Color.RED, 0);
        return syntaxStyleArray;
    }

    private static SyntaxStyle getStyle(String string, Color color, int n) {
        Color color2 = Settings.getInstance().getColor("workbench.editor.color." + string, color);
        int n2 = GuiSettings.getFontStyle("workbench.editor.syntax.style." + string, n);
        return new SyntaxStyle(color2, n2);
    }

    public static int paintSyntaxLine(Segment segment, Token token, SyntaxStyle[] syntaxStyleArray, TabExpander tabExpander, Graphics graphics, int n, int n2, int n3) {
        if (token == null) {
            return n;
        }
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        while (true) {
            if (token == null) break;
            if (token.id == 0) {
                graphics.setColor(color);
                graphics.setFont(font);
            } else {
                syntaxStyleArray[token.id].setGraphicsFlags(graphics, font);
            }
            segment.count = token.length;
            n = Utilities.drawTabbedText(segment, n, n2, graphics, tabExpander, n3);
            segment.offset += token.length;
            token = token.next;
        }
        graphics.setColor(color);
        graphics.setFont(font);
        return n;
    }

    public static float getTabbedTextWidth(Segment segment, Graphics2D graphics2D, FontMetrics fontMetrics, float f, TabExpander tabExpander, int n) {
        float f2 = f;
        char[] cArray = segment.array;
        int n2 = segment.offset;
        int n3 = segment.offset + segment.count;
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            if (cArray[i] == '\t') {
                f2 = (float)((double)f2 + fontMetrics.getStringBounds(cArray, i - n4, i, (Graphics)graphics2D).getBounds2D().getWidth());
                f2 = tabExpander.nextTabStop(f2, n + i - n2);
                n4 = 0;
                continue;
            }
            if (cArray[i] == '\n') {
                f2 = (float)((double)f2 + fontMetrics.getStringBounds(cArray, i - n4, i, (Graphics)graphics2D).getBounds2D().getWidth());
                n4 = 0;
                continue;
            }
            ++n4;
        }
        f2 = (float)((double)f2 + fontMetrics.getStringBounds(cArray, n3 - n4, n3, (Graphics)graphics2D).getBounds2D().getWidth());
        return f2 - f;
    }
}

