/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public class ValuesListCreator {
    private final String input;
    private final String delimiter;
    private final boolean useRegex;
    private boolean emptyStringIsNull = true;
    private boolean trimDelimiter = false;
    private boolean trimItems = true;
    private String lineEnding = "\n";
    private WbStringTokenizer tokenizer;
    private Pattern splitPattern;

    public ValuesListCreator(String string) {
        this(string, ",", false);
    }

    public ValuesListCreator(String string, String string2, boolean bl) {
        this.input = StringUtil.trim(string);
        this.useRegex = bl;
        this.delimiter = bl ? string2 : StringUtil.unescape(string2);
        this.initTokenizer();
    }

    public void setLineEnding(String string) {
        this.lineEnding = string;
    }

    public void setEmptyStringIsNull(boolean bl) {
        this.emptyStringIsNull = bl;
    }

    public void setTrimDelimiter(boolean bl) {
        this.trimDelimiter = bl;
    }

    public void setTrimItems(boolean bl) {
        this.trimItems = bl;
    }

    public String createValuesList() {
        if (StringUtil.isBlank(this.input)) {
            return "";
        }
        List<String> list = StringUtil.getLines(this.input);
        StringBuilder stringBuilder = new StringBuilder(this.input.length() + 50);
        int n = 0;
        for (String string : list) {
            StringBuilder stringBuilder2;
            string = string.trim();
            if (!this.useRegex && this.trimDelimiter) {
                if (string.startsWith(this.delimiter)) {
                    string = string.substring(1);
                }
                if (string.endsWith(this.delimiter)) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            List<String> list2 = this.splitLine(string);
            if (n > 0) {
                stringBuilder.append(',');
                stringBuilder.append(this.lineEnding);
            }
            if ((stringBuilder2 = this.convertToEntry(list2)).length() <= 0) continue;
            stringBuilder.append((CharSequence)stringBuilder2);
            ++n;
        }
        return stringBuilder.toString();
    }

    private void initTokenizer() {
        if (this.useRegex) {
            this.splitPattern = Pattern.compile(this.delimiter);
            this.tokenizer = null;
        } else {
            this.tokenizer = new WbStringTokenizer(this.delimiter, "\"'", true);
            this.splitPattern = null;
        }
    }

    private List<String> splitLine(String string) {
        if (this.tokenizer != null) {
            this.tokenizer.setSourceString(string);
            return this.tokenizer.getAllTokens();
        }
        String[] stringArray = this.splitPattern.split(string);
        return Arrays.asList(stringArray);
    }

    private StringBuilder convertToEntry(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder(list.size() * 10);
        stringBuilder.append('(');
        int n = 0;
        for (String string : list) {
            if (this.trimItems && string != null) {
                string = string.trim();
            }
            if (n > 0) {
                stringBuilder.append(", ");
            }
            if (string != null && (string.startsWith("'") || string.startsWith("\"") || StringUtil.isNumber(string))) {
                stringBuilder.append(string);
            } else if (this.emptyStringIsNull && StringUtil.isEmptyString(string) || string == null) {
                stringBuilder.append("NULL");
            } else {
                stringBuilder.append('\'');
                stringBuilder.append(string);
                stringBuilder.append('\'');
            }
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder;
    }
}

