/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.fontzoom;

import java.awt.Font;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import workbench.gui.actions.WbAction;
import workbench.resource.GuiSettings;

public class FontZoomer
implements MouseWheelListener {
    private JComponent client;
    private Font originalFont;
    private final double increasePercent;

    public FontZoomer(JComponent jComponent) {
        this.client = jComponent;
        this.increasePercent = GuiSettings.getFontZoomPercentage();
    }

    public void resetFontZoom() {
        if (this.originalFont != null) {
            this.client.setFont(this.originalFont);
        }
        this.originalFont = null;
    }

    public void increaseFontSize() {
        this.applyFontScale(1.0 + this.increasePercent / 100.0);
    }

    public void decreaseFontSize() {
        this.applyFontScale(1.0 - this.increasePercent / 100.0);
    }

    private void applyFontScale(double d) {
        Font font = this.client.getFont();
        if (font == null) {
            return;
        }
        if (this.originalFont == null) {
            this.originalFont = font;
        }
        Font font2 = font.deriveFont((float)((double)font.getSize() * d));
        this.client.setFont(font2);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0 && WbAction.isCtrlPressed(mouseWheelEvent.getModifiers())) {
            if (mouseWheelEvent.getWheelRotation() > 0) {
                this.decreaseFontSize();
            } else {
                this.increaseFontSize();
            }
        }
    }
}

