/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.lnf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import workbench.gui.lnf.LnFDefinition;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class LnFManager {
    private List<LnFDefinition> lnfList;
    public static final String FLATLAF_LIGHT_CLASS = "com.formdev.flatlaf.FlatLightLaf";
    public static final String FLATLAF_DARK_CLASS = "com.formdev.flatlaf.FlatDarkLaf";

    public void removeDefinition(LnFDefinition lnFDefinition) {
        if (lnFDefinition == null) {
            return;
        }
        if (!lnFDefinition.isBuiltIn()) {
            this.getLnFList().remove(lnFDefinition);
        }
    }

    public LnFDefinition getCurrentLnF() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getClass().getName();
        return this.findLookAndFeel(string);
    }

    public int addDefinition(LnFDefinition lnFDefinition) {
        List<LnFDefinition> list = this.getLnFList();
        list.add(lnFDefinition);
        return list.size() - 1;
    }

    public void saveLookAndFeelDefinitions() {
        Settings settings = Settings.getInstance();
        this.removeLnFEntries();
        int n = 0;
        for (LnFDefinition lnFDefinition : this.getLnFList()) {
            if (lnFDefinition.isDynamic()) {
                String string = StringUtil.listToString(lnFDefinition.getLibraries(), "$|$", false);
                settings.setProperty("workbench.lnf." + n + ".classpath", string);
                settings.setProperty("workbench.lnf." + n + ".class", lnFDefinition.getClassName());
                settings.setProperty("workbench.lnf." + n + ".name", lnFDefinition.getName());
                ++n;
                continue;
            }
            if (!lnFDefinition.isExt()) continue;
            settings.setProperty("workbench.lnf." + n + ".class", lnFDefinition.getClassName());
            settings.setProperty("workbench.lnf." + n + ".name", lnFDefinition.getName());
            settings.setProperty("workbench.lnf." + n + ".classpath", "ext");
            ++n;
        }
        settings.setProperty("workbench.lnf.count", n);
    }

    private void removeLnFEntries() {
        Settings settings = Settings.getInstance();
        int n = settings.getIntProperty("workbench.lnf.count", 0);
        for (int i = 0; i < n; ++i) {
            settings.removeProperty("workbench.lnf." + i + ".classpath");
            settings.removeProperty("workbench.lnf." + i + ".class");
            settings.removeProperty("workbench.lnf." + i + ".name");
        }
    }

    public boolean isFlatLafLibPresent() {
        ClasspathUtil classpathUtil = new ClasspathUtil();
        List<File> list = classpathUtil.getExtLibs();
        for (File file : list) {
            if (!file.getName().toLowerCase().contains("flatlaf")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized List<LnFDefinition> getLnFList() {
        LnFDefinition lnFDefinition3;
        Object object;
        if (this.lnfList != null) {
            return this.lnfList;
        }
        long l = System.currentTimeMillis();
        this.lnfList = new ArrayList<LnFDefinition>();
        Settings settings = Settings.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        int n = settings.getIntProperty("workbench.lnf.count", 0);
        for (int i = 0; i < n; ++i) {
            void var11_21;
            object = settings.getProperty("workbench.lnf." + i + ".class", "");
            if (object == null) continue;
            if (!bl && ((String)object).equals(FLATLAF_LIGHT_CLASS)) {
                bl = true;
            }
            if (!bl2 && ((String)object).equals(FLATLAF_DARK_CLASS)) {
                bl2 = true;
            }
            String string = settings.getProperty("workbench.lnf." + i + ".name", (String)object);
            String string2 = settings.getProperty("workbench.lnf." + i + ".classpath", "");
            if (string2.equals("ext")) {
                LnFDefinition lnFDefinition4 = LnFDefinition.newExtLaf(string, (String)object);
                LogMgr.logDebug(new CallerInfo(){}, "Found Look & Feel: " + lnFDefinition4.debugString());
                this.lnfList.add(lnFDefinition4);
                continue;
            }
            Object var11_18 = null;
            if (string2.contains("$|$")) {
                List<String> list = StringUtil.stringToList(string2, "$|$");
            } else {
                List<String> list = StringUtil.stringToList(string2, StringUtil.getPathSeparator());
            }
            if (!CollectionUtil.isNonEmpty((Collection)var11_21)) continue;
            lnFDefinition3 = new LnFDefinition(string, (String)object, (List<String>)var11_21);
            LogMgr.logDebug(new CallerInfo(){}, "Found Look & Feel: " + lnFDefinition3.debugString());
            this.lnfList.add(lnFDefinition3);
        }
        if (!(bl && bl2 || !this.isFlatLafLibPresent())) {
            if (!bl) {
                LnFDefinition lnFDefinition4 = LnFDefinition.newExtLaf("FlatLaf Light", FLATLAF_LIGHT_CLASS);
                this.lnfList.add(lnFDefinition4);
                LogMgr.logDebug(new CallerInfo(){}, "Added " + lnFDefinition4.debugString());
            }
            if (!bl2) {
                LnFDefinition lnFDefinition5 = LnFDefinition.newExtLaf("FlatLaf Dark", FLATLAF_DARK_CLASS);
                this.lnfList.add(lnFDefinition5);
                LogMgr.logDebug(new CallerInfo(){}, "Added " + lnFDefinition5.debugString());
            }
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray) {
            lnFDefinition3 = new LnFDefinition(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
            if (this.lnfList.contains(lnFDefinition3)) continue;
            this.lnfList.add(lnFDefinition3);
        }
        object = (lnFDefinition, lnFDefinition2) -> StringUtil.compareStrings(lnFDefinition.getName(), lnFDefinition2.getName(), true);
        this.lnfList.sort((Comparator<LnFDefinition>)object);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Checking look & feels took: " + l2 + "ms");
        return this.lnfList;
    }

    public List<LnFDefinition> getAvailableLookAndFeels() {
        return Collections.unmodifiableList(this.getLnFList());
    }

    public boolean isRegistered(String string) {
        return this.findLookAndFeel(string) != null;
    }

    public LnFDefinition findLookAndFeel(String string) {
        if (string == null) {
            return null;
        }
        for (LnFDefinition lnFDefinition : this.getLnFList()) {
            if (!lnFDefinition.getClassName().equals(string)) continue;
            return lnFDefinition;
        }
        return null;
    }
}

