/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import workbench.db.DbDriver;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.WbButton;
import workbench.gui.help.HelpManager;
import workbench.gui.profiles.DriverlistEditorPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class DriverEditorDialog
extends JDialog
implements ActionListener {
    private JPanel dummyPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private WbButton helpButton;
    private DriverlistEditorPanel driverListPanel;
    private JButton cancelButton;
    private boolean cancelled = true;
    private EscAction escAction;

    public DriverEditorDialog(Frame frame) {
        super(frame, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.escAction = new EscAction(this, this);
        if (!Settings.getInstance().restoreWindowSize(this)) {
            this.pack();
            WbSwingUtilities.scale(this, 1.05, 1.1);
        }
        EventQueue.invokeLater(() -> {
            this.toFront();
            this.requestFocus();
        });
    }

    private void initComponents() {
        this.driverListPanel = new DriverlistEditorPanel();
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.okButton = new WbButton(ResourceMgr.getString("LblOK"));
        this.cancelButton = new WbButton(ResourceMgr.getString("LblCancel"));
        this.dummyPanel = new JPanel();
        this.helpButton = new WbButton();
        this.helpButton.setResourceKey("LblHelp");
        this.helpButton.addActionListener(this);
        this.setTitle(ResourceMgr.getString("TxtDriverEditorWindowTitle"));
        this.setModal(true);
        this.setName("DriverEditorDialog");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DriverEditorDialog.this.closeDialog(windowEvent);
            }
        });
        this.driverListPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.driverListPanel, "Center");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.buttonPanel.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.dummyPanel.setMaximumSize(new Dimension(2, 2));
        this.dummyPanel.setMinimumSize(new Dimension(1, 1));
        this.dummyPanel.setPreferredSize(new Dimension(2, 2));
        this.getContentPane().add((Component)this.dummyPanel, "North");
        WbSwingUtilities.makeEqualWidth(this.okButton, this.cancelButton, this.helpButton);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals(this.escAction.getActionName())) {
            this.cancelButtonActionPerformed();
        } else if (actionEvent.getSource() == this.helpButton) {
            HelpManager.showDriverHelp();
        }
    }

    private void cancelButtonActionPerformed() {
        this.cancelled = true;
        this.closeDialog();
    }

    public void setDriverName(String string) {
        if (this.driverListPanel != null && string != null) {
            this.driverListPanel.selectDriver(string);
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.driverListPanel.canChangeSelection()) {
                this.driverListPanel.saveItem();
                this.cancelled = false;
                this.closeDialog();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error closing dialog", exception);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.closeDialog();
    }

    public void closeDialog() {
        Settings.getInstance().storeWindowSize(this);
        this.setVisible(false);
        this.dispose();
    }

    public static void showDriverDialog(Frame frame, DbDriver dbDriver) {
        EventQueue.invokeLater(() -> {
            DriverEditorDialog driverEditorDialog = new DriverEditorDialog(frame);
            driverEditorDialog.setDriverName(dbDriver != null ? dbDriver.getName() : null);
            WbSwingUtilities.center(driverEditorDialog, frame);
            driverEditorDialog.setVisible(true);
            driverEditorDialog.dispose();
        });
    }
}

