/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.components.WbButton;
import workbench.gui.help.HelpManager;
import workbench.gui.profiles.ConnectionGuiHelper;
import workbench.gui.profiles.DriverEditorDialog;
import workbench.gui.profiles.ProfileChangeListener;
import workbench.gui.profiles.ProfileSelectionPanel;
import workbench.interfaces.EventDisplay;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.EventNotifier;
import workbench.util.NotifierEvent;
import workbench.util.StringUtil;

public class ProfileSelectionDialog
extends JDialog
implements ActionListener,
WindowListener,
TreeSelectionListener,
EventDisplay,
ProfileChangeListener {
    private JPanel okCancelPanel;
    private JButton okButton;
    private JButton cancelButton;
    private WbButton helpButton;
    private WbButton manageDriversButton;
    private ProfileSelectionPanel profiles;
    private ConnectionProfile selectedProfile;
    private boolean cancelled;
    private String escActionCommand;
    private JLabel versionInfo;
    private boolean processEscKey;
    private static boolean firstDisplay = true;

    public ProfileSelectionDialog(Frame frame, boolean bl, String string) {
        super(frame, bl);
        this.initComponents(string);
        if (firstDisplay) {
            EventNotifier.getInstance().addEventDisplay(this);
            firstDisplay = false;
        }
        this.enableDefaultButtons();
        EscAction escAction = new EscAction(this, this);
        this.escActionCommand = escAction.getActionName();
    }

    public void enableDefaultButtons() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(this.okButton);
        this.processEscKey = true;
    }

    public void disableDefaultButtons() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(null);
        this.processEscKey = false;
    }

    private void initComponents(String string) {
        this.profiles = new ProfileSelectionPanel(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.manageDriversButton = new WbButton();
        this.manageDriversButton.setResourceKey("LblEditDrivers");
        this.manageDriversButton.addActionListener(this);
        this.helpButton = new WbButton();
        this.helpButton.setResourceKey("LblHelp");
        this.helpButton.addActionListener(this);
        jPanel2.add(this.manageDriversButton);
        jPanel2.add(this.helpButton);
        this.okCancelPanel = new JPanel();
        jPanel.add((Component)this.okCancelPanel, "East");
        jPanel.add((Component)jPanel2, "West");
        this.versionInfo = new JLabel("  ");
        this.versionInfo.setForeground(Color.RED);
        this.versionInfo.setBorder(new EmptyBorder(0, 15, 0, 0));
        jPanel.add((Component)this.versionInfo, "Center");
        this.okButton = new WbButton(ResourceMgr.getString("LblOK"));
        this.okButton.setEnabled(this.profiles.getSelectedProfile() != null);
        this.cancelButton = new WbButton(ResourceMgr.getString("LblCancel"));
        WbSwingUtilities.makeEqualWidth(this.manageDriversButton, this.helpButton);
        WbSwingUtilities.makeEqualWidth(this.okButton, this.cancelButton);
        this.addWindowListener(this);
        this.okCancelPanel.setLayout(new FlowLayout(2));
        this.okCancelPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.okCancelPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.profiles.addProfileSelectionListener(mouseEvent -> this.profileListClicked((MouseEvent)mouseEvent));
        this.profiles.addSelectionListener(this);
        this.profiles.addProfileChangelistener(this);
        BorderLayout borderLayout = new BorderLayout();
        this.getContentPane().setLayout(borderLayout);
        this.getContentPane().add((Component)this.profiles, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle(ResourceMgr.getString("LblSelectProfile"));
        this.restoreSize();
        WbSwingUtilities.requestComponentFocus(this, this.profiles.getInitialFocusComponent());
    }

    @Override
    public void showAlert(final NotifierEvent notifierEvent) {
        if (this.versionInfo == null) {
            return;
        }
        this.versionInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    ActionEvent actionEvent = new ActionEvent(ProfileSelectionDialog.this, -1, notifierEvent.getType());
                    ProfileSelectionDialog.this.versionInfo.removeMouseListener(this);
                    notifierEvent.getHandler().actionPerformed(actionEvent);
                }
            }
        });
        WbSwingUtilities.invokeLater(() -> {
            this.versionInfo.setCursor(Cursor.getPredefinedCursor(12));
            this.versionInfo.setIcon(IconMgr.getInstance().getLabelIcon(notifierEvent.getIconKey()));
            this.versionInfo.setText("<html><b>" + notifierEvent.getMessage() + "</b></html>");
            String string = notifierEvent.getTooltip();
            if (StringUtil.isNonEmpty(string)) {
                this.versionInfo.setToolTipText(string);
            }
            this.versionInfo.getParent().doLayout();
        });
    }

    @Override
    public void removeAlert() {
        if (this.versionInfo == null) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            this.versionInfo.setCursor(null);
            this.versionInfo.setIcon(null);
            this.versionInfo.setText("");
            this.versionInfo.getParent().doLayout();
        });
    }

    private void closeDialog() {
        this.saveSize();
        this.profiles.saveSettings();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void profileChanged(ConnectionProfile connectionProfile) {
        this.okButton.setEnabled(connectionProfile != null && connectionProfile.isConfigured());
    }

    public ConnectionProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public void restoreSize() {
        if (!Settings.getInstance().restoreWindowSize(this)) {
            this.pack();
            this.setSize((int)((double)this.getWidth() * 1.1), (int)((double)this.getHeight() * 1.05));
            this.profiles.initDivider();
        }
    }

    public void saveSize() {
        Settings settings = Settings.getInstance();
        settings.storeWindowSize(this);
    }

    public void selectProfile() {
        if (this.profiles.validateInput()) {
            this.selectedProfile = this.profiles.getSelectedProfile();
            boolean bl = ConnectionGuiHelper.doPrompt(this, this.selectedProfile);
            if (bl) {
                this.cancelled = false;
                this.closeDialog();
                if (Settings.getInstance().getSaveProfilesImmediately()) {
                    ConnectionMgr.getInstance().saveProfiles();
                }
            }
        }
    }

    public void profileListClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && this.profiles.getSelectedProfile() != null) {
            this.profiles.applyProfiles();
            this.selectProfile();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.profiles.applyProfiles();
            this.selectProfile();
        } else if (actionEvent.getSource() == this.cancelButton || this.processEscKey && actionEvent.getActionCommand().equals(this.escActionCommand)) {
            this.selectedProfile = null;
            this.cancelled = true;
            this.closeDialog();
        } else if (actionEvent.getSource() == this.manageDriversButton) {
            this.showDriverEditorDialog();
        } else if (actionEvent.getSource() == this.helpButton) {
            HelpManager.showProfileHelp();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.profiles.done();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancelled = true;
        this.selectedProfile = null;
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.cancelled = true;
        this.selectedProfile = null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.okButton.setEnabled(this.profiles.getSelectedProfile() != null && this.profiles.getSelectedProfile().isConfigured());
    }

    private void showDriverEditorDialog() {
        Frame frame = (Frame)this.getParent();
        DbDriver dbDriver = this.profiles.getCurrentDriver();
        DriverEditorDialog.showDriverDialog(frame, dbDriver);
    }
}

