/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import workbench.db.ConnectionProfile;
import workbench.gui.WbSwingUtilities;
import workbench.gui.profiles.ProfileFlavor;
import workbench.gui.profiles.ProfileTree;
import workbench.gui.profiles.ProfileTreeTransferable;
import workbench.gui.profiles.TransferableProfileNode;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class ProfileTreeTransferHandler
extends TransferHandler {
    private TreePath[] lastCutNodes = null;
    private ProfileTree myTree;

    public ProfileTreeTransferHandler(ProfileTree profileTree) {
        this.myTree = profileTree;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof ProfileTree) {
            TreePath[] treePathArray = ((ProfileTree)jComponent).getSelectionPaths();
            return new ProfileTreeTransferable(treePathArray, (ProfileTree)jComponent);
        }
        return null;
    }

    @Override
    public void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (transferable == null) {
            return;
        }
        if (n != 2) {
            return;
        }
        if (!(jComponent instanceof ProfileTree)) {
            return;
        }
        ProfileTree profileTree = (ProfileTree)jComponent;
        try {
            TransferableProfileNode transferableProfileNode = (TransferableProfileNode)transferable.getTransferData(ProfileFlavor.FLAVOR);
            TreePath[] treePathArray = transferableProfileNode.getPath();
            if (treePathArray == null) {
                return;
            }
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode.getParent() == null) continue;
                profileTree.getModel().removeNodeFromParent(defaultMutableTreeNode);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not process drop event", exception);
        }
    }

    private void removeCutNodes() {
        if (this.lastCutNodes == null) {
            return;
        }
        for (TreePath treePath : this.lastCutNodes) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ConnectionProfile connectionProfile = (ConnectionProfile)defaultMutableTreeNode.getUserObject();
            this.myTree.getModel().deleteProfile(connectionProfile);
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDataFlavorSupported(ProfileFlavor.FLAVOR)) {
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
        TreePath treePath = dropLocation.getPath();
        if (treePath == null) {
            return false;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (!treeNode.getAllowsChildren()) {
            return false;
        }
        Transferable transferable = transferSupport.getTransferable();
        return transferable != null;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Object object;
        ProfileTree profileTree = (ProfileTree)transferSupport.getComponent();
        if (profileTree == null) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (transferSupport.isDrop()) {
            JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
            object = dropLocation.getPath();
            if (object == null) {
                return false;
            }
            defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent();
        } else {
            defaultMutableTreeNode = profileTree.getSelectedGroupNode();
        }
        if (defaultMutableTreeNode == null) {
            return false;
        }
        if (!defaultMutableTreeNode.getAllowsChildren()) {
            return false;
        }
        int n = 1;
        if (transferSupport.isDrop()) {
            n = transferSupport.getDropAction();
        }
        try {
            object = transferSupport.getTransferable();
            if (object == null) {
                return false;
            }
            TransferableProfileNode transferableProfileNode = (TransferableProfileNode)object.getTransferData(ProfileFlavor.FLAVOR);
            List<ConnectionProfile> list = this.getProfiles((Transferable)object);
            Window window = SwingUtilities.getWindowAncestor(profileTree);
            ProfileTree profileTree2 = (ProfileTree)WbSwingUtilities.findComponentByName(ProfileTree.class, transferableProfileNode.getSourceName(), window);
            if (transferSupport.isDrop() && n == 2 && profileTree2 != null) {
                for (ConnectionProfile connectionProfile : list) {
                    profileTree2.getModel().deleteProfile(connectionProfile);
                }
            }
            profileTree.handleDroppedNodes(list, defaultMutableTreeNode, 1);
            if (!transferSupport.isDrop() && profileTree2 != null) {
                ProfileTreeTransferHandler profileTreeTransferHandler = (ProfileTreeTransferHandler)profileTree2.getTransferHandler();
                super.removeCutNodes();
            }
            return true;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not process drop event", exception);
            return false;
        }
    }

    private List<ConnectionProfile> getProfiles(Transferable transferable) {
        ArrayList<ConnectionProfile> arrayList = new ArrayList<ConnectionProfile>();
        TransferableProfileNode transferableProfileNode = null;
        try {
            transferableProfileNode = (TransferableProfileNode)transferable.getTransferData(ProfileFlavor.FLAVOR);
        }
        catch (Exception exception) {
            return arrayList;
        }
        TreePath[] treePathArray = transferableProfileNode.getPath();
        if (treePathArray == null) {
            return arrayList;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ConnectionProfile connectionProfile = (ConnectionProfile)defaultMutableTreeNode.getUserObject();
            arrayList.add(connectionProfile);
        }
        return arrayList;
    }

    @Override
    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
        this.lastCutNodes = n == 2 ? ((ProfileTree)jComponent).getSelectionPaths() : null;
        super.exportToClipboard(jComponent, clipboard, 1);
    }
}

