/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import workbench.gui.renderer.ToolTipRenderer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.WbDateFormatter;

public class DateColumnRenderer
extends ToolTipRenderer {
    private final WbDateFormatter dateFormatter = new WbDateFormatter("yyyy-MM-dd HH:mm:ss");
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public DateColumnRenderer() {
        this.setHorizontalAlignment(4);
    }

    public DateColumnRenderer(String string, boolean bl) {
        this();
        this.setFormat(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFormat(String string, boolean bl) {
        try {
            WbDateFormatter wbDateFormatter = this.dateFormatter;
            synchronized (wbDateFormatter) {
                this.dateFormatter.applyPattern(string, bl);
            }
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when setting date format [" + string + "] default format [" + DEFAULT_FORMAT + "] will be used instead", exception);
            this.dateFormatter.applyPattern(DEFAULT_FORMAT);
        }
    }

    @Override
    public void prepareDisplay(Object object) {
        try {
            this.displayValue = this.dateFormatter.formatDateTimeValue(object);
            this.tooltip = this.showTooltip ? this.displayValue : null;
        }
        catch (Throwable throwable) {
            this.displayValue = object.toString();
            this.setTooltip(this.displayValue);
        }
    }
}

