/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import workbench.db.DependencyNode;
import workbench.gui.WbSwingUtilities;
import workbench.resource.IconMgr;

public class DependencyTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private Color selectedForeground;
    private Color selectedBackground;
    private Color unselectedForeground;
    private Color unselectedBackground;
    private ImageIcon fk;
    private ImageIcon table;
    private boolean isSelected;

    public DependencyTreeCellRenderer() {
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.setVerticalAlignment(1);
        this.setHorizontalAlignment(2);
        this.fk = IconMgr.getInstance().getLabelIcon("key");
        this.table = IconMgr.getInstance().getLabelIcon("table");
        this.selectedForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectedBackground = UIManager.getColor("Tree.selectionBackground");
        this.unselectedForeground = UIManager.getColor("Tree.textForeground");
        this.unselectedBackground = UIManager.getColor("Tree.textBackground");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.isSelected = bl;
        if (bl) {
            this.setForeground(this.selectedForeground);
        } else {
            this.setForeground(this.unselectedForeground);
        }
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 == null) {
                this.setIcon(null);
                this.setToolTipText(null);
            } else if (object2 instanceof DependencyNode) {
                this.setIcon(this.table);
                DependencyNode dependencyNode = (DependencyNode)object2;
                String string = dependencyNode.getUpdateAction();
                String string2 = dependencyNode.getDeleteAction();
                if (string.length() > 0 || string2.length() > 0) {
                    StringBuilder stringBuilder = new StringBuilder(50);
                    stringBuilder.append("<html>");
                    boolean bl5 = false;
                    if (string.length() > 0) {
                        stringBuilder.append("ON UPDATE ");
                        stringBuilder.append(string);
                        bl5 = true;
                    }
                    if (string2.length() > 0) {
                        if (bl5) {
                            stringBuilder.append("<br>");
                        }
                        stringBuilder.append("ON DELETE ");
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append("</html>");
                    this.setToolTipText(stringBuilder.toString());
                } else {
                    this.setToolTipText(null);
                }
            } else {
                this.setIcon(this.fk);
                this.setToolTipText(null);
            }
        } else {
            this.setIcon(null);
        }
        this.setText(object.toString());
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        if (this.isSelected) {
            color = this.selectedBackground;
        } else {
            color = this.unselectedBackground;
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n = -1;
        if (color != null) {
            n = this.getLabelStart();
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight());
            }
            graphics.setColor(color2);
        }
        super.paint(graphics);
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }
}

