/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.CellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import workbench.db.postgres.HstoreMap;
import workbench.db.postgres.HstoreSupport;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.SetNullAction;
import workbench.gui.components.FlatButton;
import workbench.gui.components.MapEditor;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTable;
import workbench.interfaces.Disposable;
import workbench.interfaces.NullableEditor;
import workbench.resource.Settings;
import workbench.storage.DataStore;

public class HstoreEditor
implements CellEditor,
TableCellEditor,
ActionListener,
MouseListener,
NullableEditor,
Disposable {
    private final String CONFIG_PROP = "workbench.gui.hstoreeditor";
    private JPanel component;
    private JTextField textField;
    private FlatButton openButton;
    private final List<CellEditorListener> listeners = Collections.synchronizedList(new ArrayList());
    private SetNullAction setNull;
    private TextComponentMouseListener contextMenu;
    private boolean isNull;
    private Color defaultBackground;

    public HstoreEditor() {
        this.component = new JPanel(new BorderLayout(0, 0));
        this.textField = new JTextField(){

            @Override
            public Insets getInsets(Insets insets) {
                return new Insets(0, 0, 0, 0);
            }

            @Override
            public Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }
        };
        this.defaultBackground = this.textField.getBackground();
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField.setFont(Settings.getInstance().getDataFont(true));
        this.textField.addMouseListener(this);
        this.contextMenu = new TextComponentMouseListener();
        this.setNull = new SetNullAction(this);
        this.contextMenu.addAction(this.setNull);
        this.setNull.addToInputMap(this.textField);
        this.textField.addMouseListener(this.contextMenu);
        this.component.add((Component)this.textField, "Center");
        this.openButton = new FlatButton("...");
        this.openButton.setBasicUI();
        this.openButton.setFlatLook();
        this.openButton.setBorder(WbSwingUtilities.FLAT_BUTTON_BORDER);
        this.openButton.setEnabled(true);
        this.openButton.setFocusable(false);
        this.openButton.addActionListener(this);
        this.component.add((Component)this.openButton, "After");
    }

    @Override
    public void setNull(boolean bl) {
        if (bl) {
            this.textField.setText("");
        }
        this.isNull = bl;
    }

    @Override
    public JTextComponent getEditor() {
        return this.textField;
    }

    @Override
    public void restoreOriginal() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.showEditDialog();
    }

    @Override
    public void dispose() {
        if (this.setNull != null) {
            this.setNull.dispose();
        }
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
        }
        this.listeners.clear();
    }

    protected void showEditDialog() {
        Map map = this.getHstore();
        MapEditor mapEditor = new MapEditor(map){

            @Override
            protected DataStore createDataStore() {
                String[] stringArray = new String[]{"Key", "Value"};
                int[] nArray = new int[]{12, 12};
                int[] nArray2 = new int[]{15, 25};
                return new DataStore(stringArray, nArray, nArray2);
            }
        };
        mapEditor.optimizeColumnWidths();
        ValidatingDialog validatingDialog = ValidatingDialog.createDialog(WbSwingUtilities.getWindowAncestor(this.component), mapEditor, "Edit", null, 0, false);
        mapEditor.setEditable(this.textField.isEditable());
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.hstoreeditor");
        if (!validatingDialog.isCancelled() && mapEditor.isModified()) {
            Map<String, String> map2 = mapEditor.getMap();
            this.textField.setText(HstoreSupport.getDisplay(map2));
            this.textField.selectAll();
        }
    }

    private Map getHstore() {
        String string = this.textField.getText();
        Map<String, String> map = HstoreSupport.parseLiteral(string);
        return map == null ? Collections.emptyMap() : map;
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
        if (!bl) {
            this.textField.setBackground(this.defaultBackground);
        }
        this.textField.getCaret().setVisible(true);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = "";
        if (object instanceof Map) {
            string = HstoreSupport.getDisplay((Map)object);
        }
        this.isNull = false;
        WbTable wbTable = (WbTable)jTable;
        this.setEditable(!wbTable.isReadOnly());
        this.textField.setText(string);
        this.textField.selectAll();
        return this.component;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isNull) {
            return null;
        }
        return new HstoreMap(this.getHstore());
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() == 2;
        }
        return false;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    protected void fireEditingStopped() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>(this.listeners);
        for (CellEditorListener cellEditorListener : arrayList) {
            cellEditorListener.editingStopped(changeEvent);
        }
    }

    protected void fireEditingCancelled() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>(this.listeners);
        for (CellEditorListener cellEditorListener : arrayList) {
            cellEditorListener.editingCanceled(changeEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.showEditDialog();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

