/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FontStyleComboBoxModel;
import workbench.gui.components.NumberField;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DataTooltipType;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.DisplayLocale;
import workbench.util.StringUtil;
import workbench.util.WbLocale;

public class DataDisplayOptions
extends JPanel
implements Restoreable,
ValidatingComponent,
ActionListener {
    private JLabel alignLabel;
    private JComboBox alignmentDropDown;
    private JCheckBox appendResults;
    private JCheckBox autoColWidth;
    private JCheckBox autoRowHeight;
    private JCheckBox boldHeader;
    private JPanel colWidthPanel;
    private JTextField defMaxRows;
    private JPanel generalPanel;
    private JCheckBox ignoreEmptyRows;
    private JCheckBox includeHeaderWidth;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JComboBox localeDropDown;
    private JTextField maxColSizeField;
    private JLabel maxColSizeLabel;
    private JTextField maxRowHeight;
    private JLabel maxRowHeightLabel;
    private JTextField minColSizeField;
    private JLabel minColSizeLabel;
    private JPanel multiLinePanel;
    private JTextField multiLineThreshold;
    private JLabel multilineThresholLabel;
    private JComboBox<String> nullFontStyle;
    private JTextField nullString;
    private JLabel nullStringLabel;
    private JCheckBox retrieveComments;
    private JPanel rowHeightPanel;
    private JCheckBox rowHeightResize;
    private JCheckBox selectSummary;
    private JCheckBox showDataType;
    private JCheckBox showGeneratingSQL;
    private JCheckBox showMaxRowsTooltip;
    private JCheckBox showMaxRowsWarn;
    private JCheckBox showRemarks;
    private JCheckBox showRowNumbers;
    private JCheckBox showTableAsPrefix;
    private JCheckBox showTableName;
    private JLabel toolTipConfigLabel;
    private JComboBox tooltipConfig;
    private JCheckBox useTableName;
    private JCheckBox wrapMultineRender;
    private JCheckBox wrapMultlineEdit;

    public DataDisplayOptions() {
        this.initComponents();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{ResourceMgr.getString("TxtTabRight"), ResourceMgr.getString("TxtTabLeft")});
        this.alignmentDropDown.setModel(defaultComboBoxModel);
        this.nullFontStyle.setModel(new FontStyleComboBoxModel());
        WbSwingUtilities.setMinimumSizeFromCols(this.defMaxRows);
        WbSwingUtilities.setMinimumSizeFromCols(this.nullString);
        WbSwingUtilities.setMinimumSizeFromCols(this.maxRowHeight);
        WbSwingUtilities.setMinimumSizeFromCols(this.multiLineThreshold);
        WbSwingUtilities.setMinimumSizeFromCols(this.minColSizeField);
        WbSwingUtilities.setMinimumSizeFromCols(this.maxColSizeField);
        WbSwingUtilities.makeEqualWidth(this.nullString, this.defMaxRows, this.alignmentDropDown);
    }

    @Override
    public void restoreSettings() {
        String[] stringArray = new String[]{ResourceMgr.getString("LblResultToolTipNone"), ResourceMgr.getString("LblResultToolTipLastExec"), ResourceMgr.getString("LblResultToolTipFull")};
        this.tooltipConfig.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.tooltipConfig.setSelectedIndex(this.typeToIndex(GuiSettings.getDataTooltipType()));
        this.appendResults.setSelected(GuiSettings.getDefaultAppendResults());
        this.rowHeightResize.setSelected(GuiSettings.getAllowRowHeightResizing());
        this.autoRowHeight.setSelected(GuiSettings.getAutomaticOptimalRowHeight());
        this.maxRowHeight.setText(Integer.toString(GuiSettings.getAutRowHeightMaxLines()));
        this.autoColWidth.setSelected(GuiSettings.getAutomaticOptimalWidth());
        this.includeHeaderWidth.setSelected(GuiSettings.getIncludeHeaderInOptimalWidth());
        this.ignoreEmptyRows.setSelected(GuiSettings.getIgnoreWhitespaceForAutoRowHeight());
        this.minColSizeField.setText(Integer.toString(GuiSettings.getMinColumnWidth()));
        this.maxColSizeField.setText(Integer.toString(GuiSettings.getMaxColumnWidth()));
        this.selectSummary.setSelected(GuiSettings.getShowSelectionSummary());
        this.multiLineThreshold.setText(Integer.toString(GuiSettings.getMultiLineThreshold()));
        this.wrapMultineRender.setSelected(GuiSettings.getWrapMultilineRenderer());
        this.wrapMultlineEdit.setSelected(GuiSettings.getWrapMultilineEditor());
        this.defMaxRows.setText(Integer.toString(GuiSettings.getDefaultMaxRows()));
        this.retrieveComments.setSelected(GuiSettings.getRetrieveQueryComments());
        this.showRowNumbers.setSelected(GuiSettings.getShowTableRowNumbers());
        this.showMaxRowsWarn.setSelected(GuiSettings.getShowMaxRowsReached());
        this.showMaxRowsTooltip.setSelected(GuiSettings.getShowMaxRowsTooltip());
        this.nullString.setText(GuiSettings.getDisplayNullString());
        this.showGeneratingSQL.setSelected(GuiSettings.getShowResultSQL());
        this.useTableName.setSelected(GuiSettings.getUseTablenameAsResultName());
        int n = GuiSettings.getNumberDataAlignment();
        if (n == 2) {
            this.alignmentDropDown.setSelectedIndex(1);
        } else {
            this.alignmentDropDown.setSelectedIndex(0);
        }
        this.boldHeader.setSelected(GuiSettings.showTableHeaderInBold());
        this.showDataType.setSelected(GuiSettings.showDatatypeInTableHeader());
        this.showRemarks.setSelected(GuiSettings.showRemarksInTableHeader());
        this.nullFontStyle.setSelectedIndex(GuiSettings.getDisplayNullFontStyle());
        this.showTableName.setSelected(GuiSettings.showTableNameInColumnHeader());
        this.showTableAsPrefix.setSelected(GuiSettings.showTableNameAsColumnPrefix());
        this.showTableAsPrefix.setEnabled(this.showTableName.isSelected());
        this.fillLanguageDropDown();
    }

    @Override
    public void saveSettings() {
        int n = StringUtil.getIntValue(this.multiLineThreshold.getText(), -1);
        if (n > 0) {
            GuiSettings.setMultiLineThreshold(n);
        }
        GuiSettings.setAllowRowHeightResizing(this.rowHeightResize.isSelected());
        GuiSettings.setMaxColumnWidth(((NumberField)this.maxColSizeField).getValue());
        GuiSettings.setMinColumnWidth(((NumberField)this.minColSizeField).getValue());
        GuiSettings.setAutomaticOptimalWidth(this.autoColWidth.isSelected());
        GuiSettings.setIncludeHeaderInOptimalWidth(this.includeHeaderWidth.isSelected());
        GuiSettings.setAutomaticOptimalRowHeight(this.autoRowHeight.isSelected());
        GuiSettings.setAutRowHeightMaxLines(((NumberField)this.maxRowHeight).getValue());
        GuiSettings.setIgnoreWhitespaceForAutoRowHeight(this.ignoreEmptyRows.isSelected());
        GuiSettings.setShowSelectionSummary(this.selectSummary.isSelected());
        GuiSettings.setDefaultMaxRows(StringUtil.getIntValue(this.defMaxRows.getText(), 0));
        GuiSettings.setRetrieveQueryComments(this.retrieveComments.isSelected());
        GuiSettings.setShowTableRowNumbers(this.showRowNumbers.isSelected());
        GuiSettings.setShowMaxRowsReached(this.showMaxRowsWarn.isSelected());
        GuiSettings.setDisplayNullString(this.nullString.getText());
        GuiSettings.setShowResultSQL(this.showGeneratingSQL.isSelected());
        GuiSettings.setShowTableHeaderInBold(this.boldHeader.isSelected());
        GuiSettings.setWrapMultilineEditor(this.wrapMultlineEdit.isSelected());
        GuiSettings.setWrapMultilineRenderer(this.wrapMultineRender.isSelected());
        GuiSettings.setShowMaxRowsTooltip(this.showMaxRowsTooltip.isSelected());
        GuiSettings.setDefaultAppendResults(this.appendResults.isSelected());
        GuiSettings.setUseTablenameAsResultName(this.useTableName.isSelected());
        GuiSettings.setDataTooltipType(this.indexToType(this.tooltipConfig.getSelectedIndex()));
        GuiSettings.setShowDatatypeInTableHeader(this.showDataType.isSelected());
        GuiSettings.setShowRemarksInTableHeader(this.showRemarks.isSelected());
        GuiSettings.setDisplayNullFontStyle(this.nullFontStyle.getSelectedIndex());
        GuiSettings.setShowTableNameInColumnHeader(this.showTableName.isSelected());
        GuiSettings.setshowTableNameAsColumnPrefix(this.showTableAsPrefix.isSelected());
        DisplayLocale displayLocale = (DisplayLocale)this.localeDropDown.getSelectedItem();
        Settings.getInstance().setSortLocale(displayLocale.getLocale());
        if (this.alignmentDropDown.getSelectedIndex() == 1) {
            GuiSettings.setNumberDataAlignment("left");
        } else {
            GuiSettings.setNumberDataAlignment("right");
        }
    }

    private DataTooltipType indexToType(int n) {
        switch (n) {
            case 0: {
                return DataTooltipType.none;
            }
            case 1: {
                return DataTooltipType.lastExec;
            }
            case 2: {
                return DataTooltipType.full;
            }
        }
        return DataTooltipType.full;
    }

    private int typeToIndex(DataTooltipType dataTooltipType) {
        switch (dataTooltipType) {
            case none: {
                return 0;
            }
            case lastExec: {
                return 1;
            }
            case full: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    private Locale[] readLocales() {
        long l = System.currentTimeMillis();
        Locale[] localeArray = Locale.getAvailableLocales();
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Reading " + localeArray.length + " locales took: " + l2 + "ms");
        l = System.currentTimeMillis();
        Comparator<Locale> comparator = new Comparator<Locale>(){
            private Locale l = Settings.getInstance().getLanguage();

            @Override
            public int compare(Locale locale, Locale locale2) {
                return locale.getDisplayLanguage(this.l).compareTo(locale2.getDisplayLanguage(this.l));
            }
        };
        Arrays.sort(localeArray, comparator);
        l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Sorting locales took: " + l2 + "ms");
        return localeArray;
    }

    private void fillLanguageDropDown() {
        Locale locale = Settings.getInstance().getLanguage();
        DisplayLocale displayLocale = new DisplayLocale(new WbLocale(Settings.getInstance().getSortLocale()));
        Locale[] localeArray = this.readLocales();
        this.localeDropDown.removeAllItems();
        this.localeDropDown.addItem(new DisplayLocale(null));
        int n = 1;
        int n2 = -1;
        for (Locale locale2 : localeArray) {
            DisplayLocale displayLocale2 = new DisplayLocale(new WbLocale(locale2));
            displayLocale2.setDisplayLocale(locale);
            this.localeDropDown.addItem(displayLocale2);
            if (displayLocale2.equals(displayLocale)) {
                n2 = n;
            }
            ++n;
        }
        if (n2 != -1) {
            this.localeDropDown.setSelectedIndex(n2);
        }
    }

    private void initComponents() {
        this.generalPanel = new JPanel();
        this.selectSummary = new JCheckBox();
        this.retrieveComments = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.defMaxRows = new JTextField();
        this.showRowNumbers = new JCheckBox();
        this.showMaxRowsWarn = new JCheckBox();
        this.showMaxRowsTooltip = new JCheckBox();
        this.showGeneratingSQL = new JCheckBox();
        this.alignmentDropDown = new JComboBox();
        this.nullStringLabel = new JLabel();
        this.nullString = new JTextField();
        this.appendResults = new JCheckBox();
        this.useTableName = new JCheckBox();
        this.alignLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.localeDropDown = new JComboBox();
        this.toolTipConfigLabel = new JLabel();
        this.tooltipConfig = new JComboBox();
        this.nullFontStyle = new JComboBox();
        this.colWidthPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.autoColWidth = new JCheckBox();
        this.includeHeaderWidth = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.minColSizeLabel = new JLabel();
        this.minColSizeField = new NumberField();
        this.jLabel4 = new JLabel();
        this.maxColSizeLabel = new JLabel();
        this.maxColSizeField = new NumberField();
        this.jLabel6 = new JLabel();
        this.rowHeightPanel = new JPanel();
        this.autoRowHeight = new JCheckBox();
        this.ignoreEmptyRows = new JCheckBox();
        this.maxRowHeightLabel = new JLabel();
        this.maxRowHeight = new NumberField();
        this.rowHeightResize = new JCheckBox();
        this.multiLinePanel = new JPanel();
        this.wrapMultineRender = new JCheckBox();
        this.wrapMultlineEdit = new JCheckBox();
        this.multilineThresholLabel = new JLabel();
        this.multiLineThreshold = new NumberField();
        this.jPanel2 = new JPanel();
        this.boldHeader = new JCheckBox();
        this.showDataType = new JCheckBox();
        this.showRemarks = new JCheckBox();
        this.showTableName = new JCheckBox();
        this.showTableAsPrefix = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.generalPanel.setLayout(new GridBagLayout());
        this.selectSummary.setText(ResourceMgr.getString("LblSelectionSummary"));
        this.selectSummary.setToolTipText(ResourceMgr.getString("d_LblSelectionSummary"));
        this.selectSummary.setBorder(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.generalPanel.add((Component)this.selectSummary, gridBagConstraints);
        this.retrieveComments.setText(ResourceMgr.getString("LblRetrieveColComments"));
        this.retrieveComments.setToolTipText(ResourceMgr.getString("d_LblRetrieveColComments"));
        this.retrieveComments.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.generalPanel.add((Component)this.retrieveComments, gridBagConstraints);
        this.jLabel5.setLabelFor(this.defMaxRows);
        this.jLabel5.setText(ResourceMgr.getString("LblDefMaxRows"));
        this.jLabel5.setToolTipText(ResourceMgr.getString("d_LblDefMaxRows"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 16, 0, 7);
        this.generalPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.defMaxRows.setColumns(8);
        this.defMaxRows.setToolTipText(ResourceMgr.getString("d_LblDefMaxRows"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.generalPanel.add((Component)this.defMaxRows, gridBagConstraints);
        this.showRowNumbers.setText(ResourceMgr.getString("LblShowRowNumbers"));
        this.showRowNumbers.setToolTipText(ResourceMgr.getString("d_LblShowRowNumbers"));
        this.showRowNumbers.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.generalPanel.add((Component)this.showRowNumbers, gridBagConstraints);
        this.showMaxRowsWarn.setText(ResourceMgr.getString("LblShowMaxRowsWarning"));
        this.showMaxRowsWarn.setToolTipText(ResourceMgr.getString("d_LblShowMaxRowsWarning"));
        this.showMaxRowsWarn.setBorder(null);
        this.showMaxRowsWarn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.generalPanel.add((Component)this.showMaxRowsWarn, gridBagConstraints);
        this.showMaxRowsTooltip.setText(ResourceMgr.getString("LblShowMaxRowsTooltip"));
        this.showMaxRowsTooltip.setToolTipText(ResourceMgr.getString("d_LblShowMaxRowsTooltip"));
        this.showMaxRowsTooltip.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.generalPanel.add((Component)this.showMaxRowsTooltip, gridBagConstraints);
        this.showGeneratingSQL.setText(ResourceMgr.getString("LblShowGenSQL"));
        this.showGeneratingSQL.setToolTipText(ResourceMgr.getString("d_LblShowGenSQL"));
        this.showGeneratingSQL.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.generalPanel.add((Component)this.showGeneratingSQL, gridBagConstraints);
        this.alignmentDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"Left", "Right"}));
        this.alignmentDropDown.setSelectedItem("Right");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 10);
        this.generalPanel.add((Component)this.alignmentDropDown, gridBagConstraints);
        this.nullStringLabel.setText(ResourceMgr.getString("LblNullString"));
        this.nullStringLabel.setToolTipText(ResourceMgr.getString("d_LblNullDisp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 16, 0, 0);
        this.generalPanel.add((Component)this.nullStringLabel, gridBagConstraints);
        this.nullString.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 9);
        this.generalPanel.add((Component)this.nullString, gridBagConstraints);
        this.appendResults.setText(ResourceMgr.getString("LblAppendDefault"));
        this.appendResults.setToolTipText(ResourceMgr.getString("d_LblAppendDefault"));
        this.appendResults.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.generalPanel.add((Component)this.appendResults, gridBagConstraints);
        this.useTableName.setText(ResourceMgr.getString("LblUseTblName"));
        this.useTableName.setToolTipText(ResourceMgr.getString("d_LblUseTblName"));
        this.useTableName.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.generalPanel.add((Component)this.useTableName, gridBagConstraints);
        this.alignLabel.setText(ResourceMgr.getString("LblAlignNum"));
        this.alignLabel.setToolTipText(ResourceMgr.getString("d_LblAlignNum"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 16, 0, 0);
        this.generalPanel.add((Component)this.alignLabel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceMgr.getString("LblSortLocale"));
        this.jLabel1.setToolTipText(ResourceMgr.getString("d_LblSortLocale"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.localeDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 6, 0, 0);
        this.jPanel1.add((Component)this.localeDropDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.generalPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.toolTipConfigLabel.setText(ResourceMgr.getString("LblResultTabTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.generalPanel.add((Component)this.toolTipConfigLabel, gridBagConstraints);
        this.tooltipConfig.setModel(new DefaultComboBoxModel<String>(new String[]{"Full", "Partial", "None"}));
        this.tooltipConfig.setSelectedItem("Right");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.generalPanel.add((Component)this.tooltipConfig, gridBagConstraints);
        this.nullFontStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.generalPanel.add(this.nullFontStyle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.generalPanel, gridBagConstraints);
        this.colWidthPanel.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("TxtColWidthSettings")));
        this.colWidthPanel.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new FlowLayout(0, 5, 0));
        this.autoColWidth.setText(ResourceMgr.getString("LblAutoColWidth"));
        this.autoColWidth.setToolTipText(ResourceMgr.getString("d_LblAutoColWidth"));
        this.autoColWidth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoColWidth.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel3.add(this.autoColWidth);
        this.includeHeaderWidth.setText(ResourceMgr.getString("LblIncludeHeaderColWidth"));
        this.includeHeaderWidth.setToolTipText(ResourceMgr.getString("d_LblIncludeHeaderColWidth"));
        this.includeHeaderWidth.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.includeHeaderWidth.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel3.add(this.includeHeaderWidth);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        this.colWidthPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.minColSizeLabel.setText(ResourceMgr.getString("LblMinColsize"));
        this.minColSizeLabel.setToolTipText(ResourceMgr.getString("d_LblMinColsize"));
        this.minColSizeLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 6);
        this.jPanel4.add((Component)this.minColSizeLabel, gridBagConstraints);
        this.minColSizeField.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.minColSizeField, gridBagConstraints);
        this.jLabel4.setText("px");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel4.add((Component)this.jLabel4, gridBagConstraints);
        this.maxColSizeLabel.setText(ResourceMgr.getString("LblMaxColsize"));
        this.maxColSizeLabel.setToolTipText(ResourceMgr.getString("d_LblMaxColsize"));
        this.maxColSizeLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel4.add((Component)this.maxColSizeLabel, gridBagConstraints);
        this.maxColSizeField.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.maxColSizeField, gridBagConstraints);
        this.jLabel6.setText("px");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel4.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 2, 0);
        this.colWidthPanel.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 7);
        this.add((Component)this.colWidthPanel, gridBagConstraints);
        this.rowHeightPanel.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("TxtRowHeightSettings")));
        this.rowHeightPanel.setLayout(new GridBagLayout());
        this.autoRowHeight.setText(ResourceMgr.getString("LblRowHeightAuto"));
        this.autoRowHeight.setToolTipText(ResourceMgr.getString("LblRowHeightAuto"));
        this.autoRowHeight.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.rowHeightPanel.add((Component)this.autoRowHeight, gridBagConstraints);
        this.ignoreEmptyRows.setText(ResourceMgr.getString("LblIgnoreRowHeightEmptyLine"));
        this.ignoreEmptyRows.setToolTipText(ResourceMgr.getString("d_LblIgnoreRowHeightEmptyLine"));
        this.ignoreEmptyRows.setBorder(null);
        this.ignoreEmptyRows.setMargin(new Insets(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.rowHeightPanel.add((Component)this.ignoreEmptyRows, gridBagConstraints);
        this.maxRowHeightLabel.setText(ResourceMgr.getString("LblRowHeightMax"));
        this.maxRowHeightLabel.setToolTipText(ResourceMgr.getString("d_LblRowHeightMax"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.rowHeightPanel.add((Component)this.maxRowHeightLabel, gridBagConstraints);
        this.maxRowHeight.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        this.rowHeightPanel.add((Component)this.maxRowHeight, gridBagConstraints);
        this.rowHeightResize.setText(ResourceMgr.getString("LblRowResize"));
        this.rowHeightResize.setToolTipText(ResourceMgr.getString("d_LblRowResize"));
        this.rowHeightResize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rowHeightResize.setHorizontalAlignment(2);
        this.rowHeightResize.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 2, 0);
        this.rowHeightPanel.add((Component)this.rowHeightResize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 7);
        this.add((Component)this.rowHeightPanel, gridBagConstraints);
        this.multiLinePanel.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("LblMultiLineCols")));
        this.multiLinePanel.setLayout(new GridBagLayout());
        this.wrapMultineRender.setText(ResourceMgr.getString("LblMultiWrapRender"));
        this.wrapMultineRender.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.multiLinePanel.add((Component)this.wrapMultineRender, gridBagConstraints);
        this.wrapMultlineEdit.setText(ResourceMgr.getString("LblMultiWrapEdit"));
        this.wrapMultlineEdit.setBorder(null);
        this.wrapMultlineEdit.setMargin(new Insets(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        this.multiLinePanel.add((Component)this.wrapMultlineEdit, gridBagConstraints);
        this.multilineThresholLabel.setText(ResourceMgr.getString("LblMultiLineLimit"));
        this.multilineThresholLabel.setToolTipText(ResourceMgr.getString("d_LblMultiLineLimit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.multiLinePanel.add((Component)this.multilineThresholLabel, gridBagConstraints);
        this.multiLineThreshold.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        this.multiLinePanel.add((Component)this.multiLineThreshold, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 7);
        this.add((Component)this.multiLinePanel, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("LblColHeaders")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.boldHeader.setText(ResourceMgr.getString("LblBoldHeader"));
        this.boldHeader.setToolTipText(ResourceMgr.getString("d_LblBoldHeader"));
        this.boldHeader.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 12, 0, 0);
        this.jPanel2.add((Component)this.boldHeader, gridBagConstraints);
        this.showDataType.setText(ResourceMgr.getString("LblInclTypeInHeader"));
        this.showDataType.setToolTipText(ResourceMgr.getString("d_LblInclTypeInHeader"));
        this.showDataType.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.jPanel2.add((Component)this.showDataType, gridBagConstraints);
        this.showRemarks.setText(ResourceMgr.getString("LblInclCommtInHeader"));
        this.showRemarks.setToolTipText(ResourceMgr.getString("d_LblInclCommtInHeader"));
        this.showRemarks.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanel2.add((Component)this.showRemarks, gridBagConstraints);
        this.showTableName.setText(ResourceMgr.getString("LblInclTableInHeader"));
        this.showTableName.setToolTipText(ResourceMgr.getString("d_LblInclTableInHeader"));
        this.showTableName.setBorder(null);
        this.showTableName.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 0, 0);
        this.jPanel2.add((Component)this.showTableName, gridBagConstraints);
        this.showTableAsPrefix.setText(ResourceMgr.getString("LblColTableAsPrefix"));
        this.showTableAsPrefix.setToolTipText(ResourceMgr.getString("d_LblColTableAsPrefix"));
        this.showTableAsPrefix.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 0, 0);
        this.jPanel2.add((Component)this.showTableAsPrefix, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 7);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.showMaxRowsWarn) {
            this.showMaxRowsWarnActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.showTableName) {
            this.showTableNameActionPerformed(actionEvent);
        }
    }

    private void showMaxRowsWarnActionPerformed(ActionEvent actionEvent) {
        this.showMaxRowsTooltip.setEnabled(this.showMaxRowsWarn.isSelected());
    }

    private void showTableNameActionPerformed(ActionEvent actionEvent) {
        this.showTableAsPrefix.setEnabled(this.showTableName.isSelected());
    }
}

