/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.components.WbColorPicker;
import workbench.gui.components.WbFontStylePicker;
import workbench.gui.editor.SyntaxStyle;
import workbench.gui.editor.SyntaxUtilities;
import workbench.interfaces.Restoreable;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class EditorColorsPanel
extends JPanel
implements Restoreable {
    private WbColorPicker bgColor;
    private JLabel bgColorLabel;
    private WbFontStylePicker blockComments;
    private JLabel blockCommentsLabel;
    private WbColorPicker currLineColor;
    private JLabel currLineLabel;
    private WbColorPicker currentStmtColor;
    private JLabel currentStmtLabel;
    private WbColorPicker cursorColor;
    private JLabel cursorLabel;
    private JLabel dataTypesLabel;
    private WbFontStylePicker datatypes;
    private JPanel editorColors;
    private WbColorPicker errorColor;
    private JLabel errorColorLabel;
    private WbFontStylePicker functions;
    private JLabel functionsLabel;
    private WbFontStylePicker keyword1;
    private JLabel keywordsLabel;
    private WbFontStylePicker lineComments;
    private JLabel lineCommentsLabel;
    private WbFontStylePicker literals;
    private JLabel literalsLabel;
    private WbFontStylePicker operators;
    private JLabel operatorsLabel;
    private JLabel quoteIdLabel;
    private WbFontStylePicker quotedIds;
    private WbColorPicker selectionColor;
    private JLabel selectionColorLabel;
    private JPanel syntaxColors;
    private WbColorPicker textColor;
    private JLabel textColorLabel;
    private JLabel wbCommandsLabel;
    private WbFontStylePicker wbKeywords;

    public EditorColorsPanel() {
        this.initComponents();
    }

    @Override
    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        SyntaxStyle[] syntaxStyleArray = SyntaxUtilities.getDefaultSyntaxStyles();
        this.textColor.setDefaultLabelKey("LblDefaultIndicator");
        this.bgColor.setDefaultLabelKey("LblDefaultIndicator");
        this.selectionColor.setDefaultLabelKey("LblDefaultIndicator");
        Color color = settings.getColor("workbench.editor.color.foreground", null);
        this.textColor.setSelectedColor(color);
        Color color2 = settings.getColor("workbench.editor.color.background", null);
        this.bgColor.setSelectedColor(color2);
        this.blockComments.setStyle(syntaxStyleArray[1]);
        this.lineComments.setStyle(syntaxStyleArray[2]);
        this.keyword1.setStyle(syntaxStyleArray[6]);
        this.functions.setStyle(syntaxStyleArray[8]);
        this.wbKeywords.setStyle(syntaxStyleArray[7]);
        this.literals.setStyle(syntaxStyleArray[3]);
        this.quotedIds.setStyle(syntaxStyleArray[4]);
        this.operators.setStyle(syntaxStyleArray[9]);
        this.datatypes.setStyle(syntaxStyleArray[5]);
        this.errorColor.setSelectedColor(Settings.getInstance().getEditorErrorColor());
        this.currentStmtColor.setSelectedColor(Settings.getInstance().getEditorCurrentStmtColor());
        this.selectionColor.setSelectedColor(Settings.getInstance().getEditorSelectionColor());
        this.currLineColor.setSelectedColor(Settings.getInstance().getEditorCurrentLineColor());
        this.cursorColor.setSelectedColor(Settings.getInstance().getEditorCursorColor());
    }

    @Override
    public void saveSettings() {
        this.saveStyle(this.blockComments, "comment1");
        this.saveStyle(this.lineComments, "comment2");
        this.saveStyle(this.keyword1, "keyword1");
        this.saveStyle(this.wbKeywords, "keyword2");
        this.saveStyle(this.functions, "keyword3");
        this.saveStyle(this.literals, "literal1");
        this.saveStyle(this.quotedIds, "literal2");
        this.saveStyle(this.operators, "operator");
        this.saveStyle(this.datatypes, "datatype");
        Settings settings = Settings.getInstance();
        settings.setEditorErrorColor(this.errorColor.getSelectedColor());
        settings.setEditorCurrentLineColor(this.currLineColor.getSelectedColor());
        settings.setEditorSelectionColor(this.selectionColor.getSelectedColor());
        settings.setEditorBackgroundColor(this.bgColor.getSelectedColor());
        settings.setEditorTextColor(this.textColor.getSelectedColor());
        settings.setEditorCursorColor(this.cursorColor.getSelectedColor());
        settings.setEditorCurrentStmtColor(this.currentStmtColor.getSelectedColor());
    }

    private void saveStyle(WbFontStylePicker wbFontStylePicker, String string) {
        Settings settings = Settings.getInstance();
        settings.setColor("workbench.editor.color." + string, wbFontStylePicker.getSelectedColor());
        settings.setProperty("workbench.editor.syntax.style." + string, wbFontStylePicker.getFontStyle());
    }

    private void initComponents() {
        this.syntaxColors = new JPanel();
        this.lineCommentsLabel = new JLabel();
        this.wbCommandsLabel = new JLabel();
        this.literalsLabel = new JLabel();
        this.functionsLabel = new JLabel();
        this.blockCommentsLabel = new JLabel();
        this.operatorsLabel = new JLabel();
        this.keywordsLabel = new JLabel();
        this.dataTypesLabel = new JLabel();
        this.quoteIdLabel = new JLabel();
        this.keyword1 = new WbFontStylePicker();
        this.datatypes = new WbFontStylePicker();
        this.operators = new WbFontStylePicker();
        this.functions = new WbFontStylePicker();
        this.wbKeywords = new WbFontStylePicker();
        this.literals = new WbFontStylePicker();
        this.quotedIds = new WbFontStylePicker();
        this.blockComments = new WbFontStylePicker();
        this.lineComments = new WbFontStylePicker();
        this.editorColors = new JPanel();
        this.currLineLabel = new JLabel();
        this.currLineColor = new WbColorPicker(true);
        this.selectionColorLabel = new JLabel();
        this.selectionColor = new WbColorPicker(true);
        this.errorColorLabel = new JLabel();
        this.errorColor = new WbColorPicker();
        this.textColor = new WbColorPicker(true);
        this.textColorLabel = new JLabel();
        this.bgColorLabel = new JLabel();
        this.bgColor = new WbColorPicker(true);
        this.cursorLabel = new JLabel();
        this.cursorColor = new WbColorPicker();
        this.currentStmtColor = new WbColorPicker();
        this.currentStmtLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.syntaxColors.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("LblSyntaxColors")));
        this.syntaxColors.setLayout(new GridBagLayout());
        this.lineCommentsLabel.setText(ResourceMgr.getString("LblColorComment2"));
        this.lineCommentsLabel.setToolTipText(ResourceMgr.getString("d_LblColorComment2"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.syntaxColors.add((Component)this.lineCommentsLabel, gridBagConstraints);
        this.wbCommandsLabel.setText(ResourceMgr.getString("LblColorKeyword2"));
        this.wbCommandsLabel.setToolTipText(ResourceMgr.getString("d_LblColorKeyword2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 5, 0);
        this.syntaxColors.add((Component)this.wbCommandsLabel, gridBagConstraints);
        this.literalsLabel.setText(ResourceMgr.getString("LblColorLiteral"));
        this.literalsLabel.setToolTipText(ResourceMgr.getString("d_LblColorLiteral"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.syntaxColors.add((Component)this.literalsLabel, gridBagConstraints);
        this.functionsLabel.setText(ResourceMgr.getString("LblColorKeyword3"));
        this.functionsLabel.setToolTipText(ResourceMgr.getString("d_LblColorKeyword3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.syntaxColors.add((Component)this.functionsLabel, gridBagConstraints);
        this.blockCommentsLabel.setText(ResourceMgr.getString("LblColorComment1"));
        this.blockCommentsLabel.setToolTipText(ResourceMgr.getString("d_LblColorComment1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.syntaxColors.add((Component)this.blockCommentsLabel, gridBagConstraints);
        this.operatorsLabel.setText(ResourceMgr.getString("LblColorOperator"));
        this.operatorsLabel.setToolTipText(ResourceMgr.getString("d_LblColorOperator"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.syntaxColors.add((Component)this.operatorsLabel, gridBagConstraints);
        this.keywordsLabel.setText(ResourceMgr.getString("LblColorKeyword1"));
        this.keywordsLabel.setToolTipText(ResourceMgr.getString("d_LblColorKeyword1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.syntaxColors.add((Component)this.keywordsLabel, gridBagConstraints);
        this.dataTypesLabel.setText(ResourceMgr.getString("LblColorDatatype"));
        this.dataTypesLabel.setToolTipText(ResourceMgr.getString("d_LblColorDatatype"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.syntaxColors.add((Component)this.dataTypesLabel, gridBagConstraints);
        this.quoteIdLabel.setText(ResourceMgr.getString("LblColorQuotedIds"));
        this.quoteIdLabel.setToolTipText(ResourceMgr.getString("d_LblColorQuotedIds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.syntaxColors.add((Component)this.quoteIdLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 2, 0, 17);
        this.syntaxColors.add((Component)this.keyword1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 2, 0, 17);
        this.syntaxColors.add((Component)this.datatypes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 2, 0, 17);
        this.syntaxColors.add((Component)this.operators, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 2, 0, 17);
        this.syntaxColors.add((Component)this.functions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 2, 0, 17);
        this.syntaxColors.add((Component)this.wbKeywords, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 2, 0, 0);
        this.syntaxColors.add((Component)this.literals, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 2, 0, 0);
        this.syntaxColors.add((Component)this.quotedIds, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 2, 0, 0);
        this.syntaxColors.add((Component)this.blockComments, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 2, 0, 0);
        this.syntaxColors.add((Component)this.lineComments, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.add((Component)this.syntaxColors, gridBagConstraints);
        this.editorColors.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("LblEditorColors")));
        this.editorColors.setLayout(new GridBagLayout());
        this.currLineLabel.setText(ResourceMgr.getString("LblCurrLineColor"));
        this.currLineLabel.setToolTipText(ResourceMgr.getString("d_LblCurrLineColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 27, 0, 0);
        this.editorColors.add((Component)this.currLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.editorColors.add((Component)this.currLineColor, gridBagConstraints);
        this.selectionColorLabel.setText(ResourceMgr.getString("LblSelectionColor"));
        this.selectionColorLabel.setToolTipText(ResourceMgr.getString("d_LblSelectionColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 5, 0, 0);
        this.editorColors.add((Component)this.selectionColorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 0, 0);
        this.editorColors.add((Component)this.selectionColor, gridBagConstraints);
        this.errorColorLabel.setText(ResourceMgr.getString("LblSelectErrorColor"));
        this.errorColorLabel.setToolTipText(ResourceMgr.getString("d_LblSelectErrorColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 27, 0, 0);
        this.editorColors.add((Component)this.errorColorLabel, gridBagConstraints);
        this.errorColor.setToolTipText(ResourceMgr.getString("d_LblSelectErrorColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.editorColors.add((Component)this.errorColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 3, 0, 0);
        this.editorColors.add((Component)this.textColor, gridBagConstraints);
        this.textColorLabel.setText(ResourceMgr.getString("LblEditorFgColor"));
        this.textColorLabel.setToolTipText(ResourceMgr.getString("d_LblEditorFgColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.editorColors.add((Component)this.textColorLabel, gridBagConstraints);
        this.bgColorLabel.setText(ResourceMgr.getString("LblEditorBgColor"));
        this.bgColorLabel.setToolTipText(ResourceMgr.getString("d_LblEditorBgColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 5, 0, 0);
        this.editorColors.add((Component)this.bgColorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 0, 0);
        this.editorColors.add((Component)this.bgColor, gridBagConstraints);
        this.cursorLabel.setText(ResourceMgr.getString("LblEditorCursorColor"));
        this.cursorLabel.setToolTipText(ResourceMgr.getString("d_LblEditorCursorColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 27, 0, 0);
        this.editorColors.add((Component)this.cursorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.editorColors.add((Component)this.cursorColor, gridBagConstraints);
        this.currentStmtColor.setToolTipText(ResourceMgr.getString("d_LblCurrentStmtColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.editorColors.add((Component)this.currentStmtColor, gridBagConstraints);
        this.currentStmtLabel.setText(ResourceMgr.getString("LblCurrentStmtColor"));
        this.currentStmtLabel.setToolTipText(ResourceMgr.getString("d_LblCurrentStmtColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 27, 0, 0);
        this.editorColors.add((Component)this.currentStmtLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 7, 9);
        this.add((Component)this.editorColors, gridBagConstraints);
    }
}

