/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import workbench.db.WbConnection;
import workbench.gui.components.ExecuteSqlPanel;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbCheckBox;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.DelimiterDefinition;
import workbench.sql.ErrorDescriptor;
import workbench.sql.parser.ScriptParser;
import workbench.util.SqlUtil;

public class ErrorRetryPanel
extends ExecuteSqlPanel
implements ActionListener,
WindowListener {
    public static final String PROP_REPLACE_ERROR_STATEMENT = "workbench.gui.retry_error.replace.statement";
    private JPanel buttonPanel;
    private JButton retryButton;
    private JButton cancelButton;
    private JButton ignoreOneButton;
    private JButton ignoreAllButton;
    private JCheckBox replaceStatement;
    private boolean enableReplace = true;

    public ErrorRetryPanel(WbConnection wbConnection) {
        super(wbConnection);
    }

    public void setEnableReplace(boolean bl) {
        this.enableReplace = bl;
    }

    public void setStatement(ScriptParser scriptParser, int n, ErrorDescriptor errorDescriptor) {
        this.initUI();
        if (scriptParser == null) {
            return;
        }
        String string = scriptParser.getCommand(n);
        DelimiterDefinition delimiterDefinition = scriptParser.getDelimiterUsed(n);
        if (delimiterDefinition.isNonStandard()) {
            string = string + "\n" + delimiterDefinition.getDelimiter();
        }
        this.sqlEditor.setText(string);
        String string2 = SqlUtil.getSqlVerb(string);
        if ("select".equalsIgnoreCase(string2) || "with".equalsIgnoreCase(string2)) {
            this.showSelectHint();
        }
        this.showError(errorDescriptor);
    }

    public String getStatement() {
        if (this.sqlEditor == null) {
            return "";
        }
        ScriptParser scriptParser = ScriptParser.createScriptParser(this.runner.getConnection());
        scriptParser.setScript(this.sqlEditor.getText());
        if (scriptParser.getSize() < 1) {
            return "";
        }
        return scriptParser.getCommand(0);
    }

    @Override
    protected JPanel getToolPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.replaceStatement = new WbCheckBox(ResourceMgr.getString("LblReplaceOrgSql"));
        this.replaceStatement.setToolTipText(ResourceMgr.getDescription("LblReplaceOrgSql"));
        if (this.enableReplace) {
            this.replaceStatement.setEnabled(true);
            this.replaceStatement.setSelected(Settings.getInstance().getBoolProperty(PROP_REPLACE_ERROR_STATEMENT, false));
        } else {
            this.replaceStatement.setEnabled(false);
        }
        int n = IconMgr.getInstance().getSizeForLabel();
        jPanel.add((Component)this.replaceStatement, "Before");
        this.buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.retryButton = new WbButton(ResourceMgr.getString("LblRetry"));
        this.retryButton.addActionListener(this);
        this.buttonPanel.add(this.retryButton);
        this.buttonPanel.add(Box.createHorizontalStrut(n * 2));
        this.ignoreOneButton = new WbButton(ResourceMgr.getString("LblIgnoreThis"));
        this.ignoreOneButton.addActionListener(this);
        this.buttonPanel.add(this.ignoreOneButton);
        this.buttonPanel.add(Box.createHorizontalStrut(n / 3));
        this.ignoreAllButton = new WbButton(ResourceMgr.getString("LblIgnoreAllErr"));
        this.ignoreAllButton.addActionListener(this);
        this.buttonPanel.add(this.ignoreAllButton);
        this.buttonPanel.add(Box.createHorizontalStrut(n / 3));
        this.cancelButton = new WbButton(ResourceMgr.getString("LblStopScript"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        jPanel.add((Component)this.buttonPanel, "Center");
        return jPanel;
    }

    @Override
    protected JLabel getLabel() {
        return new JLabel(ResourceMgr.getString("MsgExecuteError"));
    }

    private void showSelectHint() {
        JLabel jLabel = new JLabel("<html>Query results will <b>not</b> be displayed!</html>");
        jLabel.setBorder(new EmptyBorder(0, 0, 0, IconMgr.getInstance().getSizeForLabel() / 3));
        this.buttonPanel.add((Component)jLabel, 0);
    }

    @Override
    protected void scriptSuccess() {
        super.scriptSuccess();
        this.closeDialog(1042);
    }

    public boolean shouldReplaceOriginalStatement() {
        return this.replaceStatement.isSelected();
    }

    @Override
    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.cancelButton.setEnabled(bl);
        this.retryButton.setEnabled(bl);
        this.ignoreAllButton.setEnabled(bl);
        this.ignoreOneButton.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.cancelButton) {
            this.closeDialog(2);
        }
        if (actionEvent.getSource() == this.retryButton) {
            this.startSQL();
        }
        if (actionEvent.getSource() == this.ignoreAllButton) {
            this.closeDialog(2042);
        }
        if (actionEvent.getSource() == this.ignoreOneButton) {
            this.closeDialog(3042);
        }
    }

    @Override
    protected String getWindowSettingsKey() {
        return "workbench.gui.sql.retrywindow";
    }

    @Override
    protected void saveSettings() {
        super.saveSettings();
        if (this.enableReplace) {
            Settings.getInstance().setProperty(PROP_REPLACE_ERROR_STATEMENT, this.shouldReplaceOriginalStatement());
        }
    }

    public void showDialog(Window window) {
        super.showDialog(window, ResourceMgr.getString("TxtWindowTitleErrorRetry"), true);
    }

    @Override
    public void showDialog(Window window, String string, boolean bl) {
        super.showDialog(window, string, bl);
    }
}

