/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import workbench.WbManager;
import workbench.console.DataStorePrinter;
import workbench.console.ResultSetPrinter;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionMgr;
import workbench.db.DbSettings;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.TransactionChecker;
import workbench.db.WbConnection;
import workbench.db.exporter.DataExporter;
import workbench.db.importer.DataStoreImporter;
import workbench.db.importer.DefaultImportOptions;
import workbench.db.importer.DefaultTextImportOptions;
import workbench.db.importer.ImportOptions;
import workbench.db.importer.TextImportOptions;
import workbench.gui.ErrorContinueDialog;
import workbench.gui.MainWindow;
import workbench.gui.PanelReloader;
import workbench.gui.WbSwingUtilities;
import workbench.gui.WindowTitleBuilder;
import workbench.gui.actions.AppendResultsAction;
import workbench.gui.actions.AutoCompletionAction;
import workbench.gui.actions.AutoJumpNextStatement;
import workbench.gui.actions.CheckPreparedStatementsAction;
import workbench.gui.actions.CleanJavaCodeAction;
import workbench.gui.actions.ClearCompletionCacheAction;
import workbench.gui.actions.ClearMessagesAction;
import workbench.gui.actions.CloseAllResultsAction;
import workbench.gui.actions.CloseResultTabAction;
import workbench.gui.actions.CommitAction;
import workbench.gui.actions.ConsolidateLogAction;
import workbench.gui.actions.CopyAsDbUnitXMLAction;
import workbench.gui.actions.CopyAsSqlDeleteAction;
import workbench.gui.actions.CopyAsSqlDeleteInsertAction;
import workbench.gui.actions.CopyAsSqlInsertAction;
import workbench.gui.actions.CopyAsSqlMergeAction;
import workbench.gui.actions.CopyAsSqlUpdateAction;
import workbench.gui.actions.CopyAsTextAction;
import workbench.gui.actions.CopyCurrentStatementAction;
import workbench.gui.actions.CopyRowAction;
import workbench.gui.actions.CreateDeleteScriptAction;
import workbench.gui.actions.CreateSnippetAction;
import workbench.gui.actions.DeleteDependentRowsAction;
import workbench.gui.actions.DeleteRowAction;
import workbench.gui.actions.DisplayDataFormAction;
import workbench.gui.actions.ExecuteAllAction;
import workbench.gui.actions.ExecuteCurrentAction;
import workbench.gui.actions.ExecuteFromCursorAction;
import workbench.gui.actions.ExecuteSelAction;
import workbench.gui.actions.ExecuteUpToCursorAction;
import workbench.gui.actions.ExpandEditorAction;
import workbench.gui.actions.ExpandResultAction;
import workbench.gui.actions.FileDiscardAction;
import workbench.gui.actions.FilterDataAction;
import workbench.gui.actions.FilterPickerAction;
import workbench.gui.actions.FindAction;
import workbench.gui.actions.FindDataAction;
import workbench.gui.actions.FindDataAgainAction;
import workbench.gui.actions.FormatSqlAction;
import workbench.gui.actions.HighlightCurrentStatement;
import workbench.gui.actions.HighlightErrorLineAction;
import workbench.gui.actions.IgnoreErrorsAction;
import workbench.gui.actions.ImportClipboardAction;
import workbench.gui.actions.ImportFileAction;
import workbench.gui.actions.InsertRowAction;
import workbench.gui.actions.JoinCompletionAction;
import workbench.gui.actions.JumpToNextStatement;
import workbench.gui.actions.JumpToPrevStatement;
import workbench.gui.actions.JumpToStatement;
import workbench.gui.actions.MakeInListAction;
import workbench.gui.actions.MakeLowerCaseAction;
import workbench.gui.actions.MakeUpperCaseAction;
import workbench.gui.actions.MakeValuesListAction;
import workbench.gui.actions.NextResultAction;
import workbench.gui.actions.OptimizeAllColumnsAction;
import workbench.gui.actions.OptimizeRowHeightAction;
import workbench.gui.actions.PrintAction;
import workbench.gui.actions.PrintPreviewAction;
import workbench.gui.actions.ReplaceDataAction;
import workbench.gui.actions.ResetFilterAction;
import workbench.gui.actions.ResetHighlightAction;
import workbench.gui.actions.RollbackAction;
import workbench.gui.actions.SaveDataAsAction;
import workbench.gui.actions.SelectEditorAction;
import workbench.gui.actions.SelectKeyColumnsAction;
import workbench.gui.actions.SelectMaxRowsAction;
import workbench.gui.actions.SelectResultAction;
import workbench.gui.actions.SelectionFilterAction;
import workbench.gui.actions.ShowObjectInfoAction;
import workbench.gui.actions.SpoolDataAction;
import workbench.gui.actions.SqlPanelReloadAction;
import workbench.gui.actions.StopAction;
import workbench.gui.actions.ToggleAutoCommitAction;
import workbench.gui.actions.ToggleCmdModeAction;
import workbench.gui.actions.ToggleSelectionHighlightAction;
import workbench.gui.actions.UndoExpandAction;
import workbench.gui.actions.UpdateDatabaseAction;
import workbench.gui.actions.ViewMessageLogAction;
import workbench.gui.actions.WbAction;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.gui.components.ConnectionInfo;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.DbUnitHelper;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.EtchedBorderTop;
import workbench.gui.components.GenericRowMonitor;
import workbench.gui.components.TabCloser;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.FindObjectAction;
import workbench.gui.dbobjects.objecttree.ObjectFinder;
import workbench.gui.dbobjects.objecttree.ResultTabDropHandler;
import workbench.gui.dialogs.dataimport.ImportFileDialog;
import workbench.gui.dialogs.export.ExportFileDialog;
import workbench.gui.editor.InsertTipProvider;
import workbench.gui.editor.actions.IndentSelection;
import workbench.gui.editor.actions.ShowTipAction;
import workbench.gui.editor.actions.UnIndentSelection;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.gui.macros.MacroClient;
import workbench.gui.menu.TextPopup;
import workbench.gui.preparedstatement.ParameterEditor;
import workbench.gui.sql.AutomaticRefreshMgr;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.DwStatusBar;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.ErrorRetryPanel;
import workbench.gui.sql.Highlighter;
import workbench.gui.sql.IconHandler;
import workbench.gui.sql.ImportStringVerifier;
import workbench.gui.sql.LogArea;
import workbench.gui.sql.PanelTitleSetter;
import workbench.gui.sql.PanelWorkspaceHandler;
import workbench.gui.sql.ResultCloseFilter;
import workbench.gui.sql.ResultTabHandler;
import workbench.gui.sql.RunType;
import workbench.gui.sql.SplitPaneExpander;
import workbench.gui.sql.SqlHistory;
import workbench.gui.sql.TableAnnotationProcessor;
import workbench.gui.sql.VariablesEditor;
import workbench.gui.toolbar.MainToolbar;
import workbench.gui.toolbar.ToolbarBuilder;
import workbench.interfaces.Commitable;
import workbench.interfaces.Connectable;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.DbExecutionNotifier;
import workbench.interfaces.DbUpdater;
import workbench.interfaces.Disposable;
import workbench.interfaces.ExecutionController;
import workbench.interfaces.Exporter;
import workbench.interfaces.FilenameChangeListener;
import workbench.interfaces.Interruptable;
import workbench.interfaces.JobErrorHandler;
import workbench.interfaces.MainPanel;
import workbench.interfaces.Moveable;
import workbench.interfaces.ParameterPrompter;
import workbench.interfaces.ResultLogger;
import workbench.interfaces.ResultReceiver;
import workbench.interfaces.ScriptErrorHandler;
import workbench.interfaces.StatusBar;
import workbench.interfaces.ToolWindow;
import workbench.interfaces.ToolWindowManager;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.AutoFileSaveType;
import workbench.resource.ErrorPromptType;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.ErrorDescriptor;
import workbench.sql.OutputPrinter;
import workbench.sql.StatementHistory;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.sql.VariablePool;
import workbench.sql.annotations.AppendResultAnnotation;
import workbench.sql.annotations.BookmarkAnnotation;
import workbench.sql.annotations.ResultAsTextAnnotation;
import workbench.sql.annotations.ResultAsTextMode;
import workbench.sql.annotations.UseTabAnnotation;
import workbench.sql.annotations.WbAnnotation;
import workbench.sql.macros.MacroManager;
import workbench.sql.parser.ParserType;
import workbench.sql.parser.ScriptParser;
import workbench.sql.preparedstatement.PreparedStatementPool;
import workbench.sql.preparedstatement.StatementParameters;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.DurationFormat;
import workbench.util.DurationFormatter;
import workbench.util.ExceptionUtil;
import workbench.util.HtmlUtil;
import workbench.util.LowMemoryException;
import workbench.util.MemoryWatcher;
import workbench.util.MessageBuffer;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class SqlPanel
extends JPanel
implements PropertyChangeListener,
ChangeListener,
MainPanel,
Exporter,
DbUpdater,
Interruptable,
Commitable,
JobErrorHandler,
ExecutionController,
ResultLogger,
ParameterPrompter,
DbExecutionNotifier,
FilenameChangeListener,
ResultReceiver,
MacroClient,
Moveable,
TabCloser,
StatusBar,
ToolWindowManager,
OutputPrinter,
PanelReloader,
ScriptErrorHandler {
    protected EditorPanel editor;
    protected DwPanel currentData;
    protected SqlHistory sqlHistory;
    protected StatementHistory historyStatements;
    protected LogArea log;
    protected WbTabbedPane resultTab;
    protected WbSplitPane contentPanel;
    protected boolean threadBusy;
    protected volatile boolean cancelExecution;
    private final List<Object> actions = new ArrayList<Object>(50);
    private final List<FilenameChangeListener> filenameChangeListeners = new ArrayList<FilenameChangeListener>();
    protected StopAction stopAction;
    protected ExecuteAllAction executeAll;
    protected ExecuteCurrentAction executeCurrent;
    protected ExecuteFromCursorAction executeFromCurrent;
    protected ExecuteUpToCursorAction executeToCursor;
    protected ExecuteSelAction executeSelected;
    private static int instanceCount = 0;
    private final int internalId;
    protected CopyAsTextAction dataToClipboard;
    protected SaveDataAsAction exportDataAction;
    protected CopyAsDbUnitXMLAction copyAsDBUnitXML;
    protected CopyAsSqlInsertAction copyAsSqlInsert;
    protected CopyAsSqlUpdateAction copyAsSqlUpdate;
    protected CopyAsSqlDeleteInsertAction copyAsSqlDeleteInsert;
    protected CopyAsSqlDeleteAction copyAsSqlDelete;
    protected CopyAsSqlMergeAction copyAsSqlMerge;
    protected CreateDeleteScriptAction createDeleteScript;
    protected ImportFileAction importFileAction;
    protected ImportClipboardAction importClipAction;
    protected PrintAction printDataAction;
    protected PrintPreviewAction printPreviewAction;
    protected UpdateDatabaseAction updateAction;
    protected InsertRowAction insertRow;
    protected CopyRowAction duplicateRow;
    protected DeleteRowAction deleteRow;
    protected DeleteDependentRowsAction deleteDependentRow;
    protected SelectKeyColumnsAction selectKeys;
    protected DisplayDataFormAction showFormAction;
    protected FilterDataAction filterAction;
    protected SelectionFilterAction selectionFilterAction;
    protected FilterPickerAction filterPicker;
    protected ResetFilterAction resetFilterAction;
    protected OptimizeAllColumnsAction optimizeAllCol;
    protected OptimizeRowHeightAction optimizeRowHeights;
    protected AppendResultsAction appendResultsAction;
    protected CloseResultTabAction closeResultAction;
    protected CloseAllResultsAction closeAllResultsAction;
    protected ClearCompletionCacheAction clearCompletionCache;
    protected AutoCompletionAction autoCompletion;
    protected SqlPanelReloadAction reloadAction;
    protected ShowObjectInfoAction showObjectInfoAction;
    protected JoinCompletionAction joinCompletion;
    protected CopyCurrentStatementAction copyStatementAction;
    protected IgnoreErrorsAction ignoreErrors;
    protected WbMenu copyAsSQLMenu;
    protected WbMenu copySelectedMenu;
    protected ToggleAutoCommitAction toggleAutoCommit;
    protected ToggleSelectionHighlightAction toggleSelectionHilite;
    protected CommitAction commitAction;
    protected RollbackAction rollbackAction;
    protected FormatSqlAction formatSql;
    protected SpoolDataAction spoolData;
    protected FileDiscardAction fileDiscardAction;
    protected FindDataAction findDataAction;
    protected FindDataAgainAction findDataAgainAction;
    protected ReplaceDataAction replaceDataAction;
    protected ResetHighlightAction resetHighlightAction;
    protected FindObjectAction findInDbTree;
    protected MainToolbar toolbar;
    protected WbConnection dbConnection;
    protected boolean importRunning;
    protected boolean updateRunning;
    protected String tabName;
    private final List<DbExecutionListener> execListener = Collections.synchronizedList(new ArrayList());
    protected Thread executionThread;
    protected Interruptable worker;
    private boolean appendResults;
    protected DwStatusBar statusBar;
    protected StatementRunner stmtRunner;
    protected GenericRowMonitor rowMonitor;
    protected IconHandler iconHandler;
    private boolean locked;
    private boolean ignoreStateChange;
    private boolean cmdMode;
    private boolean cmdModeForScript;
    private long lastScriptExecTime;
    protected final List<ToolWindow> resultWindows = new ArrayList<ToolWindow>(1);
    private final int macroClientId;
    private final AutomaticRefreshMgr refreshMgr;
    private final Highlighter highlighter;
    private ResultTabDropHandler tabDropHandler;
    private boolean macroExecution = false;
    private final Object toolbarLock = new Object();
    private boolean executeAllStatements = true;
    private boolean cancelAll = false;
    private boolean checkPrepared;
    private boolean hasMoved;

    public SqlPanel(int n) {
        super(new BorderLayout());
        this.internalId = ++instanceCount;
        this.setDoubleBuffered(true);
        this.refreshMgr = new AutomaticRefreshMgr();
        this.macroClientId = n;
        this.setName("sqlpanel-" + this.internalId);
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.editor = EditorPanel.createSqlEditor();
        this.highlighter = new Highlighter(this.editor);
        this.statusBar = new DwStatusBar(true, true);
        int n2 = GuiSettings.getDefaultMaxRows();
        if (n2 > 0) {
            this.statusBar.setMaxRows(n2);
        }
        this.editor.setStatusBar(this.statusBar);
        this.editor.setBorder(new EtchedBorderTop());
        if (GuiSettings.getShowTextSelectionSummary()) {
            this.statusBar.addTextSelectionDisplay(this.editor);
        }
        this.editor.setName("sqleditor" + this.internalId);
        this.log = new LogArea(this);
        this.log.setName("msg" + this.internalId);
        this.resultTab = new WbTabbedPane();
        this.resultTab.setTabPlacement(1);
        this.resultTab.setFocusable(false);
        this.resultTab.enableDragDropReordering(this);
        this.resultTab.hideDisabledButtons(true);
        this.resultTab.setName("resultspane");
        WbScrollPane wbScrollPane = new WbScrollPane(this.log);
        this.resultTab.addTab(ResourceMgr.getString("LblTabMessages"), wbScrollPane);
        this.contentPanel = new WbSplitPane(0, this.editor, this.resultTab);
        this.contentPanel.setOneTouchExpandable(true);
        this.contentPanel.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.contentPanel.setDividerBorder(new DividerBorder(12, false));
        this.appendResults = GuiSettings.getDefaultAppendResults();
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)this.statusBar, "South");
        this.initStatementHistory();
        this.initActions();
        this.setupActionMap();
        this.rowMonitor = new GenericRowMonitor(this.statusBar);
        this.resultTab.addChangeListener(this);
        this.editor.addFilenameChangeListener(this);
        new ResultTabHandler(this.resultTab, this);
        this.iconHandler = new IconHandler(this);
        if (GuiSettings.getShowResultTabCloseButton()) {
            this.resultTab.showCloseButton(this);
        } else {
            this.resultTab.showCloseButton(null);
        }
        this.tabName = ResourceMgr.getDefaultTabLabel();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.toolbar.actions", "workbench.gui.display.resulttab.closebutton", "workbench.gui.text.selection.summary");
        this.editor.setMacroExpansionEnabled(true, this);
        this.editor.setBracketCompletionEnabled(true);
        this.historyStatements = new StatementHistory(Settings.getInstance().getMaxHistorySize());
        this.stmtRunner = new StatementRunner();
        this.stmtRunner.setMacroClientId(this.macroClientId);
        this.stmtRunner.setRowMonitor(this.rowMonitor);
        this.stmtRunner.setMessagePrinter(this);
        this.stmtRunner.setMessageLogger(this);
        this.stmtRunner.setRetryHandler(this);
        this.tabDropHandler = new ResultTabDropHandler(this, this.resultTab, this.log);
    }

    public boolean isCmdModeEnabled() {
        return this.cmdMode;
    }

    public void setCmdlineMode(boolean bl) {
        this.cmdMode = bl;
    }

    @Override
    public boolean supportsBookmarks() {
        return true;
    }

    @Override
    public List<NamedScriptLocation> getBookmarks() {
        if (this.editor == null) {
            return null;
        }
        String string = this.editor.getText();
        if (StringUtil.isEmptyString(string)) {
            return Collections.emptyList();
        }
        BookmarkAnnotation bookmarkAnnotation = new BookmarkAnnotation();
        ParserType parserType = ParserType.getTypeFromConnection(this.getConnection());
        List<NamedScriptLocation> list = bookmarkAnnotation.getBookmarks(string, this.getId(), parserType);
        for (NamedScriptLocation namedScriptLocation : list) {
            int n = this.editor.getLineOfOffset(namedScriptLocation.getOffset());
            namedScriptLocation.setLineNumber(n + 1);
        }
        return list;
    }

    @Override
    public boolean isModifiedAfter(long l) {
        return this.editor.isModifiedAfter(l);
    }

    @Override
    public void jumpToBookmark(NamedScriptLocation namedScriptLocation) {
        if (namedScriptLocation == null) {
            return;
        }
        int n = namedScriptLocation.getOffset();
        int n2 = this.editor.getLineOfOffset(n);
        int n3 = this.editor.getLineStartOffset(n2);
        EventQueue.invokeLater(() -> {
            this.editor.setCaretPosition(n3);
            this.editor.centerLine(n2);
            this.editor.requestFocusInWindow();
        });
    }

    @Override
    public void registerObjectFinder(ObjectFinder objectFinder) {
        this.findInDbTree.setFinder(objectFinder);
        if (objectFinder == null) {
            this.editor.removePopupMenuItem(this.findInDbTree);
        } else {
            this.editor.addPopupMenuItem(this.findInDbTree, false);
        }
    }

    public void setDividerLocation(int n) {
        if (this.contentPanel != null) {
            this.contentPanel.setDividerLocation(n);
        }
    }

    @Override
    public void setLocked(boolean bl) {
        if (bl == this.locked) {
            return;
        }
        this.locked = bl;
        EventQueue.invokeLater(() -> {
            this.updateTabTitle();
            Container container = this.getParent();
            if (container instanceof WbTabbedPane) {
                ((WbTabbedPane)container).setCloseButtonEnabled(this, !bl);
            }
        });
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public String getId() {
        return NumberStringCache.getNumberString(this.internalId);
    }

    @Override
    public void setConnectionClient(Connectable connectable) {
    }

    public boolean getAppendResults() {
        return this.appendResults;
    }

    public void setAppendResults(boolean bl) {
        this.appendResults = bl;
    }

    protected void updateAppendAction() {
        if (this.appendResultsAction != null) {
            this.appendResultsAction.setSwitchedOn(this.appendResults);
        }
    }

    public void initDivider(int n) {
        n = (int)((double)n - this.statusBar.getPreferredSize().getHeight() * 3.0);
        n -= this.editor.getHScrollBarHeight();
        n -= this.resultTab.getTabHeight();
        n -= this.contentPanel.getDividerSize();
        int n2 = (n -= 8) / 2;
        if (n2 <= 50) {
            n2 = -1;
        }
        this.contentPanel.setDividerLocation(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WbToolbar getToolbar(List<WbAction> list, boolean bl) {
        Object object = this.toolbarLock;
        synchronized (object) {
            if (this.toolbar == null || bl) {
                if (this.toolbar != null) {
                    this.toolbar.dispose();
                }
                ToolbarBuilder toolbarBuilder = new ToolbarBuilder(this.getAllActions(), list);
                this.toolbar = toolbarBuilder.createToolbar();
                this.updateConnectionInfo();
            }
            return this.toolbar;
        }
    }

    public List<WbAction> getAllActions() {
        ArrayList<WbAction> arrayList = new ArrayList<WbAction>(this.actions.size());
        for (Object object : this.actions) {
            if (object instanceof WbAction) {
                arrayList.add((WbAction)object);
                continue;
            }
            if (!(object instanceof WbMenu)) continue;
            WbMenu wbMenu = (WbMenu)object;
            arrayList.addAll(wbMenu.getAllActions());
        }
        arrayList.add(this.ignoreErrors);
        arrayList.add(this.filterPicker);
        arrayList.add(this.appendResultsAction);
        return arrayList;
    }

    public boolean readFile(String string, String string2) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        File file = new File(string);
        if (this.editor.readFile(file, string2)) {
            this.historyStatements.clear();
            this.selectEditor();
            bl = true;
        } else {
            this.iconHandler.removeIcon();
            bl = false;
        }
        return bl;
    }

    public boolean hasFileLoaded() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.hasFileLoaded();
    }

    public boolean checkAndSaveFile() {
        if (this.editor == null) {
            return true;
        }
        int n = this.editor.checkAndSaveFile();
        return n != 2;
    }

    public String getLogMessage() {
        return this.log.getText();
    }

    public EditorPanel getEditor() {
        return this.editor;
    }

    public void clearSqlHistory() {
        if (this.sqlHistory != null) {
            this.sqlHistory.clear();
        }
    }

    public boolean closeFile(boolean bl) {
        return this.closeFile(bl, true);
    }

    public boolean closeFile(boolean bl, boolean bl2) {
        boolean bl3;
        if (this.editor == null) {
            return true;
        }
        if (bl2 && !(bl3 = this.checkAndSaveFile())) {
            return false;
        }
        if (this.editor.closeFile(bl)) {
            this.selectEditorLater();
            this.clearSqlHistory();
            return true;
        }
        return false;
    }

    @Override
    public void fileNameChanged(Object object, String string) {
        if (object == this.editor) {
            boolean bl = this.editor.hasFileLoaded();
            this.fileDiscardAction.setEnabled(bl);
            if (bl) {
                this.tabName = null;
            }
            this.historyStatements.clear();
            this.fireFilenameChanged(string);
        }
    }

    private void fireFilenameChanged(String string) {
        this.updateTabTitle();
        for (FilenameChangeListener filenameChangeListener : this.filenameChangeListeners) {
            filenameChangeListener.fileNameChanged(this, string);
        }
    }

    public void addFilenameChangeListener(FilenameChangeListener filenameChangeListener) {
        if (filenameChangeListener == null) {
            return;
        }
        this.filenameChangeListeners.add(filenameChangeListener);
    }

    public void removeFilenameChangeListener(FilenameChangeListener filenameChangeListener) {
        if (filenameChangeListener == null) {
            return;
        }
        this.filenameChangeListeners.remove(filenameChangeListener);
    }

    private void initActions() {
        this.executeAll = new ExecuteAllAction(this);
        this.executeSelected = new ExecuteSelAction(this);
        this.executeCurrent = new ExecuteCurrentAction(this);
        this.executeFromCurrent = new ExecuteFromCursorAction(this);
        this.executeToCursor = new ExecuteUpToCursorAction(this);
        MakeLowerCaseAction makeLowerCaseAction = new MakeLowerCaseAction(this.editor);
        MakeUpperCaseAction makeUpperCaseAction = new MakeUpperCaseAction(this.editor);
        this.editor.showFindOnPopupMenu();
        this.editor.showFormatSql();
        this.editor.addPopupMenuItem(this.executeSelected, true);
        this.editor.addPopupMenuItem(this.executeAll, false);
        this.editor.addPopupMenuItem(this.executeCurrent, false);
        this.editor.addPopupMenuItem(this.executeFromCurrent, false);
        this.editor.addPopupMenuItem(this.executeToCursor, false);
        TextPopup textPopup = (TextPopup)this.editor.getRightClickPopup();
        this.actions.add(this.editor.getFileSaveAction());
        this.actions.add(this.editor.getFileSaveAsAction());
        this.actions.add(this.editor.getReloadAction());
        this.fileDiscardAction = new FileDiscardAction(this);
        this.actions.add(this.fileDiscardAction);
        this.actions.add(this.editor.getUndoAction());
        this.actions.add(this.editor.getRedoAction());
        WbAction wbAction = textPopup.getCutAction();
        wbAction.setCreateMenuSeparator(true);
        this.actions.add(wbAction);
        this.actions.add(textPopup.getCopyAction());
        this.actions.add(textPopup.getPasteAction());
        wbAction = textPopup.getClearAction();
        wbAction.setCreateMenuSeparator(true);
        this.actions.add(wbAction);
        this.actions.add(textPopup.getSelectAllAction());
        this.actions.add(this.editor.getColumnSelection());
        FindAction findAction = this.editor.getFindAction();
        findAction.setCreateMenuSeparator(true);
        this.actions.add(findAction);
        this.actions.add(this.editor.getFindNextAction());
        this.actions.add(this.editor.getFindPreviousAction());
        this.actions.add(this.editor.getReplaceAction());
        IndentSelection indentSelection = new IndentSelection(this.editor);
        indentSelection.setCreateMenuSeparator(true);
        this.actions.add(indentSelection);
        this.actions.add(new UnIndentSelection(this.editor));
        this.actions.add(makeLowerCaseAction);
        this.actions.add(makeUpperCaseAction);
        this.actions.add(this.editor.getToggleCommentAction());
        this.actions.add(this.editor.getCommentAction());
        this.actions.add(this.editor.getUnCommentAction());
        this.actions.add(this.editor.getMatchBracketAction());
        this.toggleSelectionHilite = new ToggleSelectionHighlightAction(this.editor);
        this.actions.add(this.toggleSelectionHilite);
        this.updateAction = new UpdateDatabaseAction(null);
        this.updateAction.setEnabled(GuiSettings.getAlwaysEnableSaveButton());
        this.insertRow = new InsertRowAction(null);
        this.deleteRow = new DeleteRowAction(null);
        this.deleteDependentRow = new DeleteDependentRowsAction(null);
        this.duplicateRow = new CopyRowAction(null);
        this.selectKeys = new SelectKeyColumnsAction(null);
        this.showFormAction = new DisplayDataFormAction(null);
        this.reloadAction = new SqlPanelReloadAction(this);
        this.showObjectInfoAction = new ShowObjectInfoAction(this);
        this.editor.addPopupMenuItem(this.showObjectInfoAction, true);
        this.actions.add(this.showFormAction);
        this.actions.add(this.selectKeys);
        this.actions.add(this.updateAction);
        this.actions.add(this.insertRow);
        this.actions.add(this.duplicateRow);
        this.actions.add(this.reloadAction);
        this.deleteRow.setCreateMenuSeparator(true);
        this.actions.add(this.deleteRow);
        this.actions.add(this.deleteDependentRow);
        this.createDeleteScript = new CreateDeleteScriptAction(null);
        this.actions.add(this.createDeleteScript);
        this.exportDataAction = new SaveDataAsAction(null);
        this.exportDataAction.setCreateMenuSeparator(true);
        this.exportDataAction.setEnabled(false);
        SelectEditorAction selectEditorAction = new SelectEditorAction(this);
        selectEditorAction.setCreateMenuSeparator(true);
        this.actions.add(selectEditorAction);
        this.actions.add(new SelectMaxRowsAction(this.statusBar));
        this.actions.add(new ClearMessagesAction(this));
        SelectResultAction selectResultAction = new SelectResultAction(this);
        selectResultAction.setCreateMenuSeparator(true);
        this.actions.add(selectResultAction);
        this.actions.add(new NextResultAction(this.resultTab));
        this.actions.add(new ViewMessageLogAction(this));
        SplitPaneExpander splitPaneExpander = this.contentPanel.getExpander();
        wbAction = new ExpandEditorAction(splitPaneExpander);
        wbAction.setCreateMenuSeparator(true);
        this.actions.add(wbAction);
        this.actions.add(new ExpandResultAction(splitPaneExpander));
        this.actions.add(new UndoExpandAction(splitPaneExpander));
        this.optimizeAllCol = new OptimizeAllColumnsAction(null);
        this.optimizeAllCol.setCreateMenuSeparator(true);
        this.optimizeAllCol.setEnabled(false);
        this.optimizeAllCol.removeIcon();
        this.optimizeAllCol.setMenuItemName("MnuTxtView");
        this.actions.add(this.optimizeAllCol);
        this.optimizeRowHeights = new OptimizeRowHeightAction();
        this.optimizeRowHeights.setCreateMenuSeparator(false);
        this.optimizeRowHeights.setEnabled(false);
        this.optimizeRowHeights.removeIcon();
        this.optimizeRowHeights.setMenuItemName("MnuTxtView");
        this.actions.add(this.optimizeRowHeights);
        this.dataToClipboard = new CopyAsTextAction(null);
        this.dataToClipboard.setEnabled(false);
        this.actions.add(this.exportDataAction);
        this.actions.add(this.dataToClipboard);
        this.copyAsSQLMenu = WbTable.createCopyAsSQLMenu();
        this.copyAsSQLMenu.setEnabled(false);
        if (DbUnitHelper.isDbUnitAvailable()) {
            this.copyAsDBUnitXML = new CopyAsDbUnitXMLAction(null);
            this.copyAsSQLMenu.add(this.copyAsDBUnitXML);
        }
        this.copyAsSqlInsert = new CopyAsSqlInsertAction(null);
        this.copyAsSQLMenu.add(this.copyAsSqlInsert);
        this.copyAsSqlUpdate = new CopyAsSqlUpdateAction(null);
        this.copyAsSQLMenu.add(this.copyAsSqlUpdate);
        this.copyAsSqlMerge = new CopyAsSqlMergeAction(null);
        this.copyAsSQLMenu.add(this.copyAsSqlMerge);
        this.copyAsSqlDeleteInsert = new CopyAsSqlDeleteInsertAction(null);
        this.copyAsSQLMenu.add(this.copyAsSqlDeleteInsert);
        this.copyAsSqlDelete = new CopyAsSqlDeleteAction(null);
        this.copyAsSQLMenu.add(this.copyAsSqlDelete);
        this.actions.add(this.copyAsSQLMenu);
        this.copySelectedMenu = WbTable.createCopySelectedMenu();
        this.copySelectedMenu.setEnabled(false);
        this.actions.add(this.copySelectedMenu);
        this.importFileAction = new ImportFileAction(this);
        this.importFileAction.setCreateMenuSeparator(true);
        this.actions.add(this.importFileAction);
        this.importClipAction = new ImportClipboardAction(this);
        this.actions.add(this.importClipAction);
        this.printDataAction = new PrintAction(null);
        this.printPreviewAction = new PrintPreviewAction(null);
        this.actions.add(this.executeAll);
        this.actions.add(this.executeSelected);
        this.actions.add(this.executeCurrent);
        this.actions.add(this.executeFromCurrent);
        this.actions.add(this.executeToCursor);
        this.spoolData = new SpoolDataAction(this, "MnuTxtSpoolSql");
        this.spoolData.setCreateMenuSeparator(true);
        this.spoolData.setEditor(this.editor);
        this.actions.add(this.spoolData);
        this.stopAction = new StopAction(this);
        this.stopAction.setEnabled(false);
        this.stopAction.setCreateMenuSeparator(false);
        this.actions.add(this.stopAction);
        this.commitAction = new CommitAction(this);
        this.commitAction.setCreateMenuSeparator(true);
        this.commitAction.setEnabled(false);
        this.actions.add(this.commitAction);
        this.rollbackAction = new RollbackAction(this);
        this.rollbackAction.setEnabled(false);
        this.actions.add(this.rollbackAction);
        this.toggleAutoCommit = new ToggleAutoCommitAction();
        this.actions.add(this.toggleAutoCommit);
        this.actions.add(this.sqlHistory.getShowFirstStatementAction());
        this.actions.add(this.sqlHistory.getShowPreviousStatementAction());
        this.actions.add(this.sqlHistory.getShowNextStatementAction());
        this.actions.add(this.sqlHistory.getShowLastStatementAction());
        this.actions.add(this.sqlHistory.getClearHistoryAction());
        JumpToNextStatement jumpToNextStatement = new JumpToNextStatement(this);
        jumpToNextStatement.setCreateMenuSeparator(true);
        this.actions.add(jumpToNextStatement);
        this.actions.add(new JumpToPrevStatement(this));
        this.actions.add(new JumpToStatement(this));
        this.actions.add(this.editor.getJumpToLineAction());
        this.filterAction = new FilterDataAction(null, FilterDefinitionManager.getDefaultInstance());
        this.selectionFilterAction = new SelectionFilterAction();
        this.filterPicker = new FilterPickerAction(null);
        this.filterAction.setCreateMenuSeparator(true);
        this.resetFilterAction = new ResetFilterAction(null);
        this.ignoreErrors = new IgnoreErrorsAction();
        this.appendResultsAction = new AppendResultsAction(this);
        this.appendResultsAction.setEnabled(false);
        this.findDataAction = new FindDataAction(null);
        this.findDataAction.setMenuTextByKey("MnuTxtFindData");
        this.findDataAction.setEnabled(false);
        this.findDataAction.setCreateMenuSeparator(true);
        this.findDataAgainAction = new FindDataAgainAction(null);
        this.findDataAgainAction.setMenuTextByKey("MnuTxtFindDataAgain");
        this.findDataAgainAction.setEnabled(false);
        this.replaceDataAction = new ReplaceDataAction(null);
        this.replaceDataAction.setEnabled(false);
        this.autoCompletion = new AutoCompletionAction(this.editor, this.statusBar);
        this.autoCompletion.setCreateMenuSeparator(true);
        this.actions.add(this.autoCompletion);
        this.joinCompletion = new JoinCompletionAction(this);
        this.actions.add(this.joinCompletion);
        ShowTipAction showTipAction = new ShowTipAction(this.editor, new InsertTipProvider(this));
        this.actions.add(showTipAction);
        this.clearCompletionCache = new ClearCompletionCacheAction();
        this.actions.add(this.clearCompletionCache);
        this.actions.add(this.showObjectInfoAction);
        this.formatSql = this.editor.getFormatSqlAction();
        this.formatSql.setCreateMenuSeparator(true);
        this.actions.add(this.formatSql);
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTxtSettings"));
        wbMenu.setParentMenuId("MnuTxtSQL");
        new AutoJumpNextStatement().addToMenu(wbMenu);
        this.appendResultsAction.addToMenu(wbMenu);
        new ToggleCmdModeAction(this).addToMenu(wbMenu);
        wbMenu.addSeparator();
        new HighlightCurrentStatement().addToMenu(wbMenu);
        new HighlightErrorLineAction().addToMenu(wbMenu);
        this.ignoreErrors.addToMenu(wbMenu);
        new ConsolidateLogAction().addToMenu(wbMenu);
        wbMenu.addSeparator();
        new CheckPreparedStatementsAction().addToMenu(wbMenu);
        WbMenu wbMenu2 = new WbMenu(ResourceMgr.getString("MnuTxtCodeTools"));
        wbMenu2.setParentMenuId("MnuTxtSQL");
        new CreateSnippetAction(this.editor).addToMenu(wbMenu2);
        new CleanJavaCodeAction(this.editor).addToMenu(wbMenu2);
        wbMenu2.addSeparator();
        new MakeInListAction(this.editor).addToMenu(wbMenu2);
        new MakeValuesListAction(this.editor).addToMenu(wbMenu2);
        wbMenu2.addSeparator();
        this.copyStatementAction = new CopyCurrentStatementAction(this.editor);
        this.copyStatementAction.addToMenu(wbMenu2);
        this.actions.add(wbMenu2);
        this.actions.add(wbMenu);
        this.findDataAction.setCreateMenuSeparator(true);
        this.resetHighlightAction = new ResetHighlightAction(null);
        this.actions.add(this.findDataAction);
        this.actions.add(this.findDataAgainAction);
        this.actions.add(this.replaceDataAction);
        this.actions.add(this.resetHighlightAction);
        this.actions.add(this.filterAction);
        this.actions.add(this.selectionFilterAction);
        this.actions.add(this.resetFilterAction);
        this.closeResultAction = new CloseResultTabAction(this);
        this.closeResultAction.setCreateMenuSeparator(true);
        this.actions.add(this.closeResultAction);
        this.closeAllResultsAction = new CloseAllResultsAction(this);
        this.closeAllResultsAction.setCreateMenuSeparator(false);
        this.actions.add(this.closeAllResultsAction);
        this.printDataAction.setCreateMenuSeparator(true);
        this.actions.add(this.printDataAction);
        this.actions.add(this.printPreviewAction);
        this.editor.addKeyBinding(showTipAction);
        this.findInDbTree = new FindObjectAction(this.editor);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.autoCompletion.closePopup();
        }
    }

    protected boolean isResultLocked(int n) {
        DwPanel dwPanel = (DwPanel)this.resultTab.getComponentAt(n);
        return dwPanel.isLocked();
    }

    protected boolean isResultModified(int n) {
        DwPanel dwPanel = (DwPanel)this.resultTab.getComponentAt(n);
        return dwPanel.isModified();
    }

    protected int getFirstModified() {
        if (this.currentData == null) {
            return -1;
        }
        if (this.resultTab.getTabCount() == 1) {
            return -1;
        }
        for (int i = 0; i < this.resultTab.getTabCount() - 1; ++i) {
            DwPanel dwPanel = (DwPanel)this.resultTab.getComponentAt(i);
            if (!dwPanel.isModified()) continue;
            return i;
        }
        return -1;
    }

    protected boolean isDataModified() {
        return this.getFirstModified() != -1;
    }

    @Override
    public boolean isModified() {
        if (this.isDataModified()) {
            return true;
        }
        if (!this.editor.hasFileLoaded()) {
            return false;
        }
        return this.editor.isModified();
    }

    private void setupActionMap() {
        ComponentInputMap componentInputMap = new ComponentInputMap(this);
        ActionMap actionMap = new ActionMap();
        this.setInputMap(1, componentInputMap);
        this.setActionMap(actionMap);
        for (Object object : this.actions) {
            if (!(object instanceof WbAction)) continue;
            WbAction wbAction = (WbAction)object;
            wbAction.addToInputMap(componentInputMap, actionMap);
        }
        this.editor.getInputMap().setParent(componentInputMap);
        this.editor.getActionMap().setParent(actionMap);
    }

    public void selectEditorLater() {
        EventQueue.invokeLater(this::_selectEditor);
    }

    public void selectEditor() {
        WbSwingUtilities.invoke(this::_selectEditor);
    }

    protected void _selectEditor() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return;
        }
        if (window.isActive() && window.isVisible() && window.isFocused() && this.isCurrentTab() && this.editor != null) {
            this.editor.requestFocusInWindow();
        }
    }

    public void requestEditorFocus() {
        if (this.editor != null) {
            this.editor.requestFocus();
            this.editor.requestFocusInWindow();
        }
    }

    @Override
    public String getText() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getText();
    }

    @Override
    public String getSelectedText() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getSelectedText();
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public String getStatementAtCursor() {
        ScriptParser scriptParser = ScriptParser.createScriptParser(this.dbConnection);
        scriptParser.setScript(this.getEditor().getText());
        int n = scriptParser.getCommandIndexAtCursorPos(this.getEditor().getCaretPosition());
        String string = scriptParser.getCommand(n);
        return string;
    }

    private boolean isCurrentTab() {
        JTabbedPane jTabbedPane = null;
        Container container = this.getParent();
        if (container instanceof JTabbedPane) {
            jTabbedPane = (JTabbedPane)container;
        }
        if (jTabbedPane == null) {
            return false;
        }
        return jTabbedPane.getSelectedComponent() == this;
    }

    public void selectResult() {
        if (this.isVisible() && this.isCurrentTab()) {
            this.showResultPanel();
            EventQueue.invokeLater(() -> {
                if (this.currentData != null) {
                    this.currentData.getTable().requestFocusInWindow();
                }
            });
        }
    }

    @Override
    public void saveChangesToDatabase(boolean bl) {
        if (this.currentData == null) {
            IllegalStateException illegalStateException = new IllegalStateException("No data panel!");
            LogMgr.logError(new CallerInfo(){}, "Save called without a current DwPanel!", illegalStateException);
            return;
        }
        if (!this.currentData.prepareDatabaseUpdate(bl)) {
            return;
        }
        this.setBusy(true);
        this.setCancelState(true);
        this.setConnActionsState(false);
        WbThread wbThread = new WbThread("Workbench DB Update Thread"){

            @Override
            public void run() {
                SqlPanel.this.updateDb();
            }
        };
        wbThread.start();
    }

    public void updateDb() {
        try {
            this.fireDbExecStart();
            this.updateRunning = true;
            this.setLogText(ResourceMgr.getString("MsgUpdatingDatabase") + "\n");
            this.currentData.saveChanges(this.dbConnection, this);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setLogText(ExceptionUtil.getDisplay(outOfMemoryError));
            this.iconHandler.showBusyIcon(false);
            EventQueue.invokeLater(() -> WbSwingUtilities.showErrorMessageKey(this, "MsgOutOfMemoryError"));
        }
        catch (Exception exception) {
            this.setLogText(ExceptionUtil.getDisplay(exception));
            LogMgr.logError(new CallerInfo(){}, "Error during update", exception);
        }
        finally {
            this.updateRunning = false;
            this.setCancelState(false);
            this.setBusy(false);
            this.fireDbExecEnd();
            WbSwingUtilities.showDefaultCursor(this);
        }
        this.checkResultSetActions();
    }

    @Override
    public void panelSelected() {
        this.selectEditorLater();
    }

    @Override
    public List<Object> getMenuItems() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public void showLogMessage(CharSequence charSequence) {
        this.showLogPanel();
        if (charSequence != null) {
            this.setLogText(charSequence.toString());
        }
    }

    @Override
    public void clearLog() {
        this.setLogText("");
    }

    protected void setLogText(String string) {
        WbSwingUtilities.invoke(() -> this.log.setText(string));
    }

    @Override
    public void showLogPanel() {
        WbSwingUtilities.invoke(() -> {
            int n = this.resultTab.getTabCount() - 1;
            this.resultTab.setSelectedIndex(n);
        });
    }

    @Override
    public void showResultPanel() {
        this.showResultPanel(0);
    }

    public void showResultPanel(int n) {
        if (n < 0 || n > this.resultTab.getTabCount() - 1) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            this.resultTab.setSelectedIndex(n);
            Component component = this.resultTab.getComponentAt(n);
            WbSwingUtilities.requestFocus((JComponent)component);
        });
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public void setStatusMessage(String string) {
        this.statusBar.setStatusMessage(string);
    }

    @Override
    public void setStatusMessage(String string, int n) {
        this.statusBar.setStatusMessage(string, n);
    }

    @Override
    public void doRepaint() {
        this.statusBar.doRepaint();
    }

    @Override
    public void clearStatusMessage() {
        this.statusBar.clearStatusMessage();
    }

    public final void initStatementHistory() {
        int n = Settings.getInstance().getMaxHistorySize();
        this.sqlHistory = new SqlHistory(this.editor, n);
    }

    @Override
    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) throws IOException {
        long l = System.currentTimeMillis();
        PanelWorkspaceHandler panelWorkspaceHandler = new PanelWorkspaceHandler(this);
        panelWorkspaceHandler.readFromWorkspace(wbWorkspace, n);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Restoring panel " + (n + 1) + " from workspace " + wbWorkspace.getFilename() + " took " + l2 + "ms");
    }

    private boolean confirmDiscardChanges(int n, boolean bl) {
        boolean bl2;
        if (!GuiSettings.getConfirmDiscardResultSetChanges()) {
            return true;
        }
        if (n >= this.resultTab.getTabCount() - 1) {
            return false;
        }
        boolean bl3 = bl2 = n == -1 ? this.isDataModified() : this.isResultModified(n);
        if (!bl2) {
            return true;
        }
        String string = null;
        if (bl) {
            if (n == -1) {
                n = this.getFirstModified();
            }
            string = this.resultTab.getTitleAt(n);
        } else {
            string = this.getRealTabTitle();
        }
        return WbSwingUtilities.getProceedCancel(this, "MsgDiscardTabChanges", HtmlUtil.cleanHTML(string));
    }

    private boolean confirmDiscardTransaction() {
        WbConnection wbConnection = this.getConnection();
        if (wbConnection == null) {
            return true;
        }
        if (wbConnection.isClosed()) {
            return true;
        }
        if (wbConnection.isBusy()) {
            return true;
        }
        TransactionChecker transactionChecker = wbConnection.getTransactionChecker();
        if (transactionChecker.hasUncommittedChanges(wbConnection)) {
            String string = null;
            string = wbConnection.getProfile().getUseSeparateConnectionPerTab() ? this.getRealTabTitle() : wbConnection.getProfile().getName();
            return WbSwingUtilities.getProceedCancel(this, "MsgDiscardOpenTrans", HtmlUtil.cleanHTML(string));
        }
        return true;
    }

    @Override
    public boolean canClosePanel(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.checkAndSaveFile() && this.confirmDiscardChanges(-1, false);
        if (bl) {
            bl2 = bl2 && this.confirmDiscardTransaction();
        }
        return bl2;
    }

    @Override
    public void storeInWorkspace(WbWorkspace wbWorkspace, int n) {
        PanelWorkspaceHandler panelWorkspaceHandler = new PanelWorkspaceHandler(this);
        panelWorkspaceHandler.saveToWorkspace(wbWorkspace, n);
    }

    public SqlHistory getHistory() {
        return this.sqlHistory;
    }

    public String getRealTabTitle() {
        JTabbedPane jTabbedPane;
        int n;
        if (this.getParent() instanceof JTabbedPane && (n = (jTabbedPane = (JTabbedPane)this.getParent()).indexOfComponent(this)) > -1) {
            String string = jTabbedPane.getTitleAt(n);
            return string;
        }
        return this.getTabTitle();
    }

    @Override
    public String getTitle() {
        return this.getTabTitle();
    }

    @Override
    public String getTabTitle() {
        String string = ResourceMgr.getDefaultTabLabel();
        String string2 = this.getCurrentFileName();
        if (string2 != null) {
            File file = new File(string2);
            String string3 = this.getTabName();
            string2 = string3 == null || string3.startsWith(string) ? file.getName() : "[" + string3 + "]";
        } else {
            string2 = this.getTabName();
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    private void updateLockedTitle(DwPanel dwPanel) {
        int n = this.resultTab.indexOfComponent(dwPanel);
        if (n < 0) {
            return;
        }
        String string = this.resultTab.getTitleAt(n);
        if (dwPanel.isLocked()) {
            this.resultTab.setTitleAt(n, "<html><i>" + string + "</i></html>");
        } else {
            this.resultTab.setTitleAt(n, HtmlUtil.cleanHTML(string));
        }
    }

    public boolean toggleLockedResult() {
        DwPanel dwPanel = this.getCurrentResult();
        if (dwPanel == null) {
            return false;
        }
        dwPanel.setLocked(!dwPanel.isLocked());
        this.updateLockedTitle(dwPanel);
        return dwPanel.isLocked();
    }

    protected void updateTabTitle() {
        PanelTitleSetter.updateTitle(this);
    }

    @Override
    public void setTabTitle(JTabbedPane jTabbedPane, int n) {
        String string = null;
        String string2 = null;
        if (!this.isBusy()) {
            string = this.getCurrentFileName();
            if (string != null) {
                File file = new File(string);
                string2 = file.getAbsolutePath();
                if (this.editor != null) {
                    string2 = string2 + " (" + this.editor.getCurrentFileEncoding() + ")";
                }
                this.iconHandler.showIconForTab(this.iconHandler.getFileIcon());
            } else {
                this.iconHandler.removeIcon();
            }
        }
        PanelTitleSetter.setTabTitle(jTabbedPane, this, n, this.getTabTitle());
        jTabbedPane.setToolTipTextAt(n, string2);
    }

    public String getTabName() {
        return this.tabName;
    }

    @Override
    public void setTabName(String string) {
        this.tabName = StringUtil.isBlank(string) ? null : string;
        this.fireFilenameChanged(string);
    }

    public String getCurrentFileName() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getCurrentFileName();
    }

    public void appendStatementText(String string) {
        this.editor.appendLine("\n");
        int n = this.editor.getText().length();
        this.editor.appendLine(string);
        this.editor.setCaretPosition(n);
        this.editor.scrollToCaret();
    }

    public void setStatementText(String string) {
        this.storeStatementInHistory();
        if (this.editor.getCurrentFile() != null) {
            this.editor.saveCurrentFile();
        }
        this.editor.closeFile(true);
        this.editor.setText(string);
        this.editor.setCaretPosition(0);
        this.editor.scrollToCaret();
    }

    public void addStatement(String string) {
        this.editor.insertText("\n");
        this.editor.insertText(string);
        this.editor.scrollToCaret();
    }

    @Override
    public String toString() {
        return this.getTabTitle();
    }

    @Override
    public void disconnect() {
        if (this.dbConnection != null) {
            this.setConnection(null);
        }
        if (this.currentData != null) {
            this.currentData.endEdit();
        }
        this.clearResultTabs(false);
        for (ToolWindow toolWindow : this.resultWindows) {
            toolWindow.disconnect();
        }
        this.setLogText("");
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    @Override
    public boolean isConnected() {
        return this.dbConnection != null;
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        if (this.dbConnection != null) {
            this.dbConnection.removeChangeListener(this);
        }
        this.dbConnection = wbConnection;
        this.toggleAutoCommit.setConnection(this.dbConnection);
        if (this.clearCompletionCache != null) {
            this.clearCompletionCache.setConnection(this.dbConnection);
        }
        if (this.autoCompletion != null) {
            this.autoCompletion.setConnection(this.dbConnection);
        }
        if (this.showObjectInfoAction != null) {
            this.showObjectInfoAction.checkEnabled();
        }
        if (this.findInDbTree != null) {
            this.findInDbTree.setEditorConnection(this.dbConnection);
        }
        if (this.stmtRunner != null) {
            this.stmtRunner.setConnection(wbConnection);
            this.stmtRunner.setMessageLogger(this);
            this.stmtRunner.setHistoryProvider(this.historyStatements);
        }
        if (this.editor != null) {
            this.editor.setDatabaseConnection(this.dbConnection);
        }
        if (this.copyStatementAction != null) {
            this.copyStatementAction.setConnection(this.dbConnection);
        }
        this.setExecActionsState(this.dbConnection != null);
        this.setConnActionsState(this.dbConnection != null);
        this.checkResultSetActions();
        if (this.dbConnection != null) {
            this.dbConnection.addChangeListener(this);
        }
        this.updateConnectionInfo();
    }

    private void updateConnectionInfo() {
        final CallerInfo callerInfo = new CallerInfo(){};
        WbThread wbThread = new WbThread("Update connection info " + this.getId()){

            @Override
            public void run() {
                try {
                    if (SqlPanel.this.toolbar != null) {
                        SqlPanel.this.toolbar.setConnection(SqlPanel.this.dbConnection);
                    }
                    if (SqlPanel.this.doRollbackOnSetConnection()) {
                        LogMgr.logDebug(callerInfo, "Sending a rollback to end the current transaction");
                        SqlPanel.this.dbConnection.rollbackSilently(callerInfo);
                    }
                    SqlPanel.this.setConnActionsState(SqlPanel.this.dbConnection != null);
                }
                catch (Throwable throwable) {
                    SqlPanel.this.setConnActionsState(SqlPanel.this.dbConnection != null);
                    throw throwable;
                }
            }
        };
        wbThread.start();
    }

    private boolean doRollbackOnSetConnection() {
        if (this.dbConnection == null) {
            return false;
        }
        if (this.dbConnection.getAutoCommit()) {
            return false;
        }
        if (this.dbConnection.isBusy()) {
            return false;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings != null && !dbSettings.endTransactionAfterConnect()) {
            return false;
        }
        if (!this.dbConnection.isShared()) {
            return true;
        }
        return this.isCurrentTab();
    }

    protected void checkCommitAction() {
        EventQueue.invokeLater(() -> {
            if (this.dbConnection != null) {
                boolean bl = this.dbConnection.getAutoCommit();
                this.commitAction.setEnabled(!bl);
                this.rollbackAction.setEnabled(!bl);
            } else {
                this.commitAction.setEnabled(false);
                this.rollbackAction.setEnabled(false);
            }
        });
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void storeStatementInHistory() {
        this.sqlHistory.addContent(this.editor);
    }

    public void cancelUpdate() {
        if (this.currentData == null) {
            return;
        }
        WbTable wbTable = this.currentData.getTable();
        if (wbTable != null) {
            DataStoreTableModel dataStoreTableModel = (DataStoreTableModel)wbTable.getModel();
            if (dataStoreTableModel == null) {
                return;
            }
            DataStore dataStore = wbTable.getDataStore();
            if (dataStore == null) {
                return;
            }
            dataStore.cancelUpdate();
            if (!this.dbConnection.getAutoCommit()) {
                String string = ResourceMgr.getString("MsgCommitPartialUpdate");
                WbSwingUtilities.TransactionEnd transactionEnd = WbSwingUtilities.getCommitRollbackQuestion(this, string);
                try {
                    if (transactionEnd == WbSwingUtilities.TransactionEnd.Rollback) {
                        this.dbConnection.commit();
                        dataStore.resetStatusForSentRows();
                    } else {
                        this.dbConnection.rollback();
                        dataStore.resetDmlSentStatus();
                    }
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Commit failed!", sQLException);
                    string = sQLException.getMessage();
                    WbSwingUtilities.showErrorMessage(this, string);
                }
                this.currentData.rowCountChanged();
                WbSwingUtilities.repaintLater(this);
            } else {
                dataStore.resetStatusForSentRows();
            }
        }
        this.setCancelState(false);
    }

    public void forceAbort() {
        if (!this.isBusy()) {
            return;
        }
        if (this.executionThread == null) {
            return;
        }
        try {
            String string = this.executionThread.getName();
            this.cancelExecution = true;
            this.executionThread.interrupt();
            this.executionThread = null;
            if (this.stmtRunner != null) {
                this.stmtRunner.abort();
            }
            LogMgr.logDebug(new CallerInfo(){}, "'" + string + "' was interrupted.");
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when trying to kill background thread", exception);
        }
        finally {
            this.setBusy(false);
        }
    }

    public void abortExecution() {
        if (this.isCancelling()) {
            this.forceAbort();
            return;
        }
        if (!this.isBusy()) {
            return;
        }
        if (this.executionThread == null) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        long l = Settings.getInstance().getIntProperty(this.getClass().getName() + ".abortwait", 5);
        try {
            LogMgr.logDebug(callerInfo, "Interrupting SQL Thread...");
            this.cancelExecution = true;
            this.executionThread.interrupt();
            this.executionThread.join(l * 1000L);
            if (this.isBusy()) {
                this.stmtRunner.abort();
                LogMgr.logDebug(callerInfo, "SQL Thread still running after " + l + "s!");
            }
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Error when interrupting SQL thread", exception);
        }
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    @Override
    public void cancelExecution() {
        if (!this.isBusy()) {
            return;
        }
        this.setStatusMessage(ResourceMgr.getString("MsgCancellingStmt") + "\n");
        this.iconHandler.showCancelIcon();
        try {
            if (this.worker != null) {
                this.worker.cancelExecution();
            } else if (this.updateRunning) {
                this.cancelUpdate();
            } else {
                WbThread wbThread = new WbThread("SqlPanel " + this.getId() + " Cancel Thread"){

                    @Override
                    public void run() {
                        SqlPanel.this.cancelRetrieve();
                    }
                };
                wbThread.start();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error cancelling execution", throwable);
        }
    }

    @Override
    public boolean isCancelling() {
        return this.cancelExecution;
    }

    protected void cancelRetrieve() {
        this.cancelExecution = true;
        this.setCancelState(false);
        this.stmtRunner.cancel();
        if (this.executionThread != null) {
            try {
                this.executionThread.join(Settings.getInstance().getIntProperty("workbench.sql.cancel.timeout", 5000));
            }
            catch (InterruptedException interruptedException) {
                LogMgr.logDebug(new CallerInfo(){}, "Error when waiting for cancel to finish", interruptedException);
            }
        }
        if (this.executionThread != null && this.executionThread.isAlive()) {
            this.executionThread.interrupt();
        }
    }

    public void setCancelState(boolean bl) {
        this.setActionState(bl, this.stopAction);
    }

    public void setActionState(boolean bl, Action ... actionArray) {
        WbSwingUtilities.invoke(() -> {
            for (Action action : actionArray) {
                if (action == null) continue;
                action.setEnabled(bl);
            }
        });
    }

    public void runCurrentStatement() {
        String string = this.editor.getText();
        this.startExecution(string, 0, GuiSettings.getHighlightErrorStatement(), this.appendResults, RunType.RunCurrent);
    }

    public void runFromCursor() {
        String string = this.editor.getText();
        this.startExecution(string, 0, GuiSettings.getHighlightErrorStatement(), this.appendResults, RunType.RunFromCursor);
    }

    public void runToCursor() {
        String string = this.editor.getText();
        this.startExecution(string, 0, GuiSettings.getHighlightErrorStatement(), this.appendResults, RunType.RunToCursor);
    }

    public void runSelectedStatement() {
        String string = this.editor.getSelectedStatement();
        int n = 0;
        boolean bl = GuiSettings.getHighlightErrorStatement();
        if (this.editor.isTextSelected()) {
            n = this.editor.getSelectionStart();
            bl = false;
        }
        LogMgr.logTrace(new CallerInfo(){}, "Selection length: " + string.length() + ", offset: " + n + ", total length: " + this.editor.getDocumentLength());
        this.startExecution(string, n, bl, this.appendResults, RunType.RunAll);
    }

    @Override
    public void commit() {
        this.startExecution("COMMIT", 0, false, this.appendResults, RunType.RunAll);
    }

    @Override
    public void rollback() {
        this.startExecution("ROLLBACK", 0, false, this.appendResults, RunType.RunAll);
    }

    public void runAll() {
        String string = this.editor.getText();
        this.startExecution(string, 0, GuiSettings.getHighlightErrorStatement(), this.appendResults, RunType.RunAll);
    }

    private void startExecution(final String string, final int n, final boolean bl, final boolean bl2, final RunType runType) {
        if (this.executionThread != null || this.isConnectionBusy()) {
            CallerInfo callerInfo = new CallerInfo(){};
            if (this.executionThread != null) {
                LogMgr.logDebug(callerInfo, "startExecution() called although a thread is currently active", new Exception("Backtrace"));
            } else {
                String string2 = "startExecution() called, but current connection: " + this.dbConnection.getId() + " is busy.";
                if (LogMgr.isTraceEnabled()) {
                    string2 = string2 + "\nCurrent connections:\n" + ConnectionMgr.getInstance().listActiveConnections();
                }
                LogMgr.logDebug(callerInfo, string2);
            }
            this.showLogMessage(ResourceMgr.getString("ErrConnectionBusy"));
            return;
        }
        if (!bl2 && !this.confirmDiscardChanges(-1, true)) {
            return;
        }
        this.executionThread = new WbThread(this.getThreadId()){

            @Override
            public void run() {
                SqlPanel.this.runStatement(string, n, bl, bl2, runType);
            }
        };
        this.executionThread.start();
    }

    private String getThreadId() {
        String string = "SQL Thread " + this.getRealTabTitle();
        if (this.dbConnection != null) {
            string = string + " (" + this.dbConnection.getId() + ")";
        }
        return string;
    }

    private void doAutoSaveFile() {
        AutoFileSaveType autoFileSaveType = Settings.getInstance().getAutoSaveExternalFiles();
        if (autoFileSaveType != AutoFileSaveType.never && this.editor.hasFileLoaded() && this.editor.isModified()) {
            if (autoFileSaveType == AutoFileSaveType.always) {
                this.editor.saveCurrentFile();
            } else {
                this.editor.checkAndSaveFile(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runStatement(String string, int n, boolean bl, boolean bl2, RunType runType) {
        this.setStatusMessage(ResourceMgr.getString("MsgExecutingSql"));
        this.storeStatementInHistory();
        this.cancelExecution = false;
        this.setBusy(true);
        this.fireDbExecStart();
        this.doAutoSaveFile();
        this.setCancelState(true);
        try {
            this.displayResult(string, n, bl, bl2, runType);
        }
        finally {
            this.fireDbExecEnd();
            this.clearStatusMessage();
            this.setCancelState(false);
            this.updateResultInfos();
            this.iconHandler.showBusyIcon(false);
            this.setBusy(false);
            this.selectEditorLater();
            this.executionThread = null;
            this.cancelExecution = false;
        }
    }

    public AutomaticRefreshMgr getRefreshMgr() {
        return this.refreshMgr;
    }

    public void reloadCurrent() {
        if (this.isConnectionBusy()) {
            return;
        }
        if (this.currentData == null) {
            return;
        }
        this.startReloadPanel(this.currentData);
    }

    @Override
    public void startReloadPanel(final DwPanel dwPanel) {
        if (dwPanel == null) {
            return;
        }
        int n = this.resultTab.indexOfComponent(dwPanel);
        if (!this.confirmDiscardChanges(n, true)) {
            return;
        }
        this.executionThread = new WbThread(this.getThreadId()){

            @Override
            public void run() {
                SqlPanel.this.runCurrentSql(dwPanel);
            }
        };
        this.executionThread.start();
    }

    protected void runCurrentSql() {
        this.runCurrentSql(this.currentData);
    }

    public void checkAutoRefreshIndicator(DwPanel dwPanel) {
        int n = this.resultTab.indexOfComponent(dwPanel);
        if (n < 0) {
            return;
        }
        Icon icon = this.resultTab.getIconAt(n);
        this.resultTab.setIconAt(n, this.refreshMgr.getTabIcon(icon, dwPanel));
        if (this.refreshMgr.isRegistered(dwPanel)) {
            int n2 = this.refreshMgr.getRefreshPeriod(dwPanel);
            DurationFormatter durationFormatter = new DurationFormatter();
            String string = durationFormatter.formatDuration(n2, DurationFormat.dynamic, false, false).trim();
            String string2 = ResourceMgr.getFormattedString("MsgRefreshing", string, StringUtil.getCurrentTimestamp());
            this.resultTab.setToolTipTextAt(n, string2);
        }
    }

    private void runCurrentSql(DwPanel dwPanel) {
        if (this.isConnectionBusy()) {
            return;
        }
        if (dwPanel == null) {
            return;
        }
        this.cancelExecution = false;
        this.setBusy(true);
        this.fireDbExecStart();
        this.setCancelState(true);
        this.setStatusMessage(ResourceMgr.getString("MsgExecutingSql"));
        try {
            dwPanel.runCurrentSql(true);
            TableAnnotationProcessor tableAnnotationProcessor = new TableAnnotationProcessor();
            tableAnnotationProcessor.handleAnnotations(this, dwPanel, null);
            this.checkAutoRefreshIndicator(dwPanel);
            this.updateLockedTitle(dwPanel);
        }
        catch (Exception exception) {
            this.showLogMessage(exception.getMessage());
            LogMgr.logError(new CallerInfo(){}, "Error reloading current result", exception);
        }
        finally {
            this.clearStatusMessage();
            this.setCancelState(false);
            this.updateResultInfos();
            this.fireDbExecEnd();
            this.setBusy(false);
            this.executionThread = null;
        }
    }

    public void showData(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (this.isConnectionBusy()) {
            return;
        }
        if (tableIdentifier == null) {
            return;
        }
        String string = null;
        if (CollectionUtil.isNonEmpty(list)) {
            TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.dbConnection, "tabledata");
            string = tableSelectBuilder.getSelectForColumns(tableIdentifier, list, this.statusBar.getMaxRows());
        } else if (DbTreeSettings.useColumnListForTableDataDisplay(this.dbConnection.getDbId())) {
            List<ColumnIdentifier> list2 = this.dbConnection.getObjectCache().getColumns(tableIdentifier);
            TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.dbConnection, "tabledata");
            string = tableSelectBuilder.getSelectForColumns(tableIdentifier, list2, this.statusBar.getMaxRows());
        } else {
            string = "select * from " + tableIdentifier.getTableExpression(this.dbConnection);
        }
        this.startExecution(string, 0, false, true, RunType.RunAll);
    }

    @Override
    public int getMacroClientId() {
        return this.macroClientId;
    }

    @Override
    public void executeMacroSql(String string, boolean bl, boolean bl2) {
        if (this.isConnectionBusy()) {
            return;
        }
        if (StringUtil.isBlank(string)) {
            return;
        }
        if (bl) {
            this.storeStatementInHistory();
            this.editor.setText(string);
            this.macroExecution = false;
        } else {
            this.macroExecution = true;
        }
        this.startExecution(string, 0, false, this.appendResults || bl2, RunType.RunAll);
    }

    @Override
    public void exportData() {
        String string = this.editor.getSelectedStatement();
        this.cancelExecution = false;
        final ExportFileDialog exportFileDialog = new ExportFileDialog(SwingUtilities.getWindowAncestor(this));
        exportFileDialog.setQuerySql(string, this.getConnection());
        exportFileDialog.setIncludeSqlInsert(true);
        boolean bl = exportFileDialog.selectOutput();
        if (!bl) {
            return;
        }
        final DataExporter dataExporter = new DataExporter(this.dbConnection);
        dataExporter.setRowMonitor(this.rowMonitor);
        WbFile wbFile = new WbFile(exportFileDialog.getSelectedFilename());
        final boolean bl2 = exportFileDialog.doOpenFile();
        dataExporter.addQueryJob(string, wbFile, null);
        exportFileDialog.setExporterOptions(dataExporter);
        this.worker = dataExporter;
        String string2 = ResourceMgr.getString("MsgQueryExportInit");
        string2 = StringUtil.replace(string2, "%type%", dataExporter.getTypeDisplay());
        string2 = StringUtil.replace(string2, "%sql%", StringUtil.getMaxSubstring(string, 100));
        this.showLogMessage(string2);
        this.executionThread = new WbThread("ExportSQL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SqlPanel.this.setBusy(true);
                SqlPanel.this.setCancelState(true);
                SqlPanel.this.fireDbExecStart();
                SqlPanel.this.statusBar.executionStart();
                long l = System.currentTimeMillis();
                try {
                    CharSequence charSequence;
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder();
                    long l2 = dataExporter.startExport();
                    long l3 = System.currentTimeMillis() - l;
                    CharSequence charSequence2 = dataExporter.getErrors();
                    if (charSequence2.length() > 0) {
                        stringBuilder.append('\n');
                        bl = true;
                        stringBuilder.append(charSequence2);
                        stringBuilder.append('\n');
                    }
                    if ((charSequence = dataExporter.getWarnings()).length() > 0) {
                        if (!bl) {
                            stringBuilder.append('\n');
                        }
                        stringBuilder.append(charSequence);
                        stringBuilder.append('\n');
                    }
                    if (dataExporter.isSuccess()) {
                        stringBuilder.append("\n");
                        stringBuilder.append(ResourceMgr.getFormattedString("MsgSpoolOk", NumberStringCache.getNumberString(l2)));
                        stringBuilder.append("\n");
                        stringBuilder.append(ResourceMgr.getString("MsgSpoolTarget"));
                        stringBuilder.append(' ');
                        stringBuilder.append(dataExporter.getFullOutputFilename());
                        stringBuilder.append("\n\n");
                    }
                    stringBuilder.append(ResourceMgr.getString("MsgExecTime"));
                    stringBuilder.append(' ');
                    stringBuilder.append(Double.toString((double)l3 / 1000.0));
                    stringBuilder.append("s\n");
                    SqlPanel.this.appendToLog(stringBuilder.toString());
                    SqlPanel.this.showLogPanel();
                    if (bl2) {
                        exportFileDialog.openOutputFile();
                    }
                }
                catch (Exception exception) {
                    SqlPanel.this.appendToLog(ExceptionUtil.getDisplay(exception));
                    LogMgr.logError(new CallerInfo(){}, "Error exporting data", exception);
                }
                finally {
                    SqlPanel.this.setBusy(false);
                    SqlPanel.this.fireDbExecEnd();
                    SqlPanel.this.statusBar.executionEnd();
                    long l4 = System.currentTimeMillis() - l;
                    SqlPanel.this.statusBar.setExecutionTime(l4);
                    SqlPanel.this.clearStatusMessage();
                    SqlPanel.this.setCancelState(false);
                    SqlPanel.this.executionThread = null;
                    SqlPanel.this.worker = null;
                }
            }
        };
        this.executionThread.start();
    }

    @Override
    public void fatalError(String string) {
        WbSwingUtilities.showErrorMessage(this, string);
    }

    @Override
    public int getActionOnError(int n, String string, String string2, String string3) {
        if (this.importRunning) {
            return this.getImportErrorAction(n, string, string2, string3);
        }
        if (this.updateRunning) {
            return this.getUpdateErrorAction(n, string, string2, string3);
        }
        return 3;
    }

    public int getUpdateErrorAction(int n, String string, String string2, String string3) {
        this.iconHandler.showBusyIcon(false);
        int n2 = this.currentData.getActionOnError(n, string, string2, string3);
        this.iconHandler.showBusyIcon(true);
        return n2;
    }

    public int getImportErrorAction(int n, String string, String string2, String string3) {
        String string4 = null;
        if (string != null) {
            string4 = ResourceMgr.getString("ErrColumnImportError");
            string4 = string4.replace("%row%", NumberStringCache.getNumberString(n));
            string4 = string4.replace("%column%", string);
            string4 = string4.replace("%data%", string2);
        } else {
            string4 = ResourceMgr.getString("ErrRowImportError");
            string4 = string4.replace("%row%", NumberStringCache.getNumberString(n));
            string4 = string4.replace("%data%", string2 == null ? "(null)" : string2.substring(0, 40) + " ...");
        }
        this.iconHandler.showBusyIcon(false);
        int n2 = WbSwingUtilities.getYesNoIgnoreAll(this, string4);
        int n3 = 3;
        this.iconHandler.showBusyIcon(true);
        if (n2 == 0) {
            n3 = 1;
        } else if (n2 == 2042) {
            n3 = 2;
        }
        return n3;
    }

    public void importFile() {
        if (this.currentData == null) {
            return;
        }
        if (!this.currentData.startEdit()) {
            return;
        }
        ImportFileDialog importFileDialog = new ImportFileDialog(this);
        importFileDialog.allowImportModeSelection(false);
        boolean bl = importFileDialog.selectInput(ResourceMgr.getString("TxtWindowTitleSelectImportFile"), "general");
        if (!bl) {
            return;
        }
        DataStoreImporter dataStoreImporter = new DataStoreImporter(this.currentData.getTable().getDataStore(), this.currentData.getRowMonitor(), this);
        File file = importFileDialog.getSelectedFile();
        dataStoreImporter.setImportOptions(file, importFileDialog.getImportType(), importFileDialog.getGeneralOptions(), importFileDialog.getTextOptions());
        Settings.getInstance().setLastImportDir(file.getParent());
        importFileDialog.saveSettings();
        this.runImporter(dataStoreImporter);
    }

    public void importString(String string, boolean bl) {
        if (this.currentData == null) {
            return;
        }
        if (!this.currentData.startEdit()) {
            return;
        }
        DataStore dataStore = this.currentData.getTable().getDataStore();
        ImportStringVerifier importStringVerifier = new ImportStringVerifier(string, dataStore.getResultInfo());
        DataStoreImporter dataStoreImporter = new DataStoreImporter(dataStore, this.currentData.getRowMonitor(), this);
        boolean bl2 = importStringVerifier.checkData();
        if (bl || !bl2) {
            boolean bl3 = false;
            while (!bl3) {
                boolean bl4 = importStringVerifier.showOptionsDialog();
                if (!bl4) {
                    return;
                }
                bl3 = importStringVerifier.checkData();
            }
            TextImportOptions textImportOptions = importStringVerifier.getTextImportOptions();
            ImportOptions importOptions = importStringVerifier.getImportOptions();
            dataStoreImporter.importString(string, importOptions, textImportOptions);
        } else if (!importStringVerifier.columnNamesMatched()) {
            DefaultTextImportOptions defaultTextImportOptions = new DefaultTextImportOptions("\t", "\"");
            defaultTextImportOptions.setContainsHeader(false);
            DefaultImportOptions defaultImportOptions = new DefaultImportOptions();
            dataStoreImporter.importString(string, defaultImportOptions, defaultTextImportOptions);
        } else {
            dataStoreImporter.importString(string);
        }
        if (!this.currentData.startEdit()) {
            return;
        }
        this.runImporter(dataStoreImporter);
    }

    public synchronized void runImporter(final DataStoreImporter dataStoreImporter) {
        this.setActionState(false, this.importFileAction);
        this.setBusy(true);
        this.setCancelState(true);
        this.worker = dataStoreImporter;
        WbThread wbThread = new WbThread("DataImport"){

            @Override
            public void run() {
                try {
                    SqlPanel.this.importRunning = true;
                    SqlPanel.this.fireDbExecStart();
                    dataStoreImporter.startImport();
                }
                catch (Throwable throwable) {
                    LogMgr.logError(new CallerInfo(){}, "Error when importing data", throwable);
                }
                finally {
                    SqlPanel.this.importRunning = false;
                    SqlPanel.this.setBusy(false);
                    SqlPanel.this.fireDbExecEnd();
                    SqlPanel.this.currentData.getTable().getDataStoreTableModel().fileImported();
                    SqlPanel.this.currentData.rowCountChanged();
                    SqlPanel.this.currentData.clearStatusMessage();
                    MessageBuffer messageBuffer = dataStoreImporter.getMessage();
                    if (messageBuffer != null && messageBuffer.getLength() > 0) {
                        SqlPanel.this.appendToLog(messageBuffer.getBuffer().toString());
                    }
                    SqlPanel.this.setCancelState(false);
                    SqlPanel.this.checkResultSetActions();
                }
            }
        };
        wbThread.start();
        this.selectEditor();
    }

    @Override
    public void printMessage(String string) {
        this.appendMessage(string, "\n");
    }

    @Override
    public void appendToLog(CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        this.appendMessage(charSequence.toString(), new String[0]);
    }

    private void appendMessage(String string, String ... stringArray) {
        WbSwingUtilities.invoke(() -> {
            this.log.append(string);
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    this.log.append(string2);
                }
            }
            this.log.setCaretPosition(this.log.getDocument().getLength());
        });
    }

    @Override
    public String getInput(String string) {
        String string2 = WbSwingUtilities.getUserInput(this, string, "");
        if (StringUtil.isEmptyString(string2)) {
            return null;
        }
        return string2;
    }

    @Override
    public String getPassword(String string, String string2) {
        String string3 = WbSwingUtilities.passwordPrompt(this, string, string2);
        if (StringUtil.isEmptyString(string3)) {
            return null;
        }
        return string3;
    }

    @Override
    public boolean confirmExecution(String string, String string2, String string3) {
        int n;
        String string4 = "";
        Window window = SwingUtilities.getWindowAncestor(this);
        if (this.dbConnection != null) {
            WindowTitleBuilder windowTitleBuilder = new WindowTitleBuilder();
            string4 = windowTitleBuilder.getWindowTitle(this.dbConnection, null, null, null) + " - ";
        }
        return (n = WbSwingUtilities.getYesNo((Component)window, string4 = string4 + this.getRealTabTitle(), string, string2, string3)) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean confirmStatementExecution(String string) {
        if (this.executeAllStatements) {
            return true;
        }
        boolean bl = false;
        this.iconHandler.showBusyIcon(false);
        try {
            String string2 = StringUtil.getMaxSubstring(string, 80).trim();
            string2 = string2.replaceAll("((\r\n)|(\n\r)|\r|\n)", "<br>");
            String string3 = "<html>" + ResourceMgr.getString("MsgConfirmExecution") + "<br><br><tt style='white-space: normal;word-wrap: break-all;'>" + string2 + "</tt></html>";
            int n = WbSwingUtilities.getYesNoExecuteAll(this, string3);
            switch (n) {
                case 0: {
                    bl = true;
                    return bl;
                }
                case 1: {
                    bl = false;
                    return bl;
                }
                case 2: {
                    bl = false;
                    this.executeAllStatements = false;
                    this.cancelAll = true;
                    return bl;
                }
                case 4042: {
                    bl = true;
                    this.executeAllStatements = true;
                    return bl;
                }
                default: {
                    bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.iconHandler.showBusyIcon(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.ignoreStateChange || this.isBusy()) {
            return;
        }
        this.updateResultInfos();
        if (this.currentData != null) {
            this.statusBar.setExecutionTime(this.currentData.getLastExecutionTime());
        } else {
            this.statusBar.setExecutionTime(this.getTotalResultExecutionTime());
        }
    }

    private long getTotalResultExecutionTime() {
        if (this.lastScriptExecTime > 0L) {
            return this.lastScriptExecTime;
        }
        long l = 0L;
        for (int i = 0; i < this.resultTab.getTabCount() - 1; ++i) {
            DwPanel dwPanel = (DwPanel)this.resultTab.getComponentAt(i);
            l += dwPanel.getLastExecutionTime();
        }
        return l;
    }

    private void updateResultInfos() {
        int n = this.resultTab.getSelectedIndex();
        if (n == -1) {
            return;
        }
        if (this.currentData != null) {
            this.currentData.removePropertyChangeListener(this);
            this.currentData.getTable().stopEditing();
        }
        if (n == this.resultTab.getTabCount() - 1) {
            this.currentData = null;
            this.statusBar.clearRowcount();
        } else {
            this.currentData = this.getCurrentResult();
            if (this.currentData != null) {
                this.currentData.updateStatusBar();
                this.currentData.addPropertyChangeListener("updateTable", this);
            }
        }
        this.closeResultAction.setEnabled(this.currentData != null);
        this.closeAllResultsAction.setEnabled(this.getResultTabCount() > 0);
        this.updateProxiedActions();
        this.checkResultSetActions();
    }

    public String getCurrentResultTitle() {
        int n = this.resultTab.getSelectedIndex();
        return this.resultTab.getTitleAt(n);
    }

    public DwPanel getCurrentResult() {
        Component component = this.resultTab.getSelectedComponent();
        if (component instanceof DwPanel) {
            return (DwPanel)component;
        }
        return null;
    }

    public long getLoadedAt() {
        if (this.currentData == null) {
            return 0L;
        }
        DataStore dataStore = this.currentData.getDataStore();
        if (dataStore == null) {
            return 0L;
        }
        return dataStore.getLoadedAt();
    }

    public String getSourceQuery() {
        if (this.currentData == null) {
            return null;
        }
        DataStore dataStore = this.currentData.getDataStore();
        if (dataStore != null) {
            return dataStore.getGeneratingSql();
        }
        return null;
    }

    public void closeCurrentResult() {
        int n = this.resultTab.getSelectedIndex();
        this.closeResult(n);
    }

    public void removeCurrentResult() {
        int n = this.resultTab.getSelectedIndex();
        if (!this.confirmDiscardChanges(n, true)) {
            return;
        }
        this.discardResult(n, false);
    }

    public void closeResult(int n) {
        if (!this.confirmDiscardChanges(n, true)) {
            return;
        }
        this.discardResult(n, true);
    }

    public void closeSelectedResults(ResultCloseFilter resultCloseFilter) {
        try {
            this.ignoreStateChange = true;
            WbSwingUtilities.invoke(() -> {
                int n = 0;
                while (n < this.resultTab.getTabCount() - 1) {
                    Component component = this.resultTab.getComponentAt(n);
                    DwPanel dwPanel = (DwPanel)component;
                    if (resultCloseFilter.shouldClose(dwPanel, n) && this.confirmDiscardChanges(n, true)) {
                        dwPanel.removePropertyChangeListener(this);
                        dwPanel.dispose();
                        this.resultTab.removeTabAt(n);
                        continue;
                    }
                    ++n;
                }
                this.resultTab.setSelectedIndex(0);
                this.currentData = this.getCurrentResult();
                this.updateProxiedActions();
                this.updateResultInfos();
            });
        }
        finally {
            this.ignoreStateChange = false;
        }
    }

    private void discardResult(int n, boolean bl) {
        if (n == this.resultTab.getTabCount() - 1) {
            return;
        }
        try {
            DwPanel dwPanel = (DwPanel)this.resultTab.getComponentAt(n);
            this.refreshMgr.removeRefresh(dwPanel);
            dwPanel.removePropertyChangeListener(this);
            if (bl) {
                dwPanel.dispose();
            }
            this.resultTab.removeTabAt(n);
            this.currentData = null;
            int n2 = this.resultTab.getSelectedIndex();
            if (n2 > 0 && n2 == this.resultTab.getTabCount() - 1) {
                this.resultTab.setSelectedIndex(--n2);
            }
            if (n == this.resultTab.getSelectedIndex()) {
                EventQueue.invokeLater(this.resultTab::fireStateChanged);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error closing current result tab", exception);
        }
    }

    public void closeAllResults() {
        for (int i = 0; i < this.resultTab.getTabCount() - 1; ++i) {
            if (this.isResultLocked(i) || this.confirmDiscardChanges(i, true)) continue;
            return;
        }
        this.clearResultTabs(true);
    }

    private int findResultToSelect() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.resultTab.getTabCount() - 1; ++i) {
            Component component = this.resultTab.getComponentAt(i);
            if (!(component instanceof DwPanel)) continue;
            DwPanel dwPanel = (DwPanel)component;
            if (dwPanel.wasReUsed() && n == -1) {
                n = i;
            }
            if (!dwPanel.isLocked()) continue;
            n2 = i + 1;
        }
        return Math.max(n, n2);
    }

    private void resetReuse() {
        for (int i = 0; i < this.resultTab.getTabCount() - 1; ++i) {
            Component component = this.resultTab.getComponentAt(i);
            if (!(component instanceof DwPanel)) continue;
            DwPanel dwPanel = (DwPanel)component;
            dwPanel.setReUsed(false);
        }
    }

    public void clearResultTabs(boolean bl) {
        try {
            this.ignoreStateChange = true;
            WbSwingUtilities.invoke(() -> {
                int n;
                for (n = this.resultTab.getTabCount() - 2; n >= 0; --n) {
                    Component component = this.resultTab.getComponentAt(n);
                    if (component instanceof DwPanel) {
                        DwPanel dwPanel = (DwPanel)component;
                        if (bl && dwPanel.isLocked()) continue;
                        this.refreshMgr.removeRefresh(dwPanel);
                        dwPanel.removePropertyChangeListener(this);
                        dwPanel.dispose();
                    }
                    this.resultTab.removeTabAt(n);
                }
                this.resultTab.setSelectedIndex(0);
                n = this.currentData == null ? 1 : 0;
                this.currentData = null;
                if (n == 0) {
                    this.updateProxiedActions();
                }
                this.checkResultSetActions();
            });
        }
        finally {
            this.ignoreStateChange = false;
        }
    }

    protected void updateProxiedActions() {
        WbSwingUtilities.invoke(this::_updateProxiedActions);
    }

    private void _updateProxiedActions() {
        if (this.currentData == null) {
            this.updateAction.setOriginal(null);
            this.insertRow.setOriginal(null);
            this.deleteRow.setOriginal(null);
            this.deleteDependentRow.setOriginal(null);
            this.duplicateRow.setOriginal(null);
            this.selectKeys.setOriginal(null);
            this.createDeleteScript.setClient(null);
            this.exportDataAction.setOriginal(null);
            this.optimizeAllCol.setClient(null);
            this.optimizeRowHeights.setClient(null);
            this.dataToClipboard.setOriginal(null);
            this.copyAsSqlInsert.setOriginal(null);
            this.copyAsSqlUpdate.setOriginal(null);
            this.copyAsSqlDeleteInsert.setOriginal(null);
            this.copyAsSqlDelete.setOriginal(null);
            this.copyAsSqlMerge.setOriginal(null);
            this.findDataAction.setOriginal(null);
            this.findDataAgainAction.setOriginal(null);
            this.copyAsSQLMenu.setEnabled(false);
            this.copySelectedMenu.removeAll();
            this.copySelectedMenu.setEnabled(false);
            this.printDataAction.setOriginal(null);
            this.printPreviewAction.setOriginal(null);
            this.filterAction.setOriginal(null);
            this.filterPicker.setClient(null);
            this.resetFilterAction.setOriginal(null);
            this.selectionFilterAction.setClient(null);
            this.resetHighlightAction.setOriginal(null);
            this.showFormAction.setTable(null);
        } else {
            this.updateAction.setOriginal(this.currentData.getUpdateDatabaseAction());
            this.insertRow.setOriginal(this.currentData.getInsertRowAction());
            this.deleteRow.setOriginal(this.currentData.getDeleteRowAction());
            this.deleteDependentRow.setOriginal(this.currentData.getDeleteDependentRowsAction());
            this.duplicateRow.setOriginal(this.currentData.getCopyRowAction());
            this.selectKeys.setOriginal(this.currentData.getSelectKeysAction());
            this.createDeleteScript.setClient(this.currentData.getTable());
            this.exportDataAction.setOriginal(this.currentData.getTable().getExportAction());
            this.optimizeAllCol.setClient(this.currentData.getTable());
            this.optimizeRowHeights.setClient(this.currentData.getTable());
            this.dataToClipboard.setOriginal(this.currentData.getTable().getDataToClipboardAction());
            this.copyAsSqlInsert.setOriginal(this.currentData.getTable().getCopyAsInsertAction());
            this.copyAsSqlUpdate.setOriginal(this.currentData.getTable().getCopyAsUpdateAction());
            this.copyAsSqlDeleteInsert.setOriginal(this.currentData.getTable().getCopyAsDeleteInsertAction());
            this.copyAsSqlDelete.setOriginal(this.currentData.getTable().getCopyAsDeleteAction());
            this.copyAsSqlMerge.setOriginal(this.currentData.getTable().getCopyAsSqlMergeAction());
            this.findDataAction.setOriginal(this.currentData.getTable().getReplacer().getFindAction());
            this.findDataAgainAction.setOriginal(this.currentData.getTable().getReplacer().getFindAgainAction());
            this.replaceDataAction.setOriginal(this.currentData.getTable().getReplacer().getReplaceAction());
            this.copyAsSQLMenu.setEnabled(true);
            this.copySelectedMenu.removeAll();
            this.currentData.getTable().populateCopySelectedMenu(this.copySelectedMenu);
            this.copySelectedMenu.setEnabled(true);
            this.printDataAction.setOriginal(this.currentData.getTable().getPrintAction());
            this.printPreviewAction.setOriginal(this.currentData.getTable().getPrintPreviewAction());
            this.filterAction.setOriginal(this.currentData.getTable().getFilterAction());
            this.filterPicker.setClient(this.currentData.getTable());
            this.resetFilterAction.setOriginal(this.currentData.getTable().getResetFilterAction());
            this.selectionFilterAction.setClient(this.currentData.getTable());
            this.resetHighlightAction.setOriginal(this.currentData.getTable().getResetHighlightAction());
            this.showFormAction.setTable(this.currentData.getTable());
        }
    }

    @Override
    public boolean processParameterPrompts(String string) {
        boolean bl = true;
        VariablePool variablePool = VariablePool.getInstance();
        DataStore dataStore = variablePool.getParametersToBePrompted(string);
        if (dataStore != null && dataStore.getRowCount() > 0) {
            this.iconHandler.showBusyIcon(false);
            bl = VariablesEditor.showVariablesDialog(dataStore);
            this.iconHandler.showBusyIcon(true);
        }
        if (bl && this.checkPrepared) {
            PreparedStatementPool preparedStatementPool = this.dbConnection.getPreparedStatementPool();
            try {
                if (preparedStatementPool.isRegistered(string) || preparedStatementPool.addPreparedStatement(string)) {
                    StatementParameters statementParameters = preparedStatementPool.getParameters(string);
                    this.iconHandler.showBusyIcon(false);
                    bl = ParameterEditor.showParameterDialog(statementParameters, false);
                    this.iconHandler.showBusyIcon(true);
                }
            }
            catch (SQLException sQLException) {
                this.iconHandler.showBusyIcon(false);
                String string2 = ResourceMgr.getString("ErrCheckPreparedStatement");
                string2 = StringUtil.replace(string2, "%error%", ExceptionUtil.getDisplay(sQLException));
                WbSwingUtilities.showErrorMessage(this, string2);
                this.iconHandler.showBusyIcon(true);
                bl = true;
                Settings.getInstance().setCheckPreparedStatements(false);
            }
        }
        return bl;
    }

    private String getBaseDir() {
        String string = this.dbConnection != null ? this.dbConnection.getProfile().getDefaultDirectory() : null;
        return StringUtil.coalesce(string, System.getProperty("user.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayResult(String string, int n, boolean bl, boolean bl2, RunType runType) {
        if (string == null) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        boolean bl3 = false;
        boolean bl4 = runType == RunType.RunCurrent && Settings.getInstance().getAutoJumpNextStatement();
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = Settings.getInstance().getBoolProperty("workbench.gui.sql.restoreselection", true);
        boolean bl8 = false;
        String string2 = Settings.getInstance().getInternalEditorLineEnding();
        Pattern pattern = null;
        if (!string2.equals("\n")) {
            pattern = Pattern.compile("\n");
        }
        this.checkPrepared = Settings.getInstance().getCheckPreparedStatements();
        this.executeAllStatements = false;
        this.cancelAll = false;
        ScriptParser scriptParser = ScriptParser.createScriptParser(this.dbConnection);
        scriptParser.setReturnStartingWhitespace(true);
        int n2 = -1;
        int n3 = -1;
        this.stmtRunner.setExecutionController(this);
        this.stmtRunner.setParameterPrompter(this);
        DurationFormatter durationFormatter = new DurationFormatter();
        if (this.editor.hasFileLoaded()) {
            try {
                File file = new File(this.editor.getCurrentFileName());
                String string3 = file.getCanonicalFile().getParent();
                this.stmtRunner.setBaseDir(string3);
            }
            catch (IOException iOException) {
                this.stmtRunner.setBaseDir(this.getBaseDir());
            }
        } else {
            this.stmtRunner.setBaseDir(this.getBaseDir());
        }
        int n4 = -1;
        long l = System.currentTimeMillis();
        StatementRunnerResult statementRunnerResult = null;
        int n5 = this.editor.getCaretPosition();
        int n6 = this.resultTab.getTabCount() - 1;
        String string4 = null;
        if (this.macroExecution) {
            bl8 = true;
        } else {
            String string5 = this.stmtRunner.getParsingUtil().stripStartingComment(string);
            String string6 = SqlUtil.trimSemicolon(string5);
            String string7 = MacroManager.getInstance().getMacroText(this.macroClientId, string6);
            if (string7 != null) {
                string4 = ResourceMgr.getString("MsgExecutingMacro") + ": " + string6 + "\n";
                string = string7;
                bl8 = true;
            }
        }
        try {
            boolean bl9;
            String string8;
            int n7;
            String string9;
            AppendResultAnnotation appendResultAnnotation;
            int n8;
            scriptParser.setScript(string);
            int n9 = -1;
            int n10 = 0;
            int n11 = n8 = scriptParser.getSize();
            int n12 = 0;
            if (n8 == 0) {
                this.printMessage(ResourceMgr.getString("ErrNoCommand"));
                this.showLogPanel();
                return;
            }
            int n13 = this.editor.getCaretPosition();
            if (runType != RunType.RunAll) {
                int n14 = n13;
                if (GuiSettings.getUseStatementInCurrentLine()) {
                    n14 = this.editor.getLineStartOffset(this.editor.getCaretLine());
                }
                if (runType == RunType.RunFromCursor) {
                    n10 = scriptParser.getCommandIndexAtCursorPos(n14);
                    n8 -= n10;
                } else if (runType == RunType.RunToCursor) {
                    n10 = 0;
                    n8 = n11 = scriptParser.getCommandIndexAtCursorPos(n14) + 1;
                } else if (runType == RunType.RunCurrent) {
                    n10 = scriptParser.getCommandIndexAtCursorPos(n14);
                    n8 = 1;
                    n11 = n10 + 1;
                }
                if (n10 == -1) {
                    int n15 = scriptParser.getSize();
                    int n16 = scriptParser.getEndPosForCommand(n15 - 1);
                    if (GuiSettings.getUseLastIfNoCurrentStmt() && n13 >= n16) {
                        n10 = n15 - 1;
                        n11 = n15;
                        LogMgr.logWarning(callerInfo, "The cursor is not located inside a statement. Using the last statement of the editor instead!");
                    } else {
                        this.printMessage(ResourceMgr.getString("ErrNoCurrentStatement"));
                        this.showLogPanel();
                        return;
                    }
                }
            }
            if (n11 == n10 + 1 && (appendResultAnnotation = new AppendResultAnnotation()).containsAnnotation(string9 = scriptParser.getCommand(n10))) {
                bl2 = true;
            }
            if (bl2) {
                this.resetReuse();
                n4 = this.resultTab.getTabCount() - 1;
                this.appendToLog("\n");
            } else {
                this.setLogText("");
                this.clearResultTabs(true);
                int n17 = n4 = n8 > 1 ? -1 : 0;
            }
            if (string4 != null) {
                this.appendToLog(string4);
            }
            if (n8 > 1) {
                bl3 = !this.stmtRunner.getVerboseLogging();
            }
            String string10 = ResourceMgr.getString("TxtScriptStatementFinished");
            boolean bl10 = !Settings.getInstance().getIgnoreErrors();
            boolean bl11 = bl5 = (n8 > 1 || n13 > -1) && !bl8 && Settings.getInstance().getHighlightCurrentStatement();
            if (bl5) {
                n2 = this.editor.getSelectionStart();
                n3 = this.editor.getSelectionEnd();
                bl6 = bl7;
            }
            this.statusBar.executionStart();
            long l2 = 0L;
            int n18 = 0;
            int n19 = 0;
            long l3 = 0L;
            this.macroExecution = false;
            this.lastScriptExecTime = 0L;
            this.ignoreStateChange = true;
            this.stmtRunner.setMaxRows(this.statusBar.getMaxRows());
            this.stmtRunner.setQueryTimeout(this.statusBar.getQueryTimeout());
            ErrorDescriptor errorDescriptor = null;
            boolean bl12 = true;
            if (LogMgr.isTraceEnabled()) {
                LogMgr.logTrace(callerInfo, runType.toString() + ": " + n8 + " of " + scriptParser.getSize() + " statement(s): start=" + n10 + ", end=" + (n11 - 1) + " Cursor: line=" + (this.editor.getCaretLine() + 1) + ", column=" + (this.editor.getCaretPositionInLine(this.editor.getCaretLine()) + 1) + " (" + n13 + ")");
            }
            this.cmdModeForScript = this.cmdMode;
            for (n7 = n10; n7 < n11; ++n7) {
                String string11;
                String string12 = scriptParser.getCommand(n7);
                if (StringUtil.isEmptyString(string12)) continue;
                if (LogMgr.isTraceEnabled()) {
                    LogMgr.logTrace(callerInfo, "Statement " + n7 + ": " + SqlUtil.makeCleanSql(StringUtil.getMaxSubstring(string12, 150), false, false, true, this.dbConnection));
                }
                this.historyStatements.add(string12);
                if (pattern != null) {
                    string12 = pattern.matcher(string12).replaceAll(string2);
                }
                if ((string11 = MacroManager.getInstance().getMacroText(this.macroClientId, this.stmtRunner.getParsingUtil().stripStartingComment(string12))) != null) {
                    this.appendToLog(ResourceMgr.getString("MsgExecutingMacro") + ": " + string12 + "\n");
                    bl8 = true;
                    string12 = string11;
                }
                Thread.yield();
                if (this.cancelExecution) break;
                if (bl5 && !this.editor.isModifiedAfter(l)) {
                    this.highlighter.highlightStatement(scriptParser, n7, n);
                }
                if ((statementRunnerResult = this.stmtRunner.runStatement(string12)) == null) continue;
                boolean bl13 = bl12 = bl12 && statementRunnerResult.isIgnoreUpdateCount();
                if (statementRunnerResult.stopScript()) {
                    string8 = ResourceMgr.getString("MsgScriptCancelled");
                    this.printMessage(string8);
                    this.showLogPanel();
                    break;
                }
                if (statementRunnerResult.promptingWasCancelled()) {
                    this.printMessage(ResourceMgr.getFormattedString("MsgSqlCancelledDuringPrompt", NumberStringCache.getNumberString(n7 + 1)));
                    this.showLogPanel();
                    if (!GuiSettings.cancellingVariablePromptStopsExecution()) continue;
                    break;
                }
                n19 += this.addResult(statementRunnerResult);
                l2 += statementRunnerResult.getExecutionDuration();
                if (n8 > 1) {
                    bl3 = bl3 || !this.stmtRunner.getVerboseLogging();
                }
                string8 = MessageFormat.format(string10, n7 + 1 - n10, n8);
                if (!bl3) {
                    boolean bl14;
                    this.showResultMessage(statementRunnerResult);
                    StringBuilder stringBuilder = new StringBuilder(50);
                    boolean bl15 = bl14 = n8 > 1 && GuiSettings.showScriptProgress();
                    if (bl14) {
                        String string13 = statementRunnerResult.getTimingMessage();
                        if (string13 != null) {
                            stringBuilder.append('\n');
                            stringBuilder.append(string13);
                        }
                        stringBuilder.append('\n');
                        stringBuilder.append(string8);
                    }
                    if (n8 > 1 && GuiSettings.showScriptStmtFinishTime()) {
                        stringBuilder.append(" (" + StringUtil.getCurrentTimestamp() + ")");
                    }
                    if (bl14) {
                        stringBuilder.append('\n');
                    }
                    if (stringBuilder.length() > 0) {
                        this.printMessage(stringBuilder.toString());
                    }
                } else if (statementRunnerResult.hasWarning()) {
                    String string14 = this.stmtRunner.getParsingUtil().getSqlVerb(string12);
                    String string15 = StringUtil.replace(ResourceMgr.getString("MsgStmtCompletedWarn"), "%verb%", string14);
                    this.printMessage(string15);
                }
                if (n8 > 1) {
                    this.statusBar.setStatusMessage(string8);
                }
                this.stmtRunner.statementDone();
                if (this.cancelAll) break;
                if (statementRunnerResult.isSuccess()) {
                    l3 += statementRunnerResult.getTotalUpdateCount();
                } else {
                    n9 = n7;
                    errorDescriptor = statementRunnerResult.getErrorDescriptor();
                    this.showLogPanel();
                    if (bl3 && statementRunnerResult.hasMessages()) {
                        this.printMessage(statementRunnerResult.getMessages().toString());
                    }
                    if (bl10 && this.shouldAsk(n7 - n10, n8) && !this.cancelExecution) {
                        int n20;
                        if (!bl8 && !this.editor.isModifiedAfter(l)) {
                            this.highlighter.markError(bl, scriptParser, n9, n, null);
                        }
                        if ((n20 = this.handleScriptError(n7, n8, errorDescriptor, scriptParser, n)) == 2) {
                            statementRunnerResult.setStopScript(true);
                            break;
                        }
                        if (n20 == 2042) {
                            bl10 = false;
                        }
                    }
                    ++n12;
                }
                ++n18;
                if (this.cancelExecution) break;
                if (n13 <= -1 || !this.shouldRunNextStatement(scriptParser, n10)) continue;
                ++n11;
            }
            this.lastScriptExecTime = l2;
            this.statusBar.setExecutionTime(l2);
            this.statusBar.clearStatusMessage();
            n7 = this.editor.isModifiedAfter(l) ? 1 : 0;
            bl5 = bl5 && n7 == 0;
            boolean bl16 = bl = bl && n7 == 0;
            if (n9 > -1 && !bl8) {
                bl6 = false;
                this.highlighter.markError(bl, scriptParser, n9, n, errorDescriptor);
            }
            if (n12 > 0) {
                this.appendToLog(ResourceMgr.getFormattedString("MsgTotalStatementsFailed", n12) + "\n");
            }
            if (bl3) {
                this.appendToLog(ResourceMgr.getFormattedString("MsgTotalStatementsExecuted", n18) + "\n");
                if (!bl12) {
                    this.appendToLog(ResourceMgr.getFormattedString("MsgRowsAffected", l3) + "\n");
                }
                this.appendToLog("\n");
            }
            this.ignoreStateChange = false;
            if (n19 > 0 && n9 == -1) {
                if (this.resultTab.getTabCount() - 1 == n6) {
                    int n21 = this.findResultToSelect();
                    if (n21 > -1) {
                        this.showResultPanel(n21);
                    }
                } else if (n4 > -1) {
                    this.showResultPanel(n4);
                }
            } else {
                this.showLogPanel();
            }
            String string16 = durationFormatter.formatDuration(this.lastScriptExecTime, Settings.getInstance().getDurationFormat(), this.lastScriptExecTime < 60000L);
            boolean bl17 = bl9 = n8 > 1 && GuiSettings.showScriptProgress();
            if (n8 > 1) {
                string8 = ResourceMgr.getString("TxtScriptFinished");
                if (GuiSettings.showScriptFinishTime()) {
                    string8 = string8 + " (" + StringUtil.getCurrentTimestamp() + ")";
                }
                this.appendToLog("\n" + string8);
                this.appendToLog("\n" + ResourceMgr.getString("MsgScriptExecTime") + " " + string16);
                if (!bl9) {
                    this.appendToLog("\n" + ResourceMgr.getFormattedString("MsgTotalStatementsExecuted", n18));
                }
            } else {
                if (!bl9) {
                    this.appendToLog("\n" + ResourceMgr.getString("MsgExecTime") + " " + string16 + "\n");
                }
                if (GuiSettings.showScriptFinishTime()) {
                    this.appendToLog("(" + StringUtil.getCurrentTimestamp() + ")\n");
                }
            }
            bl6 = bl6 && !GuiSettings.getKeepCurrentSqlHighlight() && n7 == 0;
            this.restoreSelection(bl5, bl4, bl6, n5, n2, n3, n9, n10, n11, scriptParser);
        }
        catch (LowMemoryException lowMemoryException) {
            WbManager.getInstance().showLowMemoryError();
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                if (statementRunnerResult != null) {
                    try {
                        this.stmtRunner.statementDone();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    statementRunnerResult.clearResultData();
                }
                WbManager.getInstance().showOutOfMemoryError();
            }
            LogMgr.logError(callerInfo, "Error executing statement", throwable);
            if (statementRunnerResult != null && statementRunnerResult.hasMessages()) {
                this.showLogMessage(statementRunnerResult.getMessages());
                statementRunnerResult.clear();
            } else {
                this.showLogMessage(throwable.getLocalizedMessage());
            }
        }
        finally {
            this.stmtRunner.done();
            this.ignoreStateChange = false;
        }
    }

    private boolean shouldAsk(int n, int n2) {
        if (GuiSettings.getErrorPromptType() == ErrorPromptType.PromptWithRetry) {
            if (n2 > 1) {
                return true;
            }
            return GuiSettings.retryForSingleStatement();
        }
        return n < n2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleScriptError(int n, int n2, ErrorDescriptor errorDescriptor, ScriptParser scriptParser, int n3) {
        this.iconHandler.showBusyIcon(false);
        int n4 = -1;
        ErrorPromptType errorPromptType = GuiSettings.getErrorPromptType();
        try {
            if (errorPromptType == ErrorPromptType.PromptWithRetry) {
                n4 = this.handleRetry(n, errorDescriptor, scriptParser, n3);
            } else {
                String string = ResourceMgr.getFormattedString("MsgScriptStatementError", n + 1, n2);
                if (errorDescriptor != null && errorDescriptor.getScriptFile() != null) {
                    string = string + "\n" + ResourceMgr.getFormattedString("MsgInFile", errorDescriptor.getScriptFile().getFullPath());
                }
                if (errorPromptType == ErrorPromptType.PromptWithErroressage) {
                    string = string + "\n" + ResourceMgr.getString("MsgScriptErrorLabel");
                }
                n4 = this.askContinue(errorDescriptor, string);
            }
        }
        finally {
            this.iconHandler.showBusyIcon(true);
        }
        return n4;
    }

    @Override
    public int scriptErrorPrompt(int n, ErrorDescriptor errorDescriptor, ScriptParser scriptParser, int n2) {
        int n3 = scriptParser != null && scriptParser.isFullyLoaded() ? scriptParser.getSize() : -1;
        return this.handleScriptError(n, n3, errorDescriptor, scriptParser, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleRetry(int n, ErrorDescriptor errorDescriptor, ScriptParser scriptParser, int n2) {
        ErrorRetryPanel errorRetryPanel = new ErrorRetryPanel(this.getConnection());
        errorRetryPanel.setEnableReplace(scriptParser != null);
        WbSwingUtilities.invoke(() -> {
            boolean bl = this.getConnection().isBusy();
            try {
                this.getConnection().setBusy(false);
                if (scriptParser != null) {
                    errorRetryPanel.setStatement(scriptParser, n, errorDescriptor);
                }
                errorRetryPanel.showDialog(WbSwingUtilities.getWindowAncestor(this));
            }
            finally {
                this.getConnection().setBusy(bl);
            }
        });
        int n3 = errorRetryPanel.getChoice();
        try {
            if (errorRetryPanel.getChoice() == 1042) {
                if (scriptParser != null && errorRetryPanel.shouldReplaceOriginalStatement()) {
                    int n4 = scriptParser.getStartPosForCommand(n) + n2;
                    int n5 = scriptParser.getEndPosForCommand(n) + n2;
                    this.editor.replaceText(n4, n5, errorRetryPanel.getStatement());
                }
                n3 = 3042;
            }
        }
        finally {
            errorRetryPanel.dispose();
        }
        return n3;
    }

    private int askContinue(ErrorDescriptor errorDescriptor, String string) {
        ErrorContinueDialog errorContinueDialog = new ErrorContinueDialog(errorDescriptor, string);
        int n = errorContinueDialog.askContinue(this);
        return n;
    }

    private boolean shouldRunNextStatement(ScriptParser scriptParser, int n) {
        if (!Settings.getInstance().getAutoRunExportStatement()) {
            return false;
        }
        if (this.stmtRunner == null) {
            return false;
        }
        if (this.stmtRunner.getConsumer() == null) {
            return false;
        }
        if (n + 1 < scriptParser.getSize()) {
            String string = this.stmtRunner.getParsingUtil().getSqlVerb(scriptParser.getCommand(n + 1));
            Collection<String> collection = Settings.getInstance().getAutoRunVerbs();
            if (collection.contains(string)) {
                return true;
            }
        }
        return false;
    }

    private void restoreSelection(boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6, ScriptParser scriptParser) {
        WbSwingUtilities.invoke(() -> this._restoreSelection(bl, bl2, bl3, n, n2, n3, n4, n5, n6, scriptParser));
    }

    private void _restoreSelection(boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4, int n5, int n6, ScriptParser scriptParser) {
        if (!bl || !GuiSettings.getKeepCurrentSqlHighlight()) {
            int n7;
            int n8;
            if (!bl2 && bl3 && n2 > -1 && n3 > -1) {
                n8 = n2;
                n7 = n3;
                this.editor.select(n8, n7);
            }
            if (bl && !bl3 && n4 == -1) {
                n8 = scriptParser.getStartPosForCommand(n6 - 1);
                if ((n8 = scriptParser.findNextLineStart(n8)) > -1 && n8 < this.editor.getText().length()) {
                    this.editor.setCaretPosition(n8);
                }
            }
            if (n4 == -1 && bl2) {
                n8 = n5 + 1;
                n7 = scriptParser.getStartPosForCommand(n8);
                if ((n7 = scriptParser.findNextLineStart(n7)) > -1) {
                    this.editor.setCaretPosition(n7);
                } else if (n2 > -1) {
                    this.editor.setCaretPosition(n2);
                }
            }
        } else if (bl && n > -1) {
            this.editor.setCaretPosition(n);
        }
    }

    private void showResultMessage(StatementRunnerResult statementRunnerResult) {
        if (!statementRunnerResult.hasMessages()) {
            return;
        }
        try {
            if (!MemoryWatcher.isMemoryLow(true)) {
                statementRunnerResult.appendMessages(this);
            } else {
                LogMgr.logError(new CallerInfo(){}, "Not enough memory to show all messages!", null);
            }
            this.appendToLog("\n");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            statementRunnerResult.clearMessageBuffer();
            this.clearLog();
            System.gc();
            WbManager.getInstance().setOutOfMemoryOcurred();
            boolean bl = statementRunnerResult.isSuccess();
            EventQueue.invokeLater(() -> {
                if (bl) {
                    this.log.append(ResourceMgr.getString("ErrLogNoMemSuccess"));
                } else {
                    this.log.append(ResourceMgr.getString("ErrLogNoMemError"));
                }
                this.log.append("\n");
                this.log.append(ResourceMgr.getString("ErrLogNoMemCheckLog"));
                this.log.append("\n");
                this.log.setCaretPosition(this.log.getDocument().getLength());
            });
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not show message!", throwable);
        }
    }

    private DwPanel createDwPanel(boolean bl) throws SQLException {
        DwPanel dwPanel = new DwPanel(this.statusBar);
        dwPanel.getTable().setTransposeRowEnabled(true);
        dwPanel.setBorder(WbSwingUtilities.EMPTY_BORDER);
        dwPanel.setConnection(this.dbConnection);
        dwPanel.setUpdateHandler(this);
        dwPanel.setSqlInfoEnabled(true);
        if (bl) {
            MainWindow mainWindow = null;
            try {
                mainWindow = (MainWindow)SwingUtilities.getWindowAncestor(this);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not find MainWindow!", exception);
                mainWindow = null;
            }
            if (mainWindow != null) {
                dwPanel.initTableNavigation(mainWindow);
            }
        }
        return dwPanel;
    }

    @Override
    public void showResult(String string, String string2, ResultReceiver.ShowType showType) {
        if (showType == ResultReceiver.ShowType.logText) {
            this.appendToLog("\n" + ResourceMgr.getString("MsgLoadRelatedData") + "\n" + string + "\n\n");
        } else if (showType != ResultReceiver.ShowType.showNone) {
            int n = this.editor.getDocumentLength();
            if (showType == ResultReceiver.ShowType.replaceText) {
                this.editor.setText("");
                n = 0;
            } else {
                if (StringUtil.isNonBlank(string2)) {
                    if (n > 1) {
                        this.editor.appendLine("\n");
                    }
                    this.editor.appendLine(string2 + "\n");
                } else {
                    this.editor.appendLine("\n\n");
                }
                n = this.editor.getDocumentLength();
            }
            this.editor.appendLine(string + ";\n");
            this.editor.setCaretPosition(n);
            this.editor.scrollToCaret();
        }
        this.startExecution(string2 + "\n" + string, 0, false, true, RunType.RunAll);
    }

    public void showData(DataStore dataStore) {
        CallerInfo callerInfo = new CallerInfo(){};
        WbSwingUtilities.invoke(() -> {
            try {
                DwPanel dwPanel = this.createDwPanel(false);
                dwPanel.showData(dataStore, dataStore.getGeneratingSql(), -1L);
                int n = this.addResultTab(dwPanel);
                if (n > 0 || this.resultTab.getTabCount() == 2) {
                    WbSwingUtilities.invokeLater(() -> this.resultTab.setSelectedIndex(n));
                }
            }
            catch (Exception exception) {
                LogMgr.logError(callerInfo, "Could not attach datastore", exception);
            }
        });
    }

    private int getNextResultNumber() {
        int n = this.resultTab.getTabCount();
        if (n <= 1) {
            return 1;
        }
        String string = ResourceMgr.getString("LblTabResult");
        int n2 = 0;
        for (int i = 0; i < n - 1; ++i) {
            int n3;
            String string2 = HtmlUtil.cleanHTML(this.resultTab.getTitleAt(i));
            if (string2 == null || !string2.startsWith(string) || (n3 = StringUtil.getIntValue(string2.replaceAll("[^0-9]", ""), -1)) <= n2) continue;
            n2 = n3;
        }
        return n2 + 1;
    }

    private int addResultTab(DwPanel dwPanel) {
        String string;
        int n = this.resultTab.getTabCount() - 1;
        WbTable wbTable = dwPanel.getTable();
        DataStore dataStore = wbTable != null ? wbTable.getDataStore() : null;
        String string2 = string = dataStore != null ? dataStore.getResultName() : null;
        if (StringUtil.isBlank(string)) {
            string = ResourceMgr.getString("LblTabResult") + " " + NumberStringCache.getNumberString(this.getNextResultNumber());
        } else if (wbTable != null) {
            wbTable.setPrintHeader(string);
        }
        this.resultTab.insertTab(string, null, dwPanel, null, n);
        dwPanel.showGeneratingSQLAsTooltip();
        dwPanel.checkLimitReachedDisplay();
        TableAnnotationProcessor tableAnnotationProcessor = new TableAnnotationProcessor();
        tableAnnotationProcessor.handleAnnotations(this, dwPanel, this.getRefreshMgr());
        this.checkAutoRefreshIndicator(dwPanel);
        this.updateLockedTitle(dwPanel);
        return n;
    }

    public void setSelectedResultTab(int n) {
        this.resultTab.setSelectedIndex(n);
    }

    public int getResultTabCount() {
        return this.resultTab.getTabCount();
    }

    private DwPanel findResultPanelByName(String string) {
        int n = this.resultTab.getTabCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.resultTab.getTitleAt(i);
            if (!StringUtil.equalStringIgnoreCase(string2, string)) continue;
            DwPanel dwPanel = (DwPanel)this.resultTab.getComponentAt(i);
            return dwPanel;
        }
        return null;
    }

    private boolean evaluateResultMode(List<WbAnnotation> list) {
        ResultAsTextMode resultAsTextMode = ResultAsTextAnnotation.getMode(list);
        boolean bl = this.cmdModeForScript;
        switch (resultAsTextMode) {
            case turnOff: {
                this.cmdModeForScript = false;
                bl = false;
                break;
            }
            case turnOn: {
                this.cmdModeForScript = true;
                bl = true;
                break;
            }
            case onceOnly: {
                bl = true;
            }
        }
        return bl;
    }

    public int addResult(StatementRunnerResult statementRunnerResult) throws SQLException {
        List<Object> list;
        if (statementRunnerResult == null) {
            return 0;
        }
        String string = statementRunnerResult.getSourceCommand();
        long l = statementRunnerResult.getExecutionDuration();
        int n = 0;
        ResultAsTextAnnotation resultAsTextAnnotation = new ResultAsTextAnnotation();
        UseTabAnnotation useTabAnnotation = new UseTabAnnotation();
        List<WbAnnotation> list2 = WbAnnotation.readAllAnnotations(string, useTabAnnotation, resultAsTextAnnotation);
        boolean bl = this.evaluateResultMode(list2);
        if (statementRunnerResult.hasDataStores()) {
            list = statementRunnerResult.getDataStores();
            n += list.size();
            ArrayList arrayList = new ArrayList(list.size());
            WbSwingUtilities.invoke(() -> {
                try {
                    int n = -1;
                    for (DataStore dataStore : list) {
                        List<WbAnnotation> list4;
                        String string2 = string;
                        if (StringUtil.isEmptyString(string)) {
                            string2 = dataStore.getGeneratingSql();
                            list4 = WbAnnotation.readAllAnnotations(string2, useTabAnnotation, resultAsTextAnnotation);
                        } else {
                            list4 = list2;
                        }
                        boolean bl2 = bl || this.evaluateResultMode(list2);
                        String string3 = list4.contains(useTabAnnotation) ? useTabAnnotation.getResultName(string) : null;
                        DwPanel dwPanel = null;
                        if (StringUtil.isNonEmpty(string3)) {
                            dataStore.setResultName(string3);
                            dwPanel = this.findResultPanelByName(string3);
                        }
                        if (dwPanel != null) {
                            dwPanel.showData(dataStore, string2, l);
                            arrayList.add(dwPanel);
                            dwPanel.setReUsed(true);
                            dwPanel.showGeneratingSQLAsTooltip();
                            continue;
                        }
                        if (bl2) {
                            this.showDataStoreAsText(dataStore, string2);
                            continue;
                        }
                        dwPanel = this.createDwPanel(true);
                        dwPanel.showData(dataStore, string2, l);
                        n = this.addResultTab(dwPanel);
                        arrayList.add(dwPanel);
                    }
                    if (n > -1) {
                        this.resultTab.setSelectedIndex(n);
                    }
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error when adding new DwPanel with DataStore", exception);
                }
            });
            if (GuiSettings.getRetrieveQueryComments()) {
                for (DwPanel dwPanel : arrayList) {
                    dwPanel.readColumnComments();
                }
            }
        }
        if (statementRunnerResult.hasResultSets()) {
            list = statementRunnerResult.getResultSets();
            n += list.size();
            WbSwingUtilities.invoke(() -> {
                int n = -1;
                try {
                    for (ResultSet resultSet : list) {
                        if (bl) {
                            this.showResultAsText(resultSet, string);
                            continue;
                        }
                        DwPanel dwPanel = this.createDwPanel(true);
                        dwPanel.showData(resultSet, string, l);
                        n = this.addResultTab(dwPanel);
                    }
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error when adding new DwPanel with ResultSet", exception);
                }
                if (n > -1) {
                    this.resultTab.setSelectedIndex(n);
                }
            });
        }
        if (n > 0 && this.contentPanel.getExpander().isUpperPartExpanded()) {
            this.contentPanel.getExpander().undoExpand();
        }
        return n;
    }

    private void showDataStoreAsText(DataStore dataStore, String string) {
        if (GuiSettings.includeQueryWithResultAsText()) {
            this.log.append(string);
            this.log.addLine("\n");
        }
        DataStorePrinter dataStorePrinter = new DataStorePrinter(dataStore);
        dataStorePrinter.setPrintRowCount(true);
        dataStorePrinter.printTo(this.log);
        this.log.addLine("");
    }

    private void showResultAsText(ResultSet resultSet, String string) {
        if (GuiSettings.includeQueryWithResultAsText()) {
            this.log.append(string);
            this.log.addLine("\n");
        }
        ResultSetPrinter resultSetPrinter = new ResultSetPrinter(this.log);
        resultSetPrinter.setPrintRowCount(true);
        resultSetPrinter.printResultSet(resultSet);
        this.log.addLine("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerToolWindow(ToolWindow toolWindow) {
        List<ToolWindow> list = this.resultWindows;
        synchronized (list) {
            this.resultWindows.add(toolWindow);
        }
        WbManager.getInstance().registerToolWindow(toolWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            return;
        }
        List<ToolWindow> list = this.resultWindows;
        synchronized (list) {
            this.resultWindows.remove(toolWindow);
        }
        WbManager.getInstance().unregisterToolWindow(toolWindow);
    }

    protected void checkResultSetActions() {
        boolean bl = this.dbConnection == null ? false : this.dbConnection.isSessionReadOnly();
        boolean bl2 = this.currentData != null ? this.currentData.hasResultSet() : false;
        boolean bl3 = bl2 && this.currentData.getTable().getRowCount() > 0;
        boolean bl4 = !bl && bl2 && this.currentData.hasUpdateableColumns();
        boolean bl5 = bl2 && this.currentData.getTable().canSearchAgain();
        this.setActionState(bl2, this.dataToClipboard, this.exportDataAction, this.optimizeAllCol, this.optimizeRowHeights, this.printDataAction, this.printPreviewAction);
        WbSwingUtilities.invoke(() -> {
            this.importFileAction.setEnabled(bl4);
            this.importClipAction.setEnabled(bl4);
            this.findDataAgainAction.setEnabled(bl5);
            this.copySelectedMenu.setEnabled(bl2);
            this.reloadAction.checkEnabled();
            this.showFormAction.setEnabled(bl3);
        });
    }

    private void setExecActionsState(boolean bl) {
        this.setActionState(bl, this.executeAll, this.executeCurrent, this.executeSelected, this.executeFromCurrent, this.executeToCursor);
        EventQueue.invokeLater(() -> {
            ConnectionInfo connectionInfo;
            if (this.toolbar != null && (connectionInfo = this.toolbar.getConnectionInfo()) != null) {
                connectionInfo.setDbSwitcherEnabled(bl);
            }
        });
    }

    private void setConnActionsState(boolean bl) {
        WbSwingUtilities.invoke(() -> {
            this.toggleAutoCommit.setEnabled(bl);
            if (bl) {
                this.checkCommitAction();
            } else {
                this.commitAction.setEnabled(bl);
                this.rollbackAction.setEnabled(bl);
            }
            this.spoolData.canExport(bl);
            this.appendResultsAction.setEnabled(bl);
            this.joinCompletion.setEnabled(bl);
        });
    }

    public void setBusy(boolean bl) {
        this.threadBusy = bl;
        if (this.iconHandler != null) {
            this.iconHandler.showBusyIcon(bl);
        }
        this.setConnActionsState(!bl);
        this.setExecActionsState(!bl);
        if (GuiSettings.getDisableEditorDuringExecution() && this.editor != null) {
            this.editor.setEditable(!bl);
        }
        if (this.sqlHistory != null) {
            this.sqlHistory.setEnabled(!bl);
        }
    }

    public boolean isConnectionBusy() {
        if (this.isBusy()) {
            return true;
        }
        if (this.dbConnection == null) {
            return false;
        }
        return this.dbConnection.isBusy();
    }

    @Override
    public boolean isBusy() {
        return this.threadBusy;
    }

    @Override
    public void addDbExecutionListener(DbExecutionListener dbExecutionListener) {
        this.execListener.add(dbExecutionListener);
    }

    @Override
    public void removeDbExecutionListener(DbExecutionListener dbExecutionListener) {
        if (this.execListener == null) {
            return;
        }
        this.execListener.remove(dbExecutionListener);
    }

    public void fireDbExecStart() {
        if (this.execListener != null) {
            for (DbExecutionListener dbExecutionListener : this.execListener) {
                if (dbExecutionListener == null) continue;
                dbExecutionListener.executionStart(this.dbConnection, this);
            }
        }
        if (this.dbConnection != null) {
            this.dbConnection.setBusy(true);
        }
    }

    public void fireDbExecEnd() {
        if (this.dbConnection != null) {
            this.dbConnection.setBusy(false);
        }
        if (this.execListener != null) {
            for (DbExecutionListener dbExecutionListener : this.execListener) {
                if (dbExecutionListener == null) continue;
                dbExecutionListener.executionEnd(this.dbConnection, this);
            }
        }
    }

    @Override
    public void reset() {
        this.locked = false;
        if (this.editor != null) {
            this.editor.reset();
        }
        this.clearLog();
        this.clearResultTabs(false);
        this.refreshMgr.clear();
        if (this.currentData != null) {
            this.currentData.dispose();
        }
        this.currentData = null;
        if (this.iconHandler != null) {
            this.iconHandler.flush();
        }
        if (this.sqlHistory != null) {
            this.sqlHistory.clear();
        }
        this.contentPanel.setDividerLocation(0.5);
    }

    @Override
    public void dispose() {
        Settings.getInstance().removePropertyChangeListener(this);
        this.disconnect();
        this.reset();
        if (this.iconHandler != null) {
            this.iconHandler.dispose();
        }
        if (this.stmtRunner != null) {
            this.stmtRunner.dispose();
        }
        if (this.tabDropHandler != null) {
            this.tabDropHandler.dispose();
        }
        this.execListener.clear();
        if (this.statusBar != null) {
            this.statusBar.removeTextSelectionDisplay(this.editor);
        }
        if (this.editor != null) {
            this.editor.dispose();
        }
        this.editor = null;
        if (this.actions != null) {
            for (Object object : this.actions) {
                if (!(object instanceof Disposable)) continue;
                ((Disposable)object).dispose();
            }
            this.actions.clear();
        }
        if (this.filenameChangeListeners != null) {
            this.filenameChangeListeners.clear();
        }
        if (this.toolbar != null) {
            this.toolbar.removeAll();
            this.toolbar = null;
        }
        this.forceAbort();
        this.executionThread = null;
        if (this.log != null) {
            this.log.dispose();
        }
        if (this.sqlHistory != null) {
            this.sqlHistory.dispose();
        }
        this.copyAsSQLMenu.dispose();
        this.copySelectedMenu.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if ("workbench.gui.toolbar.actions".equals(string)) {
            this.toolbar = null;
        }
        if (propertyChangeEvent.getSource() == this.dbConnection && "autocommit".equals(string)) {
            this.checkCommitAction();
        } else if (propertyChangeEvent.getSource() == this.currentData && string.equals("updateTable")) {
            this.checkResultSetActions();
        } else if ("workbench.gui.text.selection.summary".equals(string)) {
            if (GuiSettings.getShowTextSelectionSummary()) {
                this.statusBar.addTextSelectionDisplay(this.editor);
            } else {
                this.statusBar.removeTextSelectionDisplay(this.editor);
            }
        } else if ("workbench.gui.display.resulttab.closebutton".equals(string)) {
            if (GuiSettings.getShowResultTabCloseButton()) {
                this.resultTab.showCloseButton(this);
            } else {
                this.resultTab.showCloseButton(null);
            }
        }
    }

    @Override
    public boolean startMove(int n) {
        boolean bl;
        this.ignoreStateChange = bl = n != this.resultTab.getTabCount() - 1;
        this.hasMoved = false;
        return bl;
    }

    @Override
    public void endMove(int n) {
        this.ignoreStateChange = false;
        if (!this.hasMoved) {
            return;
        }
        if (this.resultTab.getSelectedIndex() != n) {
            this.resultTab.setSelectedIndex(n);
        } else {
            this.updateResultInfos();
        }
    }

    @Override
    public void moveCancelled() {
        this.ignoreStateChange = false;
    }

    @Override
    public boolean moveTab(int n, int n2) {
        Component component = this.resultTab.getComponentAt(n);
        if (n2 == this.resultTab.getTabCount() - 1) {
            return false;
        }
        String string = this.resultTab.getTitleAt(n);
        this.resultTab.remove(component);
        this.resultTab.add(component, n2);
        this.resultTab.setTitleAt(n2, string);
        this.hasMoved = true;
        return true;
    }

    @Override
    public boolean canCloseTab(int n) {
        return n != this.resultTab.getTabCount() - 1;
    }

    @Override
    public void tabCloseButtonClicked(int n) {
        if (!this.canCloseTab(n)) {
            return;
        }
        if (this.confirmDiscardChanges(n, true)) {
            this.discardResult(n, true);
        }
    }
}

