/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.tabhistory;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import workbench.gui.MainWindow;
import workbench.gui.sql.SqlHistoryEntry;
import workbench.gui.sql.SqlPanel;
import workbench.gui.tabhistory.ClosedTabInfo;
import workbench.interfaces.MainPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.util.FixedSizeList;
import workbench.util.NumberStringCache;

public class ClosedTabManager
implements ActionListener {
    private final FixedSizeList<ClosedTabInfo> recentTabs = new FixedSizeList(GuiSettings.getTabHistorySize());
    private final MainWindow client;

    public ClosedTabManager(MainWindow mainWindow) {
        this.recentTabs.setAllowDuplicates(true);
        this.client = mainWindow;
    }

    public void addToTabHistory(MainPanel mainPanel, int n) {
        if (mainPanel instanceof SqlPanel) {
            SqlPanel sqlPanel = (SqlPanel)mainPanel;
            List<SqlHistoryEntry> list = sqlPanel.getHistory().getEntries();
            String string = mainPanel.getTabTitle();
            ClosedTabInfo closedTabInfo = new ClosedTabInfo(string, list, n);
            closedTabInfo.setExternalFile(sqlPanel.getEditor().getCurrentFile(), sqlPanel.getEditor().getCurrentFileEncoding());
            this.recentTabs.add(closedTabInfo);
            LogMgr.logDebug(new CallerInfo(){}, "Recent tab added: " + closedTabInfo.toString());
        }
    }

    public void updateMenu(JMenu jMenu) {
        jMenu.removeAll();
        for (ClosedTabInfo closedTabInfo : this.recentTabs) {
            String string = closedTabInfo.getTabName();
            if (GuiSettings.getShowTabIndex()) {
                string = string + " " + NumberStringCache.getNumberString(closedTabInfo.getTabIndex() + 1);
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.putClientProperty("tab-info", closedTabInfo);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        jMenu.setEnabled(this.recentTabs.size() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.client == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (!(object instanceof JMenuItem)) {
            return;
        }
        JMenuItem jMenuItem = (JMenuItem)object;
        ClosedTabInfo closedTabInfo = (ClosedTabInfo)jMenuItem.getClientProperty("tab-info");
        if (closedTabInfo == null) {
            return;
        }
        SqlPanel sqlPanel = this.client.restoreTab(closedTabInfo.getTabIndex());
        if (sqlPanel != null) {
            this.recentTabs.remove(closedTabInfo);
            sqlPanel.getHistory().replaceHistory(closedTabInfo.getHistory());
            sqlPanel.setTabName(closedTabInfo.getTabName());
            this.client.updateTabHistoryMenu();
            if (closedTabInfo.getExternalFile() != null) {
                if (closedTabInfo.getExternalFile().exists()) {
                    sqlPanel.getEditor().readFile(closedTabInfo.getExternalFile(), closedTabInfo.getFileEncoding());
                } else {
                    LogMgr.logWarning(new CallerInfo(){}, "The tab \"" + closedTabInfo.getTabName() + "\" referenced the no longer existing file: " + closedTabInfo.getExternalFile().getAbsolutePath());
                }
            }
            closedTabInfo.clear();
        }
    }

    public void clear() {
        for (ClosedTabInfo closedTabInfo : this.recentTabs) {
            closedTabInfo.clear();
        }
        this.recentTabs.clear();
    }

    public void reset(JMenu jMenu) {
        this.clear();
        if (jMenu != null) {
            jMenu.removeAll();
            jMenu.setEnabled(false);
        }
    }
}

