/*
 * Decompiled with CFR 0.152.
 */
package workbench.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.HashMap;
import java.util.List;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.WbTable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.print.RenderUtils;
import workbench.print.TablePrintPage;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.WbThread;

public class TablePrinter
implements Printable,
Pageable {
    private PageFormat format;
    protected WbTable table;
    private int pageCount = -1;
    private Font printFont;
    private String headerText = null;
    private List<String> wrappedHeader = null;
    private TablePrintPage[] pages = null;
    private int pagesAcross = 0;
    private int pagesDown = 0;
    private int lineSpacing = 2;
    private int colSpacing = 5;
    private boolean showHeader;
    private boolean autoAdjustColumns = GuiSettings.getAutomaticOptimalWidth();
    private boolean useAlternateColor = GuiSettings.getAlternateRowColor() != null;

    public TablePrinter(WbTable wbTable) {
        PageFormat pageFormat = Settings.getInstance().getPageFormat();
        Font font = Settings.getInstance().getPrinterFont();
        this.init(wbTable, pageFormat, font);
    }

    private void init(WbTable wbTable, PageFormat pageFormat, Font font) {
        this.table = wbTable;
        this.printFont = font;
        this.format = pageFormat;
        String string = this.table.getPrintHeader();
        if (string != null) {
            this.setHeaderText(string);
        }
        this.calculatePages();
    }

    public void setUseAlternateColor(boolean bl) {
        if (bl != this.useAlternateColor) {
            this.useAlternateColor = bl;
            if (this.pages != null) {
                for (TablePrintPage tablePrintPage : this.pages) {
                    tablePrintPage.setUseAlternateColor(bl);
                }
            }
        }
    }

    public void setShowHeader(boolean bl) {
        if (bl != this.showHeader) {
            this.showHeader = bl;
            this.calculatePages();
        }
    }

    public void setAutoadjustColumns(boolean bl) {
        if (bl != this.autoAdjustColumns) {
            this.autoAdjustColumns = bl;
            this.calculatePages();
        }
    }

    public void setHeaderText(String string) {
        this.headerText = string;
    }

    public void setFont(Font font) {
        this.printFont = font;
        this.calculatePages();
    }

    public Font getFont() {
        return this.printFont;
    }

    public void startPrint() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.format == null) {
            this.setPageFormat(printerJob.defaultPage());
        }
        printerJob.setPrintable(this, this.format);
        printerJob.setPageable(this);
        WbThread wbThread = new WbThread("Print Thread"){

            @Override
            public void run() {
                try {
                    if (printerJob.printDialog()) {
                        RepaintManager.currentManager(TablePrinter.this.table).setDoubleBufferingEnabled(false);
                        printerJob.print();
                        RepaintManager.currentManager(TablePrinter.this.table).setDoubleBufferingEnabled(true);
                    }
                }
                catch (Exception exception) {
                    LogMgr.logWarning(new CallerInfo(){}, "Error during printing", exception);
                }
            }
        };
        wbThread.start();
    }

    public int getPagesAcross() {
        return this.pagesAcross;
    }

    public int getPreviousVerticalPage(int n) {
        if (n < 1) {
            return -1;
        }
        if (n >= this.pageCount) {
            return -1;
        }
        if (this.pagesAcross == 1) {
            return n - 1;
        }
        int n2 = this.pages[n].getPageNumberDown();
        for (int i = n; i > 0; --i) {
            int n3 = this.pages[i].getPageNumberDown();
            if (n3 >= n2) continue;
            return i;
        }
        return -1;
    }

    public int getNextVerticalPage(int n) {
        if (n < 0) {
            return -1;
        }
        if (n >= this.pageCount - 1) {
            return -1;
        }
        if (this.pagesAcross == 1) {
            return n + 1;
        }
        int n2 = this.pages[n].getPageNumberDown();
        for (int i = n; i < this.pageCount; ++i) {
            int n3 = this.pages[i].getPageNumberDown();
            if (n3 <= n2) continue;
            return i;
        }
        return -1;
    }

    public int getNextHorizontalPage(int n) {
        if (this.pagesAcross == 1) {
            return -1;
        }
        if (n < 0) {
            return -1;
        }
        if (n >= this.pageCount - 1) {
            return -1;
        }
        int n2 = this.pages[n].getPageNumberAcross();
        if (n2 == this.pagesAcross) {
            return -1;
        }
        return n + 1;
    }

    public int getPreviousHorizontalPage(int n) {
        if (this.pagesAcross == 1) {
            return -1;
        }
        if (n < 1) {
            return -1;
        }
        int n2 = this.pages[n].getPageNumberAcross();
        if (n2 == 1) {
            return -1;
        }
        return n - 1;
    }

    public PageFormat getPageFormat() {
        return this.format;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.format = pageFormat;
        if (this.format == null) {
            this.format = PrinterJob.getPrinterJob().defaultPage();
        }
        this.calculatePages();
    }

    private void calculateHeaderLines(FontMetrics fontMetrics, int n) {
        if (this.headerText == null || !this.showHeader) {
            this.wrappedHeader = null;
            return;
        }
        this.wrappedHeader = RenderUtils.wrap(this.headerText, fontMetrics, n);
    }

    private void calculatePages() {
        int n;
        if (this.format == null) {
            return;
        }
        if (this.table == null) {
            return;
        }
        int n2 = (int)this.format.getImageableWidth();
        int n3 = (int)this.format.getImageableHeight();
        if (this.printFont == null) {
            this.printFont = this.table.getFont();
        }
        FontMetrics fontMetrics = this.table.getFontMetrics(this.printFont);
        int n4 = fontMetrics.getHeight() + this.lineSpacing;
        int n5 = (n3 -= n4 + 10) / n4;
        int n6 = 0;
        if (this.headerText != null && this.showHeader) {
            this.calculateHeaderLines(fontMetrics, n2);
            n6 = this.wrappedHeader.size();
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n7 = tableColumnModel.getColumnCount();
        int n8 = this.table.getRowCount();
        this.pagesDown = (int)Math.ceil((double)(n8 + n6) / (double)(--n5));
        int n9 = 0;
        int[] nArray = this.calculateColumnWidths(fontMetrics);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        hashMap.put(0, 0);
        String[] stringArray = new String[n7];
        this.pagesAcross = 1;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        for (n = 0; n < n7; ++n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            String string = (String)tableColumn.getIdentifier();
            rectangle3.x = 0;
            rectangle3.y = 0;
            rectangle3.width = nArray[n];
            rectangle3.height = n4;
            rectangle.setBounds(0, 0, 0, 0);
            rectangle2.setBounds(0, 0, 0, 0);
            stringArray[n] = SwingUtilities.layoutCompoundLabel(fontMetrics, string, null, 1, 2, 1, 4, rectangle3, rectangle, rectangle2, 0);
            if (n9 + nArray[n] + this.colSpacing >= n2) {
                hashMap.put(this.pagesAcross, n);
                ++this.pagesAcross;
                n9 = 0;
            }
            n9 += nArray[n] + this.colSpacing;
        }
        n = 0;
        this.pageCount = this.pagesDown * this.pagesAcross;
        this.pages = new TablePrintPage[this.pageCount];
        int n10 = 0;
        for (int i = 0; i < this.pagesDown; ++i) {
            for (int j = 0; j < this.pagesAcross; ++j) {
                int n11 = (Integer)hashMap.get(j);
                int n12 = j + 1 >= this.pagesAcross ? n7 - 1 : (Integer)hashMap.get(j + 1) - 1;
                int n13 = n10 + n5;
                if (n == 0) {
                    n13 -= n6;
                }
                if (n13 >= n8) {
                    n13 = n8 - 1;
                }
                TablePrintPage tablePrintPage = new TablePrintPage(this.table, n10, n13, n11, n12, nArray);
                tablePrintPage.setPageIndex(n + 1);
                if (this.pagesAcross > 1) {
                    tablePrintPage.setPageNumberDown(i + 1);
                    tablePrintPage.setPageNumberAcross(j + 1);
                }
                tablePrintPage.setSpacing(this.lineSpacing, this.colSpacing);
                tablePrintPage.setColumnHeaders(stringArray);
                tablePrintPage.setFont(this.printFont);
                this.pages[n] = tablePrintPage;
                ++n;
            }
            n10 += n5 + 1;
        }
    }

    private int[] calculateColumnWidths(FontMetrics fontMetrics) {
        int n = this.table.getColumnCount();
        int[] nArray = new int[n];
        int n2 = (int)this.format.getImageableWidth();
        int n3 = GuiSettings.getMinColumnWidth();
        int n4 = n2;
        if (this.printFont.equals(this.table.getFont()) || !this.autoAdjustColumns) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                nArray[i] = Math.min(tableColumn.getWidth(), n2);
            }
        } else {
            ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(this.table);
            for (int i = 0; i < n; ++i) {
                nArray[i] = columnWidthOptimizer.calculateOptimalColumnWidth(i, n3, n4, true, fontMetrics);
            }
        }
        return nArray;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n >= this.pageCount) {
            return 1;
        }
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        graphics2D.setClip((int)d, (int)d2, n2, n3);
        graphics2D.translate(d, d2);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(this.printFont);
        TablePrintPage tablePrintPage = this.pages[n];
        StringBuilder stringBuilder = new StringBuilder(100);
        if (this.pagesAcross > 1) {
            stringBuilder.append(ResourceMgr.getFormattedString("TxtPageFooterHor", tablePrintPage.getPageNumberAcross(), this.pagesAcross, tablePrintPage.getPageNumberDown(), this.pagesDown));
        } else {
            stringBuilder.append(ResourceMgr.getFormattedString("TxtPageFooterNormal", tablePrintPage.getPageIndex(), this.pageCount));
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.printFont);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(stringBuilder.toString(), graphics2D);
        double d3 = rectangle2D.getWidth();
        graphics2D.drawString(stringBuilder.toString(), (int)(((double)n2 - d3) / 2.0), n3 - fontMetrics.getDescent());
        if (this.wrappedHeader != null && this.showHeader && n == 0) {
            int n4 = fontMetrics.getAscent();
            for (String string : this.wrappedHeader) {
                rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                graphics2D.drawString(string, 0, n4);
                n4 += fontMetrics.getAscent() + this.lineSpacing;
            }
            graphics2D.translate(0, n4 + this.lineSpacing);
        }
        tablePrintPage.print(graphics2D);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(null);
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return this.pageCount;
    }

    @Override
    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.format;
    }

    @Override
    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }
}

