/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.StringUtil;

public class WbAnnotation {
    private final String keyword;
    private String value;

    protected WbAnnotation(String string) {
        this.keyword = WbAnnotation.getTag(string);
    }

    public static String getTag(String string) {
        if (string.startsWith("@")) {
            return string.toLowerCase();
        }
        return "@" + string.toLowerCase();
    }

    public boolean needsValue() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getKeyWord() {
        return this.keyword;
    }

    public String getAnnotationValue(String string) {
        SQLToken sQLToken = this.getAnnotationToken(string);
        if (sQLToken == null) {
            return null;
        }
        return this.extractAnnotationValue(sQLToken);
    }

    public static List<WbAnnotation> readAllAnnotations(String string, WbAnnotation ... wbAnnotationArray) {
        if ((string = StringUtil.trimToNull(string)) == null || wbAnnotationArray == null) {
            return Collections.emptyList();
        }
        if (!string.startsWith("--") && !string.startsWith("/*")) {
            return Collections.emptyList();
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
        SQLToken sQLToken = sQLLexer.getNextToken(true, false);
        ArrayList<WbAnnotation> arrayList = new ArrayList<WbAnnotation>();
        while (sQLToken != null && sQLToken.isComment()) {
            String string2 = sQLToken.getText();
            string2 = WbAnnotation.stripCommentChars(string2.trim()).toLowerCase();
            for (WbAnnotation wbAnnotation : wbAnnotationArray) {
                int n;
                String string3 = wbAnnotation.getKeyWord();
                if (string3 == null || (n = string2.indexOf(string3)) < 0) continue;
                String string4 = null;
                WbAnnotation wbAnnotation2 = wbAnnotation.newInstance();
                if ((n += string3.length()) < string2.length() && Character.isWhitespace(string2.charAt(n))) {
                    string4 = WbAnnotation.extractAnnotationValue(sQLToken, string3);
                }
                if (string4 == null && wbAnnotation2.needsValue()) continue;
                wbAnnotation2.setValue(string4);
                arrayList.add(wbAnnotation2);
            }
            sQLToken = sQLLexer.getNextToken(true, false);
        }
        return arrayList;
    }

    private WbAnnotation newInstance() {
        try {
            return (WbAnnotation)this.getClass().newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean containsAnnotation(String string) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
        SQLToken sQLToken = sQLLexer.getNextToken(true, false);
        while (sQLToken != null && sQLToken.isComment()) {
            String string2 = sQLToken.getText();
            int n = (string2 = WbAnnotation.stripCommentChars(string2.trim())).toLowerCase().indexOf(this.keyword);
            if (n >= 0) {
                return true;
            }
            sQLToken = sQLLexer.getNextToken(true, false);
        }
        return false;
    }

    protected SQLToken getAnnotationToken(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        if (string.indexOf(64) == -1) {
            return null;
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(string);
        SQLToken sQLToken = sQLLexer.getNextToken(true, false);
        while (sQLToken != null && sQLToken.isComment()) {
            String string2 = sQLToken.getText();
            int n = (string2 = WbAnnotation.stripCommentChars(string2.trim())).toLowerCase().indexOf(this.keyword);
            if (n >= 0) {
                if ((n += this.keyword.length()) >= string2.length()) {
                    return null;
                }
                if (Character.isWhitespace(string2.charAt(n))) {
                    return sQLToken;
                }
            }
            sQLToken = sQLLexer.getNextToken(true, false);
        }
        return null;
    }

    protected String extractAnnotationValue(SQLToken sQLToken) {
        return WbAnnotation.extractAnnotationValue(sQLToken, this.keyword);
    }

    protected static String extractAnnotationValue(SQLToken sQLToken, String string) {
        if (sQLToken == null) {
            return null;
        }
        String string2 = sQLToken.getText();
        int n = (string2 = WbAnnotation.stripCommentChars(string2.trim())).toLowerCase().indexOf(string.toLowerCase());
        if (n >= 0) {
            if ((n += string.length()) >= string2.length()) {
                return null;
            }
            if (Character.isWhitespace(string2.charAt(n))) {
                int n2 = StringUtil.findPattern(StringUtil.PATTERN_CRLF, string2, n + 1);
                if (n2 == -1) {
                    n2 = string2.length();
                }
                return string2.substring(n + 1, n2);
            }
        }
        return null;
    }

    private static String stripCommentChars(String string) {
        if (string.startsWith("--")) {
            return string.substring(2);
        }
        if (string.startsWith("/*")) {
            return string.substring(2, string.length() - 2);
        }
        return string;
    }

    public int hashCode() {
        return this.keyword.toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WbAnnotation) {
            WbAnnotation wbAnnotation = (WbAnnotation)object;
            return this.keyword.equalsIgnoreCase(wbAnnotation.keyword);
        }
        return false;
    }

    public boolean is(String string) {
        return this.keyword.equals(WbAnnotation.getTag(string));
    }
}

