/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.wbcommands.WbFetchSize;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class SetCommand
extends SqlCommand {
    public static final String VERB = "SET";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = null;
        String string2 = null;
        int n = -1;
        String string3 = null;
        try {
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken != null) {
                string2 = sQLToken.getContents();
                n = sQLToken.getCharEnd();
            }
            if ((sQLToken = sQLLexer.getNextToken(false, false)) != null && sQLToken.getContents().equals("=")) {
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            if (sQLToken != null) {
                string3 = sQLToken.getContents();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not parse statement", exception);
            statementRunnerResult = new StatementRunnerResult();
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
            return statementRunnerResult;
        }
        boolean bl = true;
        boolean bl2 = false;
        if (string2 != null) {
            if (string2.equalsIgnoreCase("autocommit")) {
                statementRunnerResult = this.setAutocommit(this.currentConnection, string3);
                bl = false;
            } else if (string2.equalsIgnoreCase("maxrows")) {
                statementRunnerResult = new StatementRunnerResult();
                bl = false;
                try {
                    int n2 = Integer.parseInt(string3);
                    this.runner.setMaxRows(n2);
                    statementRunnerResult.setSuccess();
                    statementRunnerResult.addMessageByKey("MsgSetSuccess", string2, n2);
                }
                catch (Exception exception) {
                    statementRunnerResult.addErrorMessageByKey("MsgSetFailure", string3, string2);
                }
            } else if (string2.equalsIgnoreCase("timeout")) {
                statementRunnerResult = new StatementRunnerResult();
                bl = false;
                try {
                    int n3 = Integer.parseInt(string3);
                    this.runner.setQueryTimeout(n3);
                    statementRunnerResult.setSuccess();
                    statementRunnerResult.addMessageByKey("MsgSetSuccess", string2, n3);
                }
                catch (Exception exception) {
                    statementRunnerResult.addErrorMessageByKey("MsgSetFailure", string3, string2);
                }
            } else if ((string2.equalsIgnoreCase("schema") || string2.equalsIgnoreCase("search_path")) && this.canChangeSchema()) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("fetchsize")) {
                String string4 = string.substring(n).trim();
                statementRunnerResult = new StatementRunnerResult(string);
                WbFetchSize.setFetchSize(string4, statementRunnerResult, this.currentConnection);
                bl = false;
            } else if (this.currentConnection.getMetadata().isOracle()) {
                Set<String> set = CollectionUtil.caseInsensitiveSet("constraints", "constraint", "transaction", "role");
                object = Settings.getInstance().getListProperty("workbench.db.oracle.set.options", true, "");
                set.addAll((Collection<String>)object);
                bl = false;
                if (string2.equalsIgnoreCase("serveroutput")) {
                    statementRunnerResult = this.setServeroutput(this.currentConnection, string3);
                } else if (string2.equalsIgnoreCase("feedback")) {
                    statementRunnerResult = this.setFeedback(string3);
                } else if (string2.equalsIgnoreCase("autotrace")) {
                    statementRunnerResult = this.handleAutotrace(string.substring(n).trim());
                } else if (set.contains(string2)) {
                    bl = true;
                } else {
                    statementRunnerResult = new StatementRunnerResult();
                    if (Settings.getInstance().getShowIgnoredWarning()) {
                        statementRunnerResult.addMessageByKey("MsgCommandIgnored", this.getParsingUtil().getSqlVerb(string));
                    }
                    statementRunnerResult.setSuccess();
                }
            } else if (this.currentConnection.getMetadata().isFirebird()) {
                statementRunnerResult = new StatementRunnerResult(string);
                boolean bl3 = this.handleFirebird(statementRunnerResult, string);
                boolean bl4 = bl = !bl3;
            }
        }
        if (!bl) {
            return statementRunnerResult;
        }
        try {
            String string5 = null;
            object = null;
            if (bl2) {
                this.currentConnection.getMetadata().clearCachedSchemaInformation();
                string5 = string3;
                object = this.currentConnection.getCurrentSchema();
            }
            statementRunnerResult = new StatementRunnerResult();
            statementRunnerResult.ignoreUpdateCounts(true);
            String string6 = this.getSqlToExecute(string);
            this.currentStatement = this.currentConnection.createStatement();
            boolean bl5 = this.currentStatement.execute(string6);
            this.processResults(statementRunnerResult, bl5);
            statementRunnerResult.setSuccess();
            if (bl2) {
                String string7 = this.handleSchemaChange(string5, (String)object);
                statementRunnerResult.addMessageByKey("MsgSchemaChanged", string7);
            } else {
                this.appendSuccessMessage(statementRunnerResult);
            }
        }
        catch (Exception exception) {
            statementRunnerResult = new StatementRunnerResult();
            statementRunnerResult.clear();
            if (this.currentConnection.getMetadata().isOracle()) {
                statementRunnerResult.setSuccess();
                statementRunnerResult.addWarning(ResourceMgr.getString("MsgSetErrorIgnored") + ": " + exception.getMessage());
            } else {
                statementRunnerResult.addErrorMessage(exception.getMessage());
            }
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    private boolean canChangeSchema() {
        if (this.currentConnection == null) {
            return false;
        }
        DbSettings dbSettings = this.currentConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        return dbSettings.supportsSetSchema();
    }

    private boolean handleFirebird(StatementRunnerResult statementRunnerResult, String string) {
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken == null) {
            return false;
        }
        if (sQLToken.getText().equalsIgnoreCase("plan")) {
            sQLToken = sQLLexer.getNextToken(false, false);
            boolean bl = false;
            bl = sQLToken == null ? !this.runner.getBoolSessionAttribute("fb_showplan") : sQLToken.getText().equalsIgnoreCase("ON");
            this.runner.setSessionProperty("fb_showplan", Boolean.toString(bl));
            String string2 = bl ? "TxtOn" : "TxtOff";
            statementRunnerResult.addMessageByKey("MsgFbExecPlan", ResourceMgr.getString(string2));
            return true;
        }
        if (sQLToken.getText().equalsIgnoreCase("planonly")) {
            sQLToken = sQLLexer.getNextToken(false, false);
            sQLToken = sQLLexer.getNextToken(false, false);
            boolean bl = false;
            bl = sQLToken == null ? !this.runner.getBoolSessionAttribute("fb_planonly") : sQLToken.getText().equalsIgnoreCase("ON");
            this.runner.setSessionProperty("fb_planonly", Boolean.toString(bl));
            if (bl) {
                statementRunnerResult.addMessageByKey("MsgFbExecPlanNoResult");
            } else {
                statementRunnerResult.addMessageByKey("MsgFbExecPlanResult");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleSchemaChange(String string, String string2) {
        boolean bl = this.currentConnection.isBusy();
        String string3 = null;
        try {
            this.currentConnection.setBusy(false);
            LogMgr.logDebug(new CallerInfo(){}, "Updating current schema");
            string3 = this.currentConnection.getCurrentSchema();
            if (string3 == null) {
                string3 = string;
            }
            this.currentConnection.schemaChanged(string2, string3);
        }
        finally {
            this.currentConnection.setBusy(bl);
        }
        return string3;
    }

    private StatementRunnerResult handleAutotrace(String string) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        statementRunnerResult.setSuccess();
        if ("off".equalsIgnoreCase(string)) {
            this.runner.removeSessionProperty("autotrace");
            statementRunnerResult.addMessageByKey("MsgAutoTraceOff");
            return statementRunnerResult;
        }
        List<String> list = StringUtil.stringToList(string.toLowerCase(), " ");
        if (list.contains("on") || list.contains("traceonly") || list.contains("trace")) {
            this.runner.setSessionProperty("autotrace", StringUtil.listToString(list, ','));
            statementRunnerResult.addMessageByKey("MsgAutoTraceOn");
        } else {
            statementRunnerResult.addErrorMessageByKey("MsgAutoTraceUsage");
        }
        return statementRunnerResult;
    }

    private StatementRunnerResult setServeroutput(WbConnection wbConnection, String string) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        statementRunnerResult.setSuccess();
        if ("off".equalsIgnoreCase(string)) {
            wbConnection.getMetadata().disableOutput();
            if (OracleUtils.showSetServeroutputFeedback()) {
                statementRunnerResult.addMessageByKey("MsgDbmsOutputDisabled");
            } else {
                this.runner.removeSessionProperty("server_messages");
            }
        } else if ("on".equalsIgnoreCase(string)) {
            wbConnection.getMetadata().enableOutput();
            if (OracleUtils.showSetServeroutputFeedback()) {
                statementRunnerResult.addMessageByKey("MsgDbmsOutputEnabled");
            } else {
                this.runner.setSessionProperty("server_messages", "hide");
            }
        } else {
            statementRunnerResult.addErrorMessageByKey("ErrServeroutputWrongParameter");
        }
        return statementRunnerResult;
    }

    private StatementRunnerResult setAutocommit(WbConnection wbConnection, String string) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        if (StringUtil.isEmptyString(string)) {
            statementRunnerResult.addErrorMessageByKey("ErrAutocommitWrongParameter");
            return statementRunnerResult;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet("off", "false", "0");
        Set<String> set2 = CollectionUtil.caseInsensitiveSet("on", "true", "1");
        try {
            if (set.contains(string)) {
                wbConnection.setAutoCommit(false);
                statementRunnerResult.addMessageByKey("MsgAutocommitDisabled");
                statementRunnerResult.setSuccess();
            } else if (set2.contains(string)) {
                wbConnection.setAutoCommit(true);
                statementRunnerResult.addMessageByKey("MsgAutocommitEnabled");
                statementRunnerResult.setSuccess();
            } else {
                statementRunnerResult.addErrorMessageByKey("ErrAutocommitWrongParameter");
            }
        }
        catch (SQLException sQLException) {
            statementRunnerResult.addErrorMessage(sQLException.getMessage());
        }
        return statementRunnerResult;
    }

    private StatementRunnerResult setFeedback(String string) {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        if (StringUtil.isEmptyString(string)) {
            statementRunnerResult.addErrorMessageByKey("ErrFeedbackWrongParameter");
            return statementRunnerResult;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet("off", "false", "0");
        Set<String> set2 = CollectionUtil.caseInsensitiveSet("on", "true", "1");
        if (set.contains(string)) {
            this.runner.setVerboseLogging(false);
            statementRunnerResult.addMessageByKey("MsgFeedbackDisabled");
            statementRunnerResult.setSuccess();
        } else if (set2.contains(string)) {
            this.runner.setVerboseLogging(true);
            statementRunnerResult.addMessageByKey("MsgFeedbackEnabled");
            statementRunnerResult.setSuccess();
        } else {
            statementRunnerResult.addErrorMessageByKey("ErrFeedbackWrongParameter");
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return VERB;
    }
}

