/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.fksupport;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import workbench.db.DependencyNode;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.Settings;
import workbench.sql.fksupport.JoinCondition;
import workbench.util.TableAlias;

public class JoinColumnsDetector {
    private final TableAlias joinTable;
    private final TableAlias joinedTable;
    private final WbConnection connection;
    private boolean preferUsingOperator;
    private boolean alwaysUseParentheses = false;
    private GeneratedIdentifierCase keywordCase;
    private GeneratedIdentifierCase identifierCase;

    public JoinColumnsDetector(WbConnection wbConnection, TableAlias tableAlias, TableAlias tableAlias2) {
        this.joinTable = tableAlias;
        this.joinedTable = tableAlias2;
        this.connection = wbConnection;
        this.preferUsingOperator = Settings.getInstance().getJoinCompletionPreferUSING();
        this.identifierCase = Settings.getInstance().getFormatterIdentifierCase();
        this.keywordCase = Settings.getInstance().getFormatterKeywordsCase();
    }

    public void setAlwaysUseParentheses(boolean bl) {
        this.alwaysUseParentheses = bl;
    }

    public void setPreferUsingOperator(boolean bl) {
        this.preferUsingOperator = bl;
    }

    public void setKeywordCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.keywordCase = generatedIdentifierCase;
    }

    public void setIdentifierCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.identifierCase = generatedIdentifierCase;
    }

    public List<JoinCondition> getJoinConditions() throws SQLException {
        TableIdentifier tableIdentifier = this.connection.getObjectCache().getOrRetrieveTable(this.joinTable.getTable());
        TableIdentifier tableIdentifier2 = this.connection.getObjectCache().getOrRetrieveTable(this.joinedTable.getTable());
        if (tableIdentifier == null || tableIdentifier2 == null) {
            return Collections.emptyList();
        }
        List<JoinCondition> list = this.getJoinConditions(tableIdentifier, this.joinTable, tableIdentifier2, this.joinedTable);
        if (list.isEmpty()) {
            list = this.getJoinConditions(tableIdentifier2, this.joinedTable, tableIdentifier, this.joinTable);
        }
        return list;
    }

    private List<JoinCondition> getJoinConditions(TableIdentifier tableIdentifier, TableAlias tableAlias, TableIdentifier tableIdentifier2, TableAlias tableAlias2) throws SQLException {
        ArrayList<JoinCondition> arrayList = new ArrayList<JoinCondition>();
        List<DependencyNode> list = this.connection.getObjectCache().getReferencedTables(tableIdentifier2);
        for (DependencyNode dependencyNode : list) {
            if (!dependencyNode.getTable().equals(tableIdentifier)) continue;
            Map<String, String> map = dependencyNode.getColumns();
            JoinCondition joinCondition = new JoinCondition(tableAlias, tableAlias2, dependencyNode.getFkName(), map);
            joinCondition.setIdentifierCase(this.identifierCase);
            joinCondition.setKeywordCase(this.keywordCase);
            joinCondition.setPreferUsingOperator(this.preferUsingOperator);
            joinCondition.setUseParentheses(this.alwaysUseParentheses);
            arrayList.add(joinCondition);
        }
        return arrayList;
    }
}

