/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.generator;

import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.sql.generator.DefaultInsertGenerator;
import workbench.sql.generator.InsertType;
import workbench.util.VersionNumber;

public class PostgresInsertGenerator
extends DefaultInsertGenerator {
    public PostgresInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        super(tableIdentifier, list);
    }

    public PostgresInsertGenerator(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, WbConnection wbConnection) {
        super(tableIdentifier, list, wbConnection);
    }

    protected boolean is95() {
        return this.dbVersion.isNewerThan(new VersionNumber(9, 5));
    }

    @Override
    public boolean supportsType(InsertType insertType) {
        if (insertType == InsertType.Upsert) {
            return this.is95() && this.getPKColumns().size() > 0;
        }
        return super.supportsType(insertType) || insertType == InsertType.InsertIgnore;
    }

    @Override
    protected CharSequence buildFinalPart() {
        switch (this.getInsertType()) {
            case InsertIgnore: {
                return this.buildIgnore();
            }
            case Upsert: 
            case Merge: {
                return this.buildDoUpdate();
            }
        }
        return "";
    }

    private CharSequence buildIgnore() {
        return "\nON CONFLICT DO NOTHING";
    }

    private CharSequence buildDoUpdate() {
        String string = this.buildOnConflict();
        string = string + "\nDO UPDATE \n SET ";
        List<ColumnIdentifier> list = this.getKeyColumns();
        int n = 0;
        for (int i = 0; i < this.targetColumns.size(); ++i) {
            ColumnIdentifier columnIdentifier = (ColumnIdentifier)this.targetColumns.get(i);
            if (list.contains(columnIdentifier)) continue;
            if (n > 0) {
                string = string + ",\n      ";
            }
            String string2 = this.quoteHandler.quoteObjectname(columnIdentifier.getDisplayName());
            string = string + string2 + " = EXCLUDED." + string2;
            ++n;
        }
        return string;
    }

    private String buildOnConflict() {
        String string = "\nON CONFLICT (";
        List<ColumnIdentifier> list = this.getKeyColumns();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            String string2 = list.get(i).getDisplayName();
            string2 = this.quoteHandler.quoteObjectname(string2);
            string = string + string2;
        }
        string = string + ")";
        return string;
    }
}

