/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.lexer;

import java.io.Reader;
import workbench.db.WbConnection;
import workbench.sql.lexer.MySQLLexer;
import workbench.sql.lexer.NonStandardLexer;
import workbench.sql.lexer.PgEscapingLexer;
import workbench.sql.lexer.PostgresLexer;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SqlServerLexer;
import workbench.sql.lexer.StandardLexer;
import workbench.sql.parser.ParserType;
import workbench.util.CharSequenceReader;

public class SQLLexerFactory {
    public static SQLLexer createLexer() {
        StandardLexer standardLexer = new StandardLexer("");
        return standardLexer;
    }

    public static SQLLexer createLexer(WbConnection wbConnection) {
        ParserType parserType = ParserType.getTypeFromConnection(wbConnection);
        return SQLLexerFactory.createLexer(parserType, (CharSequence)"");
    }

    public static SQLLexer createLexer(CharSequence charSequence) {
        StandardLexer standardLexer = new StandardLexer(charSequence);
        return standardLexer;
    }

    public static SQLLexer createLexer(WbConnection wbConnection, String string) {
        ParserType parserType = ParserType.getTypeFromConnection(wbConnection);
        return SQLLexerFactory.createLexer(parserType, (CharSequence)string);
    }

    public static SQLLexer createLexer(WbConnection wbConnection, CharSequence charSequence) {
        ParserType parserType = ParserType.getTypeFromConnection(wbConnection);
        return SQLLexerFactory.createLexer(parserType, charSequence);
    }

    public static SQLLexer createLexerForDbId(String string, CharSequence charSequence) {
        ParserType parserType = ParserType.getTypeFromDBID(string);
        return SQLLexerFactory.createLexer(parserType, charSequence);
    }

    public static SQLLexer createLexer(ParserType parserType, CharSequence charSequence) {
        return SQLLexerFactory.createLexer(parserType, new CharSequenceReader(charSequence));
    }

    public static SQLLexer createLexer(ParserType parserType, Reader reader) {
        SQLLexer sQLLexer;
        switch (parserType) {
            case MySQL: {
                sQLLexer = new MySQLLexer(reader);
                break;
            }
            case SqlServer: {
                sQLLexer = new SqlServerLexer(reader);
                break;
            }
            case Postgres: {
                sQLLexer = new PostgresLexer(reader);
                break;
            }
            default: {
                sQLLexer = new StandardLexer(reader);
            }
        }
        return sQLLexer;
    }

    public static SQLLexer createNonStandardLexer(ParserType parserType, Reader reader) {
        if (parserType == ParserType.Postgres) {
            return new PgEscapingLexer(reader);
        }
        return new NonStandardLexer(reader);
    }

    public static SQLLexer createNonStandardLexer(ParserType parserType, String string) {
        if (parserType == ParserType.Postgres) {
            return new PgEscapingLexer(string);
        }
        return new NonStandardLexer(string);
    }
}

