/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.preparedstatement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import workbench.db.WbConnection;
import workbench.sql.preparedstatement.StatementParameters;
import workbench.util.SqlUtil;

public class PreparedStatementPool {
    private Map<String, StatementParameters> statements = new HashMap<String, StatementParameters>();
    private WbConnection dbConnection;

    public PreparedStatementPool(WbConnection wbConnection) {
        this.setConnection(wbConnection);
    }

    private void setConnection(WbConnection wbConnection) {
        this.done();
        this.dbConnection = wbConnection;
    }

    public void done() {
        this.dbConnection = null;
        if (this.statements != null) {
            this.statements.clear();
        }
    }

    public synchronized StatementParameters getParameters(String string) {
        return this.statements.get(this.getSqlToUse(string));
    }

    public synchronized boolean addPreparedStatement(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        if (string.indexOf(63) == -1) {
            return false;
        }
        String string2 = SqlUtil.makeCleanSql(string, false, false, true, this.dbConnection);
        if (string2.indexOf(63) == -1) {
            return false;
        }
        if (this.statements.containsKey(string = this.getSqlToUse(string))) {
            return true;
        }
        StatementParameters statementParameters = new StatementParameters(string, this.dbConnection);
        if (!statementParameters.hasParameter()) {
            return false;
        }
        this.statements.put(string, statementParameters);
        return true;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.dbConnection == null) {
            throw new NullPointerException("No SQL Connection!");
        }
        StatementParameters statementParameters = this.getParameters(string = this.getSqlToUse(string));
        if (statementParameters == null) {
            throw new IllegalArgumentException("SQL Statement has not been registered with pool");
        }
        PreparedStatement preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
        statementParameters.applyParameter(preparedStatement);
        return preparedStatement;
    }

    private String getSqlToUse(String string) {
        if (this.dbConnection.getDbSettings().useCleanSQLForPreparedStatements()) {
            return SqlUtil.makeCleanSql(string, false, false);
        }
        return string;
    }

    public synchronized boolean isRegistered(String string) {
        return this.statements.containsKey(this.getSqlToUse(string));
    }
}

