/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.CallableStatement;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.WbManager;
import workbench.console.ConsolePrompter;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureDefinition;
import workbench.db.oracle.DbmsOutput;
import workbench.db.oracle.OracleProcedureReader;
import workbench.db.oracle.OracleUtils;
import workbench.gui.preparedstatement.ParameterEditor;
import workbench.interfaces.StatementParameterPrompter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.preparedstatement.ParameterDefinition;
import workbench.sql.preparedstatement.StatementParameters;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.storage.reader.CallableStmtResultHolder;
import workbench.storage.reader.ResultHolder;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbCall
extends SqlCommand {
    public static final String EXEC_VERB_SHORT = "EXEC";
    public static final String EXEC_VERB_LONG = "EXECUTE";
    public static final String VERB = "WbCall";
    private Map<Integer, ParameterDefinition> refCursor = null;
    private List<ParameterDefinition> inputParameters = new ArrayList<ParameterDefinition>(5);
    private String sqlUsed = null;
    private StatementParameterPrompter parameterPrompter = WbManager.getInstance().isConsoleMode() ? new ConsolePrompter() : ParameterEditor.GUI_PROMPTER;

    @Override
    public String getVerb() {
        return VERB;
    }

    private String getSqlToPrepare(String string, boolean bl) {
        if (bl) {
            return "{? =  call " + string + "}";
        }
        return "{call " + string + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        SqlParsingUtil sqlParsingUtil = this.getParsingUtil();
        String string2 = sqlParsingUtil.getSqlVerb(string).toUpperCase();
        String string3 = sqlParsingUtil.stripVerb(string);
        if (OracleUtils.shouldTrimContinuationCharacter(this.currentConnection)) {
            string3 = OracleUtils.trimSQLPlusLineContinuation(string3);
        }
        this.sqlUsed = this.getSqlToPrepare(string3, false);
        this.inputParameters.clear();
        CallerInfo callerInfo = new CallerInfo(){};
        List<ParameterDefinition> list = null;
        try {
            Object object2;
            this.refCursor = null;
            object = this.currentConnection.getSqlConnection().prepareCall(this.sqlUsed);
            this.currentStatement = object;
            boolean bl = this.sqlUsed.indexOf(63) > -1;
            boolean bl2 = false;
            Savepoint savepoint = null;
            if (bl) {
                try {
                    if (this.currentConnection.getDbSettings().useSavePointForDML()) {
                        savepoint = this.currentConnection.setSavepoint();
                    }
                    list = this.checkParametersFromStatement((CallableStatement)object);
                    bl2 = false;
                    this.currentConnection.releaseSavepoint(savepoint);
                }
                catch (Throwable throwable) {
                    LogMgr.logWarning(callerInfo, "Could not get parameters from statement!", throwable);
                    JdbcUtils.closeStatement((Statement)object);
                    this.currentConnection.rollback(savepoint);
                }
                finally {
                    savepoint = null;
                }
            }
            if (CollectionUtil.isEmpty(list) && string2.equals("WBCALL")) {
                try {
                    if (this.currentConnection.getDbSettings().useSavePointForDML()) {
                        savepoint = this.currentConnection.setSavepoint();
                    }
                    list = this.checkParametersFromDatabase(string3);
                    bl2 = true;
                    if (this.currentStatement != null) {
                        object = (CallableStatement)this.currentStatement;
                    }
                    this.currentConnection.releaseSavepoint(savepoint);
                }
                catch (Throwable throwable) {
                    LogMgr.logError(callerInfo, "Error during procedure check", throwable);
                    this.currentConnection.rollback(savepoint);
                }
                finally {
                    savepoint = null;
                }
            }
            if (bl && this.inputParameters.size() > 0 && this.parameterPrompter != null) {
                StatementParameters statementParameters = new StatementParameters(this.inputParameters);
                boolean bl3 = this.parameterPrompter.showParameterDialog(statementParameters, bl2);
                if (!bl3) {
                    statementRunnerResult.addErrorMessageByKey("MsgStatementCancelled");
                    StatementRunnerResult statementRunnerResult2 = statementRunnerResult;
                    return statementRunnerResult2;
                }
                for (ParameterDefinition parameterDefinition : this.inputParameters) {
                    int n = parameterDefinition.getType();
                    int n2 = parameterDefinition.getIndex();
                    object2 = parameterDefinition.getValue();
                    object.setObject(n2, object2, n);
                }
            }
            boolean bl4 = object != null ? object.execute() : false;
            statementRunnerResult.setSuccess();
            if (this.refCursor != null) {
                for (Map.Entry<Integer, ParameterDefinition> entry : this.refCursor.entrySet()) {
                    try {
                        List<DataStore> list2;
                        ResultSet resultSet = (ResultSet)object.getObject(entry.getKey());
                        if (resultSet != null) {
                            this.processResults(statementRunnerResult, true, resultSet);
                        }
                        if (!CollectionUtil.isNonEmpty(list2 = statementRunnerResult.getDataStores()) || entry.getValue() == null) continue;
                        DataStore dataStore = list2.get(list2.size() - 1);
                        dataStore.setGeneratingSql(string);
                        if (dataStore.getResultName() != null || !StringUtil.isNonBlank((CharSequence)(object2 = entry.getValue().getParameterName()))) continue;
                        dataStore.setResultName((String)object2);
                    }
                    catch (Exception exception) {
                        statementRunnerResult.addMessage(ExceptionUtil.getDisplay(exception));
                    }
                }
            } else {
                this.processResults(statementRunnerResult, bl4);
            }
            if (CollectionUtil.isNonEmpty(list)) {
                String[] stringArray = new String[]{"PARAMETER", "VALUE"};
                int[] nArray = new int[]{12, 12};
                int[] nArray2 = new int[]{35, 35};
                DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
                ParameterDefinition.sortByIndex(list);
                RowDataReader rowDataReader = this.createReader(list);
                object2 = new CallableStmtResultHolder((CallableStatement)object);
                for (ParameterDefinition parameterDefinition : list) {
                    if (this.refCursor != null && this.refCursor.containsKey(parameterDefinition.getIndex())) continue;
                    Object object3 = object.getObject(parameterDefinition.getIndex());
                    if (object3 instanceof ResultSet) {
                        this.processResults(statementRunnerResult, true, (ResultSet)object3);
                        continue;
                    }
                    LogMgr.logDebug(callerInfo, "Reading parameter=" + parameterDefinition.getParameterName() + ", mode=" + parameterDefinition.getModeString() + ", index=" + parameterDefinition.getIndex() + ", type=" + SqlUtil.getTypeName(parameterDefinition.getType()) + " (" + parameterDefinition.getType() + ")");
                    Object object4 = rowDataReader.readColumnData((ResultHolder)object2, parameterDefinition.getType(), parameterDefinition.getIndex(), true);
                    int n = dataStore.addRow();
                    dataStore.setValue(n, 0, (Object)parameterDefinition.getParameterName());
                    dataStore.setValue(n, 1, object4 == null ? "NULL" : object4);
                }
                dataStore.resetStatus();
                statementRunnerResult.addDataStore(dataStore);
            }
        }
        catch (Exception exception) {
            this.processResults(statementRunnerResult, false);
            LogMgr.logError(new CallerInfo(){}, "Error calling stored procedure using: " + this.sqlUsed, exception);
            statementRunnerResult.addMessageByKey("MsgExecuteError");
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
        }
        finally {
            this.done();
        }
        if (statementRunnerResult.isSuccess()) {
            LogMgr.logDebug(new CallerInfo(){}, "Converted procedure call to JDBC syntax: " + this.sqlUsed);
            object = null;
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string3);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken != null) {
                object = sQLToken.getText();
            }
            statementRunnerResult.addMessageByKey("MsgKnownStatementOK", object);
        }
        return statementRunnerResult;
    }

    private RowDataReader createReader(List<ParameterDefinition> list) {
        ColumnIdentifier[] columnIdentifierArray = new ColumnIdentifier[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ColumnIdentifier columnIdentifier;
            ParameterDefinition parameterDefinition = list.get(i);
            columnIdentifierArray[i] = columnIdentifier = new ColumnIdentifier(parameterDefinition.getParameterName(), parameterDefinition.getType());
        }
        ResultInfo resultInfo = new ResultInfo(columnIdentifierArray);
        return RowDataReaderFactory.createReader(resultInfo, this.currentConnection);
    }

    @Override
    protected void appendOutput(StatementRunnerResult statementRunnerResult) {
        super.appendOutput(statementRunnerResult);
        if (this.retrieveDbmsOutput()) {
            try {
                DbmsOutput dbmsOutput = new DbmsOutput(this.currentConnection.getSqlConnection());
                String string = dbmsOutput.retrieveOutput();
                if (StringUtil.isNonEmpty(string)) {
                    statementRunnerResult.addMessage(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean retrieveDbmsOutput() {
        if (this.currentConnection == null) {
            return false;
        }
        if (!this.currentConnection.getMetadata().isOracle()) {
            return false;
        }
        if (this.currentConnection.getMetadata().isDbmsOutputEnabled()) {
            return false;
        }
        return Settings.getInstance().retrieveDbmsOutputAfterExec();
    }

    @Override
    public void done() {
        super.done();
        if (this.refCursor != null) {
            this.refCursor.clear();
        }
        this.refCursor = null;
        this.inputParameters.clear();
    }

    private List<ParameterDefinition> checkParametersFromStatement(CallableStatement callableStatement) throws SQLException {
        if (!this.currentConnection.getDbSettings().supportsParameterMetaDataForCallableStatement()) {
            return null;
        }
        ArrayList<ParameterDefinition> arrayList = null;
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        if (parameterMetaData != null) {
            arrayList = new ArrayList<ParameterDefinition>();
            for (int i = 0; i < parameterMetaData.getParameterCount(); ++i) {
                int n = parameterMetaData.getParameterMode(i + 1);
                int n2 = parameterMetaData.getParameterType(i + 1);
                ParameterDefinition parameterDefinition = new ParameterDefinition(i + 1, n2);
                parameterDefinition.setParameterMode(n);
                if (n == 4 || n == 2) {
                    callableStatement.registerOutParameter(i + 1, n2);
                    arrayList.add(parameterDefinition);
                }
                if (n != 1 && n != 2) continue;
                this.inputParameters.add(parameterDefinition);
            }
        }
        return arrayList;
    }

    private List<ParameterDefinition> checkParametersFromDatabase(String string) throws SQLException {
        int n;
        Object object2;
        List<Object> list;
        String string2;
        List<String> list2 = SqlUtil.getFunctionParameters(string);
        DbMetadata dbMetadata = this.currentConnection.getMetadata();
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        String string3 = null;
        String string4 = null;
        String string5 = string2 = sQLToken == null ? "" : sQLToken.getContents();
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split("\\.");
        if (dbMetadata.isOracle()) {
            if (stringArray.length == 3) {
                string3 = stringArray[0];
                string4 = stringArray[1].toUpperCase();
                string2 = stringArray[2];
            }
            if (stringArray.length == 2) {
                string2 = stringArray[1];
                list = this.currentConnection.getMetadata().getSchemas();
                if (list.contains(stringArray[0].toUpperCase())) {
                    string3 = stringArray[0];
                } else {
                    string3 = null;
                    string4 = stringArray[0].toUpperCase();
                }
            }
            if ((object2 = ((OracleProcedureReader)((Object)(list = (OracleProcedureReader)this.currentConnection.getMetadata().getProcedureReader()))).resolveSynonym(string4, string3, string2)) != null) {
                string3 = ((ProcedureDefinition)object2).getSchema();
                string4 = ((ProcedureDefinition)object2).getCatalog();
            }
        } else if (stringArray.length == 2) {
            string3 = stringArray[0];
            string2 = stringArray[1];
        }
        list = null;
        object2 = SqlUtil.removeObjectQuotes(dbMetadata.adjustSchemaNameCase(string3));
        if (object2 == null) {
            object2 = dbMetadata.getCurrentSchema();
        }
        String string6 = SqlUtil.removeObjectQuotes(dbMetadata.adjustObjectnameCase(string2));
        ProcedureDefinition object3 = null;
        DataStore dataStore = null;
        List<ProcedureDefinition> list3 = dbMetadata.getProcedureReader().getProcedureList(string4, (String)object2, string6);
        if (list3.size() == 1) {
            object3 = list3.get(0);
        } else if (list3.size() > 1) {
            ArrayList<DataStore> arrayList = new ArrayList<DataStore>(list3.size());
            for (ProcedureDefinition object4 : list3) {
                dataStore = dbMetadata.getProcedureReader().getProcedureColumns(object4);
                arrayList.add(dataStore);
                n = dataStore.getRowCount();
                if (object4.isFunction()) {
                    --n;
                }
                if (n != list2.size()) continue;
                object3 = object4;
                break;
            }
            if (object3 == null) {
                object3 = list3.get(0);
                dataStore = (DataStore)arrayList.get(0);
            }
        } else {
            object3 = new ProcedureDefinition(string4, (String)object2, string6);
        }
        if (dataStore == null) {
            dataStore = dbMetadata.getProcedureReader().getProcedureColumns(object3);
        }
        int n2 = 0;
        boolean bl = ProcedureDefinition.returnsRefCursor(this.currentConnection, dataStore);
        if (!bl && this.isFunction(object3, dataStore)) {
            bl = true;
            n2 = 1;
        }
        this.sqlUsed = this.getSqlToPrepare(string, bl);
        if (dbMetadata.isOracle() && !bl && !this.hasPlaceHolder(list2)) {
            return null;
        }
        if (this.currentStatement != null) {
            JdbcUtils.closeStatement(this.currentStatement);
        }
        CallableStatement callableStatement = this.currentConnection.getSqlConnection().prepareCall(this.sqlUsed);
        this.currentStatement = callableStatement;
        n = dataStore.getRowCount();
        if (dbMetadata.isOracle() && n != list2.size() && !bl) {
            return null;
        }
        if (n != list2.size() && object3.isFunction() && n - 1 != list2.size()) {
            list2 = null;
        }
        this.inputParameters.clear();
        if (n > 0) {
            int n3 = 1 + n2;
            int n4 = 0;
            list = new ArrayList<ParameterDefinition>(n);
            for (int i = 0; i < n; ++i) {
                int n5 = dataStore.getValueAsInt(i, 3, -1);
                String string7 = dataStore.getValueAsString(i, 2);
                String string8 = dataStore.getValueAsString(i, 1);
                String string9 = dataStore.getValueAsString(i, 0);
                int n6 = n3;
                if (string8.equals("RETURN")) {
                    n6 = 1;
                }
                ParameterDefinition parameterDefinition = new ParameterDefinition(n6, n5);
                parameterDefinition.setParameterName(string9 == null ? string8 : string9);
                boolean bl2 = string8.equals("IN");
                boolean bl3 = ProcedureDefinition.isRefCursor(this.currentConnection, string7);
                if (string8.equals("INOUT")) {
                    boolean bl4 = bl2 = !bl3;
                }
                if (bl2) {
                    if (list2 != null) {
                        if (list2.get(n4).equals("?")) {
                            this.inputParameters.add(parameterDefinition);
                            if (string8.equals("INOUT")) {
                                list.add(parameterDefinition);
                                callableStatement.registerOutParameter(n3, n5);
                            }
                            ++n3;
                        }
                    } else {
                        this.inputParameters.add(parameterDefinition);
                        ++n3;
                    }
                } else if (string8.endsWith("OUT") || bl && StringUtil.equalString(string8, "RETURN")) {
                    if (bl3) {
                        int n7 = this.currentConnection.getDbSettings().getRefCursorDataType();
                        if (n7 != Integer.MIN_VALUE) {
                            n5 = n7;
                        }
                        if (this.refCursor == null) {
                            this.refCursor = new HashMap<Integer, ParameterDefinition>();
                        }
                        this.refCursor.put(n3, parameterDefinition);
                    } else {
                        list.add(parameterDefinition);
                    }
                    if (bl && StringUtil.equalString(string8, "RETURN") && n2 == 1) {
                        callableStatement.registerOutParameter(n2, n5);
                    } else {
                        callableStatement.registerOutParameter(n3, n5);
                        ++n3;
                    }
                }
                if (string8.equals("RETURN")) continue;
                ++n4;
            }
        }
        return list;
    }

    private boolean isFunction(ProcedureDefinition procedureDefinition, DataStore dataStore) {
        if (this.currentConnection.getMetadata().isPostgres()) {
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                String string = dataStore.getValueAsString(i, 1);
                if (!"RETURN".equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        return ProcedureDefinition.isFunction(procedureDefinition, dataStore);
    }

    private boolean hasPlaceHolder(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (String string : list) {
            if (string.indexOf(63) <= -1) continue;
            return true;
        }
        return false;
    }

    public void setParameterPrompter(StatementParameterPrompter statementParameterPrompter) {
        this.parameterPrompter = statementParameterPrompter;
    }

    public String getSqlUsed() {
        return this.sqlUsed;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

