/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ExceptionUtil;

public class WbSetSchema
extends SqlCommand {
    public static final String VERB = "WbSetSchema";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        try {
            String string2 = this.getCommandLine(string);
            String string3 = this.currentConnection.getCurrentSchema();
            this.currentConnection.getSqlConnection().setSchema(string2);
            this.notifySchemaChange(string3, string2);
            statementRunnerResult.addMessageByKey("MsgSchemaChanged", string2);
            statementRunnerResult.setSuccess();
        }
        catch (Exception exception) {
            if (this.currentConnection.getDbSettings().treatSchemaChangeErrorAsWarning()) {
                statementRunnerResult.addWarning(ExceptionUtil.getAllExceptions(exception).toString());
            } else {
                statementRunnerResult.addMessageByKey("MsgExecuteError");
                statementRunnerResult.addErrorMessage(ExceptionUtil.getAllExceptions(exception).toString());
            }
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String notifySchemaChange(String string, String string2) {
        boolean bl = this.currentConnection.isBusy();
        try {
            this.currentConnection.setBusy(false);
            this.currentConnection.schemaChanged(string, string2);
        }
        finally {
            this.currentConnection.setBusy(bl);
        }
        return string2;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    public String getVerb() {
        return VERB;
    }
}

