/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbDriver;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.BatchRunner;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ConnectionDescriptor;
import workbench.sql.wbcommands.InvalidConnectionDescriptor;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.StringUtil;

public class WbCreateProfile
extends SqlCommand {
    public static final String VERB = "WbCreateProfile";
    public static final String ARG_DRV_NAME = "driverName";

    public WbCreateProfile() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("name");
        this.cmdLine.addArgument("savePassword", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("autocommit");
        this.cmdLine.addArgument("driverclass");
        this.cmdLine.addArgument("driver");
        this.cmdLine.addArgument("driverjar");
        this.cmdLine.addArgument("password");
        this.cmdLine.addArgument("url");
        this.cmdLine.addArgument("username");
        this.cmdLine.addArgument("sshHost");
        this.cmdLine.addArgument("sshPrivateKey", ArgumentType.Filename);
        this.cmdLine.addArgument("sshPassword");
        this.cmdLine.addArgument("sshUser");
        this.cmdLine.addArgument("sshDBHost");
        this.cmdLine.addArgument("sshDBPort");
        this.cmdLine.addArgument("fetchSize");
        this.cmdLine.addArgument("emptyStringIsNull");
        this.cmdLine.addArgument("altDelimiter");
        this.cmdLine.addArgument("separateConnection");
        this.cmdLine.addArgument("trimCharData");
        this.cmdLine.addArgument("removeComments");
        this.cmdLine.addArgument("checkUncommitted");
        this.cmdLine.addArgument("readOnly");
        this.cmdLine.addArgument("connectionProperties");
        this.cmdLine.addArgument("emptyStringIsNull");
        this.cmdLine.addArgument(ARG_DRV_NAME);
        this.cmdLine.addArgument("profilegroup");
        this.cmdLine.addArgument("connection");
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        String string2 = this.cmdLine.getValue("name");
        if (StringUtil.isBlank(string2)) {
            statementRunnerResult.addErrorMessageByKey("ErrNoProfile");
            return statementRunnerResult;
        }
        try {
            ConnectionProfile connectionProfile = BatchRunner.createCmdLineProfile(this.cmdLine, false);
            DbDriver dbDriver = this.getDriverFromCommandline();
            connectionProfile.setDriver(dbDriver);
            connectionProfile.setName(string2);
            connectionProfile.setTemporaryProfile(false);
            connectionProfile.setStorePassword(this.cmdLine.getBoolean("savePassword", true));
            connectionProfile.setStoreExplorerSchema(false);
            String string3 = this.cmdLine.getValue("profilegroup");
            if (string3 != null) {
                connectionProfile.setGroup(string3);
            }
            ConnectionMgr.getInstance().addProfile(connectionProfile);
            ConnectionMgr.getInstance().saveProfiles();
            ConnectionMgr.getInstance().saveDrivers();
            statementRunnerResult.addMessageByKey("MsgProfileAdded", connectionProfile.getKey().toString());
        }
        catch (InvalidConnectionDescriptor invalidConnectionDescriptor) {
            LogMgr.logError(new CallerInfo(){}, "Invalid connection descriptor specified", invalidConnectionDescriptor);
            statementRunnerResult.addErrorMessageByKey("ErrInvalidConnection");
        }
        return statementRunnerResult;
    }

    private DbDriver getDriverFromCommandline() {
        DbDriver dbDriver = null;
        String string = this.cmdLine.getValue("url");
        String string2 = this.cmdLine.getValue("driver");
        if (string2 == null) {
            string2 = this.cmdLine.getValue("driverclass");
        }
        boolean bl = false;
        String string3 = this.cmdLine.getValue("driverjar");
        String string4 = this.cmdLine.getValue(ARG_DRV_NAME);
        if (string4 != null) {
            List<DbDriver> list = ConnectionMgr.getInstance().getDrivers();
            for (DbDriver dbDriver2 : list) {
                if (!dbDriver2.getName().equalsIgnoreCase(string4)) continue;
                dbDriver = dbDriver2;
                bl = true;
                break;
            }
        } else if (string2 != null) {
            dbDriver = ConnectionMgr.getInstance().findDriverByClass(string2);
            if (dbDriver != null) {
                bl = true;
                if (!dbDriver.canReadLibrary() && string3 != null) {
                    dbDriver.setLibrary(string3);
                }
            }
        } else {
            string2 = ConnectionDescriptor.findDriverClassFromUrl(string);
            dbDriver = ConnectionMgr.getInstance().findDriver(string2);
            if (dbDriver != null && !dbDriver.canReadLibrary() && string3 != null) {
                dbDriver.setLibrary(string3);
            }
        }
        if (!bl && string2 != null) {
            dbDriver = new DbDriver(string2);
            if (string4 != null) {
                dbDriver.setName(string4);
            }
            dbDriver.setLibrary(string3);
            ConnectionMgr.getInstance().getDrivers().add(dbDriver);
        }
        return dbDriver;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }
}

