/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands.console;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ConnectionMgr;
import workbench.db.DbDriver;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbDefineDriver
extends SqlCommand {
    public static final String VERB = "WbDefineDriver";
    public static final String ARG_DRV_NAME = "name";

    public WbDefineDriver() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_DRV_NAME);
        this.cmdLine.addArgument("driverclass");
        this.cmdLine.addArgument("driverjar");
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        boolean bl;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (!this.cmdLine.hasArguments()) {
            statementRunnerResult.addMessageByKey("ErrDefDrv");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        String string3 = this.cmdLine.getValue(ARG_DRV_NAME);
        String string4 = this.cmdLine.getValue("driverclass");
        String string5 = this.cmdLine.getValue("driverjar");
        if (StringUtil.isBlank(string3)) {
            statementRunnerResult.addMessageByKey("ErrDefDrvNoName");
            statementRunnerResult.addMessageByKey("ErrDefDrv");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        DbDriver dbDriver = this.findDriver(string3 = string3.trim());
        boolean bl2 = bl = dbDriver != null;
        if (StringUtil.isBlank(string4) && dbDriver == null) {
            statementRunnerResult.addMessageByKey("ErrDefDrvNoClass");
            statementRunnerResult.addMessageByKey("ErrDefDrv");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        if (dbDriver == null) {
            dbDriver = new DbDriver();
            dbDriver.setName(string3);
            ConnectionMgr.getInstance().getDrivers().add(dbDriver);
        }
        if (StringUtil.isNonBlank(string5)) {
            dbDriver.setLibrary(string5);
        }
        if (StringUtil.isNonBlank(string4)) {
            dbDriver.setDriverClass(string4);
        }
        List<String> list = dbDriver.getLibraryList();
        for (String string6 : list) {
            WbFile wbFile = new WbFile(string6);
            if (wbFile.exists()) continue;
            statementRunnerResult.addMessageByKey("ErrFileNotFound", wbFile.getFullPath());
            statementRunnerResult.setFailure();
        }
        if (!statementRunnerResult.isSuccess()) {
            return statementRunnerResult;
        }
        ConnectionMgr.getInstance().saveDrivers();
        if (bl) {
            statementRunnerResult.addMessageByKey("MsgDriverUpdated", string3);
        } else {
            statementRunnerResult.addMessageByKey("MsgDriverAdded", string3);
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    private DbDriver findDriver(String string) {
        List<DbDriver> list = ConnectionMgr.getInstance().getDrivers();
        for (DbDriver dbDriver : list) {
            if (!dbDriver.getName().equalsIgnoreCase(string)) continue;
            return dbDriver;
        }
        return null;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

