/*
 * Decompiled with CFR 0.152.
 */
package workbench.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import workbench.db.ConnectionProfile;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.ssh.JschLogger;
import workbench.ssh.PortForwarder;
import workbench.ssh.SshConfig;
import workbench.ssh.SshException;
import workbench.ssh.SshHostConfig;
import workbench.ssh.UrlParser;
import workbench.util.WbFile;

public class SshManager {
    private final Object lock = new Object();
    private Map<SshConfig, Entry> activeSessions = new HashMap<SshConfig, Entry>();
    private final Map<String, String> passphrases = new ConcurrentHashMap<String, String>(2);

    public String initializeSSHSession(ConnectionProfile connectionProfile) throws SshException {
        return this.initializeSSHSession(connectionProfile.getSshConfig(), connectionProfile.getUrl(), connectionProfile.getKey());
    }

    public String initializeSSHSession(SshConfig sshConfig, String string, ProfileKey profileKey) throws SshException {
        if (sshConfig == null) {
            return string;
        }
        if (Settings.getInstance().enableJSchLoggin()) {
            JSch.setLogger(new JschLogger());
        } else {
            JSch.setLogger(null);
        }
        SshHostConfig sshHostConfig = sshConfig.getSshHostConfig();
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            LogMgr.logDebug(callerInfo, "SSH session required for profile: " + profileKey);
            int n = sshConfig.getLocalPort();
            String string2 = string;
            UrlParser urlParser = new UrlParser(string2);
            PortForwarder portForwarder = this.getForwarder(sshConfig);
            if (!portForwarder.isConnected()) {
                n = portForwarder.startForwarding(sshConfig.getDbHostname(), sshConfig.getDbPort(), n, sshHostConfig.getSshPort());
                if (sshHostConfig.getPrivateKeyFile() != null && sshHostConfig.hasTemporaryPassword()) {
                    this.passphrases.put(sshHostConfig.getPrivateKeyFile(), sshHostConfig.getDecryptedPassword());
                }
            } else {
                LogMgr.logDebug(callerInfo, "Re-Using existing SSH session for " + portForwarder);
                n = portForwarder.getLocalPort();
            }
            if (sshConfig.getLocalPort() == 0) {
                string2 = urlParser.getLocalUrl(n);
            }
            return string2;
        }
        catch (Throwable throwable) {
            LogMgr.logError(callerInfo, "Could not initialize SSH tunnel", throwable);
            throw new SshException("Could not initialize SSH tunnel: " + throwable.getMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsPassphrase(SshHostConfig sshHostConfig) {
        if (sshHostConfig == null) {
            return false;
        }
        String string = sshHostConfig.getPrivateKeyFile();
        if (string == null) {
            return false;
        }
        boolean bl = Settings.getInstance().getBoolProperty("workbench.ssh.check.encrypted.keyfile", true);
        if (!bl) {
            return true;
        }
        WbFile wbFile = new WbFile(string);
        if (!wbFile.exists()) {
            return false;
        }
        String string2 = wbFile.getFullPath();
        KeyPair keyPair = null;
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            long l = System.currentTimeMillis();
            JSch jSch = new JSch();
            keyPair = KeyPair.load(jSch, string2);
            boolean bl2 = keyPair.isEncrypted();
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(callerInfo, "Checking for encrypted key file took: " + l2 + "ms");
            if (!bl2) {
                LogMgr.logInfo(callerInfo, "Key file " + string2 + " is not encrypted. Assuming no passphrase is required");
            }
            boolean bl3 = bl2;
            return bl3;
        }
        catch (Throwable throwable) {
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (keyPair != null) {
                keyPair.dispose();
            }
        }
    }

    public int getLocalPort(SshConfig sshConfig) {
        if (sshConfig == null) {
            return -1;
        }
        if (sshConfig.getSshHostConfig() == null) {
            return -1;
        }
        PortForwarder portForwarder = this.findForwarder(sshConfig);
        if (portForwarder != null) {
            return portForwarder.getLocalPort();
        }
        return -1;
    }

    public String getPassphrase(SshHostConfig sshHostConfig) {
        if (sshHostConfig.getPrivateKeyFile() == null) {
            return null;
        }
        return this.passphrases.get(sshHostConfig.getPrivateKeyFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortForwarder findForwarder(SshConfig sshConfig) {
        PortForwarder portForwarder = null;
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.activeSessions.get(sshConfig);
            if (entry != null) {
                portForwarder = entry.fwd;
            }
        }
        return portForwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortForwarder getForwarder(SshConfig sshConfig) {
        PortForwarder portForwarder = null;
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.activeSessions.get(sshConfig);
            if (entry == null) {
                entry = new Entry(new PortForwarder(sshConfig.getSshHostConfig()));
                portForwarder = entry.fwd;
                entry.usageCount = 1;
                this.activeSessions.put(sshConfig, entry);
            } else {
                portForwarder = entry.fwd;
                ++entry.usageCount;
            }
        }
        return portForwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementUsage(SshConfig sshConfig) {
        if (sshConfig == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.activeSessions.get(sshConfig);
            if (entry != null) {
                --entry.usageCount;
                if (entry.usageCount == 0) {
                    entry.fwd.close();
                    this.activeSessions.remove(sshConfig);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(SshConfig sshConfig) {
        if (sshConfig == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.activeSessions.get(sshConfig);
            if (entry != null) {
                entry.fwd.close();
                this.activeSessions.remove(sshConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectAll() {
        Object object = this.lock;
        synchronized (object) {
            for (Entry entry : this.activeSessions.values()) {
                entry.fwd.close();
            }
            this.activeSessions.clear();
        }
    }

    public static boolean canUseAgent() {
        CallerInfo callerInfo = new CallerInfo(){};
        long l = System.currentTimeMillis();
        boolean bl = false;
        try {
            Connector connector = ConnectorFactory.getDefault().createConnector();
            if (connector != null) {
                LogMgr.logInfo(callerInfo, "SSH agent connector " + connector.getName() + " available: " + connector.isAvailable());
            } else {
                LogMgr.logInfo(callerInfo, "No agent connector available");
            }
            bl = connector != null;
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Can not create agent connector (" + throwable.getClass().getName() + " " + throwable.getMessage() + ")");
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(callerInfo, "Checking for SSH agent connector took: " + l2 + "ms");
        return bl;
    }

    private static class Entry {
        final PortForwarder fwd;
        int usageCount;

        Entry(PortForwarder portForwarder) {
            this.fwd = portForwarder;
        }
    }
}

