/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.Arrays;
import java.util.Comparator;
import workbench.storage.RowData;

public class RowDataList {
    private static final int DEFAULT_SIZE = 150;
    private final float grow = 1.2f;
    private int size;
    private RowData[] data;

    public RowDataList() {
        this(150);
    }

    public RowDataList(int n) {
        this.data = new RowData[n];
        this.size = 0;
    }

    private void grow(int n) {
        if (this.data == null) {
            this.data = new RowData[(int)((float)n * 1.2f)];
        } else {
            int n2 = (int)((float)this.data.length * 1.2f) + 1;
            if (n2 < n) {
                n2 = n;
            }
            RowData[] rowDataArray = new RowData[n2];
            System.arraycopy(this.data, 0, rowDataArray, 0, this.size);
            this.data = rowDataArray;
        }
    }

    public void addColumn() {
        if (this.data == null) {
            return;
        }
        for (RowData rowData : this.data) {
            if (rowData == null) continue;
            rowData.addColum();
        }
    }

    public void addColumn(int n) {
        if (this.data == null) {
            return;
        }
        for (RowData rowData : this.data) {
            if (rowData == null) continue;
            rowData.addColum(n);
        }
    }

    public void ensureCapacity(int n) {
        this.grow(n);
    }

    public void reset() {
        if (this.data == null) {
            return;
        }
        for (RowData rowData : this.data) {
            if (rowData == null) continue;
            rowData.reset();
        }
        this.clear();
    }

    public void clear() {
        this.size = 0;
        this.data = null;
    }

    public int size() {
        return this.size;
    }

    public RowData get(int n) {
        if (this.data == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public void remove(int n) {
        if (this.data == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.data, n + 1, this.data, n, n2);
        }
        --this.size;
        this.data[this.size] = null;
    }

    public int add(RowData rowData) {
        int n;
        if (this.data == null) {
            this.grow(150);
        }
        if ((n = this.size + 1) > this.data.length) {
            this.grow(n);
        }
        this.data[n - 1] = rowData;
        this.size = n;
        return this.size;
    }

    public int add(int n, RowData rowData) {
        int n2 = this.size + 1;
        if (this.data == null) {
            this.grow(150);
        } else if (n2 > this.data.length) {
            RowData[] rowDataArray = new RowData[(int)((float)n2 * 1.2f)];
            System.arraycopy(this.data, 0, rowDataArray, 0, n);
            System.arraycopy(this.data, n, rowDataArray, n + 1, this.size - n);
            this.data = rowDataArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = rowData;
        this.size = n2;
        return n;
    }

    public void sort(Comparator<RowData> comparator) {
        if (this.size == 0 || this.data == null) {
            return;
        }
        Arrays.sort(this.data, 0, this.size, comparator);
    }
}

