/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.util.Arrays;
import java.util.List;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class SortDefinition {
    private boolean[] sortAscending;
    private int[] sortColumns;
    private boolean ignoreCase;
    private boolean naturalSort;

    public SortDefinition() {
    }

    public SortDefinition(int n, boolean bl) {
        this.sortColumns = new int[]{n};
        this.sortAscending = new boolean[]{bl};
    }

    public SortDefinition(int[] nArray, boolean[] blArray) {
        this.sortColumns = new int[nArray.length];
        this.sortAscending = new boolean[blArray.length];
        System.arraycopy(nArray, 0, this.sortColumns, 0, nArray.length);
        System.arraycopy(blArray, 0, this.sortAscending, 0, blArray.length);
    }

    public boolean useNaturalSort() {
        return this.naturalSort;
    }

    public void setUseNaturalSort(boolean bl) {
        this.naturalSort = bl;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public SortDefinition createCopy() {
        SortDefinition sortDefinition = new SortDefinition();
        if (this.sortColumns != null) {
            sortDefinition.sortColumns = new int[this.sortColumns.length];
            System.arraycopy(this.sortColumns, 0, sortDefinition.sortColumns, 0, this.sortColumns.length);
            sortDefinition.sortAscending = new boolean[this.sortAscending.length];
            System.arraycopy(this.sortAscending, 0, sortDefinition.sortAscending, 0, this.sortAscending.length);
        }
        sortDefinition.ignoreCase = this.ignoreCase;
        sortDefinition.naturalSort = this.naturalSort;
        return sortDefinition;
    }

    public int hashCode() {
        int n = 7;
        n = 67 * n + (this.sortAscending != null ? Arrays.hashCode(this.sortAscending) : 0);
        n = 67 * n + (this.sortColumns != null ? Arrays.hashCode(this.sortColumns) : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof SortDefinition) {
            SortDefinition sortDefinition = (SortDefinition)object;
            if (sortDefinition.getColumnCount() != this.getColumnCount()) {
                return false;
            }
            if (this.getColumnCount() == 0) {
                return true;
            }
            for (int i = 0; i < this.sortColumns.length; ++i) {
                if (this.sortColumns[i] != sortDefinition.sortColumns[i]) {
                    return false;
                }
                if (this.sortAscending[i] == sortDefinition.sortAscending[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (this.isEmpty()) {
            return true;
        }
        for (int n : this.sortColumns) {
            if (n >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.getColumnCount() == 0;
    }

    public boolean hasColumns() {
        return this.getColumnCount() != 0;
    }

    public int getColumnCount() {
        if (this.sortColumns == null) {
            return 0;
        }
        return this.sortColumns.length;
    }

    public int getSortColumnByIndex(int n) throws ArrayIndexOutOfBoundsException {
        if (this.sortColumns == null) {
            return -1;
        }
        return this.sortColumns[n];
    }

    public boolean isSortAscending(int n) {
        int n2 = this.findSortColumnIndex(n);
        if (n2 < 0) {
            return false;
        }
        return this.sortAscending[n2];
    }

    public boolean isPrimarySortColumn(int n) {
        int n2 = this.findSortColumnIndex(n);
        return n2 == 0;
    }

    public boolean isSortColumn(int n) {
        int n2 = this.findSortColumnIndex(n);
        return n2 > -1;
    }

    public void removeSortColumn(int n) {
        int n2 = this.findSortColumnIndex(n);
        if (n2 < 0) {
            return;
        }
        if (this.sortColumns.length == 1) {
            this.sortColumns = null;
            this.sortAscending = null;
            return;
        }
        int[] nArray = new int[this.sortColumns.length - 1];
        boolean[] blArray = new boolean[this.sortColumns.length - 1];
        System.arraycopy(this.sortColumns, 0, nArray, 0, n2);
        System.arraycopy(this.sortAscending, 0, blArray, 0, n2);
        System.arraycopy(this.sortColumns, n2 + 1, nArray, n2, this.sortColumns.length - n2 - 1);
        System.arraycopy(this.sortAscending, 0, blArray, n2, this.sortColumns.length - n2 - 1);
        this.sortColumns = nArray;
        this.sortAscending = blArray;
    }

    public void addSortColumn(int n, boolean bl) {
        this.setSortColumn(n, bl, true);
    }

    public void setSortColumn(int n, boolean bl) {
        this.setSortColumn(n, bl, false);
    }

    private void setSortColumn(int n, boolean bl, boolean bl2) {
        if (!bl2 || this.sortColumns == null) {
            this.sortColumns = new int[]{n};
            this.sortAscending = new boolean[]{bl};
        } else {
            int n2 = this.findSortColumnIndex(n);
            if (n2 < 0) {
                int[] nArray = new int[this.sortColumns.length + 1];
                boolean[] blArray = new boolean[this.sortColumns.length + 1];
                System.arraycopy(this.sortColumns, 0, nArray, 0, this.sortColumns.length);
                System.arraycopy(this.sortAscending, 0, blArray, 0, this.sortColumns.length);
                nArray[this.sortColumns.length] = n;
                blArray[this.sortColumns.length] = bl;
                this.sortColumns = nArray;
                this.sortAscending = blArray;
            } else {
                this.sortAscending[n2] = bl;
            }
        }
    }

    private int findSortColumnIndex(int n) {
        if (this.sortColumns == null) {
            return -1;
        }
        for (int i = 0; i < this.sortColumns.length; ++i) {
            if (this.sortColumns[i] != n) continue;
            return i;
        }
        return -1;
    }

    public String getDefinitionString() {
        if (this.sortColumns == null || this.sortColumns.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.sortColumns.length * 3);
        for (int i = 0; i < this.sortColumns.length; ++i) {
            if (i > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(Integer.toString(this.sortColumns[i]));
            stringBuilder.append(',');
            stringBuilder.append(this.sortAscending[i] ? (char)'a' : 'd');
        }
        return stringBuilder.toString();
    }

    public static SortDefinition parseDefinitionString(String string) {
        List<String> list = StringUtil.stringToList(string, ";", true, true, false);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        int[] nArray = new int[list.size()];
        boolean[] blArray = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string2 = StringUtil.trimQuotes(list.get(i));
            String[] stringArray = string2.split(",");
            if (stringArray == null || stringArray.length != 2) continue;
            int n = StringUtil.getIntValue(stringArray[0], -1);
            if (n < 0) {
                return null;
            }
            nArray[i] = n;
            blArray[i] = "a".equalsIgnoreCase(stringArray[1]);
        }
        return new SortDefinition(nArray, blArray);
    }

    public static SortDefinition getTableListSort() {
        SortDefinition sortDefinition = new SortDefinition();
        sortDefinition.addSortColumn(1, true);
        sortDefinition.addSortColumn(2, true);
        sortDefinition.addSortColumn(3, true);
        sortDefinition.addSortColumn(0, true);
        sortDefinition.setIgnoreCase(true);
        return sortDefinition;
    }
}

