/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.ArgumentType;
import workbench.util.ArgumentValue;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringArgumentValue;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public class ArgumentParser {
    private static final String ARG_PRESENT = "$WB$__ARG_PRESENT__$WB$";
    protected final Map<String, Object> arguments = new TreeMap<String, Object>(CaseInsensitiveComparator.INSTANCE);
    private final Map<String, ArgumentType> argTypes = new TreeMap<String, ArgumentType>(CaseInsensitiveComparator.INSTANCE);
    private final List<String> unknownParameters = new ArrayList<String>();
    private Set<String> deprecatedParameters = CollectionUtil.caseInsensitiveSet();
    private final Map<String, Collection<ArgumentValue>> allowedValues = new TreeMap<String, Collection<ArgumentValue>>(CaseInsensitiveComparator.INSTANCE);
    private int argCount = 0;
    private boolean needSwitch = true;
    private String nonArguments;
    private final Set<ArgumentType> repeatableTypes = EnumSet.of(ArgumentType.Repeatable, ArgumentType.RepeatableValue);

    public ArgumentParser() {
        this.addArgument("help", ArgumentType.BoolSwitch);
    }

    public ArgumentParser(boolean bl) {
        this();
        this.needSwitch = bl;
    }

    public boolean needsSwitch() {
        return this.needSwitch;
    }

    public void clear() {
        this.arguments.clear();
        this.argTypes.clear();
        this.allowedValues.clear();
        this.unknownParameters.clear();
        this.addArgument("help", ArgumentType.BoolSwitch);
    }

    public boolean isAllowedValue(String string, String string2) {
        StringArgumentValue stringArgumentValue = new StringArgumentValue(string2);
        Collection<ArgumentValue> collection = this.getAllowedValues(string);
        if (collection == null) {
            return false;
        }
        return collection.contains(stringArgumentValue);
    }

    public Collection<ArgumentValue> getAllowedValues(String string) {
        return this.allowedValues.get(string);
    }

    public boolean hasValidValue(String string) {
        String string2 = this.getValue(string);
        return this.isAllowedValue(string, string2);
    }

    public <T extends Enum<T>> void addArgument(String string, Class<T> clazz) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum enum_ : enumArray) {
            arrayList.add(enum_.toString());
        }
        this.addArgument(string, arrayList);
    }

    public void addArgument(String string, List<String> list) {
        this.addArgument(string, ArgumentType.ListArgument);
        if (list == null) {
            return;
        }
        TreeSet<ArgumentValue> treeSet = new TreeSet<ArgumentValue>(ArgumentValue.COMPARATOR);
        for (String string2 : list) {
            treeSet.add(new StringArgumentValue(string2));
        }
        this.allowedValues.put(string, treeSet);
    }

    public void addArgumentWithValues(String string, List<? extends ArgumentValue> list) {
        this.addArgument(string, ArgumentType.ListArgument);
        if (list == null) {
            return;
        }
        TreeSet<? extends ArgumentValue> treeSet = new TreeSet<ArgumentValue>();
        treeSet.addAll(list);
        this.allowedValues.put(string, treeSet);
    }

    public void addArgument(String string) {
        this.addArgument(string, ArgumentType.StringArgument);
    }

    public void addArgument(String string, ArgumentType argumentType) {
        if (string == null) {
            throw new NullPointerException("Key may not be null");
        }
        this.arguments.put(string, null);
        this.argTypes.put(string, argumentType);
    }

    public void addDeprecatedArgument(String string, ArgumentType argumentType) {
        if (string == null) {
            throw new NullPointerException("Key may not be null");
        }
        this.arguments.put(string, null);
        this.argTypes.put(string, argumentType);
        this.deprecatedParameters.add(string);
    }

    public void parseProperties(File file) throws IOException {
        Reader reader = EncodingUtil.createReader(file, null);
        List<String> list = FileUtil.getLines(new BufferedReader(reader));
        this.parse(list);
    }

    public void parse(String[] stringArray) {
        this.reset();
        if (stringArray == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 20);
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        this.parse(stringBuilder.toString());
    }

    public void parse(String string) {
        WbStringTokenizer wbStringTokenizer;
        this.reset();
        if (string == null) {
            return;
        }
        if (this.needSwitch) {
            wbStringTokenizer = new WbStringTokenizer('-', "\"'", true);
            wbStringTokenizer.setDelimiterNeedsWhitspace(true);
        } else {
            wbStringTokenizer = new WbStringTokenizer(' ', "\"'", true);
            wbStringTokenizer.setDelimiterNeedsWhitspace(false);
        }
        wbStringTokenizer.setSourceString(string.trim());
        List<String> list = wbStringTokenizer.getAllTokens();
        this.parse(list);
    }

    public String getNonArguments() {
        return this.nonArguments;
    }

    private void appendNonArg(String string) {
        if (this.nonArguments.length() > 0) {
            this.nonArguments = this.nonArguments + " ";
        }
        this.nonArguments = this.nonArguments + string.trim();
    }

    protected void parse(List<String> list) {
        this.nonArguments = "";
        Pattern pattern = Pattern.compile("\\s+=\\s+");
        try {
            for (String string : list) {
                if (StringUtil.isBlank(string)) continue;
                String string2 = string.trim();
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) {
                    string2 = matcher.replaceFirst("=");
                }
                String string3 = string2;
                String string4 = null;
                int n = string2.indexOf(61);
                int n2 = StringUtil.findFirstWhiteSpace(string2);
                if (n > -1 && n2 > 0 && n2 < n) {
                    this.appendNonArg(string2.substring(n2));
                    string2 = string2.substring(0, n2);
                    n = string2.indexOf(61);
                    string3 = string2;
                }
                boolean bl = false;
                if (n > -1) {
                    string3 = string2.substring(0, n).trim();
                    String string5 = string4 = n < string2.length() - 1 ? string2.substring(n + 1).trim() : "";
                    if (string4.length() > 0) {
                        int n3;
                        char c = string4.charAt(0);
                        char c2 = string4.charAt(string4.length() - 1);
                        if ((c == '\"' && c2 == '\"' || c == '\'' && c2 == '\'') && ((n3 = string4.indexOf(c, 1)) == -1 || n3 == string4.length() - 1)) {
                            string4 = StringUtil.trimQuotes(string4);
                            bl = true;
                        }
                    }
                }
                if (string4 == null) {
                    string4 = ARG_PRESENT;
                } else if (!bl) {
                    string4 = string4.trim();
                }
                if (this.arguments.containsKey(string3)) {
                    ArgumentType argumentType = this.argTypes.get(string3);
                    if (this.repeatableTypes.contains((Object)argumentType)) {
                        ArrayList<String> arrayList = (ArrayList<String>)this.arguments.get(string3);
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                            this.arguments.put(string3, arrayList);
                        }
                        if (bl) {
                            arrayList.add(string4);
                        } else if (argumentType == ArgumentType.RepeatableValue) {
                            arrayList.add(StringUtil.trimQuotes(string4));
                        } else {
                            List<String> list2 = StringUtil.stringToList(string4, ",", true, true, false);
                            arrayList.addAll(list2);
                        }
                    } else {
                        this.arguments.put(string3, string4);
                    }
                    ++this.argCount;
                    continue;
                }
                this.appendNonArg(string);
                this.unknownParameters.add(string3);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when parsing entries", exception);
        }
    }

    public List<String> getArgumentsOnCommandLine() {
        ArrayList<String> arrayList = new ArrayList<String>(this.arguments.size());
        for (Map.Entry<String, Object> entry : this.arguments.entrySet()) {
            if (entry.getValue() == null || this.getArgumentType(entry.getKey()) == ArgumentType.Repeatable) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public List<String> getRegisteredArguments() {
        Iterator<Map.Entry<String, ArgumentType>> iterator = this.argTypes.entrySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>(this.argTypes.size());
        while (iterator.hasNext()) {
            Map.Entry<String, ArgumentType> entry = iterator.next();
            if (this.deprecatedParameters.contains(entry.getKey())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public ArgumentType getArgumentType(String string) {
        return this.argTypes.get(string);
    }

    public boolean hasArguments() {
        return this.argCount > 0;
    }

    public int getArgumentCount() {
        return this.argCount;
    }

    public boolean hasUnknownArguments() {
        return this.unknownParameters.size() > 0;
    }

    public String getUnknownArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.unknownParameters.size() > 0) {
            for (int i = 0; i < this.unknownParameters.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append('-');
                stringBuilder.append(this.unknownParameters.get(i));
            }
        }
        return stringBuilder.toString();
    }

    public boolean isRegistered(String string) {
        return this.arguments.containsKey(string);
    }

    public boolean isArgNotPresent(String string) {
        return !this.isArgPresent(string);
    }

    public boolean isArgPresent(String string) {
        if (string == null) {
            return false;
        }
        Object object = this.arguments.get(string);
        return object != null;
    }

    public void removeArgument(String string) {
        if (this.arguments.get(string) != null) {
            --this.argCount;
        }
        this.arguments.remove(string);
        this.argTypes.remove(string);
        this.allowedValues.remove(string);
    }

    private void reset() {
        for (String string : this.arguments.keySet()) {
            this.arguments.put(string, null);
        }
        this.argCount = 0;
        this.unknownParameters.clear();
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getValue(string);
        if (StringUtil.isBlank(string2)) {
            if (this.getArgumentType(string) == ArgumentType.BoolSwitch && this.isArgPresent(string)) {
                return true;
            }
            return bl;
        }
        return StringUtil.stringToBool(string2);
    }

    public String getValue(String string) {
        if (this.getArgumentType(string) == ArgumentType.Repeatable) {
            List<String> list = this.getList(string);
            if (CollectionUtil.isEmpty(list)) {
                return null;
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            throw new IllegalStateException("Cannot return a single string from a List");
        }
        Object object = this.arguments.get(string);
        if (object == ARG_PRESENT) {
            return null;
        }
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public List<String> getList(String string) {
        if (this.repeatableTypes.contains((Object)this.getArgumentType(string))) {
            Object object = this.arguments.get(string);
            if (object == ARG_PRESENT || object == null) {
                return Collections.emptyList();
            }
            return (List)object;
        }
        String string2 = this.getValue(string);
        if (string2 == null) {
            return Collections.emptyList();
        }
        return CollectionUtil.arrayList(string2);
    }

    public String getValue(String string, String string2) {
        String string3 = this.getValue(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public List<String> getListValue(String string) {
        if (this.repeatableTypes.contains((Object)this.getArgumentType(string))) {
            return this.getList(string);
        }
        String string2 = this.getValue(string);
        if (string2 == null) {
            return Collections.emptyList();
        }
        List<String> list = StringUtil.stringToList(string2, ",", true, true, false);
        return list;
    }

    public Map<String, String> getMapValue(String string) {
        List<String> list = this.getListValue(string);
        if (CollectionUtil.isEmpty(list)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
        for (String string2 : list) {
            String[] stringArray = string2.split("=");
            if (stringArray == null || stringArray.length != 2) {
                stringArray = string2.split(":");
            }
            if (stringArray == null || stringArray.length != 2) continue;
            hashMap.put(stringArray[0], StringUtil.trimQuotes(stringArray[1]));
        }
        return hashMap;
    }

    public int getIntValue(String string, int n) {
        return StringUtil.getIntValue(this.getValue(string), n);
    }

    public String getEscapedString(String string) {
        return this.getEscapedString(string, null);
    }

    public String getEscapedString(String string, String string2) {
        String string3 = StringUtil.trimQuotes(this.getValue(string, string2));
        return StringUtil.unescape(string3);
    }

    public <T extends Enum<T>> T getEnumValue(String string, T t) {
        return this.getEnumValue(string, t, t.getDeclaringClass());
    }

    public <T extends Enum<T>> T getEnumValue(String string, Class<T> clazz) {
        return this.getEnumValue(string, null, clazz);
    }

    public <T extends Enum<T>> T getEnumValue(String string, T t, Class<T> clazz) throws IllegalArgumentException {
        String string2 = this.getValue(string, null);
        if (string2 == null) {
            return t;
        }
        return Enum.valueOf(clazz, string2);
    }
}

