/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Optional;
import workbench.db.ConnectionInfoBuilder;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.MemoryWatcher;
import workbench.util.PlatformHelper;
import workbench.util.StringUtil;
import workbench.util.WbThread;
import workbench.util.function.WbConsumer;

public class BrowserLauncher {
    public static void openEmail(String string, WbConnection wbConnection) {
        WbConsumer<URI> wbConsumer;
        Optional<Desktop> optional = BrowserLauncher.getDesktop(Desktop.Action.MAIL);
        if (optional.isPresent()) {
            wbConsumer = optional.get()::mail;
        } else if (PlatformHelper.isLinux()) {
            wbConsumer = BrowserLauncher::xdgOpenUrl;
        } else {
            wbConsumer = null;
            LogMgr.logError(new CallerInfo(){}, "Desktop not supported!", null);
            WbSwingUtilities.showErrorMessage("Desktop not supported by your Java version");
        }
        if (wbConsumer == null) {
            return;
        }
        WbThread wbThread = new WbThread(() -> {
            try {
                Object object;
                String string2;
                String string3 = BrowserLauncher.urlEncode("SQL Workbench/J (Build " + ResourceMgr.getBuildNumber() + ") - feedback");
                String string4 = ResourceMgr.getFormattedString("TxtFeedbackMail", LogMgr.getLogfile().getFullPath());
                string4 = string4 + "\n\nSQL Workbench/J " + ResourceMgr.getBuildInfo();
                string4 = string4 + "\n" + ResourceMgr.getFullJavaInfo();
                long l = MemoryWatcher.MAX_MEMORY / 0x100000L;
                string4 = string4 + "\n" + ResourceMgr.getOSInfo() + ", max. memory=" + l + "MB";
                if (wbConnection != null && StringUtil.isNonEmpty(string2 = ((ConnectionInfoBuilder)(object = new ConnectionInfoBuilder())).getPlainTextDisplay(wbConnection, 5))) {
                    String string5 = ResourceMgr.getFormattedString("TxtFeedbackMailConInfo", string2);
                    string4 = string4 + "\n\n" + string5;
                }
                string4 = BrowserLauncher.urlEncode(string4);
                object = new URI("mailto:" + string + "?subject=" + string3 + "&body=" + string4);
                wbConsumer.accept((URI)object);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not open email program", exception);
                WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
            }
        }, "OpenBrowser");
        wbThread.start();
    }

    private static String urlEncode(String string) throws Exception {
        return URLEncoder.encode(string, "UTF-8").replace("+", "%20");
    }

    public static void openURL(String string) throws Exception {
        BrowserLauncher.openURL(new URI(string));
    }

    private static Optional<Desktop> getDesktop(Desktop.Action action) {
        return Desktop.isDesktopSupported() ? Optional.ofNullable(Desktop.getDesktop()).filter(desktop -> desktop.isSupported(action)) : Optional.empty();
    }

    private static void xdgOpenUrl(URI uRI) throws IOException {
        Runtime.getRuntime().exec(new String[]{"xdg-open", uRI.toString()});
    }

    public static void openURL(URI uRI) throws Exception {
        Object object;
        Object object2;
        String string = uRI.toString();
        if (string.indexOf(35) > -1 && GuiSettings.useHTMLRedirectForAnchor()) {
            object2 = File.createTempFile("sqlwb_show_help", ".html");
            ((File)object2).deleteOnExit();
            object = "<html><head>\n<meta http-equiv=\"refresh\" content=\"0;url=" + string + "\"/>\n</head></html>";
            FileUtil.writeString((File)object2, (String)object, "UTF-8", false);
            URI uRI2 = ((File)object2).toURI();
            LogMgr.logDebug(new CallerInfo(){}, "Redirecting to an anchor using intermediate URL: " + uRI2.toString());
        } else {
            URI uRI3 = uRI;
        }
        object2 = BrowserLauncher.getDesktop(Desktop.Action.BROWSE);
        if (((Optional)object2).isPresent()) {
            object = ((Desktop)((Optional)object2).get())::browse;
        } else if (PlatformHelper.isLinux()) {
            object = BrowserLauncher::xdgOpenUrl;
        } else {
            object = null;
            LogMgr.logError(new CallerInfo(){}, "Desktop or Plattform not supported!", null);
            WbSwingUtilities.showErrorMessage("Starting the browser is not supported by your Java installation");
        }
        if (object == null) {
            return;
        }
        try {
            new WbThread(() -> BrowserLauncher.lambda$openURL$2(uRI, (WbConsumer)object), "OpenBrowser").start();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error starting browser", exception);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
        }
    }

    private static /* synthetic */ void lambda$openURL$2(URI uRI, WbConsumer wbConsumer) {
        try {
            LogMgr.logDebug(new CallerInfo(){}, "Opening URL: " + uRI.toString());
            wbConsumer.accept(uRI);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error starting browser", exception);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
        }
    }
}

