/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ClasspathUtil {
    public static final String EXT_DIR = "ext";
    private final File extDir = this.getExtDir();

    public List<File> checkLibsToMove() {
        File file = this.getJarFile();
        if (file == null) {
            return Collections.emptyList();
        }
        File file3 = file.getParentFile();
        if (file3 == null) {
            return Collections.emptyList();
        }
        LogMgr.logDebug(new CallerInfo(){}, "Checking directory: " + file3 + " for additional libraries");
        long l = System.currentTimeMillis();
        List<File> list = this.getClassPath();
        FileFilter fileFilter = file2 -> !file2.equals(file) && this.isExtJar(file2, list);
        File[] fileArray = file3.listFiles(fileFilter);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logInfo(new CallerInfo(){}, "Checking for ext libs took: " + l2 + "ms");
        if (fileArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(fileArray);
    }

    public List<File> getExtLibs() {
        FileFilter fileFilter = file -> file.getName().toLowerCase().endsWith(".jar");
        File[] fileArray = this.extDir.listFiles(fileFilter);
        if (fileArray == null) {
            return this.getClassPath();
        }
        return Arrays.asList(fileArray);
    }

    public boolean isExtDir(List<File> list) {
        return list.size() == 1 && this.isExtDir(list.get(0));
    }

    public boolean isExtDir(File file) {
        if (file == null) {
            return false;
        }
        return file.equals(this.extDir);
    }

    public boolean isInExtDir(List<File> list) {
        for (File file : list) {
            if (!this.isInExtDir(file)) continue;
            return true;
        }
        return false;
    }

    public boolean isInExtDir(File file) {
        if (file == null) {
            return false;
        }
        if (this.extDir.equals(file)) {
            return true;
        }
        if (EXT_DIR.equals(file.getName()) && file.getParent() == null) {
            return true;
        }
        if (file.isAbsolute()) {
            return this.extDir.equals(file.getParentFile());
        }
        List<File> list = this.getExtLibs();
        File file2 = null;
        file2 = file.getParentFile() == null ? new File(this.extDir, file.getName()) : new File(new WbFile(file).getFullPath());
        return list.contains(file2);
    }

    public WbFile getExtDir() {
        File file;
        String string = System.getProperty("workbench.libs.extdir", null);
        if (StringUtil.isNonBlank(string) && (file = new WbFile(string)).exists()) {
            return file;
        }
        file = this.getJarFile();
        if (file == null) {
            return new WbFile(".", EXT_DIR);
        }
        return new WbFile(file.getParentFile(), EXT_DIR);
    }

    public List<File> getClassPath() {
        String string2 = System.getProperty("java.class.path");
        String[] stringArray = string2.split(System.getProperty("path.separator"));
        if (stringArray == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(stringArray).map(string -> new File((String)string)).collect(Collectors.toList());
    }

    private boolean isExtJar(File file, List<File> list) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (list.contains(file)) {
            return false;
        }
        if (file.getName().toLowerCase().endsWith(".jar")) {
            return !this.mightBeJDBCDriver(file);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean mightBeJDBCDriver(File file) {
        try (JarFile jarFile = new JarFile(file);){
            ZipEntry zipEntry = jarFile.getEntry("META-INF/services/java.sql.Driver");
            boolean bl = zipEntry != null;
            return bl;
        }
        catch (Throwable throwable6) {
            return false;
        }
    }

    public File getJarFile() {
        File file;
        URL uRL = null;
        try {
            uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (uRL == null || StringUtil.isBlank(uRL.getFile())) {
            return new File(".");
        }
        try {
            String string = URLDecoder.decode(uRL.getFile(), "UTF-8");
            file = new File(string);
        }
        catch (Throwable throwable) {
            String string = uRL.getFile().replace("%20", " ");
            file = new File(string);
        }
        return file;
    }

    public File getJarDir() {
        File file = this.getJarFile();
        if (file == null || file.getParentFile() == null) {
            return new File("");
        }
        return this.getJarFile().getParentFile();
    }

    public String getJarPath() {
        File file = this.getJarFile();
        if (file == null || file.getParentFile() == null) {
            return ".";
        }
        WbFile wbFile = new WbFile(file.getParentFile());
        return wbFile.getFullPath();
    }
}

